/*
 * tegra210_mvc_alt.h - Definitions for Tegra210 MVC driver
 *
 * Copyright (c) 2014-2015 NVIDIA CORPORATION.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __TEGRA210_MVC_ALT_H__
#define __TEGRA210_MVC_ALT_H__

/*
 * MVC_AXBAR_RX registers are with respect to AXBAR.
 * The data is coming from AXBAR to MVC for playback.
 */
#define TEGRA210_MVC_AXBAR_RX_STATUS				0x0c
#define TEGRA210_MVC_AXBAR_RX_INT_STATUS			0x10
#define TEGRA210_MVC_AXBAR_RX_INT_MASK				0x14
#define TEGRA210_MVC_AXBAR_RX_INT_SET				0x18
#define TEGRA210_MVC_AXBAR_RX_INT_CLEAR				0x1c
#define TEGRA210_MVC_AXBAR_RX_CIF_CTRL				0x20
#define TEGRA210_MVC_AXBAR_RX_CYA					0x24
#define TEGRA210_MVC_AXBAR_RX_DBG					0x28

/*
 * MVC_AXBAR_TX registers are with respect to AXBAR.
 * The data is going out of MVC for playback.
 */
#define TEGRA210_MVC_AXBAR_TX_STATUS				0x4c
#define TEGRA210_MVC_AXBAR_TX_INT_STATUS			0x50
#define TEGRA210_MVC_AXBAR_TX_INT_MASK				0x54
#define TEGRA210_MVC_AXBAR_TX_INT_SET				0x58
#define TEGRA210_MVC_AXBAR_TX_INT_CLEAR				0x5c
#define TEGRA210_MVC_AXBAR_TX_CIF_CTRL				0x60
#define TEGRA210_MVC_AXBAR_TX_CYA					0x64
#define TEGRA210_MVC_AXBAR_TX_DBG					0x68

/* Register offsets from TEGRA210_MVC*_BASE */
#define TEGRA210_MVC_ENABLE							0x80
#define TEGRA210_MVC_SOFT_RESET						0x84
#define TEGRA210_MVC_CG								0x88
#define TEGRA210_MVC_STATUS							0x90
#define TEGRA210_MVC_INT_STATUS						0x94
#define TEGRA210_MVC_CTRL							0xa8
#define TEGRA210_MVC_SWITCH							0xac
#define TEGRA210_MVC_INIT_VOL						0xb0
#define TEGRA210_MVC_TARGET_VOL						0xd0
#define TEGRA210_MVC_DURATION						0xf0
#define TEGRA210_MVC_DURATION_INV					0xf4
#define TEGRA210_MVC_POLY_N1						0xf8
#define TEGRA210_MVC_POLY_N2						0xfc
#define TEGRA210_MVC_PEAK_CTRL						0x100
#define TEGRA210_MVC_AHUBRAMCTL_CONFIG_RAM_CTRL		0x104
#define TEGRA210_MVC_AHUBRAMCTL_CONFIG_RAM_DATA		0x108
#define TEGRA210_MVC_PEAK_VALUE						0x10c
#define TEGRA210_MVC_CONFIG_ERR_TYPE				0x12c
#define TEGRA210_MVC_CYA							0x130
#define TEGRA210_MVC_DBG							0x138

/* Fields in TEGRA210_MVC_ENABLE */
#define TEGRA210_MVC_EN_SHIFT					0
#define TEGRA210_MVC_EN							(1 << TEGRA210_MVC_EN_SHIFT)

#define TEGRA210_MVC_MUTE_SHIFT					8
#define TEGRA210_MVC_MUTE_MASK					(0xff << TEGRA210_MVC_MUTE_SHIFT)
#define TEGRA210_MVC_MUTE_EN					(0xff << TEGRA210_MVC_MUTE_SHIFT)

#define TEGRA210_MVC_PER_CHAN_CTRL_EN_SHIFT		30
#define TEGRA210_MVC_PER_CHAN_CTRL_EN_MASK		(1 << TEGRA210_MVC_PER_CHAN_CTRL_EN_SHIFT)
#define TEGRA210_MVC_PER_CHAN_CTRL_EN			(1 << TEGRA210_MVC_PER_CHAN_CTRL_EN_SHIFT)

#define TEGRA210_MVC_CURVE_TYPE_SHIFT			1
#define TEGRA210_MVC_CURVE_TYPE_MASK \
	(1 << TEGRA210_MVC_CURVE_TYPE_SHIFT)
#define TEGRA210_MVC_CURVE_TYPE_POLY \
	(0 << TEGRA210_MVC_CURVE_TYPE_SHIFT)
#define TEGRA210_MVC_CURVE_TYPE_LINEAR \
	(1 << TEGRA210_MVC_CURVE_TYPE_SHIFT)

#define TEGRA210_MVC_VOLUME_SWITCH_SHIFT		2
#define TEGRA210_MVC_VOLUME_SWITCH_MASK		(1 << TEGRA210_MVC_VOLUME_SWITCH_SHIFT)
#define TEGRA210_MVC_VOLUME_SWITCH_TRIGGER		(1 << TEGRA210_MVC_VOLUME_SWITCH_SHIFT)

#define TEGRA210_MVC_COEFF_SWITCH_SHIFT			1
#define TEGRA210_MVC_COEFF_SWITCH_MASK			(1 << TEGRA210_MVC_COEFF_SWITCH_SHIFT)
#define TEGRA210_MVC_COEFF_SWITCH_TRIGGER		(1 << TEGRA210_MVC_COEFF_SWITCH_SHIFT)

#define TEGRA210_MVC_DURATION_SWITCH_SHIFT		0
#define TEGRA210_MVC_DURATION_SWITCH_MASK		(1 << TEGRA210_MVC_DURATION_SWITCH_SHIFT)
#define TEGRA210_MVC_DURATION_SWITCH_TRIGGER	(1 << TEGRA210_MVC_DURATION_SWITCH_SHIFT)

#define TEGRA210_MVC_INIT_VOL_DEFAULT_POLY		0x01000000
#define TEGRA210_MVC_INIT_VOL_DEFAULT_LINEAR	0x00000000

/* Fields in TEGRA210_MVC ram ctrl */
#define TEGRA210_MVC_AHUBRAMCTL_CONFIG_RAM_CTRL_READ_BUSY_SHIFT			31
#define TEGRA210_MVC_AHUBRAMCTL_CONFIG_RAM_CTRL_READ_BUSY_MASK			(1 << TEGRA210_MVC_AHUBRAMCTL_CONFIG_RAM_CTRL_READ_BUSY_SHIFT)
#define TEGRA210_MVC_AHUBRAMCTL_CONFIG_RAM_CTRL_READ_BUSY				(1 << TEGRA210_MVC_AHUBRAMCTL_CONFIG_RAM_CTRL_READ_BUSY_SHIFT)

#define TEGRA210_MVC_AHUBRAMCTL_CONFIG_RAM_CTRL_SEQ_READ_COUNT_SHIFT	16
#define TEGRA210_MVC_AHUBRAMCTL_CONFIG_RAM_CTRL_SEQ_READ_COUNT_MASK		(0xff << TEGRA210_MVC_AHUBRAMCTL_CONFIG_RAM_CTRL_SEQ_READ_COUNT_SHIFT)

#define TEGRA210_MVC_AHUBRAMCTL_CONFIG_RAM_CTRL_RW_SHIFT				14
#define TEGRA210_MVC_AHUBRAMCTL_CONFIG_RAM_CTRL_RW_MASK					(1 << TEGRA210_MVC_AHUBRAMCTL_CONFIG_RAM_CTRL_RW_SHIFT)
#define TEGRA210_MVC_AHUBRAMCTL_CONFIG_RAM_CTRL_RW_WRITE				(1 << TEGRA210_MVC_AHUBRAMCTL_CONFIG_RAM_CTRL_RW_SHIFT)

#define TEGRA210_MVC_AHUBRAMCTL_CONFIG_RAM_CTRL_ADDR_INIT_EN_SHIFT		13
#define TEGRA210_MVC_AHUBRAMCTL_CONFIG_RAM_CTRL_ADDR_INIT_EN_MASK		(1 << TEGRA210_MVC_AHUBRAMCTL_CONFIG_RAM_CTRL_ADDR_INIT_EN_SHIFT)
#define TEGRA210_MVC_AHUBRAMCTL_CONFIG_RAM_CTRL_ADDR_INIT_EN			(1 << TEGRA210_MVC_AHUBRAMCTL_CONFIG_RAM_CTRL_ADDR_INIT_EN_SHIFT)

#define TEGRA210_MVC_AHUBRAMCTL_CONFIG_RAM_CTRL_SEQ_ACCESS_EN_SHIFT		12
#define TEGRA210_MVC_AHUBRAMCTL_CONFIG_RAM_CTRL_SEQ_ACCESS_EN_MASK		(1 << TEGRA210_MVC_AHUBRAMCTL_CONFIG_RAM_CTRL_SEQ_ACCESS_EN_SHIFT)
#define TEGRA210_MVC_AHUBRAMCTL_CONFIG_RAM_CTRL_SEQ_ACCESS_EN			(1 << TEGRA210_MVC_AHUBRAMCTL_CONFIG_RAM_CTRL_SEQ_ACCESS_EN_SHIFT)

#define TEGRA210_MVC_AHUBRAMCTL_CONFIG_RAM_CTRL_RAM_ADDR_SHIFT			0
#define TEGRA210_MVC_AHUBRAMCTL_CONFIG_RAM_CTRL_RAM_ADDR_MASK			(0x1ff << TEGRA210_MVC_AHUBRAMCTL_CONFIG_RAM_CTRL_RAM_ADDR_SHIFT)

enum {
	CURVE_POLY,
	CURVE_LINEAR,
};

struct tegra210_mvc_soc_data {
	void (*set_audio_cif)(struct regmap *map,
			unsigned int reg,
			struct tegra210_xbar_cif_conf *conf);
};

struct tegra210_mvc {
	struct regmap *regmap;
	int poly_coeff[9];
	int poly_n1, poly_n2, duration, duration_inv;
	int volume;
	unsigned int curve_type;
	unsigned int cif_channels;
	unsigned int audio_bits;
	const struct tegra210_mvc_soc_data *soc_data;
};

#endif
