/*
 * tegra210_amx_alt.h - Definitions for Tegra210 AMX driver
 *
 * Copyright (c) 2014-2015, NVIDIA CORPORATION.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHIN
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __TEGRA210_AMX_ALT_H__
#define __TEGRA210_AMX_ALT_H__

#define TEGRA210_AMX_AUDIOCIF_CH_STRIDE 4

/* Register offsets from TEGRA210_AMX*_BASE */
#define TEGRA210_AMX_AXBAR_RX_STATUS		0x0c
#define TEGRA210_AMX_AXBAR_RX_INT_STATUS	0x10
#define TEGRA210_AMX_AXBAR_RX_INT_MASK		0x14
#define TEGRA210_AMX_AXBAR_RX_INT_SET		0x18
#define TEGRA210_AMX_AXBAR_RX_INT_CLEAR		0x1c
#define TEGRA210_AMX_AXBAR_RX1_CIF_CTRL		0x20
#define TEGRA210_AMX_AXBAR_RX2_CIF_CTRL		0x24
#define TEGRA210_AMX_AXBAR_RX3_CIF_CTRL		0x28
#define TEGRA210_AMX_AXBAR_RX4_CIF_CTRL		0x2c
#define TEGRA210_AMX_AXBAR_TX_STATUS		0x4c
#define TEGRA210_AMX_AXBAR_TX_INT_STATUS	0x50
#define TEGRA210_AMX_AXBAR_TX_INT_MASK		0x54
#define TEGRA210_AMX_AXBAR_TX_INT_SET		0x58
#define TEGRA210_AMX_AXBAR_TX_INT_CLEAR		0x5c
#define TEGRA210_AMX_AXBAR_TX_CIF_CTRL		0x60
#define TEGRA210_AMX_ENABLE					0x80
#define TEGRA210_AMX_SOFT_RESET				0x84
#define TEGRA210_AMX_CG						0x88
#define TEGRA210_AMX_STATUS					0x8c
#define TEGRA210_AMX_INT_STATUS				0x90
#define TEGRA210_AMX_CTRL					0xa4
#define TEGRA210_AMX_OUT_BYTE_EN0			0xa8
#define TEGRA210_AMX_OUT_BYTE_EN1			0xac
#define TEGRA210_AMX_CYA					0xb0
#define TEGRA210_AMX_DBG					0xb4
#define TEGRA210_AMX_AHUBRAMCTL_AMX_CTRL	0xb8
#define TEGRA210_AMX_AHUBRAMCTL_AMX_DATA	0xbc

/* Fields in TEGRA210_AMX_AXBAR_RX1_CIF_CTRL */
/* Uses field from TEGRA210_AUDIOCIF_CTRL_* in tegra210_xbar_alt.h */

/* Fields in TEGRA210_AMX_AXBAR_RX2_CIF_CTRL */
/* Uses field from TEGRA210_AUDIOCIF_CTRL_* in tegra210_xbar_alt.h */

/* Fields in TEGRA210_AMX_AXBAR_RX3_CIF_CTRL */
/* Uses field from TEGRA210_AUDIOCIF_CTRL_* in tegra210_xbar_alt.h */

/* Fields in TEGRA210_AMX_AXBAR_RX4_CIF_CTRL */
/* Uses field from TEGRA210_AUDIOCIF_CTRL_* in tegra210_xbar_alt.h */

/* Fields in TEGRA210_AMX_AXBAR_TX_CIF_CTRL */
/* Uses field from TEGRA210_AUDIOCIF_CTRL_* in tegra210_xbar_alt.h */

/* Fields in TEGRA210_AMX_ENABLE */
#define TEGRA210_AMX_ENABLE_SHIFT					0
#define TEGRA210_AMX_ENABLE_MASK					(1 << TEGRA210_AMX_ENABLE_SHIFT)
#define TEGRA210_AMX_EN								(1 << TEGRA210_AMX_ENABLE_SHIFT)

/* Fields in TEGRA210_AMX_CTRL */
#define TEGRA210_AMX_CTRL_MSTR_RX_NUN_SHIFT			14
#define TEGRA210_AMX_CTRL_MSTR_RX_NUM_MASK			(3 << TEGRA210_AMX_CTRL_MSTR_RX_NUN_SHIFT)

#define TEGRA210_AMX_CTRL_RX_DEP_SHIFT				12
#define TEGRA210_AMX_CTRL_RX_DEP_MASK				(3 << TEGRA210_AMX_CTRL_RX_DEP_SHIFT)
#define TEGRA210_AMX_CTRL_RX_DEP_WT_ON_ALL			0
#define TEGRA210_AMX_CTRL_RX_DEP_WT_ON_ANY			(1 << TEGRA210_AMX_CTRL_RX_DEP_SHIFT)
#define TEGRA210_AMX_CTRL_RX_DEP_RSVD				(3 << TEGRA210_AMX_CTRL_RX_DEP_SHIFT)

#define TEGRA210_AMX_CTRL_RX4_FORCE_DISABLE_SHIFT	11
#define TEGRA210_AMX_CTRL_RX4_FORCE_DISABLE_MASK	(1 << TEGRA210_AMX_CTRL_RX4_FORCE_DISABLE_SHIFT)
#define TEGRA210_AMX_CTRL_RX4_FORCE_DISABLE_EN		(1 << TEGRA210_AMX_CTRL_RX4_FORCE_DISABLE_SHIFT)

#define TEGRA210_AMX_CTRL_RX3_FORCE_DISABLE_SHIFT	10
#define TEGRA210_AMX_CTRL_RX3_FORCE_DISABLE_MASK	(1 << TEGRA210_AMX_CTRL_RX3_FORCE_DISABLE_SHIFT)
#define TEGRA210_AMX_CTRL_RX3_FORCE_DISABLE_EN		(1 << TEGRA210_AMX_CTRL_RX3_FORCE_DISABLE_SHIFT)

#define TEGRA210_AMX_CTRL_RX2_FORCE_DISABLE_SHIFT	9
#define TEGRA210_AMX_CTRL_RX2_FORCE_DISABLE_MASK	(1 << TEGRA210_AMX_CTRL_RX2_FORCE_DISABLE_SHIFT)
#define TEGRA210_AMX_CTRL_RX2_FORCE_DISABLE_EN		(1 << TEGRA210_AMX_CTRL_RX2_FORCE_DISABLE_SHIFT)

#define TEGRA210_AMX_CTRL_RX1_FORCE_DISABLE_SHIFT	8
#define TEGRA210_AMX_CTRL_RX1_FORCE_DISABLE_MASK	(1 << TEGRA210_AMX_CTRL_RX1_FORCE_DISABLE_SHIFT)
#define TEGRA210_AMX_CTRL_RX1_FORCE_DISABLE_EN		(1 << TEGRA210_AMX_CTRL_RX1_FORCE_DISABLE_SHIFT)

#define TEGRA210_AMX_CTRL_RX4_ENABLE_SHIFT			3
#define TEGRA210_AMX_CTRL_RX4_ENABLE_MASK			(1 << TEGRA210_AMX_CTRL_RX4_ENABLE_SHIFT)
#define TEGRA210_AMX_CTRL_RX4_EN					(1 << TEGRA210_AMX_CTRL_RX4_ENABLE_SHIFT)

#define TEGRA210_AMX_CTRL_RX3_ENABLE_SHIFT			2
#define TEGRA210_AMX_CTRL_RX3_ENABLE_MASK			(1 << TEGRA210_AMX_CTRL_RX3_ENABLE_SHIFT)
#define TEGRA210_AMX_CTRL_RX3_EN					(1 << TEGRA210_AMX_CTRL_RX3_ENABLE_SHIFT)

#define TEGRA210_AMX_CTRL_RX2_ENABLE_SHIFT			1
#define TEGRA210_AMX_CTRL_RX2_ENABLE_MASK			(1 << TEGRA210_AMX_CTRL_RX2_ENABLE_SHIFT)
#define TEGRA210_AMX_CTRL_RX2_EN					(1 << TEGRA210_AMX_CTRL_RX2_ENABLE_SHIFT)

#define TEGRA210_AMX_CTRL_RX1_ENABLE_SHIFT			0
#define TEGRA210_AMX_CTRL_RX1_ENABLE_MASK			(1 << TEGRA210_AMX_CTRL_RX1_ENABLE_SHIFT)
#define TEGRA210_AMX_CTRL_RX1_EN					(1 << TEGRA210_AMX_CTRL_RX1_ENABLE_SHIFT)

/* Fields in TEGRA210_AMX_AHUBRAMCTL_AMX_CTRL */
#define TEGRA210_AMX_AHUBRAMCTL_AMX_CTRL_READ_BUSY_SHIFT	31
#define TEGRA210_AMX_AHUBRAMCTL_AMX_CTRL_READ_BUSY_MASK		(1 << TEGRA210_AMX_AHUBRAMCTL_AMX_CTRL_READ_BUSY_SHIFT)
#define TEGRA210_AMX_AHUBRAMCTL_AMX_CTRL_READ_BUSY			(1 << TEGRA210_AMX_AHUBRAMCTL_AMX_CTRL_READ_BUSY_SHIFT)

#define TEGRA210_AMX_AHUBRAMCTL_AMX_CTRL_RW_SHIFT			14
#define TEGRA210_AMX_AHUBRAMCTL_AMX_CTRL_RW_MASK			(1 << TEGRA210_AMX_AHUBRAMCTL_AMX_CTRL_RW_SHIFT)
#define TEGRA210_AMX_AHUBRAMCTL_AMX_CTRL_RW_WRITE			(1 << TEGRA210_AMX_AHUBRAMCTL_AMX_CTRL_RW_SHIFT)

#define TEGRA210_AMX_AHUBRAMCTL_AMX_CTRL_ADDR_INIT_EN_SHIFT	13
#define TEGRA210_AMX_AHUBRAMCTL_AMX_CTRL_ADDR_INIT_EN_MASK	(1 << TEGRA210_AMX_AHUBRAMCTL_AMX_CTRL_ADDR_INIT_EN_SHIFT)
#define TEGRA210_AMX_AHUBRAMCTL_AMX_CTRL_ADDR_INIT_EN		(1 << TEGRA210_AMX_AHUBRAMCTL_AMX_CTRL_ADDR_INIT_EN_SHIFT)

#define TEGRA210_AMX_AHUBRAMCTL_AMX_CTRL_RAM_ADDR_SHIFT		0
#define TEGRA210_AMX_AHUBRAMCTL_AMX_CTRL_RAM_ADDR_MASK		(0xff << TEGRA210_AMX_AHUBRAMCTL_AMX_CTRL_RAM_ADDR_SHIFT)

#define TEGRA210_AMX_AHUBRAMCTL_AMX_CTRL_SEQ_ACCESS_EN_SHIFT	12
#define TEGRA210_AMX_AHUBRAMCTL_AMX_CTRL_SEQ_ACCESS_EN_MASK		(1 << TEGRA210_AMX_AHUBRAMCTL_AMX_CTRL_SEQ_ACCESS_EN_SHIFT)
#define TEGRA210_AMX_AHUBRAMCTL_AMX_CTRL_SEQ_ACCESS_EN			(1 << TEGRA210_AMX_AHUBRAMCTL_AMX_CTRL_SEQ_ACCESS_EN_SHIFT)

#define TEGRA210_AMX_AHUBRAMCTL_AMX_CTRL_SEQ_READ_COUNT_SHIFT	16
#define TEGRA210_AMX_AHUBRAMCTL_AMX_CTRL_SEQ_READ_COUNT_MASK	(0xff << TEGRA210_AMX_AHUBRAMCTL_AMX_CTRL_SEQ_READ_COUNT_SHIFT)

/* Fields in TEGRA210_AMX_SOFT_RESET */
#define TEGRA210_AMX_SOFT_RESET_SOFT_RESET_SHIFT		0
#define TEGRA210_AMX_SOFT_RESET_SOFT_RESET_MASK			(1 << TEGRA210_AMX_SOFT_RESET_SOFT_RESET_SHIFT)
#define TEGRA210_AMX_SOFT_RESET_SOFT_EN			(1 << TEGRA210_AMX_SOFT_RESET_SOFT_RESET_SHIFT)
#define TEGRA210_AMX_SOFT_RESET_SOFT_DEFAULT			(0 << TEGRA210_AMX_SOFT_RESET_SOFT_RESET_SHIFT)

/*
 * Those defines are not in register field.
 */
#define TEGRA210_AMX_NUM_INPUTS					4
#define TEGRA210_AMX_RAM_DEPTH					16
#define TEGRA210_AMX_MAP_STREAM_NUMBER_SHIFT	6
#define TEGRA210_AMX_MAP_STREAM_NUMBER_MASK		(0x3 << TEGRA210_AMX_MAP_STREAM_NUMBER_SHIFT)
#define TEGRA210_AMX_MAP_WORD_NUMBER_SHIFT		2
#define TEGRA210_AMX_MAP_WORD_NUMBER_MASK		(0xF << TEGRA210_AMX_MAP_WORD_NUMBER_SHIFT)
#define TEGRA210_AMX_MAP_BYTE_NUMBER_SHIFT		0
#define TEGRA210_AMX_MAP_BYTE_NUMBER_MASK		(0x3 << TEGRA210_AMX_MAP_BYTE_NUMBER_SHIFT)

enum {
	TEGRA210_AMX_WAIT_ON_ALL,
	TEGRA210_AMX_WAIT_ON_ANY,
};

enum {
	/* Code assumes that IN_STREAM values of AMX start at 0 */
	TEGRA210_AMX_IN_STREAM0 = 0,
	TEGRA210_AMX_IN_STREAM1,
	TEGRA210_AMX_IN_STREAM2,
	TEGRA210_AMX_IN_STREAM3,
	TEGRA210_AMX_OUT_STREAM,
	TEGRA210_AMX_TOTAL_STREAM
};

enum {
	TEGRA210_AMX_RX_DISABLE,
	TEGRA210_AMX_RX_ENABLE,
};

struct tegra210_amx_soc_data {
	void (*set_audio_cif)(struct regmap *map,
			unsigned int reg,
			struct tegra210_xbar_cif_conf *conf);
};

struct tegra210_amx {
	struct regmap *regmap;
	unsigned int map[TEGRA210_AMX_RAM_DEPTH];
	unsigned int byte_mask[2];
	int output_channels;
	const struct tegra210_amx_soc_data *soc_data;
};

#endif
