/*
 * es755-access.h  --  ES755 Soc Audio access values
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef _ES755_ACCESS_H
#define _ES755_ACCESS_H


#include "es-d300.h"
#if defined(CONFIG_SND_SOC_ES854)
#include "es-a350-reg.h"
#elif defined(CONFIG_SND_SOC_ES857)
#include "es-a375-reg.h"
#else
#include "es-a300-reg.h"
#endif
#include "es755.h"

static struct escore_api_access es755_api_access[ES_API_ADDR_MAX] = {
	[ES_CHANGE_STATUS] = {
		.read_msg = { ES_API_WORD(0x804f, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x904f, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 4,
	},
	[ES_FW_FIRST_CHAR] = {
		.read_msg = { ES_API_WORD(0x8020, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x9020, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES_FW_NEXT_CHAR] = {
		.read_msg = { ES_API_WORD(0x8021, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x9021, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 255,
	},
	[ES_GET_SYS_INTERRUPT] = {
		.read_msg = { ES_API_WORD(0x8053, 0x0000) },
		.read_msg_len = 4,
		.val_shift = 0,
		.val_max = 0,
	},
	[ES_ACCDET_CONFIG] = {
		.read_msg = { ES_API_WORD(0x8055, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x9056, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 0x1FF,
	},
	[ES_GET_ACCDET_STATUS] = {
		.read_msg = { ES_API_WORD(0x8054, 0x0000) },
		.read_msg_len = 4,
		.val_shift = 0,
		.val_max = 1,
	},
	[ES_BUTTON_DETECTION_ENABLE] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x1f30) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x1f30),
			ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 1,
	},
	[ES_BUTTON_SERIAL_CONFIG] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x1f31) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x1f31),
			ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 1,
	},
	[ES_BUTTON_PARALLEL_CONFIG] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x1f32) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x1f32),
			ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 1,
	},
	[ES_BUTTON_DETECTION_RATE] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x1f33) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x1f33),
			ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 3,
	},
	[ES_BUTTON_PRESS_SETTLING_TIME] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x1f34) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x1f34),
			ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 7,
	},
	[ES_BUTTON_BOUNCE_TIME] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x1f35) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x1f35),
			ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 11,
	},
	[ES_BUTTON_DETECTION_LONG_PRESS_TIME] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x1f36) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x1f36),
			ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 15,
	},
	[ES_BUTTON_CTRL1] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x1631) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x1631),
			       ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_CODEC_VALUE] = {
		.read_msg = { ES_API_WORD(0x8009, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x900A, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_CODEC_ADDR] = {
		.write_msg = { ES_API_WORD(0x9008, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_POWER_STATE] = {
		.read_msg = { ES_API_WORD(0x800f, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x9010, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 6,
	},
	[ES_VS_INT_OSC_MEASURE_START] = {
		.read_msg = { ES_API_WORD(0x8070, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x9070, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 1,
	},
	[ES_VS_INT_OSC_MEASURE_STATUS] = {
		.read_msg = { ES_API_WORD(0x8071, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x9071, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 1,
	},
	[ES_EVENT_RESPONSE] = {
		.read_msg = { ES_API_WORD(0x801a, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x901a, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 4,
	},
	[ES_VOICE_SENSE_SET_KEYWORD] = {
		.read_msg = { ES_API_WORD(0x8000, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8000, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 4,
	},
	[ES_VOICE_SENSE_EVENT] = {
		.read_msg = { ES_API_WORD(0x806d, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8000, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 2,
	},
	[ES_VOICE_SENSE_TRAINING_MODE] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x5003) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x5003),
				   ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 2,
	},
	[ES_VOICE_SENSE_DETECTION_SENSITIVITY] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x5004) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x5004),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 10,
	},
	[ES_VOICE_ACTIVITY_DETECTION_SENSITIVITY] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x5005) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x5005),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 10,
	},
	[ES_VS_STORED_KEYWORD] = {
		.read_msg = { ES_API_WORD(0x8000, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x8000, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 1,
	},
	[ES_VOICE_SENSE_TRAINING_RECORD] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x5006) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x5006),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 2,
	},
	[ES_VOICE_SENSE_TRAINING_STATUS] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x5007) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x5007),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 7,
	},
	[ES_VOICE_SENSE_TRAINING_MODEL_LENGTH] = {
		.read_msg = { ES_API_WORD(ES_GET_ALGO_PARAM, 0x500A) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x500A),
			       ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 75,
	},
	[ES_CVS_PRESET] = {
		.read_msg = { ES_API_WORD(0x806F, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x906F, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_SET_NS] = {
		.read_msg = { ES_API_WORD(0x8043, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x901C, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PRESET] = {
		.read_msg = { ES_API_WORD(0x8031, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x9031, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_STEREO_WIDTH] = {
		.read_msg = {ES_API_WORD(ES_GET_ALGO_PARAM, 0x1006)},
		.read_msg_len = 4,
		.write_msg = {
			ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x1006),
			ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000),
		},
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},

	[ES_MIC_CONFIG] = {
		.read_msg = {ES_API_WORD(ES_GET_ALGO_PARAM, 0x0002)},
		.read_msg_len = 4,
		.write_msg = {
			ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x0002),
			ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000),
		},
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},

	[ES_AEC_MODE] = {
		.read_msg = {ES_API_WORD(ES_GET_ALGO_PARAM, 0x0003)},
		.read_msg_len = 4,
		.write_msg = {
			ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x0003),
			ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000),
		},
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},

	[ES_AF_MODE] = {
		.read_msg = {ES_API_WORD(ES_GET_ALGO_PARAM, 0x2002)},
		.read_msg_len = 4,
		.write_msg = {
			ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x2002),
			ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000),
		},
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},

	[ES_VP_METERS] = {
		.read_msg = {ES_API_WORD(ES_GET_ALGO_PARAM, 0x003A)},
		.read_msg_len = 4,
		.write_msg = {
			ES_API_WORD(ES_SET_ALGO_PARAM_ID, 0x003A),
			ES_API_WORD(ES_SET_ALGO_PARAM, 0x0000),
		},
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 1,
	},

	[ES_PORT_WORD_LEN] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0000),
			ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORT_TDM_SLOTS_PER_FRAME] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0001) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0001),
			ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORT_TX_DELAY_FROM_FS] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0002) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0002),
			ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORT_RX_DELAY_FROM_FS] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0003) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0003),
			ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORT_LATCH_EDGE] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0004) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0004),
			ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORT_ENDIAN] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0005) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0005),
			ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORT_TRISTATE] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0006) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0006),
			ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORT_AUDIO_MODE] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0007) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0007),
			ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORT_TDM_ENABLED] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0008) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0008),
			ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORT_CLOCK_CONTROL] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x0009) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x0009),
			ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORT_DATA_JUSTIFICATION] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x000a) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x000a),
			ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_PORT_FS_DURATION] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x000b) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x000b),
			ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_FE_STREAMING] = {
		.read_msg = { ES_API_WORD(0x8028, 0x0000) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(0x9028, 0x0000) },
		.write_msg_len = 4,
		.val_shift = 0,
		.val_max = 65535,
	},
	[ES_CODEC_OUTPUT_RATE] = {
		.read_msg = { ES_API_WORD(ES_GET_DEV_PARAM, 0x1604) },
		.read_msg_len = 4,
		.write_msg = { ES_API_WORD(ES_SET_DEV_PARAM_ID, 0x1604),
			ES_API_WORD(ES_SET_DEV_PARAM, 0x0000) },
		.write_msg_len = 8,
		.val_shift = 0,
		.val_max = 65535,
	},

};

static struct escore_reg_cache a300_reg_cache[ES_MAX_REGISTER] = { {0} };


#endif /* _ES_ACCESS_H */
