/*
 * drivers/video/tegra/host/tsec/hw_tsec.h
 *
 * Copyright (c) 2012, NVIDIA Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

 /*
  * Function naming determines intended use:
  *
  *     <x>_r(void) : Returns the offset for register <x>.
  *
  *     <x>_w(void) : Returns the word offset for word (4 byte) element <x>.
  *
  *     <x>_<y>_s(void) : Returns size of field <y> of register <x> in bits.
  *
  *     <x>_<y>_f(u32 v) : Returns a value based on 'v' which has been shifted
  *         and masked to place it at field <y> of register <x>.  This value
  *         can be |'d with others to produce a full register value for
  *         register <x>.
  *
  *     <x>_<y>_m(void) : Returns a mask for field <y> of register <x>.  This
  *         value can be ~'d and then &'d to clear the value of field <y> for
  *         register <x>.
  *
  *     <x>_<y>_<z>_f(void) : Returns the constant value <z> after being shifted
  *         to place it at field <y> of register <x>.  This value can be |'d
  *         with others to produce a full register value for <x>.
  *
  *     <x>_<y>_v(u32 r) : Returns the value of field <y> from a full register
  *         <x> value 'r' after being shifted to place its LSB at bit 0.
  *         This value is suitable for direct comparison with other unshifted
  *         values appropriate for use in field <y> of register <x>.
  *
  *     <x>_<y>_<z>_v(void) : Returns the constant value for <z> defined for
  *         field <y> of register <x>.  This value is suitable for direct
  *         comparison with unshifted values appropriate for use in field <y>
  *         of register <x>.
  */

#ifndef __hw_tsec_h__
#define __hw_tsec_h__
/*This file is autogenerated.  Do not edit. */

static inline u32 tsec_irqsclr_r(void)
{
	return 0x00001004;
}
static inline u32 tsec_irqsclr_gptmr_s(void)
{
	return 1;
}
static inline u32 tsec_irqsclr_gptmr_f(u32 v)
{
	return (v & 0x1) << 0;
}
static inline u32 tsec_irqsclr_gptmr_m(void)
{
	return 0x1 << 0;
}
static inline u32 tsec_irqsclr_gptmr_v(u32 r)
{
	return (r >> 0) & 0x1;
}
static inline u32 tsec_irqsclr_gptmr_set_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqsclr_gptmr_set_f(void)
{
	return 0x1;
}
static inline u32 tsec_irqsclr_wdtmr_s(void)
{
	return 1;
}
static inline u32 tsec_irqsclr_wdtmr_f(u32 v)
{
	return (v & 0x1) << 1;
}
static inline u32 tsec_irqsclr_wdtmr_m(void)
{
	return 0x1 << 1;
}
static inline u32 tsec_irqsclr_wdtmr_v(u32 r)
{
	return (r >> 1) & 0x1;
}
static inline u32 tsec_irqsclr_wdtmr_set_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqsclr_wdtmr_set_f(void)
{
	return 0x2;
}
static inline u32 tsec_irqsclr_mthd_s(void)
{
	return 1;
}
static inline u32 tsec_irqsclr_mthd_f(u32 v)
{
	return (v & 0x1) << 2;
}
static inline u32 tsec_irqsclr_mthd_m(void)
{
	return 0x1 << 2;
}
static inline u32 tsec_irqsclr_mthd_v(u32 r)
{
	return (r >> 2) & 0x1;
}
static inline u32 tsec_irqsclr_mthd_set_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqsclr_mthd_set_f(void)
{
	return 0x4;
}
static inline u32 tsec_irqsclr_ctxsw_s(void)
{
	return 1;
}
static inline u32 tsec_irqsclr_ctxsw_f(u32 v)
{
	return (v & 0x1) << 3;
}
static inline u32 tsec_irqsclr_ctxsw_m(void)
{
	return 0x1 << 3;
}
static inline u32 tsec_irqsclr_ctxsw_v(u32 r)
{
	return (r >> 3) & 0x1;
}
static inline u32 tsec_irqsclr_ctxsw_set_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqsclr_ctxsw_set_f(void)
{
	return 0x8;
}
static inline u32 tsec_irqsclr_halt_s(void)
{
	return 1;
}
static inline u32 tsec_irqsclr_halt_f(u32 v)
{
	return (v & 0x1) << 4;
}
static inline u32 tsec_irqsclr_halt_m(void)
{
	return 0x1 << 4;
}
static inline u32 tsec_irqsclr_halt_v(u32 r)
{
	return (r >> 4) & 0x1;
}
static inline u32 tsec_irqsclr_halt_set_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqsclr_halt_set_f(void)
{
	return 0x10;
}
static inline u32 tsec_irqsclr_exterr_s(void)
{
	return 1;
}
static inline u32 tsec_irqsclr_exterr_f(u32 v)
{
	return (v & 0x1) << 5;
}
static inline u32 tsec_irqsclr_exterr_m(void)
{
	return 0x1 << 5;
}
static inline u32 tsec_irqsclr_exterr_v(u32 r)
{
	return (r >> 5) & 0x1;
}
static inline u32 tsec_irqsclr_exterr_set_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqsclr_exterr_set_f(void)
{
	return 0x20;
}
static inline u32 tsec_irqsclr_swgen0_s(void)
{
	return 1;
}
static inline u32 tsec_irqsclr_swgen0_f(u32 v)
{
	return (v & 0x1) << 6;
}
static inline u32 tsec_irqsclr_swgen0_m(void)
{
	return 0x1 << 6;
}
static inline u32 tsec_irqsclr_swgen0_v(u32 r)
{
	return (r >> 6) & 0x1;
}
static inline u32 tsec_irqsclr_swgen0_set_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqsclr_swgen0_set_f(void)
{
	return 0x40;
}
static inline u32 tsec_irqsclr_swgen1_s(void)
{
	return 1;
}
static inline u32 tsec_irqsclr_swgen1_f(u32 v)
{
	return (v & 0x1) << 7;
}
static inline u32 tsec_irqsclr_swgen1_m(void)
{
	return 0x1 << 7;
}
static inline u32 tsec_irqsclr_swgen1_v(u32 r)
{
	return (r >> 7) & 0x1;
}
static inline u32 tsec_irqsclr_swgen1_set_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqsclr_swgen1_set_f(void)
{
	return 0x80;
}
static inline u32 tsec_irqsclr_ext_s(void)
{
	return 8;
}
static inline u32 tsec_irqsclr_ext_f(u32 v)
{
	return (v & 0xff) << 8;
}
static inline u32 tsec_irqsclr_ext_m(void)
{
	return 0xff << 8;
}
static inline u32 tsec_irqsclr_ext_v(u32 r)
{
	return (r >> 8) & 0xff;
}
static inline u32 tsec_irqmset_r(void)
{
	return 0x00001010;
}
static inline u32 tsec_irqmset_gptmr_s(void)
{
	return 1;
}
static inline u32 tsec_irqmset_gptmr_f(u32 v)
{
	return (v & 0x1) << 0;
}
static inline u32 tsec_irqmset_gptmr_m(void)
{
	return 0x1 << 0;
}
static inline u32 tsec_irqmset_gptmr_v(u32 r)
{
	return (r >> 0) & 0x1;
}
static inline u32 tsec_irqmset_gptmr_set_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqmset_gptmr_set_f(void)
{
	return 0x1;
}
static inline u32 tsec_irqmset_wdtmr_s(void)
{
	return 1;
}
static inline u32 tsec_irqmset_wdtmr_f(u32 v)
{
	return (v & 0x1) << 1;
}
static inline u32 tsec_irqmset_wdtmr_m(void)
{
	return 0x1 << 1;
}
static inline u32 tsec_irqmset_wdtmr_v(u32 r)
{
	return (r >> 1) & 0x1;
}
static inline u32 tsec_irqmset_wdtmr_set_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqmset_wdtmr_set_f(void)
{
	return 0x2;
}
static inline u32 tsec_irqmset_mthd_s(void)
{
	return 1;
}
static inline u32 tsec_irqmset_mthd_f(u32 v)
{
	return (v & 0x1) << 2;
}
static inline u32 tsec_irqmset_mthd_m(void)
{
	return 0x1 << 2;
}
static inline u32 tsec_irqmset_mthd_v(u32 r)
{
	return (r >> 2) & 0x1;
}
static inline u32 tsec_irqmset_mthd_set_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqmset_mthd_set_f(void)
{
	return 0x4;
}
static inline u32 tsec_irqmset_ctxsw_s(void)
{
	return 1;
}
static inline u32 tsec_irqmset_ctxsw_f(u32 v)
{
	return (v & 0x1) << 3;
}
static inline u32 tsec_irqmset_ctxsw_m(void)
{
	return 0x1 << 3;
}
static inline u32 tsec_irqmset_ctxsw_v(u32 r)
{
	return (r >> 3) & 0x1;
}
static inline u32 tsec_irqmset_ctxsw_set_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqmset_ctxsw_set_f(void)
{
	return 0x8;
}
static inline u32 tsec_irqmset_halt_s(void)
{
	return 1;
}
static inline u32 tsec_irqmset_halt_f(u32 v)
{
	return (v & 0x1) << 4;
}
static inline u32 tsec_irqmset_halt_m(void)
{
	return 0x1 << 4;
}
static inline u32 tsec_irqmset_halt_v(u32 r)
{
	return (r >> 4) & 0x1;
}
static inline u32 tsec_irqmset_halt_set_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqmset_halt_set_f(void)
{
	return 0x10;
}
static inline u32 tsec_irqmset_exterr_s(void)
{
	return 1;
}
static inline u32 tsec_irqmset_exterr_f(u32 v)
{
	return (v & 0x1) << 5;
}
static inline u32 tsec_irqmset_exterr_m(void)
{
	return 0x1 << 5;
}
static inline u32 tsec_irqmset_exterr_v(u32 r)
{
	return (r >> 5) & 0x1;
}
static inline u32 tsec_irqmset_exterr_set_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqmset_exterr_set_f(void)
{
	return 0x20;
}
static inline u32 tsec_irqmset_swgen0_s(void)
{
	return 1;
}
static inline u32 tsec_irqmset_swgen0_f(u32 v)
{
	return (v & 0x1) << 6;
}
static inline u32 tsec_irqmset_swgen0_m(void)
{
	return 0x1 << 6;
}
static inline u32 tsec_irqmset_swgen0_v(u32 r)
{
	return (r >> 6) & 0x1;
}
static inline u32 tsec_irqmset_swgen0_set_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqmset_swgen0_set_f(void)
{
	return 0x40;
}
static inline u32 tsec_irqmset_swgen1_s(void)
{
	return 1;
}
static inline u32 tsec_irqmset_swgen1_f(u32 v)
{
	return (v & 0x1) << 7;
}
static inline u32 tsec_irqmset_swgen1_m(void)
{
	return 0x1 << 7;
}
static inline u32 tsec_irqmset_swgen1_v(u32 r)
{
	return (r >> 7) & 0x1;
}
static inline u32 tsec_irqmset_swgen1_set_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqmset_swgen1_set_f(void)
{
	return 0x80;
}
static inline u32 tsec_irqmset_ext_s(void)
{
	return 8;
}
static inline u32 tsec_irqmset_ext_f(u32 v)
{
	return (v & 0xff) << 8;
}
static inline u32 tsec_irqmset_ext_m(void)
{
	return 0xff << 8;
}
static inline u32 tsec_irqmset_ext_v(u32 r)
{
	return (r >> 8) & 0xff;
}
static inline u32 tsec_irqdest_r(void)
{
	return 0x0000101c;
}
static inline u32 tsec_irqdest_host_gptmr_s(void)
{
	return 1;
}
static inline u32 tsec_irqdest_host_gptmr_f(u32 v)
{
	return (v & 0x1) << 0;
}
static inline u32 tsec_irqdest_host_gptmr_m(void)
{
	return 0x1 << 0;
}
static inline u32 tsec_irqdest_host_gptmr_v(u32 r)
{
	return (r >> 0) & 0x1;
}
static inline u32 tsec_irqdest_host_gptmr_init_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_host_gptmr_init_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_host_gptmr_falcon_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_host_gptmr_falcon_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_host_gptmr_host_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqdest_host_gptmr_host_f(void)
{
	return 0x1;
}
static inline u32 tsec_irqdest_host_wdtmr_s(void)
{
	return 1;
}
static inline u32 tsec_irqdest_host_wdtmr_f(u32 v)
{
	return (v & 0x1) << 1;
}
static inline u32 tsec_irqdest_host_wdtmr_m(void)
{
	return 0x1 << 1;
}
static inline u32 tsec_irqdest_host_wdtmr_v(u32 r)
{
	return (r >> 1) & 0x1;
}
static inline u32 tsec_irqdest_host_wdtmr_init_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_host_wdtmr_init_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_host_wdtmr_falcon_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_host_wdtmr_falcon_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_host_wdtmr_host_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqdest_host_wdtmr_host_f(void)
{
	return 0x2;
}
static inline u32 tsec_irqdest_host_mthd_s(void)
{
	return 1;
}
static inline u32 tsec_irqdest_host_mthd_f(u32 v)
{
	return (v & 0x1) << 2;
}
static inline u32 tsec_irqdest_host_mthd_m(void)
{
	return 0x1 << 2;
}
static inline u32 tsec_irqdest_host_mthd_v(u32 r)
{
	return (r >> 2) & 0x1;
}
static inline u32 tsec_irqdest_host_mthd_init_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_host_mthd_init_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_host_mthd_falcon_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_host_mthd_falcon_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_host_mthd_host_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqdest_host_mthd_host_f(void)
{
	return 0x4;
}
static inline u32 tsec_irqdest_host_ctxsw_s(void)
{
	return 1;
}
static inline u32 tsec_irqdest_host_ctxsw_f(u32 v)
{
	return (v & 0x1) << 3;
}
static inline u32 tsec_irqdest_host_ctxsw_m(void)
{
	return 0x1 << 3;
}
static inline u32 tsec_irqdest_host_ctxsw_v(u32 r)
{
	return (r >> 3) & 0x1;
}
static inline u32 tsec_irqdest_host_ctxsw_init_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_host_ctxsw_init_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_host_ctxsw_falcon_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_host_ctxsw_falcon_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_host_ctxsw_host_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqdest_host_ctxsw_host_f(void)
{
	return 0x8;
}
static inline u32 tsec_irqdest_host_halt_s(void)
{
	return 1;
}
static inline u32 tsec_irqdest_host_halt_f(u32 v)
{
	return (v & 0x1) << 4;
}
static inline u32 tsec_irqdest_host_halt_m(void)
{
	return 0x1 << 4;
}
static inline u32 tsec_irqdest_host_halt_v(u32 r)
{
	return (r >> 4) & 0x1;
}
static inline u32 tsec_irqdest_host_halt_init_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_host_halt_init_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_host_halt_falcon_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_host_halt_falcon_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_host_halt_host_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqdest_host_halt_host_f(void)
{
	return 0x10;
}
static inline u32 tsec_irqdest_host_exterr_s(void)
{
	return 1;
}
static inline u32 tsec_irqdest_host_exterr_f(u32 v)
{
	return (v & 0x1) << 5;
}
static inline u32 tsec_irqdest_host_exterr_m(void)
{
	return 0x1 << 5;
}
static inline u32 tsec_irqdest_host_exterr_v(u32 r)
{
	return (r >> 5) & 0x1;
}
static inline u32 tsec_irqdest_host_exterr_init_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_host_exterr_init_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_host_exterr_falcon_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_host_exterr_falcon_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_host_exterr_host_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqdest_host_exterr_host_f(void)
{
	return 0x20;
}
static inline u32 tsec_irqdest_host_swgen0_s(void)
{
	return 1;
}
static inline u32 tsec_irqdest_host_swgen0_f(u32 v)
{
	return (v & 0x1) << 6;
}
static inline u32 tsec_irqdest_host_swgen0_m(void)
{
	return 0x1 << 6;
}
static inline u32 tsec_irqdest_host_swgen0_v(u32 r)
{
	return (r >> 6) & 0x1;
}
static inline u32 tsec_irqdest_host_swgen0_init_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_host_swgen0_init_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_host_swgen0_falcon_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_host_swgen0_falcon_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_host_swgen0_host_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqdest_host_swgen0_host_f(void)
{
	return 0x40;
}
static inline u32 tsec_irqdest_host_swgen1_s(void)
{
	return 1;
}
static inline u32 tsec_irqdest_host_swgen1_f(u32 v)
{
	return (v & 0x1) << 7;
}
static inline u32 tsec_irqdest_host_swgen1_m(void)
{
	return 0x1 << 7;
}
static inline u32 tsec_irqdest_host_swgen1_v(u32 r)
{
	return (r >> 7) & 0x1;
}
static inline u32 tsec_irqdest_host_swgen1_init_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_host_swgen1_init_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_host_swgen1_falcon_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_host_swgen1_falcon_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_host_swgen1_host_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqdest_host_swgen1_host_f(void)
{
	return 0x80;
}
static inline u32 tsec_irqdest_host_ext_s(void)
{
	return 8;
}
static inline u32 tsec_irqdest_host_ext_f(u32 v)
{
	return (v & 0xff) << 8;
}
static inline u32 tsec_irqdest_host_ext_m(void)
{
	return 0xff << 8;
}
static inline u32 tsec_irqdest_host_ext_v(u32 r)
{
	return (r >> 8) & 0xff;
}
static inline u32 tsec_irqdest_target_gptmr_s(void)
{
	return 1;
}
static inline u32 tsec_irqdest_target_gptmr_f(u32 v)
{
	return (v & 0x1) << 16;
}
static inline u32 tsec_irqdest_target_gptmr_m(void)
{
	return 0x1 << 16;
}
static inline u32 tsec_irqdest_target_gptmr_v(u32 r)
{
	return (r >> 16) & 0x1;
}
static inline u32 tsec_irqdest_target_gptmr_init_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_target_gptmr_init_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_target_gptmr_falcon_irq0_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_target_gptmr_falcon_irq0_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_target_gptmr_falcon_irq1_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqdest_target_gptmr_falcon_irq1_f(void)
{
	return 0x10000;
}
static inline u32 tsec_irqdest_target_gptmr_host_normal_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_target_gptmr_host_normal_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_target_gptmr_host_nonstall_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqdest_target_gptmr_host_nonstall_f(void)
{
	return 0x10000;
}
static inline u32 tsec_irqdest_target_wdtmr_s(void)
{
	return 1;
}
static inline u32 tsec_irqdest_target_wdtmr_f(u32 v)
{
	return (v & 0x1) << 17;
}
static inline u32 tsec_irqdest_target_wdtmr_m(void)
{
	return 0x1 << 17;
}
static inline u32 tsec_irqdest_target_wdtmr_v(u32 r)
{
	return (r >> 17) & 0x1;
}
static inline u32 tsec_irqdest_target_wdtmr_init_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_target_wdtmr_init_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_target_wdtmr_falcon_irq0_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_target_wdtmr_falcon_irq0_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_target_wdtmr_falcon_irq1_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqdest_target_wdtmr_falcon_irq1_f(void)
{
	return 0x20000;
}
static inline u32 tsec_irqdest_target_wdtmr_host_normal_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_target_wdtmr_host_normal_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_target_wdtmr_host_nonstall_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqdest_target_wdtmr_host_nonstall_f(void)
{
	return 0x20000;
}
static inline u32 tsec_irqdest_target_mthd_s(void)
{
	return 1;
}
static inline u32 tsec_irqdest_target_mthd_f(u32 v)
{
	return (v & 0x1) << 18;
}
static inline u32 tsec_irqdest_target_mthd_m(void)
{
	return 0x1 << 18;
}
static inline u32 tsec_irqdest_target_mthd_v(u32 r)
{
	return (r >> 18) & 0x1;
}
static inline u32 tsec_irqdest_target_mthd_init_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_target_mthd_init_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_target_mthd_falcon_irq0_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_target_mthd_falcon_irq0_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_target_mthd_falcon_irq1_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqdest_target_mthd_falcon_irq1_f(void)
{
	return 0x40000;
}
static inline u32 tsec_irqdest_target_mthd_host_normal_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_target_mthd_host_normal_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_target_mthd_host_nonstall_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqdest_target_mthd_host_nonstall_f(void)
{
	return 0x40000;
}
static inline u32 tsec_irqdest_target_ctxsw_s(void)
{
	return 1;
}
static inline u32 tsec_irqdest_target_ctxsw_f(u32 v)
{
	return (v & 0x1) << 19;
}
static inline u32 tsec_irqdest_target_ctxsw_m(void)
{
	return 0x1 << 19;
}
static inline u32 tsec_irqdest_target_ctxsw_v(u32 r)
{
	return (r >> 19) & 0x1;
}
static inline u32 tsec_irqdest_target_ctxsw_init_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_target_ctxsw_init_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_target_ctxsw_falcon_irq0_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_target_ctxsw_falcon_irq0_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_target_ctxsw_falcon_irq1_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqdest_target_ctxsw_falcon_irq1_f(void)
{
	return 0x80000;
}
static inline u32 tsec_irqdest_target_ctxsw_host_normal_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_target_ctxsw_host_normal_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_target_ctxsw_host_nonstall_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqdest_target_ctxsw_host_nonstall_f(void)
{
	return 0x80000;
}
static inline u32 tsec_irqdest_target_halt_s(void)
{
	return 1;
}
static inline u32 tsec_irqdest_target_halt_f(u32 v)
{
	return (v & 0x1) << 20;
}
static inline u32 tsec_irqdest_target_halt_m(void)
{
	return 0x1 << 20;
}
static inline u32 tsec_irqdest_target_halt_v(u32 r)
{
	return (r >> 20) & 0x1;
}
static inline u32 tsec_irqdest_target_halt_init_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_target_halt_init_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_target_halt_falcon_irq0_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_target_halt_falcon_irq0_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_target_halt_falcon_irq1_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqdest_target_halt_falcon_irq1_f(void)
{
	return 0x100000;
}
static inline u32 tsec_irqdest_target_halt_host_normal_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_target_halt_host_normal_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_target_halt_host_nonstall_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqdest_target_halt_host_nonstall_f(void)
{
	return 0x100000;
}
static inline u32 tsec_irqdest_target_exterr_s(void)
{
	return 1;
}
static inline u32 tsec_irqdest_target_exterr_f(u32 v)
{
	return (v & 0x1) << 21;
}
static inline u32 tsec_irqdest_target_exterr_m(void)
{
	return 0x1 << 21;
}
static inline u32 tsec_irqdest_target_exterr_v(u32 r)
{
	return (r >> 21) & 0x1;
}
static inline u32 tsec_irqdest_target_exterr_init_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_target_exterr_init_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_target_exterr_falcon_irq0_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_target_exterr_falcon_irq0_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_target_exterr_falcon_irq1_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqdest_target_exterr_falcon_irq1_f(void)
{
	return 0x200000;
}
static inline u32 tsec_irqdest_target_exterr_host_normal_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_target_exterr_host_normal_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_target_exterr_host_nonstall_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqdest_target_exterr_host_nonstall_f(void)
{
	return 0x200000;
}
static inline u32 tsec_irqdest_target_swgen0_s(void)
{
	return 1;
}
static inline u32 tsec_irqdest_target_swgen0_f(u32 v)
{
	return (v & 0x1) << 22;
}
static inline u32 tsec_irqdest_target_swgen0_m(void)
{
	return 0x1 << 22;
}
static inline u32 tsec_irqdest_target_swgen0_v(u32 r)
{
	return (r >> 22) & 0x1;
}
static inline u32 tsec_irqdest_target_swgen0_init_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_target_swgen0_init_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_target_swgen0_falcon_irq0_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_target_swgen0_falcon_irq0_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_target_swgen0_falcon_irq1_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqdest_target_swgen0_falcon_irq1_f(void)
{
	return 0x400000;
}
static inline u32 tsec_irqdest_target_swgen0_host_normal_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_target_swgen0_host_normal_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_target_swgen0_host_nonstall_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqdest_target_swgen0_host_nonstall_f(void)
{
	return 0x400000;
}
static inline u32 tsec_irqdest_target_swgen1_s(void)
{
	return 1;
}
static inline u32 tsec_irqdest_target_swgen1_f(u32 v)
{
	return (v & 0x1) << 23;
}
static inline u32 tsec_irqdest_target_swgen1_m(void)
{
	return 0x1 << 23;
}
static inline u32 tsec_irqdest_target_swgen1_v(u32 r)
{
	return (r >> 23) & 0x1;
}
static inline u32 tsec_irqdest_target_swgen1_init_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_target_swgen1_init_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_target_swgen1_falcon_irq0_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_target_swgen1_falcon_irq0_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_target_swgen1_falcon_irq1_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqdest_target_swgen1_falcon_irq1_f(void)
{
	return 0x800000;
}
static inline u32 tsec_irqdest_target_swgen1_host_normal_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_irqdest_target_swgen1_host_normal_f(void)
{
	return 0x0;
}
static inline u32 tsec_irqdest_target_swgen1_host_nonstall_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_irqdest_target_swgen1_host_nonstall_f(void)
{
	return 0x800000;
}
static inline u32 tsec_irqdest_target_ext_s(void)
{
	return 8;
}
static inline u32 tsec_irqdest_target_ext_f(u32 v)
{
	return (v & 0xff) << 24;
}
static inline u32 tsec_irqdest_target_ext_m(void)
{
	return 0xff << 24;
}
static inline u32 tsec_irqdest_target_ext_v(u32 r)
{
	return (r >> 24) & 0xff;
}
static inline u32 tsec_itfen_r(void)
{
	return 0x00001048;
}
static inline u32 tsec_itfen_ctxen_s(void)
{
	return 1;
}
static inline u32 tsec_itfen_ctxen_f(u32 v)
{
	return (v & 0x1) << 0;
}
static inline u32 tsec_itfen_ctxen_m(void)
{
	return 0x1 << 0;
}
static inline u32 tsec_itfen_ctxen_v(u32 r)
{
	return (r >> 0) & 0x1;
}
static inline u32 tsec_itfen_ctxen_init_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_itfen_ctxen_init_f(void)
{
	return 0x0;
}
static inline u32 tsec_itfen_ctxen_disable_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_itfen_ctxen_disable_f(void)
{
	return 0x0;
}
static inline u32 tsec_itfen_ctxen_enable_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_itfen_ctxen_enable_f(void)
{
	return 0x1;
}
static inline u32 tsec_itfen_mthden_s(void)
{
	return 1;
}
static inline u32 tsec_itfen_mthden_f(u32 v)
{
	return (v & 0x1) << 1;
}
static inline u32 tsec_itfen_mthden_m(void)
{
	return 0x1 << 1;
}
static inline u32 tsec_itfen_mthden_v(u32 r)
{
	return (r >> 1) & 0x1;
}
static inline u32 tsec_itfen_mthden_init_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_itfen_mthden_init_f(void)
{
	return 0x0;
}
static inline u32 tsec_itfen_mthden_disable_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_itfen_mthden_disable_f(void)
{
	return 0x0;
}
static inline u32 tsec_itfen_mthden_enable_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_itfen_mthden_enable_f(void)
{
	return 0x2;
}
static inline u32 tsec_idlestate_r(void)
{
	return 0x0000104c;
}
static inline u32 tsec_idlestate_falcon_busy_s(void)
{
	return 1;
}
static inline u32 tsec_idlestate_falcon_busy_f(u32 v)
{
	return (v & 0x1) << 0;
}
static inline u32 tsec_idlestate_falcon_busy_m(void)
{
	return 0x1 << 0;
}
static inline u32 tsec_idlestate_falcon_busy_v(u32 r)
{
	return (r >> 0) & 0x1;
}
static inline u32 tsec_idlestate_falcon_busy_false_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_idlestate_falcon_busy_false_f(void)
{
	return 0x0;
}
static inline u32 tsec_idlestate_falcon_busy_true_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_idlestate_falcon_busy_true_f(void)
{
	return 0x1;
}
static inline u32 tsec_idlestate_ext_busy_s(void)
{
	return 15;
}
static inline u32 tsec_idlestate_ext_busy_f(u32 v)
{
	return (v & 0x7fff) << 1;
}
static inline u32 tsec_idlestate_ext_busy_m(void)
{
	return 0x7fff << 1;
}
static inline u32 tsec_idlestate_ext_busy_v(u32 r)
{
	return (r >> 1) & 0x7fff;
}
static inline u32 tsec_cpuctl_r(void)
{
	return 0x00001100;
}
static inline u32 tsec_cpuctl_iinval_s(void)
{
	return 1;
}
static inline u32 tsec_cpuctl_iinval_f(u32 v)
{
	return (v & 0x1) << 0;
}
static inline u32 tsec_cpuctl_iinval_m(void)
{
	return 0x1 << 0;
}
static inline u32 tsec_cpuctl_iinval_v(u32 r)
{
	return (r >> 0) & 0x1;
}
static inline u32 tsec_cpuctl_iinval_true_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_cpuctl_iinval_true_f(void)
{
	return 0x1;
}
static inline u32 tsec_cpuctl_iinval_false_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_cpuctl_iinval_false_f(void)
{
	return 0x0;
}
static inline u32 tsec_cpuctl_startcpu_s(void)
{
	return 1;
}
static inline u32 tsec_cpuctl_startcpu_f(u32 v)
{
	return (v & 0x1) << 1;
}
static inline u32 tsec_cpuctl_startcpu_m(void)
{
	return 0x1 << 1;
}
static inline u32 tsec_cpuctl_startcpu_v(u32 r)
{
	return (r >> 1) & 0x1;
}
static inline u32 tsec_cpuctl_startcpu_true_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_cpuctl_startcpu_true_f(void)
{
	return 0x2;
}
static inline u32 tsec_cpuctl_startcpu_false_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_cpuctl_startcpu_false_f(void)
{
	return 0x0;
}
static inline u32 tsec_cpuctl_sreset_s(void)
{
	return 1;
}
static inline u32 tsec_cpuctl_sreset_f(u32 v)
{
	return (v & 0x1) << 2;
}
static inline u32 tsec_cpuctl_sreset_m(void)
{
	return 0x1 << 2;
}
static inline u32 tsec_cpuctl_sreset_v(u32 r)
{
	return (r >> 2) & 0x1;
}
static inline u32 tsec_cpuctl_sreset_true_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_cpuctl_sreset_true_f(void)
{
	return 0x4;
}
static inline u32 tsec_cpuctl_sreset_false_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_cpuctl_sreset_false_f(void)
{
	return 0x0;
}
static inline u32 tsec_cpuctl_hreset_s(void)
{
	return 1;
}
static inline u32 tsec_cpuctl_hreset_f(u32 v)
{
	return (v & 0x1) << 3;
}
static inline u32 tsec_cpuctl_hreset_m(void)
{
	return 0x1 << 3;
}
static inline u32 tsec_cpuctl_hreset_v(u32 r)
{
	return (r >> 3) & 0x1;
}
static inline u32 tsec_cpuctl_hreset_true_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_cpuctl_hreset_true_f(void)
{
	return 0x8;
}
static inline u32 tsec_cpuctl_hreset_false_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_cpuctl_hreset_false_f(void)
{
	return 0x0;
}
static inline u32 tsec_cpuctl_halted_s(void)
{
	return 1;
}
static inline u32 tsec_cpuctl_halted_f(u32 v)
{
	return (v & 0x1) << 4;
}
static inline u32 tsec_cpuctl_halted_m(void)
{
	return 0x1 << 4;
}
static inline u32 tsec_cpuctl_halted_v(u32 r)
{
	return (r >> 4) & 0x1;
}
static inline u32 tsec_cpuctl_halted_true_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_cpuctl_halted_true_f(void)
{
	return 0x10;
}
static inline u32 tsec_cpuctl_halted_false_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_cpuctl_halted_false_f(void)
{
	return 0x0;
}
static inline u32 tsec_cpuctl_stopped_s(void)
{
	return 1;
}
static inline u32 tsec_cpuctl_stopped_f(u32 v)
{
	return (v & 0x1) << 5;
}
static inline u32 tsec_cpuctl_stopped_m(void)
{
	return 0x1 << 5;
}
static inline u32 tsec_cpuctl_stopped_v(u32 r)
{
	return (r >> 5) & 0x1;
}
static inline u32 tsec_cpuctl_stopped_true_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_cpuctl_stopped_true_f(void)
{
	return 0x20;
}
static inline u32 tsec_cpuctl_stopped_false_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_cpuctl_stopped_false_f(void)
{
	return 0x0;
}
static inline u32 tsec_bootvec_r(void)
{
	return 0x00001104;
}
static inline u32 tsec_bootvec_vec_s(void)
{
	return 32;
}
static inline u32 tsec_bootvec_vec_f(u32 v)
{
	return (v & 0xffffffff) << 0;
}
static inline u32 tsec_bootvec_vec_m(void)
{
	return 0xffffffff << 0;
}
static inline u32 tsec_bootvec_vec_v(u32 r)
{
	return (r >> 0) & 0xffffffff;
}
static inline u32 tsec_bootvec_vec_init_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_bootvec_vec_init_f(void)
{
	return 0x0;
}
static inline u32 tsec_dmactl_r(void)
{
	return 0x0000110c;
}
static inline u32 tsec_dmactl_require_ctx_s(void)
{
	return 1;
}
static inline u32 tsec_dmactl_require_ctx_f(u32 v)
{
	return (v & 0x1) << 0;
}
static inline u32 tsec_dmactl_require_ctx_m(void)
{
	return 0x1 << 0;
}
static inline u32 tsec_dmactl_require_ctx_v(u32 r)
{
	return (r >> 0) & 0x1;
}
static inline u32 tsec_dmactl_require_ctx_init_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_dmactl_require_ctx_init_f(void)
{
	return 0x1;
}
static inline u32 tsec_dmactl_require_ctx_true_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_dmactl_require_ctx_true_f(void)
{
	return 0x1;
}
static inline u32 tsec_dmactl_require_ctx_false_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_dmactl_require_ctx_false_f(void)
{
	return 0x0;
}
static inline u32 tsec_dmactl_dmem_scrubbing_s(void)
{
	return 1;
}
static inline u32 tsec_dmactl_dmem_scrubbing_f(u32 v)
{
	return (v & 0x1) << 1;
}
static inline u32 tsec_dmactl_dmem_scrubbing_m(void)
{
	return 0x1 << 1;
}
static inline u32 tsec_dmactl_dmem_scrubbing_v(u32 r)
{
	return (r >> 1) & 0x1;
}
static inline u32 tsec_dmactl_dmem_scrubbing_pending_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_dmactl_dmem_scrubbing_pending_f(void)
{
	return 0x2;
}
static inline u32 tsec_dmactl_dmem_scrubbing_done_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_dmactl_dmem_scrubbing_done_f(void)
{
	return 0x0;
}
static inline u32 tsec_dmactl_imem_scrubbing_s(void)
{
	return 1;
}
static inline u32 tsec_dmactl_imem_scrubbing_f(u32 v)
{
	return (v & 0x1) << 2;
}
static inline u32 tsec_dmactl_imem_scrubbing_m(void)
{
	return 0x1 << 2;
}
static inline u32 tsec_dmactl_imem_scrubbing_v(u32 r)
{
	return (r >> 2) & 0x1;
}
static inline u32 tsec_dmactl_imem_scrubbing_pending_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_dmactl_imem_scrubbing_pending_f(void)
{
	return 0x4;
}
static inline u32 tsec_dmactl_imem_scrubbing_done_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_dmactl_imem_scrubbing_done_f(void)
{
	return 0x0;
}
static inline u32 tsec_dmactl_dmaq_num_s(void)
{
	return 4;
}
static inline u32 tsec_dmactl_dmaq_num_f(u32 v)
{
	return (v & 0xf) << 3;
}
static inline u32 tsec_dmactl_dmaq_num_m(void)
{
	return 0xf << 3;
}
static inline u32 tsec_dmactl_dmaq_num_v(u32 r)
{
	return (r >> 3) & 0xf;
}
static inline u32 tsec_dmactl_secure_stat_s(void)
{
	return 1;
}
static inline u32 tsec_dmactl_secure_stat_f(u32 v)
{
	return (v & 0x1) << 7;
}
static inline u32 tsec_dmactl_secure_stat_m(void)
{
	return 0x1 << 7;
}
static inline u32 tsec_dmactl_secure_stat_v(u32 r)
{
	return (r >> 7) & 0x1;
}
static inline u32 tsec_dmatrfbase_r(void)
{
	return 0x00001110;
}
static inline u32 tsec_dmatrfbase_base_s(void)
{
	return 32;
}
static inline u32 tsec_dmatrfbase_base_f(u32 v)
{
	return (v & 0xffffffff) << 0;
}
static inline u32 tsec_dmatrfbase_base_m(void)
{
	return 0xffffffff << 0;
}
static inline u32 tsec_dmatrfbase_base_v(u32 r)
{
	return (r >> 0) & 0xffffffff;
}
static inline u32 tsec_dmatrfbase_base_init_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_dmatrfbase_base_init_f(void)
{
	return 0x0;
}
static inline u32 tsec_dmatrfmoffs_r(void)
{
	return 0x00001114;
}
static inline u32 tsec_dmatrfmoffs_offs_s(void)
{
	return 16;
}
static inline u32 tsec_dmatrfmoffs_offs_f(u32 v)
{
	return (v & 0xffff) << 0;
}
static inline u32 tsec_dmatrfmoffs_offs_m(void)
{
	return 0xffff << 0;
}
static inline u32 tsec_dmatrfmoffs_offs_v(u32 r)
{
	return (r >> 0) & 0xffff;
}
static inline u32 tsec_dmatrfmoffs_offs_init_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_dmatrfmoffs_offs_init_f(void)
{
	return 0x0;
}
static inline u32 tsec_dmatrfcmd_r(void)
{
	return 0x00001118;
}
static inline u32 tsec_dmatrfcmd_full_s(void)
{
	return 1;
}
static inline u32 tsec_dmatrfcmd_full_f(u32 v)
{
	return (v & 0x1) << 0;
}
static inline u32 tsec_dmatrfcmd_full_m(void)
{
	return 0x1 << 0;
}
static inline u32 tsec_dmatrfcmd_full_v(u32 r)
{
	return (r >> 0) & 0x1;
}
static inline u32 tsec_dmatrfcmd_full_true_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_dmatrfcmd_full_true_f(void)
{
	return 0x1;
}
static inline u32 tsec_dmatrfcmd_full_false_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_dmatrfcmd_full_false_f(void)
{
	return 0x0;
}
static inline u32 tsec_dmatrfcmd_idle_s(void)
{
	return 1;
}
static inline u32 tsec_dmatrfcmd_idle_f(u32 v)
{
	return (v & 0x1) << 1;
}
static inline u32 tsec_dmatrfcmd_idle_m(void)
{
	return 0x1 << 1;
}
static inline u32 tsec_dmatrfcmd_idle_v(u32 r)
{
	return (r >> 1) & 0x1;
}
static inline u32 tsec_dmatrfcmd_idle_true_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_dmatrfcmd_idle_true_f(void)
{
	return 0x2;
}
static inline u32 tsec_dmatrfcmd_idle_false_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_dmatrfcmd_idle_false_f(void)
{
	return 0x0;
}
static inline u32 tsec_dmatrfcmd_sec_s(void)
{
	return 2;
}
static inline u32 tsec_dmatrfcmd_sec_f(u32 v)
{
	return (v & 0x3) << 2;
}
static inline u32 tsec_dmatrfcmd_sec_m(void)
{
	return 0x3 << 2;
}
static inline u32 tsec_dmatrfcmd_sec_v(u32 r)
{
	return (r >> 2) & 0x3;
}
static inline u32 tsec_dmatrfcmd_imem_s(void)
{
	return 1;
}
static inline u32 tsec_dmatrfcmd_imem_f(u32 v)
{
	return (v & 0x1) << 4;
}
static inline u32 tsec_dmatrfcmd_imem_m(void)
{
	return 0x1 << 4;
}
static inline u32 tsec_dmatrfcmd_imem_v(u32 r)
{
	return (r >> 4) & 0x1;
}
static inline u32 tsec_dmatrfcmd_imem_true_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_dmatrfcmd_imem_true_f(void)
{
	return 0x10;
}
static inline u32 tsec_dmatrfcmd_imem_false_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_dmatrfcmd_imem_false_f(void)
{
	return 0x0;
}
static inline u32 tsec_dmatrfcmd_write_s(void)
{
	return 1;
}
static inline u32 tsec_dmatrfcmd_write_f(u32 v)
{
	return (v & 0x1) << 5;
}
static inline u32 tsec_dmatrfcmd_write_m(void)
{
	return 0x1 << 5;
}
static inline u32 tsec_dmatrfcmd_write_v(u32 r)
{
	return (r >> 5) & 0x1;
}
static inline u32 tsec_dmatrfcmd_write_true_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_dmatrfcmd_write_true_f(void)
{
	return 0x20;
}
static inline u32 tsec_dmatrfcmd_write_false_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_dmatrfcmd_write_false_f(void)
{
	return 0x0;
}
static inline u32 tsec_dmatrfcmd_size_s(void)
{
	return 3;
}
static inline u32 tsec_dmatrfcmd_size_f(u32 v)
{
	return (v & 0x7) << 8;
}
static inline u32 tsec_dmatrfcmd_size_m(void)
{
	return 0x7 << 8;
}
static inline u32 tsec_dmatrfcmd_size_v(u32 r)
{
	return (r >> 8) & 0x7;
}
static inline u32 tsec_dmatrfcmd_size_4b_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_dmatrfcmd_size_4b_f(void)
{
	return 0x0;
}
static inline u32 tsec_dmatrfcmd_size_8b_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_dmatrfcmd_size_8b_f(void)
{
	return 0x100;
}
static inline u32 tsec_dmatrfcmd_size_16b_v(void)
{
	return 0x00000002;
}
static inline u32 tsec_dmatrfcmd_size_16b_f(void)
{
	return 0x200;
}
static inline u32 tsec_dmatrfcmd_size_32b_v(void)
{
	return 0x00000003;
}
static inline u32 tsec_dmatrfcmd_size_32b_f(void)
{
	return 0x300;
}
static inline u32 tsec_dmatrfcmd_size_64b_v(void)
{
	return 0x00000004;
}
static inline u32 tsec_dmatrfcmd_size_64b_f(void)
{
	return 0x400;
}
static inline u32 tsec_dmatrfcmd_size_128b_v(void)
{
	return 0x00000005;
}
static inline u32 tsec_dmatrfcmd_size_128b_f(void)
{
	return 0x500;
}
static inline u32 tsec_dmatrfcmd_size_256b_v(void)
{
	return 0x00000006;
}
static inline u32 tsec_dmatrfcmd_size_256b_f(void)
{
	return 0x600;
}
static inline u32 tsec_dmatrfcmd_ctxdma_s(void)
{
	return 3;
}
static inline u32 tsec_dmatrfcmd_ctxdma_f(u32 v)
{
	return (v & 0x7) << 12;
}
static inline u32 tsec_dmatrfcmd_ctxdma_m(void)
{
	return 0x7 << 12;
}
static inline u32 tsec_dmatrfcmd_ctxdma_v(u32 r)
{
	return (r >> 12) & 0x7;
}
static inline u32 tsec_dmatrffboffs_r(void)
{
	return 0x0000111c;
}
static inline u32 tsec_dmatrffboffs_offs_s(void)
{
	return 32;
}
static inline u32 tsec_dmatrffboffs_offs_f(u32 v)
{
	return (v & 0xffffffff) << 0;
}
static inline u32 tsec_dmatrffboffs_offs_m(void)
{
	return 0xffffffff << 0;
}
static inline u32 tsec_dmatrffboffs_offs_v(u32 r)
{
	return (r >> 0) & 0xffffffff;
}
static inline u32 tsec_dmatrffboffs_offs_init_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_dmatrffboffs_offs_init_f(void)
{
	return 0x0;
}
static inline u32 tsec_thi_int_status_r(void)
{
	return 0x00000078;
}
static inline u32 tsec_thi_int_status_falcon_int_s(void)
{
	return 1;
}
static inline u32 tsec_thi_int_status_falcon_int_f(u32 v)
{
	return (v & 0x1) << 0;
}
static inline u32 tsec_thi_int_status_falcon_int_m(void)
{
	return 0x1 << 0;
}
static inline u32 tsec_thi_int_status_falcon_int_v(u32 r)
{
	return (r >> 0) & 0x1;
}
static inline u32 tsec_thi_int_status_falcon_int_init_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_thi_int_status_falcon_int_init_f(void)
{
	return 0x0;
}
static inline u32 tsec_thi_int_status_falcon_int_clear_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_thi_int_status_falcon_int_clear_f(void)
{
	return 0x1;
}
static inline u32 tsec_tegra_ctl_r(void)
{
	return 0x00001838;
}
static inline u32 tsec_tegra_ctl_tkfi_kfuse_s(void)
{
	return 1;
}
static inline u32 tsec_tegra_ctl_tkfi_kfuse_f(u32 v)
{
	return (v & 0x1) << 16;
}
static inline u32 tsec_tegra_ctl_tkfi_kfuse_m(void)
{
	return 0x1 << 16;
}
static inline u32 tsec_tegra_ctl_tkfi_kfuse_v(u32 r)
{
	return (r >> 16) & 0x1;
}
static inline u32 tsec_tegra_ctl_tkfi_kfuse_init_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_tegra_ctl_tkfi_kfuse_init_f(void)
{
	return 0x10000;
}
static inline u32 tsec_tegra_ctl_tkfi_kfuse_disable_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_tegra_ctl_tkfi_kfuse_disable_f(void)
{
	return 0x0;
}
static inline u32 tsec_tegra_ctl_tkfi_kfuse_enable_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_tegra_ctl_tkfi_kfuse_enable_f(void)
{
	return 0x10000;
}
static inline u32 tsec_tegra_ctl_tkfi_restart_fsm_kfuse_s(void)
{
	return 1;
}
static inline u32 tsec_tegra_ctl_tkfi_restart_fsm_kfuse_f(u32 v)
{
	return (v & 0x1) << 17;
}
static inline u32 tsec_tegra_ctl_tkfi_restart_fsm_kfuse_m(void)
{
	return 0x1 << 17;
}
static inline u32 tsec_tegra_ctl_tkfi_restart_fsm_kfuse_v(u32 r)
{
	return (r >> 17) & 0x1;
}
static inline u32 tsec_tegra_ctl_tkfi_restart_fsm_kfuse_init_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_tegra_ctl_tkfi_restart_fsm_kfuse_init_f(void)
{
	return 0x0;
}
static inline u32 tsec_tegra_ctl_tmpi_force_idle_inputs_i2c_s(void)
{
	return 1;
}
static inline u32 tsec_tegra_ctl_tmpi_force_idle_inputs_i2c_f(u32 v)
{
	return (v & 0x1) << 24;
}
static inline u32 tsec_tegra_ctl_tmpi_force_idle_inputs_i2c_m(void)
{
	return 0x1 << 24;
}
static inline u32 tsec_tegra_ctl_tmpi_force_idle_inputs_i2c_v(u32 r)
{
	return (r >> 24) & 0x1;
}
static inline u32 tsec_tegra_ctl_tmpi_force_idle_inputs_i2c_init_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_tegra_ctl_tmpi_force_idle_inputs_i2c_init_f(void)
{
	return 0x1000000;
}
static inline u32 tsec_tegra_ctl_tmpi_force_idle_inputs_i2c_enable_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_tegra_ctl_tmpi_force_idle_inputs_i2c_enable_f(void)
{
	return 0x0;
}
static inline u32 tsec_tegra_ctl_tmpi_force_idle_inputs_i2c_disable_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_tegra_ctl_tmpi_force_idle_inputs_i2c_disable_f(void)
{
	return 0x1000000;
}
static inline u32 tsec_tegra_ctl_tmpi_restart_fsm_host1x_s(void)
{
	return 1;
}
static inline u32 tsec_tegra_ctl_tmpi_restart_fsm_host1x_f(u32 v)
{
	return (v & 0x1) << 25;
}
static inline u32 tsec_tegra_ctl_tmpi_restart_fsm_host1x_m(void)
{
	return 0x1 << 25;
}
static inline u32 tsec_tegra_ctl_tmpi_restart_fsm_host1x_v(u32 r)
{
	return (r >> 25) & 0x1;
}
static inline u32 tsec_tegra_ctl_tmpi_restart_fsm_host1x_init_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_tegra_ctl_tmpi_restart_fsm_host1x_init_f(void)
{
	return 0x0;
}
static inline u32 tsec_tegra_ctl_tmpi_restart_fsm_apb_s(void)
{
	return 1;
}
static inline u32 tsec_tegra_ctl_tmpi_restart_fsm_apb_f(u32 v)
{
	return (v & 0x1) << 26;
}
static inline u32 tsec_tegra_ctl_tmpi_restart_fsm_apb_m(void)
{
	return 0x1 << 26;
}
static inline u32 tsec_tegra_ctl_tmpi_restart_fsm_apb_v(u32 r)
{
	return (r >> 26) & 0x1;
}
static inline u32 tsec_tegra_ctl_tmpi_restart_fsm_apb_init_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_tegra_ctl_tmpi_restart_fsm_apb_init_f(void)
{
	return 0x0;
}
static inline u32 tsec_tegra_ctl_tmpi_disable_output_i2c_s(void)
{
	return 1;
}
static inline u32 tsec_tegra_ctl_tmpi_disable_output_i2c_f(u32 v)
{
	return (v & 0x1) << 27;
}
static inline u32 tsec_tegra_ctl_tmpi_disable_output_i2c_m(void)
{
	return 0x1 << 27;
}
static inline u32 tsec_tegra_ctl_tmpi_disable_output_i2c_v(u32 r)
{
	return (r >> 27) & 0x1;
}
static inline u32 tsec_tegra_ctl_tmpi_disable_output_i2c_init_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_tegra_ctl_tmpi_disable_output_i2c_init_f(void)
{
	return 0x0;
}
static inline u32 tsec_scp_ctl_pkey_r(void)
{
	return 0x00001418;
}
static inline u32 tsec_scp_ctl_pkey_request_reload_s(void)
{
	return 1;
}
static inline u32 tsec_scp_ctl_pkey_request_reload_f(u32 v)
{
	return (v & 0x1) << 0;
}
static inline u32 tsec_scp_ctl_pkey_request_reload_m(void)
{
	return 0x1 << 0;
}
static inline u32 tsec_scp_ctl_pkey_request_reload_v(u32 r)
{
	return (r >> 0) & 0x1;
}
static inline u32 tsec_scp_ctl_pkey_request_reload_idle_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_scp_ctl_pkey_request_reload_idle_f(void)
{
	return 0x0;
}
static inline u32 tsec_scp_ctl_pkey_request_reload_pending_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_scp_ctl_pkey_request_reload_pending_f(void)
{
	return 0x1;
}
static inline u32 tsec_scp_ctl_pkey_loaded_s(void)
{
	return 1;
}
static inline u32 tsec_scp_ctl_pkey_loaded_f(u32 v)
{
	return (v & 0x1) << 1;
}
static inline u32 tsec_scp_ctl_pkey_loaded_m(void)
{
	return 0x1 << 1;
}
static inline u32 tsec_scp_ctl_pkey_loaded_v(u32 r)
{
	return (r >> 1) & 0x1;
}
static inline u32 tsec_scp_ctl_pkey_loaded_false_v(void)
{
	return 0x00000000;
}
static inline u32 tsec_scp_ctl_pkey_loaded_false_f(void)
{
	return 0x0;
}
static inline u32 tsec_scp_ctl_pkey_loaded_true_v(void)
{
	return 0x00000001;
}
static inline u32 tsec_scp_ctl_pkey_loaded_true_f(void)
{
	return 0x2;
}

#endif /* __hw_tsec_h__ */
