/*
 * arch/arm/mach-tegra/board-pluto-memory.c
 *
 * Copyright (c) 2012-2013, NVIDIA CORPORATION.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307, USA
 */

#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/platform_data/tegra_emc.h>
#include <linux/memblock.h>
#include <asm-generic/sizes.h>

#include "board.h"
#include "board-pluto.h"
#include "tegra-board-id.h"
#include "tegra11_emc.h"
#include "fuse.h"
#include "devices.h"

static struct tegra11_emc_table e1580_fa164a1ma_gd_f_table[] = {
	{
		0x42,       /* Rev 4.0.3 */
		12750,      /* SDRAM frequency */
		900,        /* min voltage */
		"pll_p",    /* clock source id */
		0x4400003e, /* CLK_SOURCE_EMC */
		100,        /* number of burst_regs */
		30,         /* number of trim_regs (each channel) */
		11,         /* number of up_down_regs */
		{
			0x00000000, /* EMC_RC */
			0x00000003, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000002, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000006, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000001, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x0000000f, /* EMC_WDV_MASK */
			0x00000005, /* EMC_IBDLY */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000004, /* EMC_QRST */
			0x0000000f, /* EMC_RDV_MASK */
			0x0000002f, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x0000000b, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000000c, /* EMC_RW2PDEN */
			0x00000002, /* EMC_TXSR */
			0x00000002, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000003, /* EMC_TCKESR */
			0x00000003, /* EMC_TPD */
			0x00000008, /* EMC_TFAW */
			0x00000004, /* EMC_TRPAB */
			0x00000001, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x00000036, /* EMC_TREFBW */
			0x00000005, /* EMC_QUSE_EXTRA */
			0x00000020, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x0001aa86, /* EMC_FBIO_CFG5 */
			0x005800a8, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00078000, /* EMC_DLL_XFORM_DQS4 */
			0x00078000, /* EMC_DLL_XFORM_DQS5 */
			0x00078000, /* EMC_DLL_XFORM_DQS6 */
			0x00078000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00010220, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x0000a01c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x02000100, /* EMC_FBIO_SPARE */
			0x00000301, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x00000010, /* EMC_ZCAL_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x80000164, /* EMC_DYN_SELF_REF_CONTROL */
			0x09257359, /* EMC_CA_TRAINING_TIMING_CNTL1 */
			0x00000017, /* EMC_CA_TRAINING_TIMING_CNTL2 */
			0x40040001, /* MC_EMEM_ARB_CFG */
			0x8000003f, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000007, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_W2R */
			0x05040102, /* MC_EMEM_ARB_DA_TURNS */
			0x00090402, /* MC_EMEM_ARB_DA_COVERS */
			0x77c30303, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x0004032c, /* EMC_SEL_DPD_CTRL */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000007, /* EMC_QUSE */
			0x00000004, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00078000, /* EMC_DLL_XFORM_DQS0 */
			0x0000000b, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x0000000d, /* EMC_RDV */
			0x00249249, /* EMC_XM2DQSPADCTRL4 */
			0x20820800, /* EMC_XM2DQSPADCTRL3 */
			0x000c0000, /* EMC_DLL_XFORM_DQ0 */
			0xa0f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x000fc000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR2 */
			0x00078000, /* EMC_DLL_XFORM_DQS1 */
			0x00078000, /* EMC_DLL_XFORM_DQS2 */
			0x00078000, /* EMC_DLL_XFORM_DQS3 */
			0x000c0000, /* EMC_DLL_XFORM_DQ1 */
			0x000c0000, /* EMC_DLL_XFORM_DQ2 */
			0x000c0000, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000007, /* EMC_QUSE */
			0x00000004, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00078000, /* EMC_DLL_XFORM_DQS0 */
			0x0000000b, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x0000000d, /* EMC_RDV */
			0x00249249, /* EMC_XM2DQSPADCTRL4 */
			0x20820800, /* EMC_XM2DQSPADCTRL3 */
			0x000c0000, /* EMC_DLL_XFORM_DQ0 */
			0xa8f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x000fc000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR2 */
			0x00078000, /* EMC_DLL_XFORM_DQS1 */
			0x00078000, /* EMC_DLL_XFORM_DQS2 */
			0x00078000, /* EMC_DLL_XFORM_DQS3 */
			0x000c0000, /* EMC_DLL_XFORM_DQ1 */
			0x000c0000, /* EMC_DLL_XFORM_DQ2 */
			0x000c0000, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x00000007, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_G2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_G2_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_NV_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_NV2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_NV_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_NV_1 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_NV2_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_NV3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_EPP_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_EPP_1 */
			0x4E564441, /* System Verification tag */
			0x04010502, /* Reg_tool Version */
			0x02000100, /* DVFS_tool Version */
			12750,      /* SDRAM Frequency */
		},
		0x00000014, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0xf320000e, /* EMC_CFG */
		0x00000000, /* Mode Register 0 */
		0x00010083, /* Mode Register 1 */
		0x00020004, /* Mode Register 2 */
		0x000b0000, /* Mode Register 4 */
		57820,      /* expected dvfs latency (ns) */
	},
	{
		0x42,       /* Rev 4.0.3 */
		20400,      /* SDRAM frequency */
		900,        /* min voltage */
		"pll_p",    /* clock source id */
		0x44000026, /* CLK_SOURCE_EMC */
		100,        /* number of burst_regs */
		30,         /* number of trim_regs (each channel) */
		11,         /* number of up_down_regs */
		{
			0x00000001, /* EMC_RC */
			0x00000003, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000002, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000006, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000001, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x0000000f, /* EMC_WDV_MASK */
			0x00000005, /* EMC_IBDLY */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000004, /* EMC_QRST */
			0x0000000f, /* EMC_RDV_MASK */
			0x0000004c, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000013, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000000c, /* EMC_RW2PDEN */
			0x00000003, /* EMC_TXSR */
			0x00000003, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000003, /* EMC_TCKESR */
			0x00000003, /* EMC_TPD */
			0x00000008, /* EMC_TFAW */
			0x00000004, /* EMC_TRPAB */
			0x00000001, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x00000055, /* EMC_TREFBW */
			0x00000005, /* EMC_QUSE_EXTRA */
			0x00000020, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x0001aa86, /* EMC_FBIO_CFG5 */
			0x005800a8, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00078000, /* EMC_DLL_XFORM_DQS4 */
			0x00078000, /* EMC_DLL_XFORM_DQS5 */
			0x00078000, /* EMC_DLL_XFORM_DQS6 */
			0x00078000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00010220, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x0000a01c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x02000100, /* EMC_FBIO_SPARE */
			0x00000301, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x00000010, /* EMC_ZCAL_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x8000019f, /* EMC_DYN_SELF_REF_CONTROL */
			0x09257359, /* EMC_CA_TRAINING_TIMING_CNTL1 */
			0x00000017, /* EMC_CA_TRAINING_TIMING_CNTL2 */
			0x40020001, /* MC_EMEM_ARB_CFG */
			0x80000046, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000007, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_W2R */
			0x05040102, /* MC_EMEM_ARB_DA_TURNS */
			0x00090402, /* MC_EMEM_ARB_DA_COVERS */
			0x74e30303, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x0004032c, /* EMC_SEL_DPD_CTRL */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000007, /* EMC_QUSE */
			0x00000004, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00078000, /* EMC_DLL_XFORM_DQS0 */
			0x0000000b, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x0000000d, /* EMC_RDV */
			0x00249249, /* EMC_XM2DQSPADCTRL4 */
			0x20820800, /* EMC_XM2DQSPADCTRL3 */
			0x000c0000, /* EMC_DLL_XFORM_DQ0 */
			0xa0f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x000fc000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR2 */
			0x00078000, /* EMC_DLL_XFORM_DQS1 */
			0x00078000, /* EMC_DLL_XFORM_DQS2 */
			0x00078000, /* EMC_DLL_XFORM_DQS3 */
			0x000c0000, /* EMC_DLL_XFORM_DQ1 */
			0x000c0000, /* EMC_DLL_XFORM_DQ2 */
			0x000c0000, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000007, /* EMC_QUSE */
			0x00000004, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00078000, /* EMC_DLL_XFORM_DQS0 */
			0x0000000b, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x0000000d, /* EMC_RDV */
			0x00249249, /* EMC_XM2DQSPADCTRL4 */
			0x20820800, /* EMC_XM2DQSPADCTRL3 */
			0x000c0000, /* EMC_DLL_XFORM_DQ0 */
			0xa8f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x000fc000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR2 */
			0x00078000, /* EMC_DLL_XFORM_DQS1 */
			0x00078000, /* EMC_DLL_XFORM_DQS2 */
			0x00078000, /* EMC_DLL_XFORM_DQS3 */
			0x000c0000, /* EMC_DLL_XFORM_DQ1 */
			0x000c0000, /* EMC_DLL_XFORM_DQ2 */
			0x000c0000, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x0000000a, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_G2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_G2_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_NV_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_NV2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_NV_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_NV_1 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_NV2_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_NV3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_EPP_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_EPP_1 */
			0x4E564441, /* System Verification tag */
			0x04010600, /* Reg_tool Version */
			0x02000100, /* DVFS_tool Version */
			20400,      /* SDRAM Frequency */
		},
		0x00000014, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0xf320000e, /* EMC_CFG */
		0x00000000, /* Mode Register 0 */
		0x00010083, /* Mode Register 1 */
		0x00020004, /* Mode Register 2 */
		0x000b0000, /* Mode Register 4 */
		35610,      /* expected dvfs latency (ns) */
	},
	{
		0x42,       /* Rev 4.0.3 */
		40800,      /* SDRAM frequency */
		900,        /* min voltage */
		"pll_p",    /* clock source id */
		0x44000012, /* CLK_SOURCE_EMC */
		100,        /* number of burst_regs */
		30,         /* number of trim_regs (each channel) */
		11,         /* number of up_down_regs */
		{
			0x00000002, /* EMC_RC */
			0x00000005, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000002, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000006, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000001, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x0000000f, /* EMC_WDV_MASK */
			0x00000005, /* EMC_IBDLY */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000004, /* EMC_QRST */
			0x0000000f, /* EMC_RDV_MASK */
			0x0000009a, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000026, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000000c, /* EMC_RW2PDEN */
			0x00000006, /* EMC_TXSR */
			0x00000006, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000003, /* EMC_TCKESR */
			0x00000003, /* EMC_TPD */
			0x00000008, /* EMC_TFAW */
			0x00000004, /* EMC_TRPAB */
			0x00000001, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x000000aa, /* EMC_TREFBW */
			0x00000005, /* EMC_QUSE_EXTRA */
			0x00000020, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x0001aa86, /* EMC_FBIO_CFG5 */
			0x005800a8, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00078000, /* EMC_DLL_XFORM_DQS4 */
			0x00078000, /* EMC_DLL_XFORM_DQS5 */
			0x00078000, /* EMC_DLL_XFORM_DQS6 */
			0x00078000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00010220, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x0000a01c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x02000100, /* EMC_FBIO_SPARE */
			0x00000301, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x00000010, /* EMC_ZCAL_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x8000023a, /* EMC_DYN_SELF_REF_CONTROL */
			0x09257359, /* EMC_CA_TRAINING_TIMING_CNTL1 */
			0x00000017, /* EMC_CA_TRAINING_TIMING_CNTL2 */
			0xa0000001, /* MC_EMEM_ARB_CFG */
			0x8000005b, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000007, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_W2R */
			0x05040102, /* MC_EMEM_ARB_DA_TURNS */
			0x00090402, /* MC_EMEM_ARB_DA_COVERS */
			0x73030303, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x0004032c, /* EMC_SEL_DPD_CTRL */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000007, /* EMC_QUSE */
			0x00000004, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00078000, /* EMC_DLL_XFORM_DQS0 */
			0x0000000b, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x0000000d, /* EMC_RDV */
			0x00249249, /* EMC_XM2DQSPADCTRL4 */
			0x20820800, /* EMC_XM2DQSPADCTRL3 */
			0x000c0000, /* EMC_DLL_XFORM_DQ0 */
			0xa0f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x000fc000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR2 */
			0x00078000, /* EMC_DLL_XFORM_DQS1 */
			0x00078000, /* EMC_DLL_XFORM_DQS2 */
			0x00078000, /* EMC_DLL_XFORM_DQS3 */
			0x000c0000, /* EMC_DLL_XFORM_DQ1 */
			0x000c0000, /* EMC_DLL_XFORM_DQ2 */
			0x000c0000, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000007, /* EMC_QUSE */
			0x00000004, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00078000, /* EMC_DLL_XFORM_DQS0 */
			0x0000000b, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x0000000d, /* EMC_RDV */
			0x00249249, /* EMC_XM2DQSPADCTRL4 */
			0x20820800, /* EMC_XM2DQSPADCTRL3 */
			0x000c0000, /* EMC_DLL_XFORM_DQ0 */
			0xa8f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x000fc000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR2 */
			0x00078000, /* EMC_DLL_XFORM_DQS1 */
			0x00078000, /* EMC_DLL_XFORM_DQS2 */
			0x00078000, /* EMC_DLL_XFORM_DQS3 */
			0x000c0000, /* EMC_DLL_XFORM_DQ1 */
			0x000c0000, /* EMC_DLL_XFORM_DQ2 */
			0x000c0000, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x00000015, /* MC_PTSA_GRANT_DECREMENT */
			0x00b000b0, /* MC_LATENCY_ALLOWANCE_G2_0 */
			0x00b000c4, /* MC_LATENCY_ALLOWANCE_G2_1 */
			0x00d700eb, /* MC_LATENCY_ALLOWANCE_NV_0 */
			0x000000eb, /* MC_LATENCY_ALLOWANCE_NV2_0 */
			0x00eb00eb, /* MC_LATENCY_ALLOWANCE_NV_2 */
			0x00ff00eb, /* MC_LATENCY_ALLOWANCE_NV_1 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_NV2_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_NV3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_EPP_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_EPP_1 */
			0x4E564441, /* System Verification tag */
			0x04010600, /* Reg_tool Version */
			0x02000100, /* DVFS_tool Version */
			40800,      /* SDRAM Frequency */
		},
		0x00000014, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0xf320000e, /* EMC_CFG */
		0x00000000, /* Mode Register 0 */
		0x00010083, /* Mode Register 1 */
		0x00020004, /* Mode Register 2 */
		0x000b0000, /* Mode Register 4 */
		20850,      /* expected dvfs latency (ns) */
	},
	{
		0x42,       /* Rev 4.0.3 */
		68000,      /* SDRAM frequency */
		900,        /* min voltage */
		"pll_p",    /* clock source id */
		0x4400000a, /* CLK_SOURCE_EMC */
		100,        /* number of burst_regs */
		30,         /* number of trim_regs (each channel) */
		11,         /* number of up_down_regs */
		{
			0x00000004, /* EMC_RC */
			0x00000008, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000002, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000006, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000001, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x0000000f, /* EMC_WDV_MASK */
			0x00000005, /* EMC_IBDLY */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000004, /* EMC_QRST */
			0x0000000f, /* EMC_RDV_MASK */
			0x00000101, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000040, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000000c, /* EMC_RW2PDEN */
			0x0000000a, /* EMC_TXSR */
			0x0000000a, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000003, /* EMC_TCKESR */
			0x00000003, /* EMC_TPD */
			0x00000008, /* EMC_TFAW */
			0x00000004, /* EMC_TRPAB */
			0x00000001, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x0000011b, /* EMC_TREFBW */
			0x00000005, /* EMC_QUSE_EXTRA */
			0x00000020, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x0001aa86, /* EMC_FBIO_CFG5 */
			0x005800a8, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00078000, /* EMC_DLL_XFORM_DQS4 */
			0x00078000, /* EMC_DLL_XFORM_DQS5 */
			0x00078000, /* EMC_DLL_XFORM_DQS6 */
			0x00078000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00010220, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x0000a01c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x02000100, /* EMC_FBIO_SPARE */
			0x00000301, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x00000019, /* EMC_ZCAL_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x80000309, /* EMC_DYN_SELF_REF_CONTROL */
			0x09257359, /* EMC_CA_TRAINING_TIMING_CNTL1 */
			0x00000017, /* EMC_CA_TRAINING_TIMING_CNTL2 */
			0x00000001, /* MC_EMEM_ARB_CFG */
			0x80000076, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000007, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_W2R */
			0x05040102, /* MC_EMEM_ARB_DA_TURNS */
			0x00090402, /* MC_EMEM_ARB_DA_COVERS */
			0x72630403, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x0004032c, /* EMC_SEL_DPD_CTRL */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000007, /* EMC_QUSE */
			0x00000004, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00078000, /* EMC_DLL_XFORM_DQS0 */
			0x0000000b, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x0000000d, /* EMC_RDV */
			0x00249249, /* EMC_XM2DQSPADCTRL4 */
			0x20820800, /* EMC_XM2DQSPADCTRL3 */
			0x000c0000, /* EMC_DLL_XFORM_DQ0 */
			0xa0f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x000fc000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR2 */
			0x00078000, /* EMC_DLL_XFORM_DQS1 */
			0x00078000, /* EMC_DLL_XFORM_DQS2 */
			0x00078000, /* EMC_DLL_XFORM_DQS3 */
			0x000c0000, /* EMC_DLL_XFORM_DQ1 */
			0x000c0000, /* EMC_DLL_XFORM_DQ2 */
			0x000c0000, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000007, /* EMC_QUSE */
			0x00000004, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00078000, /* EMC_DLL_XFORM_DQS0 */
			0x0000000b, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x0000000d, /* EMC_RDV */
			0x00249249, /* EMC_XM2DQSPADCTRL4 */
			0x20820800, /* EMC_XM2DQSPADCTRL3 */
			0x000c0000, /* EMC_DLL_XFORM_DQ0 */
			0xa8f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x000fc000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR2 */
			0x00078000, /* EMC_DLL_XFORM_DQS1 */
			0x00078000, /* EMC_DLL_XFORM_DQS2 */
			0x00078000, /* EMC_DLL_XFORM_DQS3 */
			0x000c0000, /* EMC_DLL_XFORM_DQ1 */
			0x000c0000, /* EMC_DLL_XFORM_DQ2 */
			0x000c0000, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x00000023, /* MC_PTSA_GRANT_DECREMENT */
			0x00690069, /* MC_LATENCY_ALLOWANCE_G2_0 */
			0x00690075, /* MC_LATENCY_ALLOWANCE_G2_1 */
			0x0081008d, /* MC_LATENCY_ALLOWANCE_NV_0 */
			0x0000008d, /* MC_LATENCY_ALLOWANCE_NV2_0 */
			0x008d008d, /* MC_LATENCY_ALLOWANCE_NV_2 */
			0x00bc008d, /* MC_LATENCY_ALLOWANCE_NV_1 */
			0x000000bc, /* MC_LATENCY_ALLOWANCE_NV2_1 */
			0x00bc00bc, /* MC_LATENCY_ALLOWANCE_NV3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_EPP_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_EPP_1 */
			0x4E564441, /* System Verification tag */
			0x04010600, /* Reg_tool Version */
			0x02000100, /* DVFS_tool Version */
			68000,      /* SDRAM Frequency */
		},
		0x00000014, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0xf320000e, /* EMC_CFG */
		0x00000000, /* Mode Register 0 */
		0x00010083, /* Mode Register 1 */
		0x00020004, /* Mode Register 2 */
		0x000b0000, /* Mode Register 4 */
		10720,      /* expected dvfs latency (ns) */
	},
	{
		0x42,       /* Rev 4.0.3 */
		102000,     /* SDRAM frequency */
		900,        /* min voltage */
		"pll_p",    /* clock source id */
		0x44000006, /* CLK_SOURCE_EMC */
		100,        /* number of burst_regs */
		30,         /* number of trim_regs (each channel) */
		11,         /* number of up_down_regs */
		{
			0x00000006, /* EMC_RC */
			0x0000000d, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000004, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000006, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000001, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x0000000f, /* EMC_WDV_MASK */
			0x00000005, /* EMC_IBDLY */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000004, /* EMC_QRST */
			0x0000000f, /* EMC_RDV_MASK */
			0x00000181, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000060, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000000c, /* EMC_RW2PDEN */
			0x0000000f, /* EMC_TXSR */
			0x0000000f, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000003, /* EMC_TCKESR */
			0x00000003, /* EMC_TPD */
			0x00000008, /* EMC_TFAW */
			0x00000004, /* EMC_TRPAB */
			0x00000001, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x000001a9, /* EMC_TREFBW */
			0x00000005, /* EMC_QUSE_EXTRA */
			0x00000020, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x0001aa86, /* EMC_FBIO_CFG5 */
			0x005800a8, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00078000, /* EMC_DLL_XFORM_DQS4 */
			0x00078000, /* EMC_DLL_XFORM_DQS5 */
			0x00078000, /* EMC_DLL_XFORM_DQS6 */
			0x00078000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00010220, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x0000a01c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x02000100, /* EMC_FBIO_SPARE */
			0x00000301, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x00000025, /* EMC_ZCAL_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x8000040b, /* EMC_DYN_SELF_REF_CONTROL */
			0x09257359, /* EMC_CA_TRAINING_TIMING_CNTL1 */
			0x00000017, /* EMC_CA_TRAINING_TIMING_CNTL2 */
			0x08000001, /* MC_EMEM_ARB_CFG */
			0x80000098, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000003, /* MC_EMEM_ARB_TIMING_RC */
			0x00000001, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000007, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_W2R */
			0x05040102, /* MC_EMEM_ARB_DA_TURNS */
			0x00090403, /* MC_EMEM_ARB_DA_COVERS */
			0x72430504, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x0004032c, /* EMC_SEL_DPD_CTRL */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000007, /* EMC_QUSE */
			0x00000004, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00078000, /* EMC_DLL_XFORM_DQS0 */
			0x0000000b, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x0000000d, /* EMC_RDV */
			0x00249249, /* EMC_XM2DQSPADCTRL4 */
			0x20820800, /* EMC_XM2DQSPADCTRL3 */
			0x000c0000, /* EMC_DLL_XFORM_DQ0 */
			0xa0f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x000fc000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR2 */
			0x00078000, /* EMC_DLL_XFORM_DQS1 */
			0x00078000, /* EMC_DLL_XFORM_DQS2 */
			0x00078000, /* EMC_DLL_XFORM_DQS3 */
			0x000c0000, /* EMC_DLL_XFORM_DQ1 */
			0x000c0000, /* EMC_DLL_XFORM_DQ2 */
			0x000c0000, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000007, /* EMC_QUSE */
			0x00000004, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00078000, /* EMC_DLL_XFORM_DQS0 */
			0x0000000b, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x0000000d, /* EMC_RDV */
			0x00249249, /* EMC_XM2DQSPADCTRL4 */
			0x20820800, /* EMC_XM2DQSPADCTRL3 */
			0x000c0000, /* EMC_DLL_XFORM_DQ0 */
			0xa8f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x000fc000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x000fc000, /* EMC_DLL_XFORM_ADDR2 */
			0x00078000, /* EMC_DLL_XFORM_DQS1 */
			0x00078000, /* EMC_DLL_XFORM_DQS2 */
			0x00078000, /* EMC_DLL_XFORM_DQS3 */
			0x000c0000, /* EMC_DLL_XFORM_DQ1 */
			0x000c0000, /* EMC_DLL_XFORM_DQ2 */
			0x000c0000, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x00000034, /* MC_PTSA_GRANT_DECREMENT */
			0x00460046, /* MC_LATENCY_ALLOWANCE_G2_0 */
			0x0046004e, /* MC_LATENCY_ALLOWANCE_G2_1 */
			0x0056005e, /* MC_LATENCY_ALLOWANCE_NV_0 */
			0x0000005e, /* MC_LATENCY_ALLOWANCE_NV2_0 */
			0x005e005e, /* MC_LATENCY_ALLOWANCE_NV_2 */
			0x007d005e, /* MC_LATENCY_ALLOWANCE_NV_1 */
			0x0000007d, /* MC_LATENCY_ALLOWANCE_NV2_1 */
			0x007d007d, /* MC_LATENCY_ALLOWANCE_NV3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_EPP_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_EPP_1 */
			0x4E564441, /* System Verification tag */
			0x04010600, /* Reg_tool Version */
			0x02000100, /* DVFS_tool Version */
			102000,     /* SDRAM Frequency */
		},
		0x00000014, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0xf320000e, /* EMC_CFG */
		0x00000000, /* Mode Register 0 */
		0x00010083, /* Mode Register 1 */
		0x00020004, /* Mode Register 2 */
		0x000b0000, /* Mode Register 4 */
		6890,       /* expected dvfs latency (ns) */
	},
	{
		0x42,       /* Rev 4.0.3 */
		204000,     /* SDRAM frequency */
		900,        /* min voltage */
		"pll_p",    /* clock source id */
		0x44000002, /* CLK_SOURCE_EMC */
		100,        /* number of burst_regs */
		30,         /* number of trim_regs (each channel) */
		11,         /* number of up_down_regs */
		{
			0x0000000c, /* EMC_RC */
			0x0000001a, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000008, /* EMC_RAS */
			0x00000003, /* EMC_RP */
			0x00000007, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000003, /* EMC_RD_RCD */
			0x00000003, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x0000000f, /* EMC_WDV_MASK */
			0x00000006, /* EMC_IBDLY */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000004, /* EMC_QRST */
			0x00000010, /* EMC_RDV_MASK */
			0x00000303, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000000c0, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000003, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000000c, /* EMC_RW2PDEN */
			0x0000001d, /* EMC_TXSR */
			0x0000001d, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000004, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x0000000b, /* EMC_TFAW */
			0x00000005, /* EMC_TRPAB */
			0x00000001, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x00000351, /* EMC_TREFBW */
			0x00000006, /* EMC_QUSE_EXTRA */
			0x00000020, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x0001aa86, /* EMC_FBIO_CFG5 */
			0x005800a8, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00050000, /* EMC_DLL_XFORM_DQS4 */
			0x00050000, /* EMC_DLL_XFORM_DQS5 */
			0x00050000, /* EMC_DLL_XFORM_DQS6 */
			0x00050000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00010220, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x0000a01c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x02000100, /* EMC_FBIO_SPARE */
			0x00000301, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x0000004a, /* EMC_ZCAL_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x80000713, /* EMC_DYN_SELF_REF_CONTROL */
			0x09257359, /* EMC_CA_TRAINING_TIMING_CNTL1 */
			0x00000017, /* EMC_CA_TRAINING_TIMING_CNTL2 */
			0x01000003, /* MC_EMEM_ARB_CFG */
			0x800000fe, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000006, /* MC_EMEM_ARB_TIMING_RC */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000005, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000007, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_W2R */
			0x05050102, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0506, /* MC_EMEM_ARB_DA_COVERS */
			0x71e40a07, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x0004032c, /* EMC_SEL_DPD_CTRL */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000008, /* EMC_QUSE */
			0x00000004, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00050000, /* EMC_DLL_XFORM_DQS0 */
			0x0000000c, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x0000000e, /* EMC_RDV */
			0x00249249, /* EMC_XM2DQSPADCTRL4 */
			0x20820800, /* EMC_XM2DQSPADCTRL3 */
			0x00058000, /* EMC_DLL_XFORM_DQ0 */
			0xa0f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x00060000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00060000, /* EMC_DLL_XFORM_ADDR2 */
			0x00050000, /* EMC_DLL_XFORM_DQS1 */
			0x00050000, /* EMC_DLL_XFORM_DQS2 */
			0x00050000, /* EMC_DLL_XFORM_DQS3 */
			0x00058000, /* EMC_DLL_XFORM_DQ1 */
			0x00058000, /* EMC_DLL_XFORM_DQ2 */
			0x00058000, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000008, /* EMC_QUSE */
			0x00000004, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00050000, /* EMC_DLL_XFORM_DQS0 */
			0x0000000c, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x0000000e, /* EMC_RDV */
			0x00249249, /* EMC_XM2DQSPADCTRL4 */
			0x20820800, /* EMC_XM2DQSPADCTRL3 */
			0x00058000, /* EMC_DLL_XFORM_DQ0 */
			0xa8f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x00060000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00060000, /* EMC_DLL_XFORM_ADDR2 */
			0x00050000, /* EMC_DLL_XFORM_DQS1 */
			0x00050000, /* EMC_DLL_XFORM_DQS2 */
			0x00050000, /* EMC_DLL_XFORM_DQS3 */
			0x00058000, /* EMC_DLL_XFORM_DQ1 */
			0x00058000, /* EMC_DLL_XFORM_DQ2 */
			0x00058000, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x00000068, /* MC_PTSA_GRANT_DECREMENT */
			0x00230023, /* MC_LATENCY_ALLOWANCE_G2_0 */
			0x00230027, /* MC_LATENCY_ALLOWANCE_G2_1 */
			0x002b002f, /* MC_LATENCY_ALLOWANCE_NV_0 */
			0x0000002f, /* MC_LATENCY_ALLOWANCE_NV2_0 */
			0x002f002f, /* MC_LATENCY_ALLOWANCE_NV_2 */
			0x003e002f, /* MC_LATENCY_ALLOWANCE_NV_1 */
			0x0000003e, /* MC_LATENCY_ALLOWANCE_NV2_1 */
			0x003e003e, /* MC_LATENCY_ALLOWANCE_NV3 */
			0x00ff00c8, /* MC_LATENCY_ALLOWANCE_EPP_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_EPP_1 */
			0x4E564441, /* System Verification tag */
			0x04010600, /* Reg_tool Version */
			0x02000100, /* DVFS_tool Version */
			204000,     /* SDRAM Frequency */
		},
		0x00000017, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0xf320000e, /* EMC_CFG */
		0x00000000, /* Mode Register 0 */
		0x00010083, /* Mode Register 1 */
		0x00020004, /* Mode Register 2 */
		0x000b0000, /* Mode Register 4 */
		3420,       /* expected dvfs latency (ns) */
	},
	{
		0x42,       /* Rev 4.0.3 */
		312000,     /* SDRAM frequency */
		1000,       /* min voltage */
		"pll_c",    /* clock source id */
		0x24000002, /* CLK_SOURCE_EMC */
		100,        /* number of burst_regs */
		30,         /* number of trim_regs (each channel) */
		11,         /* number of up_down_regs */
		{
			0x00000012, /* EMC_RC */
			0x00000028, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x0000000d, /* EMC_RAS */
			0x00000005, /* EMC_RP */
			0x00000008, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000005, /* EMC_RD_RCD */
			0x00000005, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x0000000f, /* EMC_WDV_MASK */
			0x00000006, /* EMC_IBDLY */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000004, /* EMC_QRST */
			0x00000011, /* EMC_RDV_MASK */
			0x0000049b, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000126, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000005, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000000d, /* EMC_RW2PDEN */
			0x0000002c, /* EMC_TXSR */
			0x0000002c, /* EMC_TXSRDLL */
			0x00000005, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000005, /* EMC_TPD */
			0x00000010, /* EMC_TFAW */
			0x00000007, /* EMC_TRPAB */
			0x00000001, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x00000512, /* EMC_TREFBW */
			0x00000006, /* EMC_QUSE_EXTRA */
			0x00000020, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x0001aa86, /* EMC_FBIO_CFG5 */
			0x005800a8, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00028000, /* EMC_DLL_XFORM_DQS4 */
			0x00028000, /* EMC_DLL_XFORM_DQS5 */
			0x00028000, /* EMC_DLL_XFORM_DQS6 */
			0x00028000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00010220, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x0000a01c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x02000100, /* EMC_FBIO_SPARE */
			0x00000301, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x00000071, /* EMC_ZCAL_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x80000a48, /* EMC_DYN_SELF_REF_CONTROL */
			0x09257359, /* EMC_CA_TRAINING_TIMING_CNTL1 */
			0x00000017, /* EMC_CA_TRAINING_TIMING_CNTL2 */
			0x0b000004, /* MC_EMEM_ARB_CFG */
			0x8000016a, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RP */
			0x00000009, /* MC_EMEM_ARB_TIMING_RC */
			0x00000005, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000007, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000007, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_W2R */
			0x05050102, /* MC_EMEM_ARB_DA_TURNS */
			0x000c0709, /* MC_EMEM_ARB_DA_COVERS */
			0x71c50f0a, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x0004032c, /* EMC_SEL_DPD_CTRL */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000009, /* EMC_QUSE */
			0x00000004, /* EMC_EINPUT */
			0x00000006, /* EMC_EINPUT_DURATION */
			0x00028000, /* EMC_DLL_XFORM_DQS0 */
			0x0000000d, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x0000000f, /* EMC_RDV */
			0x00249249, /* EMC_XM2DQSPADCTRL4 */
			0x20820800, /* EMC_XM2DQSPADCTRL3 */
			0x00038000, /* EMC_DLL_XFORM_DQ0 */
			0xa0f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x00038000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00038000, /* EMC_DLL_XFORM_ADDR2 */
			0x00028000, /* EMC_DLL_XFORM_DQS1 */
			0x00028000, /* EMC_DLL_XFORM_DQS2 */
			0x00028000, /* EMC_DLL_XFORM_DQS3 */
			0x00038000, /* EMC_DLL_XFORM_DQ1 */
			0x00038000, /* EMC_DLL_XFORM_DQ2 */
			0x00038000, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000009, /* EMC_QUSE */
			0x00000004, /* EMC_EINPUT */
			0x00000006, /* EMC_EINPUT_DURATION */
			0x00028000, /* EMC_DLL_XFORM_DQS0 */
			0x0000000d, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x0000000f, /* EMC_RDV */
			0x00249249, /* EMC_XM2DQSPADCTRL4 */
			0x20820800, /* EMC_XM2DQSPADCTRL3 */
			0x00038000, /* EMC_DLL_XFORM_DQ0 */
			0xa8f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x00038000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00038000, /* EMC_DLL_XFORM_ADDR2 */
			0x00028000, /* EMC_DLL_XFORM_DQS1 */
			0x00028000, /* EMC_DLL_XFORM_DQS2 */
			0x00028000, /* EMC_DLL_XFORM_DQS3 */
			0x00038000, /* EMC_DLL_XFORM_DQ1 */
			0x00038000, /* EMC_DLL_XFORM_DQ2 */
			0x00038000, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x000000a0, /* MC_PTSA_GRANT_DECREMENT */
			0x00170017, /* MC_LATENCY_ALLOWANCE_G2_0 */
			0x00170019, /* MC_LATENCY_ALLOWANCE_G2_1 */
			0x001c001e, /* MC_LATENCY_ALLOWANCE_NV_0 */
			0x0000001e, /* MC_LATENCY_ALLOWANCE_NV2_0 */
			0x001e001e, /* MC_LATENCY_ALLOWANCE_NV_2 */
			0x0029001e, /* MC_LATENCY_ALLOWANCE_NV_1 */
			0x00000029, /* MC_LATENCY_ALLOWANCE_NV2_1 */
			0x00290029, /* MC_LATENCY_ALLOWANCE_NV3 */
			0x00ff0082, /* MC_LATENCY_ALLOWANCE_EPP_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_EPP_1 */
			0x4E564441, /* System Verification tag */
			0x04010600, /* Reg_tool Version */
			0x02000100, /* DVFS_tool Version */
			312000,     /* SDRAM Frequency */
		},
		0x00000021, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0xf320000e, /* EMC_CFG */
		0x00000000, /* Mode Register 0 */
		0x00010083, /* Mode Register 1 */
		0x00020004, /* Mode Register 2 */
		0x000b0000, /* Mode Register 4 */
		2180,       /* expected dvfs latency (ns) */
	},
	{
		0x42,       /* Rev 4.0.3 */
		408000,     /* SDRAM frequency */
		1000,       /* min voltage */
		"pll_p",    /* clock source id */
		0x44000000, /* CLK_SOURCE_EMC */
		100,        /* number of burst_regs */
		30,         /* number of trim_regs (each channel) */
		11,         /* number of up_down_regs */
		{
			0x00000018, /* EMC_RC */
			0x00000035, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000011, /* EMC_RAS */
			0x00000007, /* EMC_RP */
			0x0000000b, /* EMC_R2W */
			0x00000009, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000d, /* EMC_W2P */
			0x00000007, /* EMC_RD_RCD */
			0x00000007, /* EMC_WR_RCD */
			0x00000004, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x0000000f, /* EMC_WDV_MASK */
			0x00000008, /* EMC_IBDLY */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000005, /* EMC_QRST */
			0x00000013, /* EMC_RDV_MASK */
			0x00000607, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000181, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000003, /* EMC_PDEX2WR */
			0x00000003, /* EMC_PDEX2RD */
			0x00000007, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x0000003a, /* EMC_TXSR */
			0x0000003a, /* EMC_TXSRDLL */
			0x00000007, /* EMC_TCKE */
			0x00000007, /* EMC_TCKESR */
			0x00000007, /* EMC_TPD */
			0x00000015, /* EMC_TFAW */
			0x00000009, /* EMC_TRPAB */
			0x00000001, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x000006a2, /* EMC_TREFBW */
			0x00000008, /* EMC_QUSE_EXTRA */
			0x00000020, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x0001a886, /* EMC_FBIO_CFG5 */
			0x00580088, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00028000, /* EMC_DLL_XFORM_DQS4 */
			0x00028000, /* EMC_DLL_XFORM_DQS5 */
			0x00028000, /* EMC_DLL_XFORM_DQS6 */
			0x00028000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00010220, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x0001003d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x02000100, /* EMC_FBIO_SPARE */
			0x00000301, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x00000093, /* EMC_ZCAL_WAIT_CNT */
			0x00120012, /* EMC_MRS_WAIT_CNT */
			0x00120012, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x80000d22, /* EMC_DYN_SELF_REF_CONTROL */
			0x09257359, /* EMC_CA_TRAINING_TIMING_CNTL1 */
			0x00000017, /* EMC_CA_TRAINING_TIMING_CNTL2 */
			0x02000006, /* MC_EMEM_ARB_CFG */
			0x80000190, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000002, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RP */
			0x0000000c, /* MC_EMEM_ARB_TIMING_RC */
			0x00000007, /* MC_EMEM_ARB_TIMING_RAS */
			0x0000000a, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000002, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000009, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000007, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06070102, /* MC_EMEM_ARB_DA_TURNS */
			0x0010090c, /* MC_EMEM_ARB_DA_COVERS */
			0x71c7130d, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x0004032c, /* EMC_SEL_DPD_CTRL */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x0000000b, /* EMC_QUSE */
			0x00000006, /* EMC_EINPUT */
			0x00000006, /* EMC_EINPUT_DURATION */
			0x00028000, /* EMC_DLL_XFORM_DQS0 */
			0x0000000e, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000011, /* EMC_RDV */
			0x00249249, /* EMC_XM2DQSPADCTRL4 */
			0x1c71c721, /* EMC_XM2DQSPADCTRL3 */
			0x00020000, /* EMC_DLL_XFORM_DQ0 */
			0xa0f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x00020000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00020000, /* EMC_DLL_XFORM_ADDR2 */
			0x00028000, /* EMC_DLL_XFORM_DQS1 */
			0x00028000, /* EMC_DLL_XFORM_DQS2 */
			0x00028000, /* EMC_DLL_XFORM_DQS3 */
			0x00020000, /* EMC_DLL_XFORM_DQ1 */
			0x00020000, /* EMC_DLL_XFORM_DQ2 */
			0x00020000, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x0000000b, /* EMC_QUSE */
			0x00000006, /* EMC_EINPUT */
			0x00000006, /* EMC_EINPUT_DURATION */
			0x00028000, /* EMC_DLL_XFORM_DQS0 */
			0x0000000e, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000011, /* EMC_RDV */
			0x00249249, /* EMC_XM2DQSPADCTRL4 */
			0x1c71c721, /* EMC_XM2DQSPADCTRL3 */
			0x00020000, /* EMC_DLL_XFORM_DQ0 */
			0xa8f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x00020000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00020000, /* EMC_DLL_XFORM_ADDR2 */
			0x00028000, /* EMC_DLL_XFORM_DQS1 */
			0x00028000, /* EMC_DLL_XFORM_DQS2 */
			0x00028000, /* EMC_DLL_XFORM_DQS3 */
			0x00020000, /* EMC_DLL_XFORM_DQ1 */
			0x00020000, /* EMC_DLL_XFORM_DQ2 */
			0x00020000, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x000000d1, /* MC_PTSA_GRANT_DECREMENT */
			0x00110011, /* MC_LATENCY_ALLOWANCE_G2_0 */
			0x00110013, /* MC_LATENCY_ALLOWANCE_G2_1 */
			0x00150017, /* MC_LATENCY_ALLOWANCE_NV_0 */
			0x00000017, /* MC_LATENCY_ALLOWANCE_NV2_0 */
			0x00170017, /* MC_LATENCY_ALLOWANCE_NV_2 */
			0x001f0017, /* MC_LATENCY_ALLOWANCE_NV_1 */
			0x0000001f, /* MC_LATENCY_ALLOWANCE_NV2_1 */
			0x001f001f, /* MC_LATENCY_ALLOWANCE_NV3 */
			0x00d30064, /* MC_LATENCY_ALLOWANCE_EPP_0 */
			0x00d300d3, /* MC_LATENCY_ALLOWANCE_EPP_1 */
			0x4E564441, /* System Verification tag */
			0x04010600, /* Reg_tool Version */
			0x02000100, /* DVFS_tool Version */
			408000,     /* SDRAM Frequency */
		},
		0x00000029, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0xf3200006, /* EMC_CFG */
		0x00000000, /* Mode Register 0 */
		0x000100c3, /* Mode Register 1 */
		0x00020006, /* Mode Register 2 */
		0x000b0000, /* Mode Register 4 */
		1750,       /* expected dvfs latency (ns) */
	},
	{
		0x42,       /* Rev 4.0.3 */
		624000,     /* SDRAM frequency */
		1100,       /* min voltage */
		"pll_c",    /* clock source id */
		0x24000000, /* CLK_SOURCE_EMC */
		100,        /* number of burst_regs */
		30,         /* number of trim_regs (each channel) */
		11,         /* number of up_down_regs */
		{
			0x00000025, /* EMC_RC */
			0x00000051, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x0000001a, /* EMC_RAS */
			0x0000000b, /* EMC_RP */
			0x0000000d, /* EMC_R2W */
			0x0000000c, /* EMC_W2R */
			0x00000004, /* EMC_R2P */
			0x00000011, /* EMC_W2P */
			0x0000000b, /* EMC_RD_RCD */
			0x0000000b, /* EMC_WR_RCD */
			0x00000006, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x0000000f, /* EMC_WDV_MASK */
			0x0000000b, /* EMC_IBDLY */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000007, /* EMC_QRST */
			0x00000017, /* EMC_RDV_MASK */
			0x00000941, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000250, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000004, /* EMC_PDEX2WR */
			0x00000004, /* EMC_PDEX2RD */
			0x0000000b, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x00000014, /* EMC_RW2PDEN */
			0x00000058, /* EMC_TXSR */
			0x00000058, /* EMC_TXSRDLL */
			0x0000000a, /* EMC_TCKE */
			0x0000000a, /* EMC_TCKESR */
			0x0000000a, /* EMC_TPD */
			0x00000020, /* EMC_TFAW */
			0x0000000e, /* EMC_TRPAB */
			0x00000001, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x00000a24, /* EMC_TREFBW */
			0x0000000b, /* EMC_QUSE_EXTRA */
			0x00000020, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x0001a886, /* EMC_FBIO_CFG5 */
			0xf00d0199, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x0000000a, /* EMC_DLL_XFORM_DQS4 */
			0x0000000a, /* EMC_DLL_XFORM_DQS5 */
			0x0000000a, /* EMC_DLL_XFORM_DQS6 */
			0x0000000a, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00010220, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x0001003d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x02000100, /* EMC_FBIO_SPARE */
			0x00000301, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x000000e1, /* EMC_ZCAL_WAIT_CNT */
			0x00140014, /* EMC_MRS_WAIT_CNT */
			0x00140014, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x8000138d, /* EMC_DYN_SELF_REF_CONTROL */
			0x09257359, /* EMC_CA_TRAINING_TIMING_CNTL1 */
			0x00000017, /* EMC_CA_TRAINING_TIMING_CNTL2 */
			0x06000009, /* MC_EMEM_ARB_CFG */
			0x80000190, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000004, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000005, /* MC_EMEM_ARB_TIMING_RP */
			0x00000013, /* MC_EMEM_ARB_TIMING_RC */
			0x0000000c, /* MC_EMEM_ARB_TIMING_RAS */
			0x0000000f, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000003, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000b, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000008, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000007, /* MC_EMEM_ARB_TIMING_W2R */
			0x07080103, /* MC_EMEM_ARB_DA_TURNS */
			0x00160e13, /* MC_EMEM_ARB_DA_COVERS */
			0x71ca1d14, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x0004032c, /* EMC_SEL_DPD_CTRL */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x0000000f, /* EMC_QUSE */
			0x00000009, /* EMC_EINPUT */
			0x00000007, /* EMC_EINPUT_DURATION */
			0x0000000a, /* EMC_DLL_XFORM_DQS0 */
			0x00000010, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000015, /* EMC_RDV */
			0x00249249, /* EMC_XM2DQSPADCTRL4 */
			0x18618621, /* EMC_XM2DQSPADCTRL3 */
			0x0000000a, /* EMC_DLL_XFORM_DQ0 */
			0xa0f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x0000000e, /* EMC_DLL_XFORM_ADDR0 */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x0000000e, /* EMC_DLL_XFORM_ADDR2 */
			0x0000000a, /* EMC_DLL_XFORM_DQS1 */
			0x0000400a, /* EMC_DLL_XFORM_DQS2 */
			0x0000000b, /* EMC_DLL_XFORM_DQS3 */
			0x0000000a, /* EMC_DLL_XFORM_DQ1 */
			0x0000000a, /* EMC_DLL_XFORM_DQ2 */
			0x0000000a, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x0000000f, /* EMC_QUSE */
			0x00000009, /* EMC_EINPUT */
			0x00000007, /* EMC_EINPUT_DURATION */
			0x0000000a, /* EMC_DLL_XFORM_DQS0 */
			0x00000010, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000015, /* EMC_RDV */
			0x00249249, /* EMC_XM2DQSPADCTRL4 */
			0x18618621, /* EMC_XM2DQSPADCTRL3 */
			0x0000000a, /* EMC_DLL_XFORM_DQ0 */
			0xa8f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x0000000e, /* EMC_DLL_XFORM_ADDR0 */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x0000000e, /* EMC_DLL_XFORM_ADDR2 */
			0x0000000a, /* EMC_DLL_XFORM_DQS1 */
			0x0000400a, /* EMC_DLL_XFORM_DQS2 */
			0x0000000b, /* EMC_DLL_XFORM_DQS3 */
			0x0000000a, /* EMC_DLL_XFORM_DQ1 */
			0x0000000a, /* EMC_DLL_XFORM_DQ2 */
			0x0000000a, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x0000013f, /* MC_PTSA_GRANT_DECREMENT */
			0x000b000b, /* MC_LATENCY_ALLOWANCE_G2_0 */
			0x000b000c, /* MC_LATENCY_ALLOWANCE_G2_1 */
			0x000e000f, /* MC_LATENCY_ALLOWANCE_NV_0 */
			0x0000000f, /* MC_LATENCY_ALLOWANCE_NV2_0 */
			0x000f000f, /* MC_LATENCY_ALLOWANCE_NV_2 */
			0x0014000f, /* MC_LATENCY_ALLOWANCE_NV_1 */
			0x00000014, /* MC_LATENCY_ALLOWANCE_NV2_1 */
			0x00140014, /* MC_LATENCY_ALLOWANCE_NV3 */
			0x008a0041, /* MC_LATENCY_ALLOWANCE_EPP_0 */
			0x008a008a, /* MC_LATENCY_ALLOWANCE_EPP_1 */
			0x4E564441, /* System Verification tag */
			0x04010600, /* Reg_tool Version */
			0x02000100, /* DVFS_tool Version */
			624000,     /* SDRAM Frequency */
		},
		0x0000003d, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0xf3200000, /* EMC_CFG */
		0x00000000, /* Mode Register 0 */
		0x00010003, /* Mode Register 1 */
		0x00020018, /* Mode Register 2 */
		0x000b0000, /* Mode Register 4 */
		1230,       /* expected dvfs latency (ns) */
	},
	{
		0x42,       /* Rev 4.0.3 */
		744000,     /* SDRAM frequency */
		1100,       /* min voltage */
		"pll_m",    /* clock source id */
		0x84000000, /* CLK_SOURCE_EMC */
		100,        /* number of burst_regs */
		30,         /* number of trim_regs (each channel) */
		11,         /* number of up_down_regs */
		{
			0x0000002c, /* EMC_RC */
			0x00000060, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x0000001f, /* EMC_RAS */
			0x0000000d, /* EMC_RP */
			0x00000010, /* EMC_R2W */
			0x0000000d, /* EMC_W2R */
			0x00000005, /* EMC_R2P */
			0x00000013, /* EMC_W2P */
			0x0000000d, /* EMC_RD_RCD */
			0x0000000d, /* EMC_WR_RCD */
			0x00000007, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x0000000f, /* EMC_WDV_MASK */
			0x0000000d, /* EMC_IBDLY */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000009, /* EMC_QRST */
			0x0000001a, /* EMC_RDV_MASK */
			0x00000b15, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000002c5, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000005, /* EMC_PDEX2WR */
			0x00000005, /* EMC_PDEX2RD */
			0x0000000d, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x00000016, /* EMC_RW2PDEN */
			0x00000069, /* EMC_TXSR */
			0x00000069, /* EMC_TXSRDLL */
			0x0000000c, /* EMC_TCKE */
			0x0000000c, /* EMC_TCKESR */
			0x0000000c, /* EMC_TPD */
			0x00000026, /* EMC_TFAW */
			0x00000010, /* EMC_TRPAB */
			0x00000001, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x00000c18, /* EMC_TREFBW */
			0x0000010d, /* EMC_QUSE_EXTRA */
			0x00000020, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x0001a886, /* EMC_FBIO_CFG5 */
			0xf0080199, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x0000000a, /* EMC_DLL_XFORM_DQS4 */
			0x0000000a, /* EMC_DLL_XFORM_DQS5 */
			0x0000000a, /* EMC_DLL_XFORM_DQS6 */
			0x0000000a, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00010220, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x0000003d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x02000100, /* EMC_FBIO_SPARE */
			0x00000301, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x0000010c, /* EMC_ZCAL_WAIT_CNT */
			0x00160016, /* EMC_MRS_WAIT_CNT */
			0x00160016, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x8000171e, /* EMC_DYN_SELF_REF_CONTROL */
			0x09257359, /* EMC_CA_TRAINING_TIMING_CNTL1 */
			0x00000017, /* EMC_CA_TRAINING_TIMING_CNTL2 */
			0x0300000b, /* MC_EMEM_ARB_CFG */
			0x80000190, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000005, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000006, /* MC_EMEM_ARB_TIMING_RP */
			0x00000016, /* MC_EMEM_ARB_TIMING_RC */
			0x0000000e, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000012, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000003, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000c, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000009, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000008, /* MC_EMEM_ARB_TIMING_W2R */
			0x08090103, /* MC_EMEM_ARB_DA_TURNS */
			0x00191016, /* MC_EMEM_ARB_DA_COVERS */
			0x71ac2217, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x0004000c, /* EMC_SEL_DPD_CTRL */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000012, /* EMC_QUSE */
			0x0000000b, /* EMC_EINPUT */
			0x00000007, /* EMC_EINPUT_DURATION */
			0x0000000a, /* EMC_DLL_XFORM_DQS0 */
			0x00000010, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000018, /* EMC_RDV */
			0x00249249, /* EMC_XM2DQSPADCTRL4 */
			0x18618621, /* EMC_XM2DQSPADCTRL3 */
			0x00008007, /* EMC_DLL_XFORM_DQ0 */
			0xa0f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x0000400a, /* EMC_DLL_XFORM_ADDR0 */
			0x00000707, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x0000400a, /* EMC_DLL_XFORM_ADDR2 */
			0x0000400a, /* EMC_DLL_XFORM_DQS1 */
			0x0000400a, /* EMC_DLL_XFORM_DQS2 */
			0x00004009, /* EMC_DLL_XFORM_DQS3 */
			0x00008007, /* EMC_DLL_XFORM_DQ1 */
			0x00008007, /* EMC_DLL_XFORM_DQ2 */
			0x00008007, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000012, /* EMC_QUSE */
			0x0000000b, /* EMC_EINPUT */
			0x00000007, /* EMC_EINPUT_DURATION */
			0x0000000a, /* EMC_DLL_XFORM_DQS0 */
			0x00000010, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000018, /* EMC_RDV */
			0x00249249, /* EMC_XM2DQSPADCTRL4 */
			0x18618621, /* EMC_XM2DQSPADCTRL3 */
			0x00008007, /* EMC_DLL_XFORM_DQ0 */
			0xa8f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x0000400a, /* EMC_DLL_XFORM_ADDR0 */
			0x00000707, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x0000400a, /* EMC_DLL_XFORM_ADDR2 */
			0x0000400a, /* EMC_DLL_XFORM_DQS1 */
			0x0000400a, /* EMC_DLL_XFORM_DQS2 */
			0x00004009, /* EMC_DLL_XFORM_DQS3 */
			0x00008007, /* EMC_DLL_XFORM_DQ1 */
			0x00008007, /* EMC_DLL_XFORM_DQ2 */
			0x00008007, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x0000017d, /* MC_PTSA_GRANT_DECREMENT */
			0x00090009, /* MC_LATENCY_ALLOWANCE_G2_0 */
			0x0009000a, /* MC_LATENCY_ALLOWANCE_G2_1 */
			0x000b000c, /* MC_LATENCY_ALLOWANCE_NV_0 */
			0x0000000c, /* MC_LATENCY_ALLOWANCE_NV2_0 */
			0x000c000c, /* MC_LATENCY_ALLOWANCE_NV_2 */
			0x0011000c, /* MC_LATENCY_ALLOWANCE_NV_1 */
			0x00000011, /* MC_LATENCY_ALLOWANCE_NV2_1 */
			0x00110011, /* MC_LATENCY_ALLOWANCE_NV3 */
			0x00740036, /* MC_LATENCY_ALLOWANCE_EPP_0 */
			0x00740074, /* MC_LATENCY_ALLOWANCE_EPP_1 */
			0x4E564441, /* System Verification tag */
			0x04010600, /* Reg_tool Version */
			0x02000100, /* DVFS_tool Version */
			744000,     /* SDRAM Frequency */
		},
		0x00000047, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0xf3200000, /* EMC_CFG */
		0x00000000, /* Mode Register 0 */
		0x00010043, /* Mode Register 1 */
		0x0002001a, /* Mode Register 2 */
		0x000b0000, /* Mode Register 4 */
		1230,       /* expected dvfs latency (ns) */
	},
};

static struct tegra11_emc_table e1580_h9ccnnn8ktmlbr_ntm_AP40_table[] = {
	{
		0x42,       /* Rev 4.0.3 */
		12750,      /* SDRAM frequency */
		900,        /* min voltage */
		"pll_p",    /* clock source id */
		0x4400003e, /* CLK_SOURCE_EMC */
		100,        /* number of burst_regs */
		30,         /* number of trim_regs (each channel) */
		11,         /* number of up_down_regs */
		{
			0x00000000, /* EMC_RC */
			0x00000003, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000002, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000006, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000001, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x0000000f, /* EMC_WDV_MASK */
			0x00000005, /* EMC_IBDLY */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000004, /* EMC_QRST */
			0x0000000f, /* EMC_RDV_MASK */
			0x0000002f, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x0000000b, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000000c, /* EMC_RW2PDEN */
			0x00000002, /* EMC_TXSR */
			0x00000002, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000003, /* EMC_TCKESR */
			0x00000003, /* EMC_TPD */
			0x00000008, /* EMC_TFAW */
			0x00000004, /* EMC_TRPAB */
			0x00000001, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x00000036, /* EMC_TREFBW */
			0x00000005, /* EMC_QUSE_EXTRA */
			0x00000020, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x0001aa86, /* EMC_FBIO_CFG5 */
			0x005800a8, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00078000, /* EMC_DLL_XFORM_DQS4 */
			0x00078000, /* EMC_DLL_XFORM_DQS5 */
			0x00078000, /* EMC_DLL_XFORM_DQS6 */
			0x00078000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00010220, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x0000a01c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x02000100, /* EMC_FBIO_SPARE */
			0x00000201, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x00000010, /* EMC_ZCAL_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x80000164, /* EMC_DYN_SELF_REF_CONTROL */
			0x09257359, /* EMC_CA_TRAINING_TIMING_CNTL1 */
			0x00000017, /* EMC_CA_TRAINING_TIMING_CNTL2 */
			0x40040001, /* MC_EMEM_ARB_CFG */
			0x8000003f, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000007, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_W2R */
			0x05040102, /* MC_EMEM_ARB_DA_TURNS */
			0x00090402, /* MC_EMEM_ARB_DA_COVERS */
			0x77c30303, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x0004032c, /* EMC_SEL_DPD_CTRL */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x00000007, /* EMC_QUSE */
			0x00000004, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00078000, /* EMC_DLL_XFORM_DQS0 */
			0x0000000a, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x0000000d, /* EMC_RDV */
			0x00249249, /* EMC_XM2DQSPADCTRL4 */
			0x20820800, /* EMC_XM2DQSPADCTRL3 */
			0x0007c000, /* EMC_DLL_XFORM_DQ0 */
			0xa0f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x000c0000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x000c0000, /* EMC_DLL_XFORM_ADDR2 */
			0x00078000, /* EMC_DLL_XFORM_DQS1 */
			0x00078000, /* EMC_DLL_XFORM_DQS2 */
			0x00078000, /* EMC_DLL_XFORM_DQS3 */
			0x0007c000, /* EMC_DLL_XFORM_DQ1 */
			0x0007c000, /* EMC_DLL_XFORM_DQ2 */
			0x0007c000, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x00000007, /* EMC_QUSE */
			0x00000004, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00078000, /* EMC_DLL_XFORM_DQS0 */
			0x0000000a, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x0000000d, /* EMC_RDV */
			0x00249249, /* EMC_XM2DQSPADCTRL4 */
			0x20820800, /* EMC_XM2DQSPADCTRL3 */
			0x0007c000, /* EMC_DLL_XFORM_DQ0 */
			0xa8f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x000c0000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x000c0000, /* EMC_DLL_XFORM_ADDR2 */
			0x00078000, /* EMC_DLL_XFORM_DQS1 */
			0x00078000, /* EMC_DLL_XFORM_DQS2 */
			0x00078000, /* EMC_DLL_XFORM_DQS3 */
			0x0007c000, /* EMC_DLL_XFORM_DQ1 */
			0x0007c000, /* EMC_DLL_XFORM_DQ2 */
			0x0007c000, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x00000007, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_G2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_G2_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_NV_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_NV2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_NV_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_NV_1 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_NV2_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_NV3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_EPP_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_EPP_1 */
		},
		0x00000014, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0xf320000e, /* EMC_CFG */
		0x00000000, /* Mode Register 0 */
		0x80010083, /* Mode Register 1 */
		0x80020004, /* Mode Register 2 */
		0x800b0000, /* Mode Register 4 */
		57820,      /* expected dvfs latency (ns) */
	},
	{
		0x42,       /* Rev 4.0.3 */
		20400,      /* SDRAM frequency */
		900,        /* min voltage */
		"pll_p",    /* clock source id */
		0x44000026, /* CLK_SOURCE_EMC */
		100,        /* number of burst_regs */
		30,         /* number of trim_regs (each channel) */
		11,         /* number of up_down_regs */
		{
			0x00000001, /* EMC_RC */
			0x00000003, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000002, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000006, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000001, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x0000000f, /* EMC_WDV_MASK */
			0x00000005, /* EMC_IBDLY */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000004, /* EMC_QRST */
			0x0000000f, /* EMC_RDV_MASK */
			0x0000004c, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000013, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000000c, /* EMC_RW2PDEN */
			0x00000003, /* EMC_TXSR */
			0x00000003, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000003, /* EMC_TCKESR */
			0x00000003, /* EMC_TPD */
			0x00000008, /* EMC_TFAW */
			0x00000004, /* EMC_TRPAB */
			0x00000001, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x00000055, /* EMC_TREFBW */
			0x00000005, /* EMC_QUSE_EXTRA */
			0x00000020, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x0001aa86, /* EMC_FBIO_CFG5 */
			0x005800a8, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00078000, /* EMC_DLL_XFORM_DQS4 */
			0x00078000, /* EMC_DLL_XFORM_DQS5 */
			0x00078000, /* EMC_DLL_XFORM_DQS6 */
			0x00078000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00010220, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x0000a01c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x02000100, /* EMC_FBIO_SPARE */
			0x00000201, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x00000010, /* EMC_ZCAL_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x8000019f, /* EMC_DYN_SELF_REF_CONTROL */
			0x09257359, /* EMC_CA_TRAINING_TIMING_CNTL1 */
			0x00000017, /* EMC_CA_TRAINING_TIMING_CNTL2 */
			0x40020001, /* MC_EMEM_ARB_CFG */
			0x80000046, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000007, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_W2R */
			0x05040102, /* MC_EMEM_ARB_DA_TURNS */
			0x00090402, /* MC_EMEM_ARB_DA_COVERS */
			0x74e30303, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x0004032c, /* EMC_SEL_DPD_CTRL */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x00000007, /* EMC_QUSE */
			0x00000004, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00078000, /* EMC_DLL_XFORM_DQS0 */
			0x0000000a, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x0000000d, /* EMC_RDV */
			0x00249249, /* EMC_XM2DQSPADCTRL4 */
			0x20820800, /* EMC_XM2DQSPADCTRL3 */
			0x0007c000, /* EMC_DLL_XFORM_DQ0 */
			0xa0f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x000c0000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x000c0000, /* EMC_DLL_XFORM_ADDR2 */
			0x00078000, /* EMC_DLL_XFORM_DQS1 */
			0x00078000, /* EMC_DLL_XFORM_DQS2 */
			0x00078000, /* EMC_DLL_XFORM_DQS3 */
			0x0007c000, /* EMC_DLL_XFORM_DQ1 */
			0x0007c000, /* EMC_DLL_XFORM_DQ2 */
			0x0007c000, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x00000007, /* EMC_QUSE */
			0x00000004, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00078000, /* EMC_DLL_XFORM_DQS0 */
			0x0000000a, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x0000000d, /* EMC_RDV */
			0x00249249, /* EMC_XM2DQSPADCTRL4 */
			0x20820800, /* EMC_XM2DQSPADCTRL3 */
			0x0007c000, /* EMC_DLL_XFORM_DQ0 */
			0xa8f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x000c0000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x000c0000, /* EMC_DLL_XFORM_ADDR2 */
			0x00078000, /* EMC_DLL_XFORM_DQS1 */
			0x00078000, /* EMC_DLL_XFORM_DQS2 */
			0x00078000, /* EMC_DLL_XFORM_DQS3 */
			0x0007c000, /* EMC_DLL_XFORM_DQ1 */
			0x0007c000, /* EMC_DLL_XFORM_DQ2 */
			0x0007c000, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x0000000a, /* MC_PTSA_GRANT_DECREMENT */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_G2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_G2_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_NV_0 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_NV2_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_NV_2 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_NV_1 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_NV2_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_NV3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_EPP_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_EPP_1 */
		},
		0x00000014, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0xf320000e, /* EMC_CFG */
		0x00000000, /* Mode Register 0 */
		0x80010083, /* Mode Register 1 */
		0x80020004, /* Mode Register 2 */
		0x800b0000, /* Mode Register 4 */
		35610,      /* expected dvfs latency (ns) */
	},
	{
		0x42,       /* Rev 4.0.3 */
		40800,      /* SDRAM frequency */
		900,        /* min voltage */
		"pll_p",    /* clock source id */
		0x44000012, /* CLK_SOURCE_EMC */
		100,        /* number of burst_regs */
		30,         /* number of trim_regs (each channel) */
		11,         /* number of up_down_regs */
		{
			0x00000002, /* EMC_RC */
			0x00000005, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000002, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000006, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000001, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x0000000f, /* EMC_WDV_MASK */
			0x00000005, /* EMC_IBDLY */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000004, /* EMC_QRST */
			0x0000000f, /* EMC_RDV_MASK */
			0x0000009a, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000026, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000000c, /* EMC_RW2PDEN */
			0x00000006, /* EMC_TXSR */
			0x00000006, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000003, /* EMC_TCKESR */
			0x00000003, /* EMC_TPD */
			0x00000008, /* EMC_TFAW */
			0x00000004, /* EMC_TRPAB */
			0x00000001, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x000000aa, /* EMC_TREFBW */
			0x00000005, /* EMC_QUSE_EXTRA */
			0x00000020, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x0001aa86, /* EMC_FBIO_CFG5 */
			0x005800a8, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00078000, /* EMC_DLL_XFORM_DQS4 */
			0x00078000, /* EMC_DLL_XFORM_DQS5 */
			0x00078000, /* EMC_DLL_XFORM_DQS6 */
			0x00078000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00010220, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x0000a01c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x02000100, /* EMC_FBIO_SPARE */
			0x00000201, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x00000010, /* EMC_ZCAL_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x8000023a, /* EMC_DYN_SELF_REF_CONTROL */
			0x09257359, /* EMC_CA_TRAINING_TIMING_CNTL1 */
			0x00000017, /* EMC_CA_TRAINING_TIMING_CNTL2 */
			0xa0000001, /* MC_EMEM_ARB_CFG */
			0x8000005b, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000007, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_W2R */
			0x05040102, /* MC_EMEM_ARB_DA_TURNS */
			0x00090402, /* MC_EMEM_ARB_DA_COVERS */
			0x73030303, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x0004032c, /* EMC_SEL_DPD_CTRL */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x00000007, /* EMC_QUSE */
			0x00000004, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00078000, /* EMC_DLL_XFORM_DQS0 */
			0x0000000a, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x0000000d, /* EMC_RDV */
			0x00249249, /* EMC_XM2DQSPADCTRL4 */
			0x20820800, /* EMC_XM2DQSPADCTRL3 */
			0x0007c000, /* EMC_DLL_XFORM_DQ0 */
			0xa0f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x000c0000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x000c0000, /* EMC_DLL_XFORM_ADDR2 */
			0x00078000, /* EMC_DLL_XFORM_DQS1 */
			0x00078000, /* EMC_DLL_XFORM_DQS2 */
			0x00078000, /* EMC_DLL_XFORM_DQS3 */
			0x0007c000, /* EMC_DLL_XFORM_DQ1 */
			0x0007c000, /* EMC_DLL_XFORM_DQ2 */
			0x0007c000, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x00000007, /* EMC_QUSE */
			0x00000004, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00078000, /* EMC_DLL_XFORM_DQS0 */
			0x0000000a, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x0000000d, /* EMC_RDV */
			0x00249249, /* EMC_XM2DQSPADCTRL4 */
			0x20820800, /* EMC_XM2DQSPADCTRL3 */
			0x0007c000, /* EMC_DLL_XFORM_DQ0 */
			0xa8f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x000c0000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x000c0000, /* EMC_DLL_XFORM_ADDR2 */
			0x00078000, /* EMC_DLL_XFORM_DQS1 */
			0x00078000, /* EMC_DLL_XFORM_DQS2 */
			0x00078000, /* EMC_DLL_XFORM_DQS3 */
			0x0007c000, /* EMC_DLL_XFORM_DQ1 */
			0x0007c000, /* EMC_DLL_XFORM_DQ2 */
			0x0007c000, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x00000015, /* MC_PTSA_GRANT_DECREMENT */
			0x00b000b0, /* MC_LATENCY_ALLOWANCE_G2_0 */
			0x00b000c4, /* MC_LATENCY_ALLOWANCE_G2_1 */
			0x00d700eb, /* MC_LATENCY_ALLOWANCE_NV_0 */
			0x000000eb, /* MC_LATENCY_ALLOWANCE_NV2_0 */
			0x00eb00eb, /* MC_LATENCY_ALLOWANCE_NV_2 */
			0x00ff00eb, /* MC_LATENCY_ALLOWANCE_NV_1 */
			0x000000ff, /* MC_LATENCY_ALLOWANCE_NV2_1 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_NV3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_EPP_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_EPP_1 */
		},
		0x00000014, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0xf320000e, /* EMC_CFG */
		0x00000000, /* Mode Register 0 */
		0x80010083, /* Mode Register 1 */
		0x80020004, /* Mode Register 2 */
		0x800b0000, /* Mode Register 4 */
		20850,      /* expected dvfs latency (ns) */
	},
	{
		0x42,       /* Rev 4.0.3 */
		68000,      /* SDRAM frequency */
		900,        /* min voltage */
		"pll_p",    /* clock source id */
		0x4400000a, /* CLK_SOURCE_EMC */
		100,        /* number of burst_regs */
		30,         /* number of trim_regs (each channel) */
		11,         /* number of up_down_regs */
		{
			0x00000004, /* EMC_RC */
			0x00000008, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000002, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000006, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000001, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x0000000f, /* EMC_WDV_MASK */
			0x00000005, /* EMC_IBDLY */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000004, /* EMC_QRST */
			0x0000000f, /* EMC_RDV_MASK */
			0x00000101, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000040, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000000c, /* EMC_RW2PDEN */
			0x0000000a, /* EMC_TXSR */
			0x0000000a, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000003, /* EMC_TCKESR */
			0x00000003, /* EMC_TPD */
			0x00000008, /* EMC_TFAW */
			0x00000004, /* EMC_TRPAB */
			0x00000001, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x0000011b, /* EMC_TREFBW */
			0x00000005, /* EMC_QUSE_EXTRA */
			0x00000020, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x0001aa86, /* EMC_FBIO_CFG5 */
			0x005800a8, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00078000, /* EMC_DLL_XFORM_DQS4 */
			0x00078000, /* EMC_DLL_XFORM_DQS5 */
			0x00078000, /* EMC_DLL_XFORM_DQS6 */
			0x00078000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00010220, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x0000a01c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x02000100, /* EMC_FBIO_SPARE */
			0x00000201, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x00000019, /* EMC_ZCAL_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x80000309, /* EMC_DYN_SELF_REF_CONTROL */
			0x09257359, /* EMC_CA_TRAINING_TIMING_CNTL1 */
			0x00000017, /* EMC_CA_TRAINING_TIMING_CNTL2 */
			0x00000001, /* MC_EMEM_ARB_CFG */
			0x80000076, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000007, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_W2R */
			0x05040102, /* MC_EMEM_ARB_DA_TURNS */
			0x00090402, /* MC_EMEM_ARB_DA_COVERS */
			0x72630403, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x0004032c, /* EMC_SEL_DPD_CTRL */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x00000007, /* EMC_QUSE */
			0x00000004, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00078000, /* EMC_DLL_XFORM_DQS0 */
			0x0000000a, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x0000000d, /* EMC_RDV */
			0x00249249, /* EMC_XM2DQSPADCTRL4 */
			0x20820800, /* EMC_XM2DQSPADCTRL3 */
			0x0007c000, /* EMC_DLL_XFORM_DQ0 */
			0xa0f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x000c0000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x000c0000, /* EMC_DLL_XFORM_ADDR2 */
			0x00078000, /* EMC_DLL_XFORM_DQS1 */
			0x00078000, /* EMC_DLL_XFORM_DQS2 */
			0x00078000, /* EMC_DLL_XFORM_DQS3 */
			0x0007c000, /* EMC_DLL_XFORM_DQ1 */
			0x0007c000, /* EMC_DLL_XFORM_DQ2 */
			0x0007c000, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x00000007, /* EMC_QUSE */
			0x00000004, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00078000, /* EMC_DLL_XFORM_DQS0 */
			0x0000000a, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x0000000d, /* EMC_RDV */
			0x00249249, /* EMC_XM2DQSPADCTRL4 */
			0x20820800, /* EMC_XM2DQSPADCTRL3 */
			0x0007c000, /* EMC_DLL_XFORM_DQ0 */
			0xa8f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x000c0000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x000c0000, /* EMC_DLL_XFORM_ADDR2 */
			0x00078000, /* EMC_DLL_XFORM_DQS1 */
			0x00078000, /* EMC_DLL_XFORM_DQS2 */
			0x00078000, /* EMC_DLL_XFORM_DQS3 */
			0x0007c000, /* EMC_DLL_XFORM_DQ1 */
			0x0007c000, /* EMC_DLL_XFORM_DQ2 */
			0x0007c000, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x00000023, /* MC_PTSA_GRANT_DECREMENT */
			0x00690069, /* MC_LATENCY_ALLOWANCE_G2_0 */
			0x00690075, /* MC_LATENCY_ALLOWANCE_G2_1 */
			0x0081008d, /* MC_LATENCY_ALLOWANCE_NV_0 */
			0x0000008d, /* MC_LATENCY_ALLOWANCE_NV2_0 */
			0x008d008d, /* MC_LATENCY_ALLOWANCE_NV_2 */
			0x00bc008d, /* MC_LATENCY_ALLOWANCE_NV_1 */
			0x000000bc, /* MC_LATENCY_ALLOWANCE_NV2_1 */
			0x00bc00bc, /* MC_LATENCY_ALLOWANCE_NV3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_EPP_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_EPP_1 */
		},
		0x00000014, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0xf320000e, /* EMC_CFG */
		0x00000000, /* Mode Register 0 */
		0x80010083, /* Mode Register 1 */
		0x80020004, /* Mode Register 2 */
		0x800b0000, /* Mode Register 4 */
		10720,      /* expected dvfs latency (ns) */
	},
	{
		0x42,       /* Rev 4.0.3 */
		102000,     /* SDRAM frequency */
		900,        /* min voltage */
		"pll_p",    /* clock source id */
		0x44000006, /* CLK_SOURCE_EMC */
		100,        /* number of burst_regs */
		30,         /* number of trim_regs (each channel) */
		11,         /* number of up_down_regs */
		{
			0x00000006, /* EMC_RC */
			0x0000000d, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000004, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000006, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000001, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x0000000f, /* EMC_WDV_MASK */
			0x00000005, /* EMC_IBDLY */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000004, /* EMC_QRST */
			0x0000000f, /* EMC_RDV_MASK */
			0x00000181, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000060, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000000c, /* EMC_RW2PDEN */
			0x0000000f, /* EMC_TXSR */
			0x0000000f, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000003, /* EMC_TCKESR */
			0x00000003, /* EMC_TPD */
			0x00000008, /* EMC_TFAW */
			0x00000004, /* EMC_TRPAB */
			0x00000001, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x000001a9, /* EMC_TREFBW */
			0x00000005, /* EMC_QUSE_EXTRA */
			0x00000020, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x0001aa86, /* EMC_FBIO_CFG5 */
			0x005800a8, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00078000, /* EMC_DLL_XFORM_DQS4 */
			0x00078000, /* EMC_DLL_XFORM_DQS5 */
			0x00078000, /* EMC_DLL_XFORM_DQS6 */
			0x00078000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00010220, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x0000a01c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x02000100, /* EMC_FBIO_SPARE */
			0x00000201, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x00000025, /* EMC_ZCAL_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x8000040b, /* EMC_DYN_SELF_REF_CONTROL */
			0x09257359, /* EMC_CA_TRAINING_TIMING_CNTL1 */
			0x00000017, /* EMC_CA_TRAINING_TIMING_CNTL2 */
			0x08000001, /* MC_EMEM_ARB_CFG */
			0x80000098, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000003, /* MC_EMEM_ARB_TIMING_RC */
			0x00000001, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000007, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_W2R */
			0x05040102, /* MC_EMEM_ARB_DA_TURNS */
			0x00090403, /* MC_EMEM_ARB_DA_COVERS */
			0x72430504, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x0004032c, /* EMC_SEL_DPD_CTRL */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x00000007, /* EMC_QUSE */
			0x00000004, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00078000, /* EMC_DLL_XFORM_DQS0 */
			0x0000000a, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x0000000d, /* EMC_RDV */
			0x00249249, /* EMC_XM2DQSPADCTRL4 */
			0x20820800, /* EMC_XM2DQSPADCTRL3 */
			0x0007c000, /* EMC_DLL_XFORM_DQ0 */
			0xa0f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x000c0000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x000c0000, /* EMC_DLL_XFORM_ADDR2 */
			0x00078000, /* EMC_DLL_XFORM_DQS1 */
			0x00078000, /* EMC_DLL_XFORM_DQS2 */
			0x00078000, /* EMC_DLL_XFORM_DQS3 */
			0x0007c000, /* EMC_DLL_XFORM_DQ1 */
			0x0007c000, /* EMC_DLL_XFORM_DQ2 */
			0x0007c000, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x00000007, /* EMC_QUSE */
			0x00000004, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00078000, /* EMC_DLL_XFORM_DQS0 */
			0x0000000a, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x0000000d, /* EMC_RDV */
			0x00249249, /* EMC_XM2DQSPADCTRL4 */
			0x20820800, /* EMC_XM2DQSPADCTRL3 */
			0x0007c000, /* EMC_DLL_XFORM_DQ0 */
			0xa8f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x000c0000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x000c0000, /* EMC_DLL_XFORM_ADDR2 */
			0x00078000, /* EMC_DLL_XFORM_DQS1 */
			0x00078000, /* EMC_DLL_XFORM_DQS2 */
			0x00078000, /* EMC_DLL_XFORM_DQS3 */
			0x0007c000, /* EMC_DLL_XFORM_DQ1 */
			0x0007c000, /* EMC_DLL_XFORM_DQ2 */
			0x0007c000, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x00000034, /* MC_PTSA_GRANT_DECREMENT */
			0x00460046, /* MC_LATENCY_ALLOWANCE_G2_0 */
			0x0046004e, /* MC_LATENCY_ALLOWANCE_G2_1 */
			0x0056005e, /* MC_LATENCY_ALLOWANCE_NV_0 */
			0x0000005e, /* MC_LATENCY_ALLOWANCE_NV2_0 */
			0x005e005e, /* MC_LATENCY_ALLOWANCE_NV_2 */
			0x007d005e, /* MC_LATENCY_ALLOWANCE_NV_1 */
			0x0000007d, /* MC_LATENCY_ALLOWANCE_NV2_1 */
			0x007d007d, /* MC_LATENCY_ALLOWANCE_NV3 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_EPP_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_EPP_1 */
		},
		0x00000014, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0xf320000e, /* EMC_CFG */
		0x00000000, /* Mode Register 0 */
		0x80010083, /* Mode Register 1 */
		0x80020004, /* Mode Register 2 */
		0x800b0000, /* Mode Register 4 */
		6890,       /* expected dvfs latency (ns) */
	},
	{
		0x42,       /* Rev 4.0.3 */
		204000,     /* SDRAM frequency */
		900,        /* min voltage */
		"pll_p",    /* clock source id */
		0x44000002, /* CLK_SOURCE_EMC */
		100,        /* number of burst_regs */
		30,         /* number of trim_regs (each channel) */
		11,         /* number of up_down_regs */
		{
			0x0000000c, /* EMC_RC */
			0x0000001a, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000008, /* EMC_RAS */
			0x00000003, /* EMC_RP */
			0x00000007, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000003, /* EMC_RD_RCD */
			0x00000003, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x0000000f, /* EMC_WDV_MASK */
			0x00000006, /* EMC_IBDLY */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000004, /* EMC_QRST */
			0x00000010, /* EMC_RDV_MASK */
			0x00000303, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000000c0, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000003, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000000c, /* EMC_RW2PDEN */
			0x0000001d, /* EMC_TXSR */
			0x0000001d, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000004, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x0000000b, /* EMC_TFAW */
			0x00000005, /* EMC_TRPAB */
			0x00000001, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x00000351, /* EMC_TREFBW */
			0x00000006, /* EMC_QUSE_EXTRA */
			0x00000020, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x0001aa86, /* EMC_FBIO_CFG5 */
			0x005800a8, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00048000, /* EMC_DLL_XFORM_DQS4 */
			0x00048000, /* EMC_DLL_XFORM_DQS5 */
			0x00048000, /* EMC_DLL_XFORM_DQS6 */
			0x00048000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00010220, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x0000a01c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x02000100, /* EMC_FBIO_SPARE */
			0x00000201, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x0000004a, /* EMC_ZCAL_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x80000713, /* EMC_DYN_SELF_REF_CONTROL */
			0x09257359, /* EMC_CA_TRAINING_TIMING_CNTL1 */
			0x00000017, /* EMC_CA_TRAINING_TIMING_CNTL2 */
			0x01000003, /* MC_EMEM_ARB_CFG */
			0x800000fe, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000006, /* MC_EMEM_ARB_TIMING_RC */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000005, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000007, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_W2R */
			0x05050102, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0506, /* MC_EMEM_ARB_DA_COVERS */
			0x71e40a07, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x0004032c, /* EMC_SEL_DPD_CTRL */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000008, /* EMC_QUSE */
			0x00000004, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00048000, /* EMC_DLL_XFORM_DQS0 */
			0x0000000c, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x0000000e, /* EMC_RDV */
			0x00249249, /* EMC_XM2DQSPADCTRL4 */
			0x20820800, /* EMC_XM2DQSPADCTRL3 */
			0x0006c000, /* EMC_DLL_XFORM_DQ0 */
			0xa0f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x00060000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00060000, /* EMC_DLL_XFORM_ADDR2 */
			0x00048000, /* EMC_DLL_XFORM_DQS1 */
			0x00048000, /* EMC_DLL_XFORM_DQS2 */
			0x00048000, /* EMC_DLL_XFORM_DQS3 */
			0x0006c000, /* EMC_DLL_XFORM_DQ1 */
			0x0006c000, /* EMC_DLL_XFORM_DQ2 */
			0x0006c000, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000008, /* EMC_QUSE */
			0x00000004, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00048000, /* EMC_DLL_XFORM_DQS0 */
			0x0000000c, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x0000000e, /* EMC_RDV */
			0x00249249, /* EMC_XM2DQSPADCTRL4 */
			0x20820800, /* EMC_XM2DQSPADCTRL3 */
			0x0006c000, /* EMC_DLL_XFORM_DQ0 */
			0xa8f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x00060000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00060000, /* EMC_DLL_XFORM_ADDR2 */
			0x00048000, /* EMC_DLL_XFORM_DQS1 */
			0x00048000, /* EMC_DLL_XFORM_DQS2 */
			0x00048000, /* EMC_DLL_XFORM_DQS3 */
			0x0006c000, /* EMC_DLL_XFORM_DQ1 */
			0x0006c000, /* EMC_DLL_XFORM_DQ2 */
			0x0006c000, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x00000068, /* MC_PTSA_GRANT_DECREMENT */
			0x00230023, /* MC_LATENCY_ALLOWANCE_G2_0 */
			0x00230027, /* MC_LATENCY_ALLOWANCE_G2_1 */
			0x002b002f, /* MC_LATENCY_ALLOWANCE_NV_0 */
			0x0000002f, /* MC_LATENCY_ALLOWANCE_NV2_0 */
			0x002f002f, /* MC_LATENCY_ALLOWANCE_NV_2 */
			0x003e002f, /* MC_LATENCY_ALLOWANCE_NV_1 */
			0x0000003e, /* MC_LATENCY_ALLOWANCE_NV2_1 */
			0x003e003e, /* MC_LATENCY_ALLOWANCE_NV3 */
			0x00ff00c8, /* MC_LATENCY_ALLOWANCE_EPP_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_EPP_1 */
		},
		0x00000017, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0xf320000e, /* EMC_CFG */
		0x00000000, /* Mode Register 0 */
		0x80010083, /* Mode Register 1 */
		0x80020004, /* Mode Register 2 */
		0x800b0000, /* Mode Register 4 */
		3420,       /* expected dvfs latency (ns) */
	},
	{
		0x42,       /* Rev 4.0.3 */
		312000,     /* SDRAM frequency */
		1000,       /* min voltage */
		"pll_c",    /* clock source id */
		0x24000002, /* CLK_SOURCE_EMC */
		100,        /* number of burst_regs */
		30,         /* number of trim_regs (each channel) */
		11,         /* number of up_down_regs */
		{
			0x00000012, /* EMC_RC */
			0x00000028, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x0000000d, /* EMC_RAS */
			0x00000005, /* EMC_RP */
			0x00000008, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000005, /* EMC_RD_RCD */
			0x00000005, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x0000000f, /* EMC_WDV_MASK */
			0x00000006, /* EMC_IBDLY */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000004, /* EMC_QRST */
			0x00000011, /* EMC_RDV_MASK */
			0x0000049b, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000126, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000005, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000000d, /* EMC_RW2PDEN */
			0x0000002c, /* EMC_TXSR */
			0x0000002c, /* EMC_TXSRDLL */
			0x00000005, /* EMC_TCKE */
			0x00000005, /* EMC_TCKESR */
			0x00000005, /* EMC_TPD */
			0x00000010, /* EMC_TFAW */
			0x00000007, /* EMC_TRPAB */
			0x00000001, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x00000512, /* EMC_TREFBW */
			0x00000006, /* EMC_QUSE_EXTRA */
			0x00000020, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x0001aa86, /* EMC_FBIO_CFG5 */
			0x005800a8, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00020000, /* EMC_DLL_XFORM_DQS4 */
			0x00020000, /* EMC_DLL_XFORM_DQS5 */
			0x00020000, /* EMC_DLL_XFORM_DQS6 */
			0x00020000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00010220, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x0000a01c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x02000100, /* EMC_FBIO_SPARE */
			0x00000201, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x00000071, /* EMC_ZCAL_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT */
			0x00100010, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x80000a48, /* EMC_DYN_SELF_REF_CONTROL */
			0x09257359, /* EMC_CA_TRAINING_TIMING_CNTL1 */
			0x00000017, /* EMC_CA_TRAINING_TIMING_CNTL2 */
			0x0b000004, /* MC_EMEM_ARB_CFG */
			0x8000016a, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RP */
			0x00000009, /* MC_EMEM_ARB_TIMING_RC */
			0x00000005, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000007, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000007, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_W2R */
			0x05050102, /* MC_EMEM_ARB_DA_TURNS */
			0x000c0709, /* MC_EMEM_ARB_DA_COVERS */
			0x71c50f0a, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x0004032c, /* EMC_SEL_DPD_CTRL */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000009, /* EMC_QUSE */
			0x00000004, /* EMC_EINPUT */
			0x00000006, /* EMC_EINPUT_DURATION */
			0x00020000, /* EMC_DLL_XFORM_DQS0 */
			0x0000000d, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x0000000f, /* EMC_RDV */
			0x00208208, /* EMC_XM2DQSPADCTRL4 */
			0x20820800, /* EMC_XM2DQSPADCTRL3 */
			0x00038000, /* EMC_DLL_XFORM_DQ0 */
			0xa0f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x00040000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00040000, /* EMC_DLL_XFORM_ADDR2 */
			0x00020000, /* EMC_DLL_XFORM_DQS1 */
			0x00020000, /* EMC_DLL_XFORM_DQS2 */
			0x00020000, /* EMC_DLL_XFORM_DQS3 */
			0x00038000, /* EMC_DLL_XFORM_DQ1 */
			0x00038000, /* EMC_DLL_XFORM_DQ2 */
			0x00038000, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000009, /* EMC_QUSE */
			0x00000004, /* EMC_EINPUT */
			0x00000006, /* EMC_EINPUT_DURATION */
			0x00020000, /* EMC_DLL_XFORM_DQS0 */
			0x0000000d, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x0000000f, /* EMC_RDV */
			0x00208208, /* EMC_XM2DQSPADCTRL4 */
			0x20820800, /* EMC_XM2DQSPADCTRL3 */
			0x00038000, /* EMC_DLL_XFORM_DQ0 */
			0xa8f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x00040000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00040000, /* EMC_DLL_XFORM_ADDR2 */
			0x00020000, /* EMC_DLL_XFORM_DQS1 */
			0x00020000, /* EMC_DLL_XFORM_DQS2 */
			0x00020000, /* EMC_DLL_XFORM_DQS3 */
			0x00038000, /* EMC_DLL_XFORM_DQ1 */
			0x00038000, /* EMC_DLL_XFORM_DQ2 */
			0x00038000, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x000000a0, /* MC_PTSA_GRANT_DECREMENT */
			0x00170017, /* MC_LATENCY_ALLOWANCE_G2_0 */
			0x00170019, /* MC_LATENCY_ALLOWANCE_G2_1 */
			0x001c001e, /* MC_LATENCY_ALLOWANCE_NV_0 */
			0x0000001e, /* MC_LATENCY_ALLOWANCE_NV2_0 */
			0x001e001e, /* MC_LATENCY_ALLOWANCE_NV_2 */
			0x0029001e, /* MC_LATENCY_ALLOWANCE_NV_1 */
			0x00000029, /* MC_LATENCY_ALLOWANCE_NV2_1 */
			0x00290029, /* MC_LATENCY_ALLOWANCE_NV3 */
			0x00ff0082, /* MC_LATENCY_ALLOWANCE_EPP_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_EPP_1 */
		},
		0x00000021, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0xf320000e, /* EMC_CFG */
		0x00000000, /* Mode Register 0 */
		0x80010083, /* Mode Register 1 */
		0x80020004, /* Mode Register 2 */
		0x800b0000, /* Mode Register 4 */
		2180,       /* expected dvfs latency (ns) */
	},
	{
		0x42,       /* Rev 4.0.3 */
		408000,     /* SDRAM frequency */
		1000,       /* min voltage */
		"pll_p",    /* clock source id */
		0x44000000, /* CLK_SOURCE_EMC */
		100,        /* number of burst_regs */
		30,         /* number of trim_regs (each channel) */
		11,         /* number of up_down_regs */
		{
			0x00000018, /* EMC_RC */
			0x00000035, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000011, /* EMC_RAS */
			0x00000007, /* EMC_RP */
			0x0000000b, /* EMC_R2W */
			0x00000009, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000d, /* EMC_W2P */
			0x00000007, /* EMC_RD_RCD */
			0x00000007, /* EMC_WR_RCD */
			0x00000004, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x0000000f, /* EMC_WDV_MASK */
			0x00000008, /* EMC_IBDLY */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000005, /* EMC_QRST */
			0x00000013, /* EMC_RDV_MASK */
			0x00000607, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000181, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000003, /* EMC_PDEX2WR */
			0x00000003, /* EMC_PDEX2RD */
			0x00000007, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x0000003a, /* EMC_TXSR */
			0x0000003a, /* EMC_TXSRDLL */
			0x00000007, /* EMC_TCKE */
			0x00000007, /* EMC_TCKESR */
			0x00000007, /* EMC_TPD */
			0x00000015, /* EMC_TFAW */
			0x00000009, /* EMC_TRPAB */
			0x00000001, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x000006a2, /* EMC_TREFBW */
			0x00000007, /* EMC_QUSE_EXTRA */
			0x00000020, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x0001a886, /* EMC_FBIO_CFG5 */
			0x00580088, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00020000, /* EMC_DLL_XFORM_DQS4 */
			0x00020000, /* EMC_DLL_XFORM_DQS5 */
			0x00020000, /* EMC_DLL_XFORM_DQS6 */
			0x00020000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00010220, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x0001003d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x02000100, /* EMC_FBIO_SPARE */
			0x00000201, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x00000093, /* EMC_ZCAL_WAIT_CNT */
			0x00120012, /* EMC_MRS_WAIT_CNT */
			0x00120012, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x80000d22, /* EMC_DYN_SELF_REF_CONTROL */
			0x09257359, /* EMC_CA_TRAINING_TIMING_CNTL1 */
			0x00000017, /* EMC_CA_TRAINING_TIMING_CNTL2 */
			0x02000006, /* MC_EMEM_ARB_CFG */
			0x80000190, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000002, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RP */
			0x0000000c, /* MC_EMEM_ARB_TIMING_RC */
			0x00000007, /* MC_EMEM_ARB_TIMING_RAS */
			0x0000000a, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000002, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000009, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000007, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06070102, /* MC_EMEM_ARB_DA_TURNS */
			0x0010090c, /* MC_EMEM_ARB_DA_COVERS */
			0x71c7130d, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x0004032c, /* EMC_SEL_DPD_CTRL */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x0000000a, /* EMC_QUSE */
			0x00000006, /* EMC_EINPUT */
			0x00000006, /* EMC_EINPUT_DURATION */
			0x00020000, /* EMC_DLL_XFORM_DQS0 */
			0x0000000e, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000011, /* EMC_RDV */
			0x00249249, /* EMC_XM2DQSPADCTRL4 */
			0x14514521, /* EMC_XM2DQSPADCTRL3 */
			0x00020000, /* EMC_DLL_XFORM_DQ0 */
			0xa0f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x0002c000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x0002c000, /* EMC_DLL_XFORM_ADDR2 */
			0x00020000, /* EMC_DLL_XFORM_DQS1 */
			0x00020000, /* EMC_DLL_XFORM_DQS2 */
			0x00020000, /* EMC_DLL_XFORM_DQS3 */
			0x00020000, /* EMC_DLL_XFORM_DQ1 */
			0x00020000, /* EMC_DLL_XFORM_DQ2 */
			0x00020000, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x0000000a, /* EMC_QUSE */
			0x00000006, /* EMC_EINPUT */
			0x00000006, /* EMC_EINPUT_DURATION */
			0x00020000, /* EMC_DLL_XFORM_DQS0 */
			0x0000000e, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000011, /* EMC_RDV */
			0x00249249, /* EMC_XM2DQSPADCTRL4 */
			0x14514521, /* EMC_XM2DQSPADCTRL3 */
			0x00020000, /* EMC_DLL_XFORM_DQ0 */
			0xa8f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x0002c000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x0002c000, /* EMC_DLL_XFORM_ADDR2 */
			0x00020000, /* EMC_DLL_XFORM_DQS1 */
			0x00020000, /* EMC_DLL_XFORM_DQS2 */
			0x00020000, /* EMC_DLL_XFORM_DQS3 */
			0x00020000, /* EMC_DLL_XFORM_DQ1 */
			0x00020000, /* EMC_DLL_XFORM_DQ2 */
			0x00020000, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x000000d1, /* MC_PTSA_GRANT_DECREMENT */
			0x00110011, /* MC_LATENCY_ALLOWANCE_G2_0 */
			0x00110013, /* MC_LATENCY_ALLOWANCE_G2_1 */
			0x00150017, /* MC_LATENCY_ALLOWANCE_NV_0 */
			0x00000017, /* MC_LATENCY_ALLOWANCE_NV2_0 */
			0x00170017, /* MC_LATENCY_ALLOWANCE_NV_2 */
			0x001f0017, /* MC_LATENCY_ALLOWANCE_NV_1 */
			0x0000001f, /* MC_LATENCY_ALLOWANCE_NV2_1 */
			0x001f001f, /* MC_LATENCY_ALLOWANCE_NV3 */
			0x00d30064, /* MC_LATENCY_ALLOWANCE_EPP_0 */
			0x00d300d3, /* MC_LATENCY_ALLOWANCE_EPP_1 */
		},
		0x00000029, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0xf3200006, /* EMC_CFG */
		0x00000000, /* Mode Register 0 */
		0x800100c3, /* Mode Register 1 */
		0x80020006, /* Mode Register 2 */
		0x800b0000, /* Mode Register 4 */
		1750,       /* expected dvfs latency (ns) */
	},
	{
		0x42,       /* Rev 4.0.3 */
		624000,     /* SDRAM frequency */
		1100,       /* min voltage */
		"pll_c",    /* clock source id */
		0x24000000, /* CLK_SOURCE_EMC */
		100,        /* number of burst_regs */
		30,         /* number of trim_regs (each channel) */
		11,         /* number of up_down_regs */
		{
			0x00000025, /* EMC_RC */
			0x00000051, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x0000001a, /* EMC_RAS */
			0x0000000b, /* EMC_RP */
			0x0000000d, /* EMC_R2W */
			0x0000000c, /* EMC_W2R */
			0x00000004, /* EMC_R2P */
			0x00000011, /* EMC_W2P */
			0x0000000b, /* EMC_RD_RCD */
			0x0000000b, /* EMC_WR_RCD */
			0x00000006, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x0000000f, /* EMC_WDV_MASK */
			0x0000000b, /* EMC_IBDLY */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000007, /* EMC_QRST */
			0x00000017, /* EMC_RDV_MASK */
			0x00000941, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000250, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000004, /* EMC_PDEX2WR */
			0x00000004, /* EMC_PDEX2RD */
			0x0000000b, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x00000014, /* EMC_RW2PDEN */
			0x00000058, /* EMC_TXSR */
			0x00000058, /* EMC_TXSRDLL */
			0x0000000a, /* EMC_TCKE */
			0x0000000a, /* EMC_TCKESR */
			0x0000000a, /* EMC_TPD */
			0x00000020, /* EMC_TFAW */
			0x0000000e, /* EMC_TRPAB */
			0x00000001, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x00000a24, /* EMC_TREFBW */
			0x0000000b, /* EMC_QUSE_EXTRA */
			0x00000020, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x0001a886, /* EMC_FBIO_CFG5 */
			0xf00d0199, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x0000000b, /* EMC_DLL_XFORM_DQS4 */
			0x0000000b, /* EMC_DLL_XFORM_DQS5 */
			0x0000000b, /* EMC_DLL_XFORM_DQS6 */
			0x0000000b, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00010220, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x0001003d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x0000003f, /* EMC_XM2VTTGENPADCTRL2 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x02000100, /* EMC_FBIO_SPARE */
			0x00000201, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x000000e1, /* EMC_ZCAL_WAIT_CNT */
			0x00140014, /* EMC_MRS_WAIT_CNT */
			0x00140014, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x8000138d, /* EMC_DYN_SELF_REF_CONTROL */
			0x09257359, /* EMC_CA_TRAINING_TIMING_CNTL1 */
			0x00000017, /* EMC_CA_TRAINING_TIMING_CNTL2 */
			0x06000009, /* MC_EMEM_ARB_CFG */
			0x80000190, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000004, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000005, /* MC_EMEM_ARB_TIMING_RP */
			0x00000013, /* MC_EMEM_ARB_TIMING_RC */
			0x0000000c, /* MC_EMEM_ARB_TIMING_RAS */
			0x0000000f, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000003, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000b, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000008, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000007, /* MC_EMEM_ARB_TIMING_W2R */
			0x07080103, /* MC_EMEM_ARB_DA_TURNS */
			0x00160e13, /* MC_EMEM_ARB_DA_COVERS */
			0x71ca1d14, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x0004032c, /* EMC_SEL_DPD_CTRL */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x0000000f, /* EMC_QUSE */
			0x00000009, /* EMC_EINPUT */
			0x00000007, /* EMC_EINPUT_DURATION */
			0x0000000b, /* EMC_DLL_XFORM_DQS0 */
			0x00000010, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000015, /* EMC_RDV */
			0x00249249, /* EMC_XM2DQSPADCTRL4 */
			0x18618621, /* EMC_XM2DQSPADCTRL3 */
			0x00000009, /* EMC_DLL_XFORM_DQ0 */
			0xa0f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x0000000f, /* EMC_DLL_XFORM_ADDR0 */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x0000000f, /* EMC_DLL_XFORM_ADDR2 */
			0x0000000b, /* EMC_DLL_XFORM_DQS1 */
			0x0000000b, /* EMC_DLL_XFORM_DQS2 */
			0x0000000b, /* EMC_DLL_XFORM_DQS3 */
			0x00000008, /* EMC_DLL_XFORM_DQ1 */
			0x00000009, /* EMC_DLL_XFORM_DQ2 */
			0x00000008, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x0000000f, /* EMC_QUSE */
			0x00000009, /* EMC_EINPUT */
			0x00000007, /* EMC_EINPUT_DURATION */
			0x0000000b, /* EMC_DLL_XFORM_DQS0 */
			0x00000010, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000015, /* EMC_RDV */
			0x00249249, /* EMC_XM2DQSPADCTRL4 */
			0x18618621, /* EMC_XM2DQSPADCTRL3 */
			0x00000009, /* EMC_DLL_XFORM_DQ0 */
			0xa8f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x0000000f, /* EMC_DLL_XFORM_ADDR0 */
			0x00000909, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x0000000f, /* EMC_DLL_XFORM_ADDR2 */
			0x0000000b, /* EMC_DLL_XFORM_DQS1 */
			0x0000000b, /* EMC_DLL_XFORM_DQS2 */
			0x0000000b, /* EMC_DLL_XFORM_DQS3 */
			0x00000008, /* EMC_DLL_XFORM_DQ1 */
			0x00000009, /* EMC_DLL_XFORM_DQ2 */
			0x00000008, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x0000013f, /* MC_PTSA_GRANT_DECREMENT */
			0x000b000b, /* MC_LATENCY_ALLOWANCE_G2_0 */
			0x000b000c, /* MC_LATENCY_ALLOWANCE_G2_1 */
			0x000e000f, /* MC_LATENCY_ALLOWANCE_NV_0 */
			0x0000000f, /* MC_LATENCY_ALLOWANCE_NV2_0 */
			0x000f000f, /* MC_LATENCY_ALLOWANCE_NV_2 */
			0x0014000f, /* MC_LATENCY_ALLOWANCE_NV_1 */
			0x00000014, /* MC_LATENCY_ALLOWANCE_NV2_1 */
			0x00140014, /* MC_LATENCY_ALLOWANCE_NV3 */
			0x008a0041, /* MC_LATENCY_ALLOWANCE_EPP_0 */
			0x008a008a, /* MC_LATENCY_ALLOWANCE_EPP_1 */
		},
		0x0000003d, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0xf3200000, /* EMC_CFG */
		0x00000000, /* Mode Register 0 */
		0x80010003, /* Mode Register 1 */
		0x80020018, /* Mode Register 2 */
		0x800b0000, /* Mode Register 4 */
		1230,       /* expected dvfs latency (ns) */
	},
	{
		0x42,       /* Rev 4.0.3 */
		792000,     /* SDRAM frequency */
		1100,       /* min voltage */
		"pll_m",    /* clock source id */
		0x84000000, /* CLK_SOURCE_EMC */
		100,        /* number of burst_regs */
		30,         /* number of trim_regs (each channel) */
		11,         /* number of up_down_regs */
		{
			0x0000002f, /* EMC_RC */
			0x00000066, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000021, /* EMC_RAS */
			0x0000000e, /* EMC_RP */
			0x00000010, /* EMC_R2W */
			0x0000000d, /* EMC_W2R */
			0x00000005, /* EMC_R2P */
			0x00000013, /* EMC_W2P */
			0x0000000e, /* EMC_RD_RCD */
			0x0000000e, /* EMC_WR_RCD */
			0x00000007, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000005, /* EMC_WDV */
			0x0000000f, /* EMC_WDV_MASK */
			0x0000000e, /* EMC_IBDLY */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000009, /* EMC_QRST */
			0x0000001a, /* EMC_RDV_MASK */
			0x00000bd0, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000002f4, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000005, /* EMC_PDEX2WR */
			0x00000005, /* EMC_PDEX2RD */
			0x0000000e, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x00000017, /* EMC_RW2PDEN */
			0x0000006f, /* EMC_TXSR */
			0x0000006f, /* EMC_TXSRDLL */
			0x0000000c, /* EMC_TCKE */
			0x0000000c, /* EMC_TCKESR */
			0x0000000c, /* EMC_TPD */
			0x00000028, /* EMC_TFAW */
			0x00000011, /* EMC_TRPAB */
			0x00000001, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x00000cdf, /* EMC_TREFBW */
			0x0000000d, /* EMC_QUSE_EXTRA */
			0x00000020, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x0001a886, /* EMC_FBIO_CFG5 */
			0xf0070199, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x0000000a, /* EMC_DLL_XFORM_DQS4 */
			0x0000000a, /* EMC_DLL_XFORM_DQS5 */
			0x0000000a, /* EMC_DLL_XFORM_DQS6 */
			0x0000000a, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00010220, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x0000003d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x02000100, /* EMC_FBIO_SPARE */
			0x00000201, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x0000011e, /* EMC_ZCAL_WAIT_CNT */
			0x00160016, /* EMC_MRS_WAIT_CNT */
			0x00160016, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x8000188b, /* EMC_DYN_SELF_REF_CONTROL */
			0x09257359, /* EMC_CA_TRAINING_TIMING_CNTL1 */
			0x00000017, /* EMC_CA_TRAINING_TIMING_CNTL2 */
			0x0e00000b, /* MC_EMEM_ARB_CFG */
			0x80000190, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000006, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000007, /* MC_EMEM_ARB_TIMING_RP */
			0x00000018, /* MC_EMEM_ARB_TIMING_RC */
			0x0000000f, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000013, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000003, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x0000000c, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000009, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000008, /* MC_EMEM_ARB_TIMING_W2R */
			0x08090103, /* MC_EMEM_ARB_DA_TURNS */
			0x001a1118, /* MC_EMEM_ARB_DA_COVERS */
			0x71ac2419, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x00040000, /* EMC_SEL_DPD_CTRL */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x00000011, /* EMC_QUSE */
			0x0000000b, /* EMC_EINPUT */
			0x00000007, /* EMC_EINPUT_DURATION */
			0x007fc00c, /* EMC_DLL_XFORM_DQS0 */
			0x00000011, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000018, /* EMC_RDV */
			0x00249249, /* EMC_XM2DQSPADCTRL4 */
			0x18618621, /* EMC_XM2DQSPADCTRL3 */
			0x0000000a, /* EMC_DLL_XFORM_DQ0 */
			0xa0f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x0000000e, /* EMC_DLL_XFORM_ADDR0 */
			0x00000808, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x0000000e, /* EMC_DLL_XFORM_ADDR2 */
			0x0000000a, /* EMC_DLL_XFORM_DQS1 */
			0x0000000a, /* EMC_DLL_XFORM_DQS2 */
			0x0000000b, /* EMC_DLL_XFORM_DQS3 */
			0x0000000a, /* EMC_DLL_XFORM_DQ1 */
			0x0000000a, /* EMC_DLL_XFORM_DQ2 */
			0x0000000a, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x00000011, /* EMC_QUSE */
			0x0000000b, /* EMC_EINPUT */
			0x00000007, /* EMC_EINPUT_DURATION */
			0x007fc00c, /* EMC_DLL_XFORM_DQS0 */
			0x00000011, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000018, /* EMC_RDV */
			0x00249249, /* EMC_XM2DQSPADCTRL4 */
			0x18618621, /* EMC_XM2DQSPADCTRL3 */
			0x0000000a, /* EMC_DLL_XFORM_DQ0 */
			0xa8f10f0f, /* EMC_AUTO_CAL_CONFIG */
			0x0000000e, /* EMC_DLL_XFORM_ADDR0 */
			0x00000808, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x0000000e, /* EMC_DLL_XFORM_ADDR2 */
			0x0000000a, /* EMC_DLL_XFORM_DQS1 */
			0x0000000a, /* EMC_DLL_XFORM_DQS2 */
			0x0000000b, /* EMC_DLL_XFORM_DQS3 */
			0x0000000a, /* EMC_DLL_XFORM_DQ1 */
			0x0000000a, /* EMC_DLL_XFORM_DQ2 */
			0x0000000a, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x00000196, /* MC_PTSA_GRANT_DECREMENT */
			0x00090009, /* MC_LATENCY_ALLOWANCE_G2_0 */
			0x0009000a, /* MC_LATENCY_ALLOWANCE_G2_1 */
			0x000b000c, /* MC_LATENCY_ALLOWANCE_NV_0 */
			0x0000000c, /* MC_LATENCY_ALLOWANCE_NV2_0 */
			0x000c000c, /* MC_LATENCY_ALLOWANCE_NV_2 */
			0x0010000c, /* MC_LATENCY_ALLOWANCE_NV_1 */
			0x00000010, /* MC_LATENCY_ALLOWANCE_NV2_1 */
			0x00100010, /* MC_LATENCY_ALLOWANCE_NV3 */
			0x006d0033, /* MC_LATENCY_ALLOWANCE_EPP_0 */
			0x006d006d, /* MC_LATENCY_ALLOWANCE_EPP_1 */
		},
		0x0000004c, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0xf3200000, /* EMC_CFG */
		0x00000000, /* Mode Register 0 */
		0x80010043, /* Mode Register 1 */
		0x8002001a, /* Mode Register 2 */
		0x800b0000, /* Mode Register 4 */
		1200,       /* expected dvfs latency (ns) */
	},
};

static struct tegra11_emc_table e1580_h9ccnnn8ktmlbr_ntm_table[] = {
	{
		0x40,       /* Rev 4.0 */
		204000,     /* SDRAM frequency */
		1000,       /* min voltage */
		"pll_p",    /* clock source id */
		0x40000002, /* CLK_SOURCE_EMC */
		99,         /* number of burst_regs */
		30,         /* number of trim_regs (each channel) */
		11,         /* number of up_down_regs */
		{
			0x0000000c, /* EMC_RC */
			0x0000001a, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000008, /* EMC_RAS */
			0x00000003, /* EMC_RP */
			0x00000007, /* EMC_R2W */
			0x00000008, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000003, /* EMC_RD_RCD */
			0x00000003, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x00000003, /* EMC_WDV_MASK */
			0x00000006, /* EMC_IBDLY */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000004, /* EMC_QRST */
			0x0000000e, /* EMC_RDV_MASK */
			0x00000303, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000000c0, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000003, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000000c, /* EMC_RW2PDEN */
			0x0000001d, /* EMC_TXSR */
			0x0000001d, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x00000004, /* EMC_TCKESR */
			0x00000004, /* EMC_TPD */
			0x0000000b, /* EMC_TFAW */
			0x00000005, /* EMC_TRPAB */
			0x00000001, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x00000351, /* EMC_TREFBW */
			0x00000006, /* EMC_QUSE_EXTRA */
			0x00000020, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x0001aa86, /* EMC_FBIO_CFG5 */
			0x005800a8, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00030000, /* EMC_DLL_XFORM_DQS4 */
			0x00030000, /* EMC_DLL_XFORM_DQS5 */
			0x00030000, /* EMC_DLL_XFORM_DQS6 */
			0x00030000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00010220, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x0000a01c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x02000100, /* EMC_FBIO_SPARE */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x0000004a, /* EMC_ZCAL_WAIT_CNT */
			0x000f000f, /* EMC_MRS_WAIT_CNT */
			0x000f000f, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x80000714, /* EMC_DYN_SELF_REF_CONTROL */
			0x09257359, /* EMC_CA_TRAINING_TIMING_CNTL1 */
			0x00000017, /* EMC_CA_TRAINING_TIMING_CNTL2 */
			0x01000003, /* MC_EMEM_ARB_CFG */
			0x800000fe, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000006, /* MC_EMEM_ARB_TIMING_RC */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000005, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000007, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_W2R */
			0x05050102, /* MC_EMEM_ARB_DA_TURNS */
			0x000a0506, /* MC_EMEM_ARB_DA_COVERS */
			0x71e40a07, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x00000007, /* EMC_QUSE */
			0x00000004, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00030000, /* EMC_DLL_XFORM_DQS0 */
			0x0000000a, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x0000000e, /* EMC_RDV */
			0x00208208, /* EMC_XM2DQSPADCTRL4 */
			0x20820800, /* EMC_XM2DQSPADCTRL3 */
			0x00040000, /* EMC_DLL_XFORM_DQ0 */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00040000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00040000, /* EMC_DLL_XFORM_ADDR2 */
			0x00030000, /* EMC_DLL_XFORM_DQS1 */
			0x00030000, /* EMC_DLL_XFORM_DQS2 */
			0x00030000, /* EMC_DLL_XFORM_DQS3 */
			0x00040000, /* EMC_DLL_XFORM_DQ1 */
			0x00040000, /* EMC_DLL_XFORM_DQ2 */
			0x00040000, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x00000007, /* EMC_QUSE */
			0x00000004, /* EMC_EINPUT */
			0x00000005, /* EMC_EINPUT_DURATION */
			0x00030000, /* EMC_DLL_XFORM_DQS0 */
			0x0000000a, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x0000000e, /* EMC_RDV */
			0x00208208, /* EMC_XM2DQSPADCTRL4 */
			0x20820800, /* EMC_XM2DQSPADCTRL3 */
			0x00040000, /* EMC_DLL_XFORM_DQ0 */
			0xa8f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00040000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00040000, /* EMC_DLL_XFORM_ADDR2 */
			0x00030000, /* EMC_DLL_XFORM_DQS1 */
			0x00030000, /* EMC_DLL_XFORM_DQS2 */
			0x00030000, /* EMC_DLL_XFORM_DQS3 */
			0x00040000, /* EMC_DLL_XFORM_DQ1 */
			0x00040000, /* EMC_DLL_XFORM_DQ2 */
			0x00040000, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x000000d0, /* MC_PTSA_GRANT_DECREMENT */
			0x00230023, /* MC_LATENCY_ALLOWANCE_G2_0 */
			0x00230027, /* MC_LATENCY_ALLOWANCE_G2_1 */
			0x002b002f, /* MC_LATENCY_ALLOWANCE_NV_0 */
			0x0000002f, /* MC_LATENCY_ALLOWANCE_NV2_0 */
			0x002f002f, /* MC_LATENCY_ALLOWANCE_NV_2 */
			0x003e002f, /* MC_LATENCY_ALLOWANCE_NV_1 */
			0x0000003e, /* MC_LATENCY_ALLOWANCE_NV2_1 */
			0x003e003e, /* MC_LATENCY_ALLOWANCE_NV3 */
			0x00ff00c8, /* MC_LATENCY_ALLOWANCE_EPP_0 */
			0x00ff00ff, /* MC_LATENCY_ALLOWANCE_EPP_1 */
		},
		0x00000017, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0xf320000e, /* EMC_CFG */
		0x00000000, /* Mode Register 0 */
		0x80010083, /* Mode Register 1 */
		0x80020004, /* Mode Register 2 */
		0x800b0000, /* Mode Register 4 */
	},
	{
		0x40,       /* Rev 4.0 */
		504000,     /* SDRAM frequency */
		1100,       /* min voltage */
		"pll_m",    /* clock source id */
		0x80000000, /* CLK_SOURCE_EMC */
		99,         /* number of burst_regs */
		30,         /* number of trim_regs (each channel) */
		11,         /* number of up_down_regs */
		{
			0x0000001e, /* EMC_RC */
			0x00000041, /* EMC_RFC */
			0x00000000, /* EMC_RFC_SLR */
			0x00000015, /* EMC_RAS */
			0x00000009, /* EMC_RP */
			0x0000000b, /* EMC_R2W */
			0x00000009, /* EMC_W2R */
			0x00000003, /* EMC_R2P */
			0x0000000d, /* EMC_W2P */
			0x00000009, /* EMC_RD_RCD */
			0x00000009, /* EMC_WR_RCD */
			0x00000005, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x00000003, /* EMC_WDV_MASK */
			0x00000008, /* EMC_IBDLY */
			0x00010000, /* EMC_PUTERM_EXTRA */
			0x00000000, /* EMC_CDB_CNTL_2 */
			0x00000005, /* EMC_QRST */
			0x00000012, /* EMC_RDV_MASK */
			0x00000775, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000001dd, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000003, /* EMC_PDEX2WR */
			0x00000003, /* EMC_PDEX2RD */
			0x00000009, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x00000011, /* EMC_RW2PDEN */
			0x00000047, /* EMC_TXSR */
			0x00000047, /* EMC_TXSRDLL */
			0x00000008, /* EMC_TCKE */
			0x00000008, /* EMC_TCKESR */
			0x00000008, /* EMC_TPD */
			0x0000001a, /* EMC_TFAW */
			0x0000000b, /* EMC_TRPAB */
			0x00000001, /* EMC_TCLKSTABLE */
			0x00000003, /* EMC_TCLKSTOP */
			0x00000836, /* EMC_TREFBW */
			0x00000007, /* EMC_QUSE_EXTRA */
			0x00000020, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x0001aa86, /* EMC_FBIO_CFG5 */
			0xf0140099, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x0000000a, /* EMC_DLL_XFORM_DQS4 */
			0x0000000a, /* EMC_DLL_XFORM_DQS5 */
			0x0000000a, /* EMC_DLL_XFORM_DQS6 */
			0x0000000a, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00010220, /* EMC_XM2CMDPADCTRL */
			0x00000000, /* EMC_XM2CMDPADCTRL4 */
			0x0003023d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x81f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL2 */
			0x0000003f, /* EMC_DSR_VTTGEN_DRV */
			0x00000000, /* EMC_TXDSRVTTGEN */
			0x02000100, /* EMC_FBIO_SPARE */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x000000b6, /* EMC_ZCAL_WAIT_CNT */
			0x00110011, /* EMC_MRS_WAIT_CNT */
			0x00110011, /* EMC_MRS_WAIT_CNT2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG2 */
			0x00000000, /* EMC_AUTO_CAL_CONFIG3 */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x80001004, /* EMC_DYN_SELF_REF_CONTROL */
			0x09257359, /* EMC_CA_TRAINING_TIMING_CNTL1 */
			0x00000017, /* EMC_CA_TRAINING_TIMING_CNTL2 */
			0x09000007, /* MC_EMEM_ARB_CFG */
			0x80000190, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000003, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000004, /* MC_EMEM_ARB_TIMING_RP */
			0x0000000f, /* MC_EMEM_ARB_TIMING_RC */
			0x00000009, /* MC_EMEM_ARB_TIMING_RAS */
			0x0000000c, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000002, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000009, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000001, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000007, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000006, /* MC_EMEM_ARB_TIMING_W2R */
			0x06070103, /* MC_EMEM_ARB_DA_TURNS */
			0x00120b0f, /* MC_EMEM_ARB_DA_COVERS */
			0x71c81710, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x0000000b, /* EMC_QUSE */
			0x00000006, /* EMC_EINPUT */
			0x00000007, /* EMC_EINPUT_DURATION */
			0x0000000a, /* EMC_DLL_XFORM_DQS0 */
			0x0000000f, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000012, /* EMC_RDV */
			0x007df7df, /* EMC_XM2DQSPADCTRL4 */
			0x20820800, /* EMC_XM2DQSPADCTRL3 */
			0x0000000a, /* EMC_DLL_XFORM_DQ0 */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x0000000a, /* EMC_DLL_XFORM_DQS1 */
			0x0000000a, /* EMC_DLL_XFORM_DQS2 */
			0x0000000a, /* EMC_DLL_XFORM_DQS3 */
			0x0000000a, /* EMC_DLL_XFORM_DQ1 */
			0x0000000a, /* EMC_DLL_XFORM_DQ2 */
			0x0000000a, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x00000000, /* EMC_CDB_CNTL_1 */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x0000000b, /* EMC_QUSE */
			0x00000006, /* EMC_EINPUT */
			0x00000007, /* EMC_EINPUT_DURATION */
			0x0000000a, /* EMC_DLL_XFORM_DQS0 */
			0x0000000f, /* EMC_QSAFE */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000012, /* EMC_RDV */
			0x007df7df, /* EMC_XM2DQSPADCTRL4 */
			0x20820800, /* EMC_XM2DQSPADCTRL3 */
			0x0000000a, /* EMC_DLL_XFORM_DQ0 */
			0xa8f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_DLL_XFORM_ADDR0 */
			0x00000000, /* EMC_XM2CLKPADCTRL2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLL_XFORM_ADDR1 */
			0x00000000, /* EMC_DLL_XFORM_ADDR2 */
			0x0000000a, /* EMC_DLL_XFORM_DQS1 */
			0x0000000a, /* EMC_DLL_XFORM_DQS2 */
			0x0000000a, /* EMC_DLL_XFORM_DQS3 */
			0x0000000a, /* EMC_DLL_XFORM_DQ1 */
			0x0000000a, /* EMC_DLL_XFORM_DQ2 */
			0x0000000a, /* EMC_DLL_XFORM_DQ3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
		},
		{
			0x00000102, /* MC_PTSA_GRANT_DECREMENT */
			0x000e000e, /* MC_LATENCY_ALLOWANCE_G2_0 */
			0x000e000f, /* MC_LATENCY_ALLOWANCE_G2_1 */
			0x00110013, /* MC_LATENCY_ALLOWANCE_NV_0 */
			0x00000013, /* MC_LATENCY_ALLOWANCE_NV2_0 */
			0x00130013, /* MC_LATENCY_ALLOWANCE_NV_2 */
			0x00190013, /* MC_LATENCY_ALLOWANCE_NV_1 */
			0x00000019, /* MC_LATENCY_ALLOWANCE_NV2_1 */
			0x00190019, /* MC_LATENCY_ALLOWANCE_NV3 */
			0x00ab0050, /* MC_LATENCY_ALLOWANCE_EPP_0 */
			0x00ab00ab, /* MC_LATENCY_ALLOWANCE_EPP_1 */
		},
		0x00000032, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0xf3200006, /* EMC_CFG */
		0x00000000, /* Mode Register 0 */
		0x800100c3, /* Mode Register 1 */
		0x80020006, /* Mode Register 2 */
		0x800b0000, /* Mode Register 4 */
	},
};

static struct tegra11_emc_pdata e1580_no_dram_pdata = {
	.description = "e1580_h9ccnnn8ktmlbr_ntm",
	.tables = e1580_h9ccnnn8ktmlbr_ntm_table,
	.num_tables = ARRAY_SIZE(e1580_h9ccnnn8ktmlbr_ntm_table),
};

static struct tegra11_emc_pdata e1580_A01P_AP40_pdata = {
	.description = "e1580_h9ccnnn8ktmlbr_ntm_AP40",
	.tables = e1580_h9ccnnn8ktmlbr_ntm_AP40_table,
	.num_tables = ARRAY_SIZE(e1580_h9ccnnn8ktmlbr_ntm_AP40_table),
};

static struct tegra11_emc_pdata e1580_A01P_AP40_2gb_pdata = {
	.description = "e1580_h9ccnnn8ktmlbr_ntm_AP40_2gb",

	.tables = e1580_fa164a1ma_gd_f_table,
	.num_tables = ARRAY_SIZE(e1580_fa164a1ma_gd_f_table),
};

static struct tegra11_emc_pdata *pluto_get_emc_data(void)
{
	struct board_info board_info;
	unsigned long mem;

	tegra_get_board_info(&board_info);

	/* Load AP40 Table */
	if (board_info.board_id == BOARD_E1580 &&
		(tegra_sku_id == 0x6 || tegra_sku_id == 0x8)) {
		/* Get the memory size */
		mem = memblock_phys_mem_size();
		if (mem > SZ_1G)
			/* Table for 2 GB memory */
			return &e1580_A01P_AP40_2gb_pdata;
		else
			return &e1580_A01P_AP40_pdata;
	}

	/* Default Pluto Table */
	if (board_info.board_id == BOARD_E1580 ||
	    board_info.board_id == BOARD_E1575 ||
	    board_info.board_id == BOARD_E1577)
		return &e1580_no_dram_pdata;

	return NULL;
}

int __init pluto_emc_init(void)
{
	tegra_emc_device.dev.platform_data = pluto_get_emc_data();
	platform_device_register(&tegra_emc_device);
	tegra11_emc_init();
	return 0;
}
