/*
 * arch/arm/mach-tegra/board-m2601-pinmux.c
 *
 * Copyright (c) 2012, NVIDIA CORPORATION.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <linux/kernel.h>
#include <linux/init.h>
#include <mach/pinmux.h>
#include <mach/pinmux-tegra30.h>
#include <mach/gpio-tegra.h>
#include "board.h"
#include "board-m2601.h"
#include "gpio-names.h"

#define DEFAULT_DRIVE(_name)					\
	{							\
		.pingroup = TEGRA_DRIVE_PINGROUP_##_name,	\
		.hsm = TEGRA_HSM_DISABLE,			\
		.schmitt = TEGRA_SCHMITT_ENABLE,		\
		.drive = TEGRA_DRIVE_DIV_1,			\
		.pull_down = TEGRA_PULL_31,			\
		.pull_up = TEGRA_PULL_31,			\
		.slew_rising = TEGRA_SLEW_SLOWEST,		\
		.slew_falling = TEGRA_SLEW_SLOWEST,		\
	}
/* Setting the drive strength of pins
 * hsm: Enable High speed mode (ENABLE/DISABLE)
 * Schimit: Enable/disable schimit (ENABLE/DISABLE)
 * drive: low power mode (DIV_1, DIV_2, DIV_4, DIV_8)
 * pulldn_drive - drive down (falling edge) - Driver Output Pull-Down drive
 *                strength code. Value from 0 to 31.
 * pullup_drive - drive up (rising edge)  - Driver Output Pull-Up drive
 *                strength code. Value from 0 to 31.
 * pulldn_slew -  Driver Output Pull-Up slew control code  - 2bit code
 *                code 11 is least slewing of signal. code 00 is highest
 *                slewing of the signal.
 *                Value - FASTEST, FAST, SLOW, SLOWEST
 * pullup_slew -  Driver Output Pull-Down slew control code -
 *                code 11 is least slewing of signal. code 00 is highest
 *                slewing of the signal.
 *                Value - FASTEST, FAST, SLOW, SLOWEST
 */
#define SET_DRIVE(_name, _hsm, _schmitt, _drive, _pulldn_drive, \
		_pullup_drive, _pulldn_slew, _pullup_slew) \
	{                                               \
		.pingroup = TEGRA_DRIVE_PINGROUP_##_name,   \
		.hsm = TEGRA_HSM_##_hsm,                    \
		.schmitt = TEGRA_SCHMITT_##_schmitt,        \
		.drive = TEGRA_DRIVE_##_drive,              \
		.pull_down = TEGRA_PULL_##_pulldn_drive,    \
		.pull_up = TEGRA_PULL_##_pullup_drive,		\
		.slew_rising = TEGRA_SLEW_##_pulldn_slew,   \
		.slew_falling = TEGRA_SLEW_##_pullup_slew,	\
	}

/* !!!FIXME!!!!  Update drive strength with characterized value  */
static __initdata struct tegra_drive_pingroup_config m2601_drive_pinmux[] = {
	/* ATC1 CFG */
	SET_DRIVE(AT1,	ENABLE, ENABLE, DIV_1, 0, 0, SLOWEST, SLOWEST),
	/* ATC2 CFG */
	SET_DRIVE(AT2,	ENABLE, ENABLE, DIV_1, 0, 0, SLOWEST, SLOWEST),
	/* ATC3 CFG */
	SET_DRIVE(AT3,	ENABLE, ENABLE, DIV_1, 0, 0, SLOWEST, SLOWEST),
	/* ATC4 CFG */
	SET_DRIVE(AT4,	DISABLE, DISABLE, DIV_1, 0, 0, SLOWEST, SLOWEST),

	/* All I2C pins are driven to maximum drive strength */
	/* GEN1 I2C */
	SET_DRIVE(DBG,	DISABLE, ENABLE, DIV_1, 31, 31, FASTEST, FASTEST),

	/* GEN2 I2C */
	SET_DRIVE(AT5,	DISABLE, ENABLE, DIV_1, 12, 30, FASTEST, FASTEST),

	/* DDC I2C */
	SET_DRIVE(DDC,	DISABLE, ENABLE, DIV_1, 31, 31, FASTEST, FASTEST),

	/* PWR_I2C */
	SET_DRIVE(AO1,	DISABLE, ENABLE, DIV_1, 31, 31, FASTEST, FASTEST),

	/* SDMMC4 */
	SET_DRIVE(GME,	DISABLE, ENABLE, DIV_1, 22, 18, SLOWEST, SLOWEST),
	SET_DRIVE(GMF,	DISABLE, ENABLE, DIV_1,  0,  0, SLOWEST, SLOWEST),
	SET_DRIVE(GMG,	DISABLE, ENABLE, DIV_1, 15,  6, SLOWEST, SLOWEST),
	SET_DRIVE(GMH,	DISABLE, ENABLE, DIV_1, 12,  6, SLOWEST, SLOWEST),

	/* LCD */
	SET_DRIVE(LCD1,	DISABLE, ENABLE, DIV_1, 31,  31, FASTEST, FASTEST),
	SET_DRIVE(LCD2,	DISABLE, ENABLE, DIV_1,  2,   2, FASTEST, FASTEST),

	/* DAP2 */
	SET_DRIVE(DAP2,	ENABLE, ENABLE, DIV_1, 0,  0, SLOWEST, SLOWEST),
	/* DAP4 */
	SET_DRIVE(DAP4,	ENABLE, ENABLE, DIV_1, 0,  0, SLOWEST, SLOWEST),
	/* DBG */
	SET_DRIVE(DBG,	ENABLE, ENABLE, DIV_1, 20,  0, SLOWEST, SLOWEST),
	/* SPI */
	SET_DRIVE(SPI,	ENABLE, ENABLE, DIV_1, 0,  0, SLOWEST, SLOWEST),
	/* UAA */
	SET_DRIVE(UAA,	DISABLE, DISABLE, DIV_1, 0,  0, SLOWEST, SLOWEST),
	/* UART2 */
	SET_DRIVE(UART2, ENABLE, ENABLE, DIV_1, 0,  0, SLOWEST, SLOWEST),
	/* UART3 */
	SET_DRIVE(UART3, ENABLE, ENABLE, DIV_1, 0,  0, SLOWEST, SLOWEST),
	/* GME */
	SET_DRIVE(GME,	DISABLE, ENABLE, DIV_1, 1,  4, SLOWEST, SLOWEST),
	/* GMF */
	SET_DRIVE(GMF,	DISABLE, ENABLE, DIV_1, 0,  0, SLOWEST, SLOWEST),
	/* GMG */
	SET_DRIVE(GMG,	DISABLE, ENABLE, DIV_1, 3,  0, SLOWEST, SLOWEST),
	/* GMH */
	SET_DRIVE(GMH,	DISABLE, ENABLE, DIV_1, 0,  12, SLOWEST, SLOWEST),

	/* I2S/TDM */
#ifdef CONFIG_TEGRA_MODS
	SET_DRIVE(DAP1,	ENABLE, ENABLE, DIV_1, 20,  20, SLOWEST, SLOWEST),
	SET_DRIVE(DAP3,	ENABLE, ENABLE, DIV_1, 20,  20, SLOWEST, SLOWEST),
#else
	SET_DRIVE(DAP1,	ENABLE, ENABLE, DIV_1, 3,  3, SLOWEST, SLOWEST),
	SET_DRIVE(DAP3,	ENABLE, ENABLE, DIV_1, 3,  3, SLOWEST, SLOWEST),
#endif

	/* SPI */
	SET_DRIVE(UAD,		DISABLE, ENABLE, DIV_1, 4, 1, SLOWEST, SLOWEST),
	SET_DRIVE(UAB,		DISABLE, ENABLE, DIV_1, 4, 1, SLOWEST, SLOWEST),

	/* SDMMC 3 */
	SET_DRIVE(SDIO3,	DISABLE, DISABLE, DIV_1, 46, 42, FAST, FAST),
};

#define DEFAULT_PINMUX(_pingroup, _mux, _pupd, _tri, _io)	\
	{							\
		.pingroup	= TEGRA_PINGROUP_##_pingroup,	\
		.func		= TEGRA_MUX_##_mux,		\
		.pupd		= TEGRA_PUPD_##_pupd,		\
		.tristate	= TEGRA_TRI_##_tri,		\
		.io		= TEGRA_PIN_##_io,		\
		.lock		= TEGRA_PIN_LOCK_DEFAULT,	\
		.od		= TEGRA_PIN_OD_DEFAULT,		\
		.ioreset	= TEGRA_PIN_IO_RESET_DEFAULT,	\
	}

#define I2C_PINMUX(_pingroup, _mux, _pupd, _tri, _io, _lock, _od) \
	{							\
		.pingroup	= TEGRA_PINGROUP_##_pingroup,	\
		.func		= TEGRA_MUX_##_mux,		\
		.pupd		= TEGRA_PUPD_##_pupd,		\
		.tristate	= TEGRA_TRI_##_tri,		\
		.io		= TEGRA_PIN_##_io,		\
		.lock		= TEGRA_PIN_LOCK_##_lock,	\
		.od		= TEGRA_PIN_OD_##_od,		\
		.ioreset	= TEGRA_PIN_IO_RESET_DEFAULT,	\
	}

#define VI_PINMUX(_pingroup, _mux, _pupd, _tri, _io, _lock, _ioreset) \
	{							\
		.pingroup	= TEGRA_PINGROUP_##_pingroup,	\
		.func		= TEGRA_MUX_##_mux,		\
		.pupd		= TEGRA_PUPD_##_pupd,		\
		.tristate	= TEGRA_TRI_##_tri,		\
		.io		= TEGRA_PIN_##_io,		\
		.lock		= TEGRA_PIN_LOCK_##_lock,	\
		.od		= TEGRA_PIN_OD_DEFAULT,		\
		.ioreset	= TEGRA_PIN_IO_RESET_##_ioreset	\
	}

static __initdata struct tegra_pingroup_config m2601_pinmux_common[] = {

	/* NOR pinmux */
	/* GMI Data <31 ...0> */
	DEFAULT_PINMUX(GMI_AD0,		GMI,		NORMAL,		NORMAL,		INPUT),
	DEFAULT_PINMUX(GMI_AD1,		GMI,		NORMAL,		NORMAL,		INPUT),
	DEFAULT_PINMUX(GMI_AD2,		GMI,		NORMAL,		NORMAL,		INPUT),
	DEFAULT_PINMUX(GMI_AD3,		GMI,		NORMAL,		NORMAL,		INPUT),
	DEFAULT_PINMUX(GMI_AD4,		GMI,		NORMAL,		NORMAL,		INPUT),
	DEFAULT_PINMUX(GMI_AD5,		GMI,		NORMAL,		NORMAL,		INPUT),
	DEFAULT_PINMUX(GMI_AD6,		GMI,		NORMAL,		NORMAL,		INPUT),
	DEFAULT_PINMUX(GMI_AD7,		GMI,		NORMAL,		NORMAL,		INPUT),
	DEFAULT_PINMUX(GMI_AD8,		GMI,		PULL_DOWN,	NORMAL,		INPUT),
	DEFAULT_PINMUX(GMI_AD9,		GMI,		PULL_DOWN,	NORMAL,		INPUT),
	DEFAULT_PINMUX(GMI_AD10,	GMI,		PULL_DOWN,	NORMAL,		INPUT),
	DEFAULT_PINMUX(GMI_AD11,	GMI,		PULL_DOWN,	NORMAL,		INPUT),
	DEFAULT_PINMUX(GMI_AD12,	GMI,		NORMAL,		NORMAL,		INPUT),
	DEFAULT_PINMUX(GMI_AD13,	GMI,		NORMAL,		NORMAL,		INPUT),
	DEFAULT_PINMUX(GMI_AD14,	GMI,		NORMAL,		NORMAL,		INPUT),
	DEFAULT_PINMUX(GMI_AD15,	GMI,		NORMAL,		NORMAL,		INPUT),
	DEFAULT_PINMUX(GMI_A16,		GMI,		NORMAL,		NORMAL,		INPUT),
	DEFAULT_PINMUX(GMI_A17,		GMI,		NORMAL,		NORMAL,		INPUT),
	DEFAULT_PINMUX(GMI_A18,		GMI,		NORMAL,		NORMAL,		INPUT),
	DEFAULT_PINMUX(GMI_A19,		GMI,		NORMAL,		NORMAL,		INPUT),
	DEFAULT_PINMUX(SDMMC4_DAT0,	GMI,		NORMAL,		NORMAL,		INPUT),
	DEFAULT_PINMUX(SDMMC4_DAT1,	GMI,		NORMAL,		NORMAL,		INPUT),
	DEFAULT_PINMUX(SDMMC4_DAT2,	GMI,		NORMAL,		NORMAL,		INPUT),
	DEFAULT_PINMUX(SDMMC4_DAT3,	GMI,		NORMAL,		NORMAL,		INPUT),
	DEFAULT_PINMUX(SDMMC4_DAT4,	GMI,		NORMAL,		NORMAL,		INPUT),
	DEFAULT_PINMUX(SDMMC4_DAT5,	GMI,		NORMAL,		NORMAL,		INPUT),
	DEFAULT_PINMUX(SDMMC4_DAT6,	GMI,		NORMAL,		NORMAL,		INPUT),
	DEFAULT_PINMUX(SDMMC4_DAT7,	GMI,		NORMAL,		NORMAL,		INPUT),
	DEFAULT_PINMUX(DAP1_FS,		GMI,		PULL_DOWN,	NORMAL,		INPUT),
	DEFAULT_PINMUX(DAP1_DIN,	GMI,		PULL_DOWN,	NORMAL,		INPUT),
	DEFAULT_PINMUX(DAP1_DOUT,	GMI,		PULL_DOWN,	NORMAL,		INPUT),
	DEFAULT_PINMUX(DAP1_SCLK,	GMI,		PULL_DOWN,	NORMAL,		INPUT),

	/* GMI Address <24 ...0> */
	DEFAULT_PINMUX(UART2_CTS_N,	GMI,		PULL_UP,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(UART2_RTS_N,	GMI,		PULL_UP,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(UART3_TXD,	GMI,		PULL_UP,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(UART3_RXD,	GMI,		PULL_UP,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(UART3_RTS_N,	GMI,		PULL_UP,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(UART3_CTS_N,	GMI,		PULL_UP,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(GPIO_PU0,	GMI,		NORMAL,		NORMAL,		OUTPUT),
	DEFAULT_PINMUX(GPIO_PU1,	GMI,		NORMAL,		NORMAL,		OUTPUT),
	DEFAULT_PINMUX(GPIO_PU2,	GMI,		NORMAL,		NORMAL,		OUTPUT),
	DEFAULT_PINMUX(GPIO_PU3,	GMI,		NORMAL,		NORMAL,		OUTPUT),
	DEFAULT_PINMUX(GPIO_PU4,	GMI,		NORMAL,		NORMAL,		OUTPUT),
	DEFAULT_PINMUX(GPIO_PU5,	GMI,		NORMAL,		NORMAL,		OUTPUT),
	DEFAULT_PINMUX(GPIO_PU6,	GMI,		NORMAL,		NORMAL,		OUTPUT),
	DEFAULT_PINMUX(DAP4_DIN,	GMI,		PULL_DOWN,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(DAP4_DOUT,	GMI,		PULL_DOWN,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(DAP4_FS,		GMI,		PULL_DOWN,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(DAP4_SCLK,	GMI,		PULL_DOWN,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(DAP2_DIN,	GMI,		PULL_DOWN,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(DAP2_DOUT,	GMI,		PULL_DOWN,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(DAP2_FS,		GMI,		PULL_DOWN,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(DAP2_SCLK,	GMI,		PULL_DOWN,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(SPI2_CS0_N,	GMI,		PULL_UP,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(SPI2_MISO,	GMI,		PULL_DOWN,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(SPI2_MOSI,	GMI,		PULL_DOWN,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(SPI2_SCK,	GMI,		PULL_UP,	NORMAL,		OUTPUT),

	/*GMI CS */
	DEFAULT_PINMUX(GMI_CS0_N,	GMI,		PULL_UP,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(GMI_CS1_N,	GMI,		PULL_UP,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(GMI_CS2_N,	GMI,		PULL_UP,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(GMI_CS3_N,	GMI,		PULL_UP,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(GMI_CS4_N,	GMI,		PULL_UP,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(SDMMC4_CLK,	GMI,		PULL_UP,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(GMI_CS6_N,	GMI,		PULL_UP,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(GMI_CS7_N,	GMI,		PULL_UP,	NORMAL,		OUTPUT),

	DEFAULT_PINMUX(GMI_ADV_N,	GMI,		PULL_UP,	NORMAL,		INPUT),
	DEFAULT_PINMUX(GMI_CLK,		GMI,		PULL_DOWN,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(GMI_DQS,		GMI,		NORMAL,		NORMAL,		INPUT),
	DEFAULT_PINMUX(GMI_IORDY,	GMI,		PULL_UP,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(GMI_OE_N,	GMI,		PULL_UP,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(GMI_RST_N,	GMI,		PULL_DOWN,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(GMI_WAIT,	GMI,		PULL_UP,	NORMAL,		INPUT),
	DEFAULT_PINMUX(GMI_WP_N,	GMI,		PULL_UP,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(GMI_WR_N,	GMI,		PULL_UP,	NORMAL,		OUTPUT),


	/* GPIO */
	DEFAULT_PINMUX(CLK1_OUT,	RSVD1,	PULL_DOWN,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(CLK1_REQ,	RSVD2,	NORMAL,		NORMAL,		OUTPUT),
	DEFAULT_PINMUX(SPDIF_IN,	SPDIF,	PULL_UP,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(SPDIF_OUT,	RSVD1,	PULL_UP,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(SPI1_CS0_N,	SPI1,	PULL_UP,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(SPI1_MISO,	RSVD3,	PULL_DOWN,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(SPI1_MOSI,	SPI1,	PULL_UP,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(SPI1_SCK,	SPI1,	PULL_UP,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(SPI2_CS1_N,	SPI2,	PULL_UP,	NORMAL,		INPUT),
	DEFAULT_PINMUX(GPIO_PV0,	RSVD,	NORMAL,		NORMAL,		OUTPUT),
	DEFAULT_PINMUX(GPIO_PV1,	RSVD,	NORMAL,		NORMAL,		OUTPUT),
	DEFAULT_PINMUX(ULPI_DATA2,	ULPI,	PULL_UP,	NORMAL,		INPUT),
	DEFAULT_PINMUX(ULPI_DATA3,	ULPI,	PULL_UP,	NORMAL,		INPUT),
	DEFAULT_PINMUX(GPIO_PV2,	RSVD1,	NORMAL,		NORMAL,		OUTPUT),
	DEFAULT_PINMUX(GPIO_PV3,	RSVD1,	NORMAL,		NORMAL,		OUTPUT),

	/* UART1 pinmux */
	DEFAULT_PINMUX(ULPI_DATA0,	UARTA,		PULL_UP,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(ULPI_DATA1,	UARTA,		PULL_UP,	NORMAL,		INPUT),

	/* UART2 pinmux */
	DEFAULT_PINMUX(UART2_RXD,	IRDA,		PULL_UP,	NORMAL,		INPUT),
	DEFAULT_PINMUX(UART2_TXD,	IRDA,		PULL_UP,	NORMAL,		OUTPUT),

	/* UART4 pinmux */
	DEFAULT_PINMUX(ULPI_CLK,	UARTD,		NORMAL,		NORMAL,		OUTPUT),
	DEFAULT_PINMUX(ULPI_DIR,	UARTD,		NORMAL,		NORMAL,		INPUT),

	/* UART5 pinmux */
	DEFAULT_PINMUX(SDMMC1_DAT2,	UARTE,		PULL_UP,	NORMAL,		INPUT),
	DEFAULT_PINMUX(SDMMC1_DAT3,	UARTE,		PULL_UP,	NORMAL,		OUTPUT),

	/* I2C1 pinmux */
	I2C_PINMUX(GEN1_I2C_SCL,	I2C1,		NORMAL,		NORMAL,		INPUT,	DISABLE,	ENABLE),
	I2C_PINMUX(GEN1_I2C_SDA,	I2C1,		NORMAL,		NORMAL,		INPUT,	DISABLE,	ENABLE),

	/* I2C2 pinmux */
	I2C_PINMUX(GEN2_I2C_SCL,	I2C2,		NORMAL,		NORMAL,		INPUT,	DISABLE,	ENABLE),
	I2C_PINMUX(GEN2_I2C_SDA,	I2C2,		NORMAL,		NORMAL,		INPUT,	DISABLE,	ENABLE),

	/* PowerI2C pinmux */
	I2C_PINMUX(PWR_I2C_SCL,		I2CPWR,		NORMAL,		NORMAL,		INPUT,	DISABLE,	ENABLE),
	I2C_PINMUX(PWR_I2C_SDA,		I2CPWR,		NORMAL,		NORMAL,		INPUT,	DISABLE,	ENABLE),

	/* SDMMC3 pinmux */
	DEFAULT_PINMUX(SDMMC3_CLK,	SDMMC3,		PULL_UP,	NORMAL,		INPUT),
	DEFAULT_PINMUX(SDMMC3_CMD,	SDMMC3,		PULL_UP,	NORMAL,		INPUT),
	DEFAULT_PINMUX(SDMMC3_DAT0,	SDMMC3,		PULL_UP,	NORMAL,		INPUT),
	DEFAULT_PINMUX(SDMMC3_DAT1,	SDMMC3,		PULL_UP,	NORMAL,		INPUT),
	DEFAULT_PINMUX(SDMMC3_DAT2,	SDMMC3,		PULL_UP,	NORMAL,		INPUT),
	DEFAULT_PINMUX(SDMMC3_DAT3,	SDMMC3,		PULL_UP,	NORMAL,		INPUT),
	DEFAULT_PINMUX(SDMMC3_DAT4,	SDMMC3,		PULL_UP,	NORMAL,		INPUT),
	DEFAULT_PINMUX(SDMMC3_DAT5,	SDMMC3,		PULL_UP,	NORMAL,		INPUT),
	DEFAULT_PINMUX(SDMMC3_DAT6,	SDMMC3,		PULL_UP,	NORMAL,		INPUT),
	DEFAULT_PINMUX(SDMMC3_DAT7,	SDMMC3,		PULL_UP,	NORMAL,		INPUT),

	/* SDMMC4 pinmux */

	DEFAULT_PINMUX(CAM_MCLK,	POPSDMMC4,	PULL_UP,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(GPIO_PCC1,	POPSDMMC4,	PULL_UP,	NORMAL,		INPUT),
	DEFAULT_PINMUX(GPIO_PBB0,	POPSDMMC4,	NORMAL,		NORMAL,		INPUT),
	DEFAULT_PINMUX(CAM_I2C_SCL,	POPSDMMC4,	NORMAL,		NORMAL,		INPUT),
	DEFAULT_PINMUX(CAM_I2C_SDA,	POPSDMMC4,	NORMAL,		NORMAL,		INPUT),
	DEFAULT_PINMUX(GPIO_PBB3,	POPSDMMC4,	NORMAL,		NORMAL,		INPUT),
	DEFAULT_PINMUX(GPIO_PBB4,	POPSDMMC4,	NORMAL,		NORMAL,		INPUT),
	DEFAULT_PINMUX(GPIO_PBB5,	POPSDMMC4,	NORMAL,		NORMAL,		INPUT),
	DEFAULT_PINMUX(GPIO_PBB6,	POPSDMMC4,	NORMAL,		NORMAL,		INPUT),
	DEFAULT_PINMUX(GPIO_PBB7,	POPSDMMC4,	NORMAL,		NORMAL,		INPUT),



	/* SPI2 pinmux */
	DEFAULT_PINMUX(ULPI_DATA4,	SPI2,		PULL_UP,	NORMAL,		INPUT),
	DEFAULT_PINMUX(ULPI_DATA5,	SPI2,		PULL_UP,	NORMAL,		INPUT),
	DEFAULT_PINMUX(ULPI_DATA6,	SPI2,		PULL_UP,	NORMAL,		INPUT),
	DEFAULT_PINMUX(ULPI_DATA7,	SPI2,		PULL_UP,	NORMAL,		INPUT),

	/* I2S 2 */
	DEFAULT_PINMUX(DAP3_FS,		I2S2,		PULL_DOWN,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(DAP3_DIN,	I2S2,		PULL_DOWN,	NORMAL,		INPUT),
	DEFAULT_PINMUX(DAP3_DOUT,	I2S2,		PULL_DOWN,	NORMAL,		OUTPUT),
	DEFAULT_PINMUX(DAP3_SCLK,	I2S2,		NORMAL,		NORMAL,		OUTPUT),

	/* PCIE  - Please review the change*/

	DEFAULT_PINMUX(PEX_L0_CLKREQ_N,	PCIE,		NORMAL,		NORMAL,	INPUT),
	DEFAULT_PINMUX(PEX_L0_PRSNT_N,	PCIE,		PULL_UP,	NORMAL,	INPUT),
	DEFAULT_PINMUX(PEX_L0_RST_N,	PCIE,		PULL_UP,	NORMAL,	OUTPUT),
	DEFAULT_PINMUX(PEX_L1_CLKREQ_N,	PCIE,		NORMAL,		NORMAL,	INPUT),
	DEFAULT_PINMUX(PEX_L1_PRSNT_N,	PCIE,		PULL_UP,	NORMAL,	INPUT),
	DEFAULT_PINMUX(PEX_L1_RST_N,	PCIE,		PULL_UP,	NORMAL,	OUTPUT),
	DEFAULT_PINMUX(PEX_L2_CLKREQ_N,	PCIE,		NORMAL,		NORMAL,	INPUT),
	DEFAULT_PINMUX(PEX_L2_PRSNT_N,	PCIE,		PULL_UP,	NORMAL,	INPUT),
	DEFAULT_PINMUX(PEX_L2_RST_N,	PCIE,		PULL_UP,	NORMAL,	OUTPUT),

	/*
	 * unused pins: tristate them all.
	 */

	/* KB Pins */
	DEFAULT_PINMUX(KB_ROW0,		KBC,		NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(KB_ROW1,		KBC,		NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(KB_ROW2,		KBC,		NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(KB_ROW3,		KBC,		NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(KB_ROW4,		KBC,		NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(KB_ROW6,		KBC,		NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(KB_ROW7,		KBC,		NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(KB_ROW8,		KBC,		NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(KB_ROW9,		KBC,		NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(KB_ROW10,	KBC,		NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(KB_ROW11,	KBC,		NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(KB_ROW12,	KBC,		NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(KB_ROW13,	KBC,		NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(KB_ROW14,	KBC,		NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(KB_ROW15,	KBC,		NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(KB_COL0,		KBC,		NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(KB_COL1,		KBC,		NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(KB_COL2,		KBC,		NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(KB_COL3,		KBC,		NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(KB_COL4,		KBC,		NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(KB_COL5,		KBC,		NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(KB_COL6,		KBC,		NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(KB_COL7,		KBC,		NORMAL,		TRISTATE,	INPUT),

	/*I2S 4*/

	DEFAULT_PINMUX(GPIO_PCC2,	I2S4,		NORMAL,		TRISTATE,	INPUT),

	VI_PINMUX(VI_D0,		VI,		NORMAL,		TRISTATE,	INPUT,		DISABLE,	DISABLE),
	VI_PINMUX(VI_D1,		VI,		NORMAL,		TRISTATE,	INPUT,		DISABLE,	DISABLE),
	VI_PINMUX(VI_D2,		VI,		NORMAL,		TRISTATE,	INPUT,		DISABLE,	DISABLE),
	VI_PINMUX(VI_D3,		VI,		NORMAL,		TRISTATE,	INPUT,		DISABLE,	DISABLE),
	VI_PINMUX(VI_D4,		VI,		NORMAL,		TRISTATE,	INPUT,		DISABLE,	DISABLE),
	VI_PINMUX(VI_D5,		VI,		NORMAL,		TRISTATE,	INPUT,		DISABLE,	DISABLE),
	VI_PINMUX(VI_D6,		VI,		NORMAL,		TRISTATE,	INPUT,		DISABLE,	DISABLE),
	VI_PINMUX(VI_D7,		VI,		NORMAL,		TRISTATE,	INPUT,		DISABLE,	DISABLE),
	VI_PINMUX(VI_D8,		VI,		NORMAL,		TRISTATE,	INPUT,		DISABLE,	DISABLE),
	VI_PINMUX(VI_D9,		VI,		NORMAL,		TRISTATE,	INPUT,		DISABLE,	DISABLE),
	VI_PINMUX(VI_D10,		VI,		NORMAL,		TRISTATE,	INPUT,		DISABLE,	DISABLE),
	VI_PINMUX(VI_D11,		VI,		NORMAL,		TRISTATE,	INPUT,		DISABLE,	DISABLE),
	VI_PINMUX(VI_PCLK,		VI,		NORMAL,		TRISTATE,	INPUT,		DISABLE,	DISABLE),
	VI_PINMUX(VI_HSYNC,		VI,		NORMAL,		TRISTATE,	INPUT,		DISABLE,	DISABLE),
	VI_PINMUX(VI_VSYNC,		VI,		NORMAL,		TRISTATE,	INPUT,		DISABLE,	DISABLE),
	VI_PINMUX(VI_MCLK,		VI,		NORMAL,		TRISTATE,	INPUT,		DISABLE,	DISABLE),

	DEFAULT_PINMUX(ULPI_NXT,	RSVD,		NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(ULPI_STP,	RSVD,		NORMAL,		TRISTATE,	INPUT),

	DEFAULT_PINMUX(CLK_32K_OUT,	RSVD1,		NORMAL,		TRISTATE,	INPUT),

	DEFAULT_PINMUX(CLK2_OUT,	RSVD1,		NORMAL,		TRISTATE,	OUTPUT),
	DEFAULT_PINMUX(CLK2_REQ,	RSVD1,		NORMAL,		TRISTATE,	OUTPUT),

	DEFAULT_PINMUX(CLK3_OUT,	EXTPERIPH3,	NORMAL,		TRISTATE,	OUTPUT),
	DEFAULT_PINMUX(CLK3_REQ,	RSVD1,		NORMAL,		TRISTATE,	OUTPUT),

	DEFAULT_PINMUX(PEX_WAKE_N,	PCIE,		NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(SDMMC1_CLK,	SDMMC1,		NORMAL,		TRISTATE,	OUTPUT),
	DEFAULT_PINMUX(SDMMC1_CMD,	SDMMC1,		NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(SDMMC1_DAT0,	SDMMC1,		NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(SDMMC1_DAT1,	SDMMC1,		NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(SDMMC4_CMD,	SDMMC4,		NORMAL,		TRISTATE,	INPUT),
/*	DEFAULT_PINMUX(SDMMC4_RST_N,	SDMMC4,		NORMAL,		TRISTATE,	INPUT), */
	DEFAULT_PINMUX(HDMI_CEC,	RSVD1,		NORMAL,		TRISTATE,	OUTPUT),

	/* DISPLAY pinmux */
	DEFAULT_PINMUX(LCD_D0,		DISPLAYA,	NORMAL,		TRISTATE,	OUTPUT),
	DEFAULT_PINMUX(LCD_D1,		DISPLAYA,	NORMAL,		TRISTATE,	OUTPUT),
	DEFAULT_PINMUX(LCD_D2,		DISPLAYA,	NORMAL,		TRISTATE,	OUTPUT),
	DEFAULT_PINMUX(LCD_D3,		DISPLAYA,	NORMAL,		TRISTATE,	OUTPUT),
	DEFAULT_PINMUX(LCD_D4,		DISPLAYA,	NORMAL,		TRISTATE,	OUTPUT),
	DEFAULT_PINMUX(LCD_D5,		DISPLAYA,	NORMAL,		TRISTATE,	OUTPUT),
	DEFAULT_PINMUX(LCD_D6,		DISPLAYA,	NORMAL,		TRISTATE,	OUTPUT),
	DEFAULT_PINMUX(LCD_D7,		DISPLAYA,	NORMAL,		TRISTATE,	OUTPUT),
	DEFAULT_PINMUX(LCD_D8,		DISPLAYA,	NORMAL,		TRISTATE,	OUTPUT),
	DEFAULT_PINMUX(LCD_D9,		DISPLAYA,	NORMAL,		TRISTATE,	OUTPUT),
	DEFAULT_PINMUX(LCD_D10,		DISPLAYA,	NORMAL,		TRISTATE,	OUTPUT),
	DEFAULT_PINMUX(LCD_D11,		DISPLAYA,	NORMAL,		TRISTATE,	OUTPUT),
	DEFAULT_PINMUX(LCD_D12,		DISPLAYA,	NORMAL,		TRISTATE,	OUTPUT),
	DEFAULT_PINMUX(LCD_D13,		DISPLAYA,	NORMAL,		TRISTATE,	OUTPUT),
	DEFAULT_PINMUX(LCD_D14,		DISPLAYA,	NORMAL,		TRISTATE,	OUTPUT),
	DEFAULT_PINMUX(LCD_D15,		DISPLAYA,	NORMAL,		TRISTATE,	OUTPUT),
	DEFAULT_PINMUX(LCD_D16,		DISPLAYA,	NORMAL,		TRISTATE,	OUTPUT),
	DEFAULT_PINMUX(LCD_D17,		DISPLAYA,	NORMAL,		TRISTATE,	OUTPUT),
	DEFAULT_PINMUX(LCD_D18,		DISPLAYA,	NORMAL,		TRISTATE,	OUTPUT),
	DEFAULT_PINMUX(LCD_D19,		DISPLAYA,	NORMAL,		TRISTATE,	OUTPUT),
	DEFAULT_PINMUX(LCD_D20,		DISPLAYA,	NORMAL,		TRISTATE,	OUTPUT),
	DEFAULT_PINMUX(LCD_D21,		DISPLAYA,	NORMAL,		TRISTATE,	OUTPUT),
	DEFAULT_PINMUX(LCD_D22,		DISPLAYA,	NORMAL,		TRISTATE,	OUTPUT),
	DEFAULT_PINMUX(LCD_D23,		DISPLAYA,	NORMAL,		TRISTATE,	OUTPUT),
	DEFAULT_PINMUX(LCD_DE,		DISPLAYA,	NORMAL,		TRISTATE,	OUTPUT),
	DEFAULT_PINMUX(LCD_HSYNC,	DISPLAYA,	NORMAL,		TRISTATE,	OUTPUT),
	DEFAULT_PINMUX(LCD_PCLK,	DISPLAYA,	NORMAL,		TRISTATE,	OUTPUT),
	DEFAULT_PINMUX(LCD_VSYNC,	DISPLAYA,	NORMAL,		TRISTATE,	OUTPUT),
	DEFAULT_PINMUX(LCD_PWR0,	DISPLAYA,	NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(LCD_PWR1,	DISPLAYA,	NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(LCD_PWR2,	DISPLAYA,	NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(LCD_M1,		DISPLAYA,	NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(LCD_WR_N,	DISPLAYA,	NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(LCD_SCK,		DISPLAYA,	NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(LCD_CS0_N,	DISPLAYA,	NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(LCD_CS1_N,	DISPLAYA,	NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(LCD_SDIN,	DISPLAYA,	NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(LCD_SDOUT,	DISPLAYA,	NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(LCD_DC0,		DISPLAYA,	NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(LCD_DC1,		DISPLAYA,	NORMAL,		TRISTATE,	OUTPUT),
	DEFAULT_PINMUX(CRT_VSYNC,	CRT,		NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(CRT_HSYNC,	CRT,		NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(HDMI_INT,	RSVD,		NORMAL,		TRISTATE,	OUTPUT),
	DEFAULT_PINMUX(DDC_SCL,		RSVD1,		NORMAL,		TRISTATE,	INPUT),
	DEFAULT_PINMUX(DDC_SDA,		RSVD1,		NORMAL,		TRISTATE,	INPUT),


};

int __init m2601_pinmux_init(void)
{
	tegra_pinmux_config_table(m2601_pinmux_common,
					ARRAY_SIZE(m2601_pinmux_common));
	tegra_drive_pinmux_config_table(m2601_drive_pinmux,
			ARRAY_SIZE(m2601_drive_pinmux));
	return 0;
}
#define GPIO_INIT_PIN_MODE(_gpio, _is_input, _value) \
	{						\
		.gpio_nr        = _gpio,        \
		.is_input       = _is_input,    \
		.value          = _value,       \
	}

static struct gpio_init_pin_info m2601_gpios[] = {
	GPIO_INIT_PIN_MODE(TEGRA_GPIO_PW4,	false, 1),
	GPIO_INIT_PIN_MODE(TEGRA_GPIO_PEE2,	false, 0),
	GPIO_INIT_PIN_MODE(TEGRA_GPIO_PK6,	false, 1),
	GPIO_INIT_PIN_MODE(TEGRA_GPIO_PK5,	false, 1),
	GPIO_INIT_PIN_MODE(TEGRA_GPIO_PX6,	false, 1),
	GPIO_INIT_PIN_MODE(TEGRA_GPIO_PX7,	false, 1),
	GPIO_INIT_PIN_MODE(TEGRA_GPIO_PX4,	false, 1),
	GPIO_INIT_PIN_MODE(TEGRA_GPIO_PX5,	false, 1),
	GPIO_INIT_PIN_MODE(TEGRA_GPIO_PW2,	true,  0),
	GPIO_INIT_PIN_MODE(TEGRA_GPIO_PV0,	false, 1),
	GPIO_INIT_PIN_MODE(TEGRA_GPIO_PV1,	false, 1),
	GPIO_INIT_PIN_MODE(TEGRA_GPIO_PO3,	false, 1),
	GPIO_INIT_PIN_MODE(TEGRA_GPIO_PO4,	true,  0),
	GPIO_INIT_PIN_MODE(TEGRA_GPIO_PV2,	false, 1),
	GPIO_INIT_PIN_MODE(TEGRA_GPIO_PV3,	false, 1),
};
int __init m2601_gpio_init(void)
{
	int i, pin_count = 0;
	struct gpio_init_pin_info *gpios_info = NULL;
	gpios_info = m2601_gpios;
	pin_count = ARRAY_SIZE(m2601_gpios);

	for (i = 0; i < pin_count; i++) {
		tegra_gpio_init_configure(gpios_info->gpio_nr,
		gpios_info->is_input, gpios_info->value);
		gpios_info++;
	}
	return 0;
}
