/*
 * Copyright (C) 2011 NVIDIA, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307, USA
 */

#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/platform_data/tegra_emc.h>

#include "board-enterprise.h"
#include "tegra3_emc.h"
#include "board.h"
#include "devices.h"

static const struct tegra30_emc_table enterprise_emc_tables_kmmll0_a02[] = {
	{
		0x32,       /* Rev 3.2 */
		12750,      /* SDRAM frequency */
		{
			0x00000000, /* EMC_RC */
			0x00000001, /* EMC_RFC */
			0x00000002, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x00000004, /* EMC_W2R */
			0x00000001, /* EMC_R2P */
			0x00000005, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000001, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000001, /* EMC_WDV */
			0x00000003, /* EMC_QUSE */
			0x00000001, /* EMC_QRST */
			0x00000009, /* EMC_QSAFE */
			0x0000000a, /* EMC_RDV */
			0x0000002f, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x0000000b, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000001, /* EMC_PDEX2WR */
			0x00000001, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x00000007, /* EMC_RW2PDEN */
			0x00000002, /* EMC_TXSR */
			0x00000002, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000008, /* EMC_TFAW */
			0x00000004, /* EMC_TRPAB */
			0x00000001, /* EMC_TCLKSTABLE */
			0x00000002, /* EMC_TCLKSTOP */
			0x00000036, /* EMC_TREFBW */
			0x00000004, /* EMC_QUSE_EXTRA */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00004282, /* EMC_FBIO_CFG5 */
			0x007800a4, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x000fc000, /* EMC_DLL_XFORM_DQS0 */
			0x000fc000, /* EMC_DLL_XFORM_DQS1 */
			0x000fc000, /* EMC_DLL_XFORM_DQS2 */
			0x000fc000, /* EMC_DLL_XFORM_DQS3 */
			0x000fc000, /* EMC_DLL_XFORM_DQS4 */
			0x000fc000, /* EMC_DLL_XFORM_DQS5 */
			0x000fc000, /* EMC_DLL_XFORM_DQS6 */
			0x000fc000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x000fc000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x00100220, /* EMC_XM2CMDPADCTRL */
			0x0800201c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x01f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x00000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x08000068, /* EMC_XM2QUSEPADCTRL */
			0x08000000, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x00000009, /* EMC_ZCAL_WAIT_CNT */
			0x00090009, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x80000164, /* EMC_DYN_SELF_REF_CONTROL */
			0x00050002, /* MC_EMEM_ARB_CFG */
			0xc0000008, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000004, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000001, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000000, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2R */
			0x02020001, /* MC_EMEM_ARB_DA_TURNS */
			0x00060402, /* MC_EMEM_ARB_DA_COVERS */
			0x77230303, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x50000000, /* EMC_FBIO_SPARE */
			0xff00ff00, /* EMC_CFG_RSV */
		},
		0x00000009, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x00000000, /* Mode Register 0 */
		0x00010022, /* Mode Register 1 */
		0x00020001, /* Mode Register 2 */
		0x00000001, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		25500,      /* SDRAM frequency */
		{
			0x00000001, /* EMC_RC */
			0x00000003, /* EMC_RFC */
			0x00000002, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x00000004, /* EMC_W2R */
			0x00000001, /* EMC_R2P */
			0x00000005, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000001, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000001, /* EMC_WDV */
			0x00000003, /* EMC_QUSE */
			0x00000001, /* EMC_QRST */
			0x00000009, /* EMC_QSAFE */
			0x0000000a, /* EMC_RDV */
			0x0000005e, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000017, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000001, /* EMC_PDEX2WR */
			0x00000001, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x00000007, /* EMC_RW2PDEN */
			0x00000004, /* EMC_TXSR */
			0x00000004, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000008, /* EMC_TFAW */
			0x00000004, /* EMC_TRPAB */
			0x00000004, /* EMC_TCLKSTABLE */
			0x00000002, /* EMC_TCLKSTOP */
			0x00000068, /* EMC_TREFBW */
			0x00000004, /* EMC_QUSE_EXTRA */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00004282, /* EMC_FBIO_CFG5 */
			0x007800a4, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00090000, /* EMC_DLL_XFORM_DQS0 */
			0x00090000, /* EMC_DLL_XFORM_DQS1 */
			0x00090000, /* EMC_DLL_XFORM_DQS2 */
			0x00090000, /* EMC_DLL_XFORM_DQS3 */
			0x00000010, /* EMC_DLL_XFORM_DQS4 */
			0x00000010, /* EMC_DLL_XFORM_DQS5 */
			0x00000010, /* EMC_DLL_XFORM_DQS6 */
			0x00000010, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000008, /* EMC_DLL_XFORM_QUSE4 */
			0x00000008, /* EMC_DLL_XFORM_QUSE5 */
			0x00000008, /* EMC_DLL_XFORM_QUSE6 */
			0x00000008, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00088000, /* EMC_DLL_XFORM_DQ0 */
			0x00088000, /* EMC_DLL_XFORM_DQ1 */
			0x00088000, /* EMC_DLL_XFORM_DQ2 */
			0x00088000, /* EMC_DLL_XFORM_DQ3 */
			0x00100220, /* EMC_XM2CMDPADCTRL */
			0x0800201c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x01f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x00000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x08000068, /* EMC_XM2QUSEPADCTRL */
			0x08000000, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x0000000a, /* EMC_ZCAL_WAIT_CNT */
			0x00090009, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x800001c2, /* EMC_DYN_SELF_REF_CONTROL */
			0x00030003, /* MC_EMEM_ARB_CFG */
			0xc0000008, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000004, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000001, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000000, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2R */
			0x02020001, /* MC_EMEM_ARB_DA_TURNS */
			0x00060402, /* MC_EMEM_ARB_DA_COVERS */
			0x74030303, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x50000000, /* EMC_FBIO_SPARE */
			0xff00ff00, /* EMC_CFG_RSV */
		},
		0x00000009, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x00000000, /* Mode Register 0 */
		0x00010022, /* Mode Register 1 */
		0x00020001, /* Mode Register 2 */
		0x00000001, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		51000,      /* SDRAM frequency */
		{
			0x00000003, /* EMC_RC */
			0x00000006, /* EMC_RFC */
			0x00000002, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x00000004, /* EMC_W2R */
			0x00000001, /* EMC_R2P */
			0x00000005, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000001, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000001, /* EMC_WDV */
			0x00000003, /* EMC_QUSE */
			0x00000001, /* EMC_QRST */
			0x00000009, /* EMC_QSAFE */
			0x0000000a, /* EMC_RDV */
			0x000000c0, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000030, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000001, /* EMC_PDEX2WR */
			0x00000001, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x00000007, /* EMC_RW2PDEN */
			0x00000008, /* EMC_TXSR */
			0x00000008, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000008, /* EMC_TFAW */
			0x00000004, /* EMC_TRPAB */
			0x00000004, /* EMC_TCLKSTABLE */
			0x00000002, /* EMC_TCLKSTOP */
			0x000000d5, /* EMC_TREFBW */
			0x00000004, /* EMC_QUSE_EXTRA */
			0x00000004, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00004282, /* EMC_FBIO_CFG5 */
			0x007800a4, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00090000, /* EMC_DLL_XFORM_DQS0 */
			0x00090000, /* EMC_DLL_XFORM_DQS1 */
			0x00090000, /* EMC_DLL_XFORM_DQS2 */
			0x00090000, /* EMC_DLL_XFORM_DQS3 */
			0x00000010, /* EMC_DLL_XFORM_DQS4 */
			0x00000010, /* EMC_DLL_XFORM_DQS5 */
			0x00000010, /* EMC_DLL_XFORM_DQS6 */
			0x00000010, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000018, /* EMC_DLL_XFORM_QUSE4 */
			0x00000018, /* EMC_DLL_XFORM_QUSE5 */
			0x00000018, /* EMC_DLL_XFORM_QUSE6 */
			0x00000018, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00088000, /* EMC_DLL_XFORM_DQ0 */
			0x00088000, /* EMC_DLL_XFORM_DQ1 */
			0x00088000, /* EMC_DLL_XFORM_DQ2 */
			0x00088000, /* EMC_DLL_XFORM_DQ3 */
			0x00100220, /* EMC_XM2CMDPADCTRL */
			0x0800201c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x01f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x00000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x08000068, /* EMC_XM2QUSEPADCTRL */
			0x08000000, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x00000013, /* EMC_ZCAL_WAIT_CNT */
			0x00090009, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x80000287, /* EMC_DYN_SELF_REF_CONTROL */
			0x00010003, /* MC_EMEM_ARB_CFG */
			0xc000000a, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000004, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000001, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000000, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2R */
			0x02020001, /* MC_EMEM_ARB_DA_TURNS */
			0x00060402, /* MC_EMEM_ARB_DA_COVERS */
			0x72c30303, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x50000000, /* EMC_FBIO_SPARE */
			0xff00ff00, /* EMC_CFG_RSV */
		},
		0x00000009, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x00000000, /* Mode Register 0 */
		0x00010022, /* Mode Register 1 */
		0x00020001, /* Mode Register 2 */
		0x00000001, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		102000,     /* SDRAM frequency */
		{
			0x00000006, /* EMC_RC */
			0x0000000d, /* EMC_RFC */
			0x00000004, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x00000004, /* EMC_W2R */
			0x00000001, /* EMC_R2P */
			0x00000005, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000001, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000001, /* EMC_WDV */
			0x00000003, /* EMC_QUSE */
			0x00000001, /* EMC_QRST */
			0x00000009, /* EMC_QSAFE */
			0x0000000a, /* EMC_RDV */
			0x00000181, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000060, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000001, /* EMC_PDEX2WR */
			0x00000001, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x00000007, /* EMC_RW2PDEN */
			0x0000000f, /* EMC_TXSR */
			0x0000000f, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000008, /* EMC_TFAW */
			0x00000004, /* EMC_TRPAB */
			0x00000004, /* EMC_TCLKSTABLE */
			0x00000002, /* EMC_TCLKSTOP */
			0x000001a9, /* EMC_TREFBW */
			0x00000004, /* EMC_QUSE_EXTRA */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00004282, /* EMC_FBIO_CFG5 */
			0x007800a4, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00090000, /* EMC_DLL_XFORM_DQS0 */
			0x00090000, /* EMC_DLL_XFORM_DQS1 */
			0x00090000, /* EMC_DLL_XFORM_DQS2 */
			0x00090000, /* EMC_DLL_XFORM_DQS3 */
			0x00000010, /* EMC_DLL_XFORM_DQS4 */
			0x00000010, /* EMC_DLL_XFORM_DQS5 */
			0x00000010, /* EMC_DLL_XFORM_DQS6 */
			0x00000010, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000008, /* EMC_DLL_XFORM_QUSE4 */
			0x00000008, /* EMC_DLL_XFORM_QUSE5 */
			0x00000008, /* EMC_DLL_XFORM_QUSE6 */
			0x00000008, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00088000, /* EMC_DLL_XFORM_DQ0 */
			0x00088000, /* EMC_DLL_XFORM_DQ1 */
			0x00088000, /* EMC_DLL_XFORM_DQ2 */
			0x00088000, /* EMC_DLL_XFORM_DQ3 */
			0x00100220, /* EMC_XM2CMDPADCTRL */
			0x0800201c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x01f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x00000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x08000068, /* EMC_XM2QUSEPADCTRL */
			0x08000000, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x00000025, /* EMC_ZCAL_WAIT_CNT */
			0x00090009, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x8000040b, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000003, /* MC_EMEM_ARB_CFG */
			0xc0000013, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000003, /* MC_EMEM_ARB_TIMING_RC */
			0x00000001, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000004, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000001, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000000, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2R */
			0x02020001, /* MC_EMEM_ARB_DA_TURNS */
			0x00060403, /* MC_EMEM_ARB_DA_COVERS */
			0x72430504, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x50000000, /* EMC_FBIO_SPARE */
			0xff00ff00, /* EMC_CFG_RSV */
		},
		0x0000000a, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x00000000, /* Mode Register 0 */
		0x00010022, /* Mode Register 1 */
		0x00020001, /* Mode Register 2 */
		0x00000001, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		204000,     /* SDRAM frequency */
		{
			0x0000000c, /* EMC_RC */
			0x0000001a, /* EMC_RFC */
			0x00000008, /* EMC_RAS */
			0x00000003, /* EMC_RP */
			0x00000005, /* EMC_R2W */
			0x00000004, /* EMC_W2R */
			0x00000001, /* EMC_R2P */
			0x00000006, /* EMC_W2P */
			0x00000003, /* EMC_RD_RCD */
			0x00000003, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000001, /* EMC_WDV */
			0x00000003, /* EMC_QUSE */
			0x00000001, /* EMC_QRST */
			0x0000000b, /* EMC_QSAFE */
			0x0000000a, /* EMC_RDV */
			0x00000303, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000000c0, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000001, /* EMC_PDEX2WR */
			0x00000001, /* EMC_PDEX2RD */
			0x00000003, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x00000007, /* EMC_RW2PDEN */
			0x0000001d, /* EMC_TXSR */
			0x0000001d, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x0000000b, /* EMC_TFAW */
			0x00000005, /* EMC_TRPAB */
			0x00000004, /* EMC_TCLKSTABLE */
			0x00000002, /* EMC_TCLKSTOP */
			0x00000351, /* EMC_TREFBW */
			0x00000004, /* EMC_QUSE_EXTRA */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00004282, /* EMC_FBIO_CFG5 */
			0x004400a4, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x0007c000, /* EMC_DLL_XFORM_DQS0 */
			0x0007c000, /* EMC_DLL_XFORM_DQS1 */
			0x0007c000, /* EMC_DLL_XFORM_DQS2 */
			0x0007c000, /* EMC_DLL_XFORM_DQS3 */
			0x00000010, /* EMC_DLL_XFORM_DQS4 */
			0x00000010, /* EMC_DLL_XFORM_DQS5 */
			0x00000010, /* EMC_DLL_XFORM_DQS6 */
			0x00000010, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000018, /* EMC_DLL_XFORM_QUSE4 */
			0x00000018, /* EMC_DLL_XFORM_QUSE5 */
			0x00000018, /* EMC_DLL_XFORM_QUSE6 */
			0x00000018, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00088000, /* EMC_DLL_XFORM_DQ0 */
			0x00088000, /* EMC_DLL_XFORM_DQ1 */
			0x00088000, /* EMC_DLL_XFORM_DQ2 */
			0x00088000, /* EMC_DLL_XFORM_DQ3 */
			0x000f0220, /* EMC_XM2CMDPADCTRL */
			0x0800201c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x01f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x00000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x08000068, /* EMC_XM2QUSEPADCTRL */
			0x08000000, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x0000004a, /* EMC_ZCAL_WAIT_CNT */
			0x00090009, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x80000713, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000006, /* MC_EMEM_ARB_CFG */
			0xc0000025, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000006, /* MC_EMEM_ARB_TIMING_RC */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000005, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000004, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000001, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000000, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2R */
			0x02030001, /* MC_EMEM_ARB_DA_TURNS */
			0x00070506, /* MC_EMEM_ARB_DA_COVERS */
			0x71e40a07, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x50000000, /* EMC_FBIO_SPARE */
			0xff00ff00, /* EMC_CFG_RSV */
		},
		0x00000013, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x00000000, /* Mode Register 0 */
		0x00010042, /* Mode Register 1 */
		0x00020001, /* Mode Register 2 */
		0x00000001, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		400000,     /* SDRAM frequency */
		{
			0x00000017, /* EMC_RC */
			0x00000033, /* EMC_RFC */
			0x00000010, /* EMC_RAS */
			0x00000007, /* EMC_RP */
			0x00000007, /* EMC_R2W */
			0x00000007, /* EMC_W2R */
			0x00000002, /* EMC_R2P */
			0x0000000a, /* EMC_W2P */
			0x00000007, /* EMC_RD_RCD */
			0x00000007, /* EMC_WR_RCD */
			0x00000003, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000003, /* EMC_WDV */
			0x00000007, /* EMC_QUSE */
			0x00000004, /* EMC_QRST */
			0x0000000b, /* EMC_QSAFE */
			0x0000000e, /* EMC_RDV */
			0x000005e9, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x0000017a, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000002, /* EMC_PDEX2WR */
			0x00000002, /* EMC_PDEX2RD */
			0x00000007, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000000c, /* EMC_RW2PDEN */
			0x00000038, /* EMC_TXSR */
			0x00000038, /* EMC_TXSRDLL */
			0x00000006, /* EMC_TCKE */
			0x00000014, /* EMC_TFAW */
			0x00000009, /* EMC_TRPAB */
			0x00000004, /* EMC_TCLKSTABLE */
			0x00000002, /* EMC_TCLKSTOP */
			0x00000680, /* EMC_TREFBW */
			0x00000000, /* EMC_QUSE_EXTRA */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00006282, /* EMC_FBIO_CFG5 */
			0x001d0084, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00024000, /* EMC_DLL_XFORM_DQS0 */
			0x00024000, /* EMC_DLL_XFORM_DQS1 */
			0x00024000, /* EMC_DLL_XFORM_DQS2 */
			0x00024000, /* EMC_DLL_XFORM_DQS3 */
			0x00000010, /* EMC_DLL_XFORM_DQS4 */
			0x00000010, /* EMC_DLL_XFORM_DQS5 */
			0x00000010, /* EMC_DLL_XFORM_DQS6 */
			0x00000010, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000008, /* EMC_DLL_XFORM_QUSE4 */
			0x00000008, /* EMC_DLL_XFORM_QUSE5 */
			0x00000008, /* EMC_DLL_XFORM_QUSE6 */
			0x00000008, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00048000, /* EMC_DLL_XFORM_DQ0 */
			0x00048000, /* EMC_DLL_XFORM_DQ1 */
			0x00048000, /* EMC_DLL_XFORM_DQ2 */
			0x00048000, /* EMC_DLL_XFORM_DQ3 */
			0x00060220, /* EMC_XM2CMDPADCTRL */
			0x0800003d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x01f1f408, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x00000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x08000068, /* EMC_XM2QUSEPADCTRL */
			0x08000000, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x00000090, /* EMC_ZCAL_WAIT_CNT */
			0x000c000c, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x80000ce6, /* EMC_DYN_SELF_REF_CONTROL */
			0x0000000c, /* MC_EMEM_ARB_CFG */
			0xc0000048, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000002, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RP */
			0x0000000c, /* MC_EMEM_ARB_TIMING_RC */
			0x00000007, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000009, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000006, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000001, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000000, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_W2R */
			0x04040001, /* MC_EMEM_ARB_DA_TURNS */
			0x000d090c, /* MC_EMEM_ARB_DA_COVERS */
			0x71c6120d, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0x10000000, /* EMC_FBIO_SPARE */
			0xff00ff00, /* EMC_CFG_RSV */
		},
		0x00000024, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x00000000, /* Mode Register 0 */
		0x00010082, /* Mode Register 1 */
		0x00020004, /* Mode Register 2 */
		0x00000000, /* EMC_CFG.DYN_SELF_REF */
	},
};

static const struct tegra30_emc_table enterprise_emc_tables_kmkts0_a03[] = {
	{
		0x32,       /* Rev 3.2 */
		12750,      /* SDRAM frequency */
		{
			0x00000000, /* EMC_RC */
			0x00000001, /* EMC_RFC */
			0x00000002, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x00000004, /* EMC_W2R */
			0x00000001, /* EMC_R2P */
			0x00000005, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000001, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000001, /* EMC_WDV */
			0x00000003, /* EMC_QUSE */
			0x00000001, /* EMC_QRST */
			0x0000000b, /* EMC_QSAFE */
			0x0000000a, /* EMC_RDV */
			0x0000002f, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x0000000b, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000001, /* EMC_PDEX2WR */
			0x00000001, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x00000007, /* EMC_RW2PDEN */
			0x00000002, /* EMC_TXSR */
			0x00000002, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000008, /* EMC_TFAW */
			0x00000004, /* EMC_TRPAB */
			0x00000001, /* EMC_TCLKSTABLE */
			0x00000002, /* EMC_TCLKSTOP */
			0x00000036, /* EMC_TREFBW */
			0x00000004, /* EMC_QUSE_EXTRA */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00004282, /* EMC_FBIO_CFG5 */
			0x007800a4, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x000fc000, /* EMC_DLL_XFORM_DQS0 */
			0x000fc000, /* EMC_DLL_XFORM_DQS1 */
			0x000fc000, /* EMC_DLL_XFORM_DQS2 */
			0x000fc000, /* EMC_DLL_XFORM_DQS3 */
			0x000fc000, /* EMC_DLL_XFORM_DQS4 */
			0x000fc000, /* EMC_DLL_XFORM_DQS5 */
			0x000fc000, /* EMC_DLL_XFORM_DQS6 */
			0x000fc000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x000fc000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x00100220, /* EMC_XM2CMDPADCTRL */
			0x0800201c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x01f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x00000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x08000068, /* EMC_XM2QUSEPADCTRL */
			0x08000000, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x00000009, /* EMC_ZCAL_WAIT_CNT */
			0x00090009, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x80000164, /* EMC_DYN_SELF_REF_CONTROL */
			0x00050001, /* MC_EMEM_ARB_CFG */
			0xc0000008, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000004, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000001, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000000, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2R */
			0x02020001, /* MC_EMEM_ARB_DA_TURNS */
			0x00060402, /* MC_EMEM_ARB_DA_COVERS */
			0x77230303, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0xe0000000, /* EMC_FBIO_SPARE */
			0xff00ff00, /* EMC_CFG_RSV */
		},
		0x00000009, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x00000000, /* Mode Register 0 */
		0x00010022, /* Mode Register 1 */
		0x00020001, /* Mode Register 2 */
		0x00000001, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		25500,      /* SDRAM frequency */
		{
			0x00000001, /* EMC_RC */
			0x00000003, /* EMC_RFC */
			0x00000002, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x00000004, /* EMC_W2R */
			0x00000001, /* EMC_R2P */
			0x00000005, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000001, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000001, /* EMC_WDV */
			0x00000003, /* EMC_QUSE */
			0x00000001, /* EMC_QRST */
			0x0000000b, /* EMC_QSAFE */
			0x0000000a, /* EMC_RDV */
			0x00000060, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000018, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000001, /* EMC_PDEX2WR */
			0x00000001, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x00000007, /* EMC_RW2PDEN */
			0x00000004, /* EMC_TXSR */
			0x00000004, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000008, /* EMC_TFAW */
			0x00000004, /* EMC_TRPAB */
			0x00000001, /* EMC_TCLKSTABLE */
			0x00000002, /* EMC_TCLKSTOP */
			0x0000006b, /* EMC_TREFBW */
			0x00000004, /* EMC_QUSE_EXTRA */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00004282, /* EMC_FBIO_CFG5 */
			0x007800a4, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x000fc000, /* EMC_DLL_XFORM_DQS0 */
			0x000fc000, /* EMC_DLL_XFORM_DQS1 */
			0x000fc000, /* EMC_DLL_XFORM_DQS2 */
			0x000fc000, /* EMC_DLL_XFORM_DQS3 */
			0x000fc000, /* EMC_DLL_XFORM_DQS4 */
			0x000fc000, /* EMC_DLL_XFORM_DQS5 */
			0x000fc000, /* EMC_DLL_XFORM_DQS6 */
			0x000fc000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x000fc000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x00100220, /* EMC_XM2CMDPADCTRL */
			0x0800201c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x01f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x00000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x08000068, /* EMC_XM2QUSEPADCTRL */
			0x08000000, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x0000000a, /* EMC_ZCAL_WAIT_CNT */
			0x00090009, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x800001c5, /* EMC_DYN_SELF_REF_CONTROL */
			0x00020001, /* MC_EMEM_ARB_CFG */
			0xc0000008, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000004, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000001, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000000, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2R */
			0x02020001, /* MC_EMEM_ARB_DA_TURNS */
			0x00060402, /* MC_EMEM_ARB_DA_COVERS */
			0x73e30303, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0xe0000000, /* EMC_FBIO_SPARE */
			0xff00ff00, /* EMC_CFG_RSV */
		},
		0x00000009, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x00000000, /* Mode Register 0 */
		0x00010022, /* Mode Register 1 */
		0x00020001, /* Mode Register 2 */
		0x00000001, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		51000,      /* SDRAM frequency */
		{
			0x00000003, /* EMC_RC */
			0x00000006, /* EMC_RFC */
			0x00000002, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x00000004, /* EMC_W2R */
			0x00000001, /* EMC_R2P */
			0x00000005, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000001, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000001, /* EMC_WDV */
			0x00000003, /* EMC_QUSE */
			0x00000001, /* EMC_QRST */
			0x0000000b, /* EMC_QSAFE */
			0x0000000a, /* EMC_RDV */
			0x000000c0, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000030, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000001, /* EMC_PDEX2WR */
			0x00000001, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x00000007, /* EMC_RW2PDEN */
			0x00000008, /* EMC_TXSR */
			0x00000008, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000008, /* EMC_TFAW */
			0x00000004, /* EMC_TRPAB */
			0x00000001, /* EMC_TCLKSTABLE */
			0x00000002, /* EMC_TCLKSTOP */
			0x000000d5, /* EMC_TREFBW */
			0x00000004, /* EMC_QUSE_EXTRA */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00004282, /* EMC_FBIO_CFG5 */
			0x007800a4, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x000fc000, /* EMC_DLL_XFORM_DQS0 */
			0x000fc000, /* EMC_DLL_XFORM_DQS1 */
			0x000fc000, /* EMC_DLL_XFORM_DQS2 */
			0x000fc000, /* EMC_DLL_XFORM_DQS3 */
			0x000fc000, /* EMC_DLL_XFORM_DQS4 */
			0x000fc000, /* EMC_DLL_XFORM_DQS5 */
			0x000fc000, /* EMC_DLL_XFORM_DQS6 */
			0x000fc000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x000fc000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x00100220, /* EMC_XM2CMDPADCTRL */
			0x0800201c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x01f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x00000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x08000068, /* EMC_XM2QUSEPADCTRL */
			0x08000000, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x00000013, /* EMC_ZCAL_WAIT_CNT */
			0x00090009, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x80000287, /* EMC_DYN_SELF_REF_CONTROL */
			0x00010001, /* MC_EMEM_ARB_CFG */
			0xc000000a, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000002, /* MC_EMEM_ARB_TIMING_RC */
			0x00000000, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000004, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000001, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000000, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2R */
			0x02020001, /* MC_EMEM_ARB_DA_TURNS */
			0x00060402, /* MC_EMEM_ARB_DA_COVERS */
			0x72c30303, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0xe0000000, /* EMC_FBIO_SPARE */
			0xff00ff00, /* EMC_CFG_RSV */
		},
		0x00000009, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x00000000, /* Mode Register 0 */
		0x00010022, /* Mode Register 1 */
		0x00020001, /* Mode Register 2 */
		0x00000001, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		102000,     /* SDRAM frequency */
		{
			0x00000006, /* EMC_RC */
			0x0000000d, /* EMC_RFC */
			0x00000004, /* EMC_RAS */
			0x00000002, /* EMC_RP */
			0x00000004, /* EMC_R2W */
			0x00000004, /* EMC_W2R */
			0x00000002, /* EMC_R2P */
			0x00000005, /* EMC_W2P */
			0x00000002, /* EMC_RD_RCD */
			0x00000002, /* EMC_WR_RCD */
			0x00000001, /* EMC_RRD */
			0x00000001, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000001, /* EMC_WDV */
			0x00000003, /* EMC_QUSE */
			0x00000001, /* EMC_QRST */
			0x0000000b, /* EMC_QSAFE */
			0x0000000a, /* EMC_RDV */
			0x00000181, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x00000060, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000001, /* EMC_PDEX2WR */
			0x00000001, /* EMC_PDEX2RD */
			0x00000002, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x00000007, /* EMC_RW2PDEN */
			0x0000000f, /* EMC_TXSR */
			0x0000000f, /* EMC_TXSRDLL */
			0x00000003, /* EMC_TCKE */
			0x00000008, /* EMC_TFAW */
			0x00000004, /* EMC_TRPAB */
			0x00000001, /* EMC_TCLKSTABLE */
			0x00000002, /* EMC_TCLKSTOP */
			0x000001a9, /* EMC_TREFBW */
			0x00000004, /* EMC_QUSE_EXTRA */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00004282, /* EMC_FBIO_CFG5 */
			0x007800a4, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x000fc000, /* EMC_DLL_XFORM_DQS0 */
			0x000fc000, /* EMC_DLL_XFORM_DQS1 */
			0x000fc000, /* EMC_DLL_XFORM_DQS2 */
			0x000fc000, /* EMC_DLL_XFORM_DQS3 */
			0x000fc000, /* EMC_DLL_XFORM_DQS4 */
			0x000fc000, /* EMC_DLL_XFORM_DQS5 */
			0x000fc000, /* EMC_DLL_XFORM_DQS6 */
			0x000fc000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x000fc000, /* EMC_DLL_XFORM_DQ0 */
			0x000fc000, /* EMC_DLL_XFORM_DQ1 */
			0x000fc000, /* EMC_DLL_XFORM_DQ2 */
			0x000fc000, /* EMC_DLL_XFORM_DQ3 */
			0x00100220, /* EMC_XM2CMDPADCTRL */
			0x0800201c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x01f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x00000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x08000068, /* EMC_XM2QUSEPADCTRL */
			0x08000000, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x0000000a, /* EMC_ZCAL_WAIT_CNT */
			0x00090009, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x8000040b, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000001, /* MC_EMEM_ARB_CFG */
			0xc0000013, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000003, /* MC_EMEM_ARB_TIMING_RC */
			0x00000001, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000003, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000004, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000001, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000000, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2R */
			0x02020001, /* MC_EMEM_ARB_DA_TURNS */
			0x00060403, /* MC_EMEM_ARB_DA_COVERS */
			0x72430504, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0xe0000000, /* EMC_FBIO_SPARE */
			0xff00ff00, /* EMC_CFG_RSV */
		},
		0x0000000a, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x00000000, /* Mode Register 0 */
		0x00010022, /* Mode Register 1 */
		0x00020001, /* Mode Register 2 */
		0x00000001, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		204000,     /* SDRAM frequency */
		{
			0x0000000c, /* EMC_RC */
			0x0000001a, /* EMC_RFC */
			0x00000008, /* EMC_RAS */
			0x00000003, /* EMC_RP */
			0x00000005, /* EMC_R2W */
			0x00000004, /* EMC_W2R */
			0x00000002, /* EMC_R2P */
			0x00000006, /* EMC_W2P */
			0x00000003, /* EMC_RD_RCD */
			0x00000003, /* EMC_WR_RCD */
			0x00000002, /* EMC_RRD */
			0x00000002, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000001, /* EMC_WDV */
			0x00000003, /* EMC_QUSE */
			0x00000001, /* EMC_QRST */
			0x0000000c, /* EMC_QSAFE */
			0x0000000b, /* EMC_RDV */
			0x00000303, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000000c0, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000001, /* EMC_PDEX2WR */
			0x00000001, /* EMC_PDEX2RD */
			0x00000003, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x00000007, /* EMC_RW2PDEN */
			0x0000001d, /* EMC_TXSR */
			0x0000001d, /* EMC_TXSRDLL */
			0x00000004, /* EMC_TCKE */
			0x0000000b, /* EMC_TFAW */
			0x00000005, /* EMC_TRPAB */
			0x00000001, /* EMC_TCLKSTABLE */
			0x00000002, /* EMC_TCLKSTOP */
			0x00000351, /* EMC_TREFBW */
			0x00000004, /* EMC_QUSE_EXTRA */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00004282, /* EMC_FBIO_CFG5 */
			0x004400a4, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x0007c000, /* EMC_DLL_XFORM_DQS0 */
			0x0007c000, /* EMC_DLL_XFORM_DQS1 */
			0x0007c000, /* EMC_DLL_XFORM_DQS2 */
			0x0007c000, /* EMC_DLL_XFORM_DQS3 */
			0x00072000, /* EMC_DLL_XFORM_DQS4 */
			0x00072000, /* EMC_DLL_XFORM_DQS5 */
			0x00072000, /* EMC_DLL_XFORM_DQS6 */
			0x00072000, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x00088000, /* EMC_DLL_XFORM_DQ0 */
			0x00088000, /* EMC_DLL_XFORM_DQ1 */
			0x00088000, /* EMC_DLL_XFORM_DQ2 */
			0x00088000, /* EMC_DLL_XFORM_DQ3 */
			0x000e0220, /* EMC_XM2CMDPADCTRL */
			0x0800201c, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x01f1f008, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x00000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x08000068, /* EMC_XM2QUSEPADCTRL */
			0x08000000, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00000000, /* EMC_ZCAL_INTERVAL */
			0x00000013, /* EMC_ZCAL_WAIT_CNT */
			0x00090009, /* EMC_MRS_WAIT_CNT */
			0xa0f10000, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x80000713, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000003, /* MC_EMEM_ARB_CFG */
			0xc0000025, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000001, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000001, /* MC_EMEM_ARB_TIMING_RP */
			0x00000006, /* MC_EMEM_ARB_TIMING_RC */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAS */
			0x00000005, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000001, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000002, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000004, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000001, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000000, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000003, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000002, /* MC_EMEM_ARB_TIMING_W2R */
			0x02030001, /* MC_EMEM_ARB_DA_TURNS */
			0x00070506, /* MC_EMEM_ARB_DA_COVERS */
			0x71e40a07, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0xe0000000, /* EMC_FBIO_SPARE */
			0xff00ff00, /* EMC_CFG_RSV */
		},
		0x00000013, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x00000000, /* Mode Register 0 */
		0x00010042, /* Mode Register 1 */
		0x00020001, /* Mode Register 2 */
		0x00000001, /* EMC_CFG.DYN_SELF_REF */
	},
	{
		0x32,       /* Rev 3.2 */
		533000,     /* SDRAM frequency */
		{
			0x0000001f, /* EMC_RC */
			0x00000045, /* EMC_RFC */
			0x00000016, /* EMC_RAS */
			0x00000009, /* EMC_RP */
			0x00000008, /* EMC_R2W */
			0x00000009, /* EMC_W2R */
			0x00000004, /* EMC_R2P */
			0x0000000d, /* EMC_W2P */
			0x00000009, /* EMC_RD_RCD */
			0x00000009, /* EMC_WR_RCD */
			0x00000005, /* EMC_RRD */
			0x00000003, /* EMC_REXT */
			0x00000000, /* EMC_WEXT */
			0x00000004, /* EMC_WDV */
			0x00000009, /* EMC_QUSE */
			0x00000006, /* EMC_QRST */
			0x0000000d, /* EMC_QSAFE */
			0x00000010, /* EMC_RDV */
			0x000007e1, /* EMC_REFRESH */
			0x00000000, /* EMC_BURST_REFRESH_NUM */
			0x000001f8, /* EMC_PRE_REFRESH_REQ_CNT */
			0x00000003, /* EMC_PDEX2WR */
			0x00000003, /* EMC_PDEX2RD */
			0x00000009, /* EMC_PCHG2PDEN */
			0x00000000, /* EMC_ACT2PDEN */
			0x00000001, /* EMC_AR2PDEN */
			0x0000000f, /* EMC_RW2PDEN */
			0x0000004b, /* EMC_TXSR */
			0x0000004b, /* EMC_TXSRDLL */
			0x00000008, /* EMC_TCKE */
			0x0000001b, /* EMC_TFAW */
			0x0000000c, /* EMC_TRPAB */
			0x00000001, /* EMC_TCLKSTABLE */
			0x00000002, /* EMC_TCLKSTOP */
			0x000008ab, /* EMC_TREFBW */
			0x00000000, /* EMC_QUSE_EXTRA */
			0x00000006, /* EMC_FBIO_CFG6 */
			0x00000000, /* EMC_ODT_WRITE */
			0x00000000, /* EMC_ODT_READ */
			0x00006282, /* EMC_FBIO_CFG5 */
			0xf0120091, /* EMC_CFG_DIG_DLL */
			0x00008000, /* EMC_CFG_DIG_DLL_PERIOD */
			0x00000008, /* EMC_DLL_XFORM_DQS0 */
			0x00000008, /* EMC_DLL_XFORM_DQS1 */
			0x00000008, /* EMC_DLL_XFORM_DQS2 */
			0x00000008, /* EMC_DLL_XFORM_DQS3 */
			0x00000008, /* EMC_DLL_XFORM_DQS4 */
			0x00000008, /* EMC_DLL_XFORM_DQS5 */
			0x00000008, /* EMC_DLL_XFORM_DQS6 */
			0x00000008, /* EMC_DLL_XFORM_DQS7 */
			0x00000000, /* EMC_DLL_XFORM_QUSE0 */
			0x00000000, /* EMC_DLL_XFORM_QUSE1 */
			0x00000000, /* EMC_DLL_XFORM_QUSE2 */
			0x00000000, /* EMC_DLL_XFORM_QUSE3 */
			0x00000000, /* EMC_DLL_XFORM_QUSE4 */
			0x00000000, /* EMC_DLL_XFORM_QUSE5 */
			0x00000000, /* EMC_DLL_XFORM_QUSE6 */
			0x00000000, /* EMC_DLL_XFORM_QUSE7 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS0 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS1 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS2 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS3 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS4 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS5 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS6 */
			0x00000000, /* EMC_DLI_TRIM_TXDQS7 */
			0x0000000c, /* EMC_DLL_XFORM_DQ0 */
			0x0000000c, /* EMC_DLL_XFORM_DQ1 */
			0x0000000c, /* EMC_DLL_XFORM_DQ2 */
			0x0000000c, /* EMC_DLL_XFORM_DQ3 */
			0x000a0220, /* EMC_XM2CMDPADCTRL */
			0x0800003d, /* EMC_XM2DQSPADCTRL2 */
			0x00000000, /* EMC_XM2DQPADCTRL2 */
			0x77ffc004, /* EMC_XM2CLKPADCTRL */
			0x01f1f408, /* EMC_XM2COMPPADCTRL */
			0x00000000, /* EMC_XM2VTTGENPADCTRL */
			0x00000007, /* EMC_XM2VTTGENPADCTRL2 */
			0x08000068, /* EMC_XM2QUSEPADCTRL */
			0x08000000, /* EMC_XM2DQSPADCTRL3 */
			0x00000802, /* EMC_CTT_TERM_CTRL */
			0x00064000, /* EMC_ZCAL_INTERVAL */
			0x000000c0, /* EMC_ZCAL_WAIT_CNT */
			0x000e000e, /* EMC_MRS_WAIT_CNT */
			0xa0f10202, /* EMC_AUTO_CAL_CONFIG */
			0x00000000, /* EMC_CTT */
			0x00000000, /* EMC_CTT_DURATION */
			0x800010dc, /* EMC_DYN_SELF_REF_CONTROL */
			0x00000008, /* MC_EMEM_ARB_CFG */
			0x80000060, /* MC_EMEM_ARB_OUTSTANDING_REQ */
			0x00000003, /* MC_EMEM_ARB_TIMING_RCD */
			0x00000004, /* MC_EMEM_ARB_TIMING_RP */
			0x00000010, /* MC_EMEM_ARB_TIMING_RC */
			0x0000000a, /* MC_EMEM_ARB_TIMING_RAS */
			0x0000000d, /* MC_EMEM_ARB_TIMING_FAW */
			0x00000002, /* MC_EMEM_ARB_TIMING_RRD */
			0x00000003, /* MC_EMEM_ARB_TIMING_RAP2PRE */
			0x00000008, /* MC_EMEM_ARB_TIMING_WAP2PRE */
			0x00000002, /* MC_EMEM_ARB_TIMING_R2R */
			0x00000000, /* MC_EMEM_ARB_TIMING_W2W */
			0x00000004, /* MC_EMEM_ARB_TIMING_R2W */
			0x00000005, /* MC_EMEM_ARB_TIMING_W2R */
			0x05040002, /* MC_EMEM_ARB_DA_TURNS */
			0x00110c10, /* MC_EMEM_ARB_DA_COVERS */
			0x70281811, /* MC_EMEM_ARB_MISC0 */
			0x001f0000, /* MC_EMEM_ARB_RING1_THROTTLE */
			0xe0000000, /* EMC_FBIO_SPARE */
			0xff00ff88, /* EMC_CFG_RSV */
		},
		0x00000030, /* EMC_ZCAL_WAIT_CNT after clock change */
		0x001fffff, /* EMC_AUTO_CAL_INTERVAL */
		0x00000001, /* EMC_CFG.PERIODIC_QRST */
		0x00000000, /* Mode Register 0 */
		0x000100c2, /* Mode Register 1 */
		0x00020006, /* Mode Register 2 */
		0x00000000, /* EMC_CFG.DYN_SELF_REF */
	},
};

static struct tegra30_emc_pdata enterprise_emc_chip_kmmll0_a02 = {
	.description = "kmmll0_a02",
	.tables = (struct tegra30_emc_table *)enterprise_emc_tables_kmmll0_a02,
	.num_tables = ARRAY_SIZE(enterprise_emc_tables_kmmll0_a02)
};

static struct tegra30_emc_pdata enterprise_emc_chip_kmkts0_a03 = {
	.description = "kmkts0_a03",
	.tables = (struct tegra30_emc_table *)enterprise_emc_tables_kmkts0_a03,
	.num_tables = ARRAY_SIZE(enterprise_emc_tables_kmkts0_a03)
};

int __init enterprise_emc_init(void)
{
	struct board_info board_info;
	struct tegra30_emc_pdata *emc_platdata;

	tegra_get_board_info(&board_info);

	if (board_info.fab <= BOARD_FAB_A02)
		emc_platdata = &enterprise_emc_chip_kmmll0_a02;
	else
		emc_platdata = &enterprise_emc_chip_kmkts0_a03;

	tegra_emc_device.dev.platform_data = emc_platdata;
	platform_device_register(&tegra_emc_device);

	tegra30_init_emc();

	return 0;
}
