/*
 * Copyright (C) 2012 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.webview.chromium;

import android.content.ContentResolver;
import android.webkit.WebIconDatabase;
import android.webkit.WebIconDatabase.IconListener;

/**
 * Chromium implementation of WebIconDatabase -- big old no-op (base class is deprecated).
 */
final class WebIconDatabaseAdapter extends WebIconDatabase {
    @Override
    public void open(String path) {
        // Intentional no-op: historically main effect of calling this method was to enable
        // favicon download, but chromium webview always downloads favicons.
    }

    @Override
    public void close() {
        // Intentional no-op.
    }

    @Override
    public void removeAllIcons() {
        // Intentional no-op: we have no database so nothing to remove.
    }

    @Override
    public void requestIconForPageUrl(String url, IconListener listener) {
        // Intentional no-op.
    }

    @Override
    public void bulkRequestIconForPageUrl(ContentResolver cr, String where,
            IconListener listener) {
        // Intentional no-op: hidden in base class.
    }

    @Override
    public void retainIconForPageUrl(String url) {
        // Intentional no-op.
    }

    @Override
    public void releaseIconForPageUrl(String url) {
        // Intentional no-op.
    }
}
