/*
 * (C) Copyright 2005, Embedded Alley Solutions, Inc.
 * Dan Malek, <dan@embeddedalley.com>
 * Copied from STx GP3.
 * Updates for Silicon Tx GP3 SSA
 *
 * (C) Copyright 2003,Motorola Inc.
 * Xianghua Xiao, (X.Xiao@motorola.com)
 *
 * (C) Copyright 2002 Scott McNutt <smcnutt@artesyncp.com>
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */


#include <common.h>
#include <pci.h>
#include <asm/processor.h>
#include <asm/immap_85xx.h>
#include <ioports.h>
#include <asm/io.h>
#include <spd_sdram.h>
#include <miiphy.h>

long int fixed_sdram (void);

/*
 * I/O Port configuration table
 *
 * if conf is 1, then that port pin will be configured at boot time
 * according to the five values podr/pdir/ppar/psor/pdat for that entry
 */

const iop_conf_t iop_conf_tab[4][32] = {

    /* Port A configuration */
    {	/*	      conf ppar psor pdir podr pdat */
	/* PA31 */ {   0,   1,	 0,   1,   0,	0   }, /* FCC1 TxENB */
	/* PA30 */ {   0,   1,	 0,   0,   0,	0   }, /* FCC1 TxClav	*/
	/* PA29 */ {   0,   1,	 0,   1,   0,	0   }, /* FCC1 TxSOC  */
	/* PA28 */ {   0,   1,	 0,   1,   0,	0   }, /* FCC1 RxENB */
	/* PA27 */ {   0,   1,	 0,   0,   0,	0   }, /* FCC1 RxSOC */
	/* PA26 */ {   0,   1,	 0,   0,   0,	0   }, /* FCC1 RxClav */
	/* PA25 */ {   0,   1,	 0,   1,   0,	0   }, /* FCC1 ATMTXD[0] */
	/* PA24 */ {   0,   1,	 0,   1,   0,	0   }, /* FCC1 ATMTXD[1] */
	/* PA23 */ {   0,   1,	 0,   1,   0,	0   }, /* FCC1 ATMTXD[2] */
	/* PA22 */ {   0,   1,	 0,   1,   0,	0   }, /* FCC1 ATMTXD[3] */
	/* PA21 */ {   0,   1,	 0,   1,   0,	0   }, /* FCC1 ATMTXD[4] */
	/* PA20 */ {   0,   1,	 0,   1,   0,	0   }, /* FCC1 ATMTXD[5] */
	/* PA19 */ {   0,   1,	 0,   1,   0,	0   }, /* FCC1 ATMTXD[6] */
	/* PA18 */ {   0,   1,	 0,   1,   0,	0   }, /* FCC1 ATMTXD[7] */
	/* PA17 */ {   0,   1,	 0,   0,   0,	0   }, /* FCC1 ATMRXD[7] */
	/* PA16 */ {   0,   1,	 0,   0,   0,	0   }, /* FCC1 ATMRXD[6] */
	/* PA15 */ {   0,   1,	 0,   0,   0,	0   }, /* FCC1 ATMRXD[5] */
	/* PA14 */ {   0,   1,	 0,   0,   0,	0   }, /* FCC1 ATMRXD[4] */
	/* PA13 */ {   0,   1,	 0,   0,   0,	0   }, /* FCC1 ATMRXD[3] */
	/* PA12 */ {   0,   1,	 0,   0,   0,	0   }, /* FCC1 ATMRXD[2] */
	/* PA11 */ {   0,   1,	 0,   0,   0,	0   }, /* FCC1 ATMRXD[1] */
	/* PA10 */ {   0,   1,	 0,   0,   0,	0   }, /* FCC1 ATMRXD[0] */
	/* PA9	*/ {   0,   1,	 1,   1,   0,	0   }, /* FCC1 L1TXD */
	/* PA8	*/ {   0,   1,	 1,   0,   0,	0   }, /* FCC1 L1RXD */
	/* PA7	*/ {   0,   0,	 0,   1,   0,	0   }, /* PA7 */
	/* PA6	*/ {   0,   1,	 1,   1,   0,	0   }, /* TDM A1 L1RSYNC */
	/* PA5	*/ {   0,   0,	 0,   1,   0,	0   }, /* PA5 */
	/* PA4	*/ {   0,   0,	 0,   1,   0,	0   }, /* PA4 */
	/* PA3	*/ {   0,   0,	 0,   1,   0,	0   }, /* PA3 */
	/* PA2	*/ {   0,   0,	 0,   1,   0,	0   }, /* PA2 */
	/* PA1	*/ {   1,   0,	 0,   0,   0,	0   }, /* FREERUN */
	/* PA0	*/ {   0,   0,	 0,   1,   0,	0   }  /* PA0 */
    },

    /* Port B configuration */
    {	/*	      conf ppar psor pdir podr pdat */
	/* PB31 */ {   1,   1,	 0,   1,   0,	0   }, /* FCC2 MII TX_ER */
	/* PB30 */ {   1,   1,	 0,   0,   0,	0   }, /* FCC2 MII RX_DV */
	/* PB29 */ {   1,   1,	 1,   1,   0,	0   }, /* FCC2 MII TX_EN */
	/* PB28 */ {   1,   1,	 0,   0,   0,	0   }, /* FCC2 MII RX_ER */
	/* PB27 */ {   1,   1,	 0,   0,   0,	0   }, /* FCC2 MII COL */
	/* PB26 */ {   1,   1,	 0,   0,   0,	0   }, /* FCC2 MII CRS */
	/* PB25 */ {   1,   1,	 0,   1,   0,	0   }, /* FCC2 MII TxD[3] */
	/* PB24 */ {   1,   1,	 0,   1,   0,	0   }, /* FCC2 MII TxD[2] */
	/* PB23 */ {   1,   1,	 0,   1,   0,	0   }, /* FCC2 MII TxD[1] */
	/* PB22 */ {   1,   1,	 0,   1,   0,	0   }, /* FCC2 MII TxD[0] */
	/* PB21 */ {   1,   1,	 0,   0,   0,	0   }, /* FCC2 MII RxD[0] */
	/* PB20 */ {   1,   1,	 0,   0,   0,	0   }, /* FCC2 MII RxD[1] */
	/* PB19 */ {   1,   1,	 0,   0,   0,	0   }, /* FCC2 MII RxD[2] */
	/* PB18 */ {   1,   1,	 0,   0,   0,	0   }, /* FCC2 MII RxD[3] */
	/* PB17 */ {   0,   1,	 0,   0,   0,	0   }, /* FCC3:RX_DIV */
	/* PB16 */ {   0,   1,	 0,   0,   0,	0   }, /* FCC3:RX_ERR */
	/* PB15 */ {   0,   1,	 0,   1,   0,	0   }, /* FCC3:TX_ERR */
	/* PB14 */ {   0,   1,	 0,   1,   0,	0   }, /* FCC3:TX_EN */
	/* PB13 */ {   0,   1,	 0,   0,   0,	0   }, /* FCC3:COL */
	/* PB12 */ {   0,   1,	 0,   0,   0,	0   }, /* FCC3:CRS */
	/* PB11 */ {   0,   1,	 0,   0,   0,	0   }, /* FCC3:RXD */
	/* PB10 */ {   0,   1,	 0,   0,   0,	0   }, /* FCC3:RXD */
	/* PB9	*/ {   0,   1,	 0,   0,   0,	0   }, /* FCC3:RXD */
	/* PB8	*/ {   0,   1,	 0,   0,   0,	0   }, /* FCC3:RXD */
	/* PB7	*/ {   0,   1,	 0,   1,   0,	0   }, /* FCC3:TXD */
	/* PB6	*/ {   0,   1,	 0,   1,   0,	0   }, /* FCC3:TXD */
	/* PB5	*/ {   0,   1,	 0,   1,   0,	0   }, /* FCC3:TXD */
	/* PB4	*/ {   0,   1,	 0,   1,   0,	0   }, /* FCC3:TXD */
	/* PB3	*/ {   0,   0,	 0,   0,   0,	0   }, /* pin doesn't exist */
	/* PB2	*/ {   0,   0,	 0,   0,   0,	0   }, /* pin doesn't exist */
	/* PB1	*/ {   0,   0,	 0,   0,   0,	0   }, /* pin doesn't exist */
	/* PB0	*/ {   0,   0,	 0,   0,   0,	0   }  /* pin doesn't exist */
    },

    /* Port C */
    {	/*	      conf ppar psor pdir podr pdat */
	/* PC31 */ {   0,   0,	 0,   1,   0,	0   }, /* PC31 */
	/* PC30 */ {   0,   0,	 0,   1,   0,	0   }, /* PC30 */
	/* PC29 */ {   0,   1,	 1,   0,   0,	0   }, /* SCC1 EN *CLSN */
	/* PC28 */ {   0,   0,	 0,   1,   0,	0   }, /* PC28 */
	/* PC27 */ {   0,   0,	 0,   1,   0,	0   }, /* UART Clock in */
	/* PC26 */ {   0,   0,	 0,   1,   0,	0   }, /* PC26 */
	/* PC25 */ {   0,   0,	 0,   1,   0,	0   }, /* PC25 */
	/* PC24 */ {   0,   0,	 0,   1,   0,	0   }, /* PC24 */
	/* PC23 */ {   0,   1,	 0,   1,   0,	0   }, /* ATMTFCLK */
	/* PC22 */ {   0,   1,	 0,   0,   0,	0   }, /* ATMRFCLK */
	/* PC21 */ {   0,   1,	 0,   0,   0,	0   }, /* SCC1 EN RXCLK */
	/* PC20 */ {   0,   1,	 0,   0,   0,	0   }, /* SCC1 EN TXCLK */
	/* PC19 */ {   1,   1,	 0,   0,   0,	0   }, /* FCC2 MII RX_CLK CLK13 */
	/* PC18 */ {   1,   1,	 0,   0,   0,	0   }, /* FCC Tx Clock (CLK14) */
	/* PC17 */ {   0,   0,	 0,   1,   0,	0   }, /* PC17 */
	/* PC16 */ {   0,   1,	 0,   0,   0,	0   }, /* FCC Tx Clock (CLK16) */
	/* PC15 */ {   0,   1,	 0,   0,   0,	0   }, /* PC15 */
	/* PC14 */ {   0,   1,	 0,   0,   0,	0   }, /* SCC1 EN *CD */
	/* PC13 */ {   0,   0,	 0,   1,   0,	0   }, /* PC13 */
	/* PC12 */ {   0,   1,	 0,   1,   0,	0   }, /* PC12 */
	/* PC11 */ {   0,   0,	 0,   1,   0,	0   }, /* LXT971 transmit control */
	/* PC10 */ {   0,   0,	 0,   1,   0,	0   }, /* FETHMDC */
	/* PC9	*/ {   0,   0,	 0,   0,   0,	0   }, /* FETHMDIO */
	/* PC8	*/ {   0,   0,	 0,   1,   0,	0   }, /* PC8 */
	/* PC7	*/ {   0,   0,	 0,   1,   0,	0   }, /* PC7 */
	/* PC6	*/ {   0,   0,	 0,   1,   0,	0   }, /* PC6 */
	/* PC5	*/ {   0,   0,	 0,   1,   0,	0   }, /* PC5 */
	/* PC4	*/ {   0,   0,	 0,   1,   0,	0   }, /* PC4 */
	/* PC3	*/ {   0,   0,	 0,   1,   0,	0   }, /* PC3 */
	/* PC2	*/ {   0,   0,	 0,   1,   0,	1   }, /* ENET FDE */
	/* PC1	*/ {   0,   0,	 0,   1,   0,	0   }, /* ENET DSQE */
	/* PC0	*/ {   0,   0,	 0,   1,   0,	0   }, /* ENET LBK */
    },

    /* Port D */
    {	/*	      conf ppar psor pdir podr pdat */
	/* PD31 */ {   0,   1,	 0,   0,   0,	0   }, /* SCC1 EN RxD */
	/* PD30 */ {   0,   1,	 1,   1,   0,	0   }, /* SCC1 EN TxD */
	/* PD29 */ {   0,   1,	 0,   1,   0,	0   }, /* SCC1 EN TENA */
	/* PD28 */ {   1,   1,	 0,   0,   0,	0   }, /* SCC2 RxD */
	/* PD27 */ {   1,   1,	 0,   1,   0,	0   }, /* SCC2 TxD */
	/* PD26 */ {   0,   0,	 0,   1,   0,	0   }, /* PD26 */
	/* PD25 */ {   0,   0,	 0,   1,   0,	0   }, /* PD25 */
	/* PD24 */ {   0,   0,	 0,   1,   0,	0   }, /* PD24 */
	/* PD23 */ {   0,   0,	 0,   1,   0,	0   }, /* PD23 */
	/* PD22 */ {   0,   0,	 0,   1,   0,	0   }, /* PD22 */
	/* PD21 */ {   0,   0,	 0,   1,   0,	0   }, /* PD21 */
	/* PD20 */ {   0,   0,	 0,   1,   0,	0   }, /* PD20 */
	/* PD19 */ {   0,   0,	 0,   1,   0,	0   }, /* PD19 */
	/* PD18 */ {   0,   0,	 0,   1,   0,	0   }, /* PD18 */
	/* PD17 */ {   0,   1,	 0,   0,   0,	0   }, /* FCC1 ATMRXPRTY */
	/* PD16 */ {   0,   1,	 0,   1,   0,	0   }, /* FCC1 ATMTXPRTY */
	/* PD15 */ {   1,   1,	 1,   0,   1,	0   }, /* I2C SDA */
	/* PD14 */ {   1,   1,	 1,   0,   0,	0   }, /* I2C CLK */
	/* PD13 */ {   0,   0,	 0,   0,   0,	0   }, /* PD13 */
	/* PD12 */ {   0,   0,	 0,   0,   0,	0   }, /* PD12 */
	/* PD11 */ {   0,   0,	 0,   0,   0,	0   }, /* PD11 */
	/* PD10 */ {   0,   0,	 0,   0,   0,	0   }, /* PD10 */
	/* PD9	*/ {   0,   1,	 0,   1,   0,	0   }, /* SMC1 TXD */
	/* PD8	*/ {   0,   1,	 0,   0,   0,	0   }, /* SMC1 RXD */
	/* PD7	*/ {   0,   0,	 0,   1,   0,	1   }, /* PD7 */
	/* PD6	*/ {   0,   0,	 0,   1,   0,	1   }, /* PD6 */
	/* PD5	*/ {   0,   0,	 0,   1,   0,	1   }, /* PD5 */
	/* PD4	*/ {   0,   0,	 0,   1,   0,	1   }, /* PD4 */
	/* PD3	*/ {   0,   0,	 0,   0,   0,	0   }, /* pin doesn't exist */
	/* PD2	*/ {   0,   0,	 0,   0,   0,	0   }, /* pin doesn't exist */
	/* PD1	*/ {   0,   0,	 0,   0,   0,	0   }, /* pin doesn't exist */
	/* PD0	*/ {   0,   0,	 0,   0,   0,	0   }  /* pin doesn't exist */
    }
};

static	uint64_t	next_led_update;
static	uint		led_bit;

void
reset_phy(void)
{
	volatile uint *blatch;
#if 0
	int	i;
#endif
	blatch = (volatile uint *)CFG_LBC_CFGLATCH_BASE;

	/* reset Giga bit Ethernet port if needed here */

#if 1
	*blatch &= ~0x000000c0;
	udelay(100);
#else
	*blatch = 0;
	asm("eieio");
	for (i=0; i<1000; i++)
		udelay(1000);
#endif
	*blatch = 0x000000c1;	/* Light one led, too */
	udelay(1000);

#if 0	/* This is the port we really want to use for debugging. */
	/* reset the CPM FEC port */
#if (CONFIG_ETHER_INDEX == 2)
	bcsr->bcsr2 &= ~FETH2_RST;
	udelay(2);
	bcsr->bcsr2 |=	FETH2_RST;
	udelay(1000);
#elif (CONFIG_ETHER_INDEX == 3)
	bcsr->bcsr3 &= ~FETH3_RST;
	udelay(2);
	bcsr->bcsr3 |=	FETH3_RST;
	udelay(1000);
#endif
#if defined(CONFIG_MII) && defined(CONFIG_ETHER_ON_FCC)
	/* reset PHY */
	miiphy_reset("FCC1 ETHERNET", 0x0);

	/* change PHY address to 0x02 */
	bb_miiphy_write(NULL, 0, PHY_MIPSCR, 0xf028);

	bb_miiphy_write(NULL, 0x02, PHY_BMCR,
			PHY_BMCR_AUTON | PHY_BMCR_RST_NEG);
#endif /* CONFIG_MII */
#endif
}

int
board_early_init_f(void)
{
#if defined(CONFIG_PCI)
	volatile ccsr_pcix_t *pci = (void *)(CFG_MPC85xx_PCIX_ADDR);

	pci->peer &= 0xffffffdf; /* disable master abort */
#endif

	/* Why is the phy reset done _after_ the ethernet
	 * initialization in lib_ppc/board.c?
	 * Do it here so it's done before the TSECs are used.
	 */
	reset_phy();

	return 0;
}

int
checkboard(void)
{
	printf ("Board: Silicon Tx GPPP SSA Board\n");
	return (0);
}

/* Blinkin' LEDS for Robert.
*/
void
show_activity(int flag)
{
	volatile uint *blatch;

	if (next_led_update > get_ticks())
		return;

	blatch = (volatile uint *)CFG_LBC_CFGLATCH_BASE;

	led_bit >>= 1;
	if (led_bit == 0)
		led_bit = 0x08;
	*blatch = (0xc0 | led_bit);
	eieio();
	next_led_update += (get_tbclk() / 4);
}

long int
initdram (int board_type)
{
	long dram_size = 0;

#if defined(CONFIG_DDR_DLL)
	{
		volatile ccsr_gur_t *gur = (void *)(CFG_MPC85xx_GUTS_ADDR);
		uint temp_ddrdll = 0;

		/* Work around to stabilize DDR DLL */
		temp_ddrdll = gur->ddrdllcr;
		gur->ddrdllcr = ((temp_ddrdll & 0xff) << 16) | 0x80000000;
		asm("sync;isync;msync");
	}
#endif

	dram_size = spd_sdram ();

#if defined(CONFIG_DDR_ECC)
	/* Initialize and enable DDR ECC.
	*/
	ddr_enable_ecc(dram_size);
#endif

	return dram_size;
}


#if defined(CFG_DRAM_TEST)
int testdram (void)
{
	uint *pstart = (uint *) CFG_MEMTEST_START;
	uint *pend = (uint *) CFG_MEMTEST_END;
	uint *p;

	printf("SDRAM test phase 1:\n");
	for (p = pstart; p < pend; p++)
		*p = 0xaaaaaaaa;

	for (p = pstart; p < pend; p++) {
		if (*p != 0xaaaaaaaa) {
			printf ("SDRAM test fails at: %08x\n", (uint) p);
			return 1;
		}
	}

	printf("SDRAM test phase 2:\n");
	for (p = pstart; p < pend; p++)
		*p = 0x55555555;

	for (p = pstart; p < pend; p++) {
		if (*p != 0x55555555) {
			printf ("SDRAM test fails at: %08x\n", (uint) p);
			return 1;
		}
	}

	printf("SDRAM test passed.\n");
	return 0;
}
#endif

#if defined(CONFIG_PCI)

/*
 * Initialize PCI Devices, report devices found.
 */

#ifndef CONFIG_PCI_PNP
static struct pci_config_table pci_stxgp3_config_table[] = {
    { PCI_ANY_ID, PCI_ANY_ID, PCI_ANY_ID, PCI_ANY_ID,
      PCI_IDSEL_NUMBER, PCI_ANY_ID,
      pci_cfgfunc_config_device, { PCI_ENET0_IOADDR,
				   PCI_ENET0_MEMADDR,
				   PCI_COMMAND_MEMORY | PCI_COMMAND_MASTER
      } },
    { }
};
#endif


static struct pci_controller hose[] = {
#ifndef CONFIG_PCI_PNP
	{ config_table: pci_stxgp3_config_table,},
#else
	{},
#endif
#ifdef CONFIG_MPC85XX_PCI2
	{},
#endif
};

#endif	/* CONFIG_PCI */


void
pci_init_board(void)
{
#ifdef CONFIG_PCI
	extern void pci_mpc85xx_init(struct pci_controller *hose);

	pci_mpc85xx_init(hose);
#endif /* CONFIG_PCI */
}
