/*
 * (C) Copyright 2001
 * Denis Peter, MPL AG, d.peter@mpl.ch.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 * Note: Parts of these software are imported from
 *       - UBL, The Universal Talkware Boot Loader
 *         Copyright (C) 2000 Universal Talkware Inc.
 *       - Linux
 *
 * File: vga_table.c
 *
 * contains all tables (include fonts) for the vga controller.
 *
 **********************************************/
#ifndef _VGA_TABLE_H
#define _VGA_TABLE_H

/* table for VGA Initialization  */
typedef struct {
	const unsigned char reg;
	const unsigned char val;
} VIDEO_CFG_TABLE;

/* Attribute table */
static VIDEO_CFG_TABLE attr[] = {
	{ 0x00, 0x00 }, /* black */
	{ 0x01, 0x01 }, /* blue */
	{ 0x02, 0x02 },	/* green */
	{ 0x03, 0x03 },	/* cyan */
	{ 0x04, 0x04 },	/* red */
	{ 0x05, 0x05 }, /* magenta */
	{ 0x06, 0x14 },	/* brown */
	{ 0x07, 0x07 },	/* white */
	{ 0x08, 0x38 },	/* dark gray */
	{ 0x09, 0x39 },	/* light blue */
	{ 0x0A, 0x3A },	/* light green */
	{ 0x0B, 0x3B },	/* light Cyan */
	{ 0x0C, 0x3C },	/* light red */
	{ 0x0D, 0x3D },	/* light magenta */
	{ 0x0E, 0x3E }, /* yellow */
	{ 0x0F, 0x3F },	/* intense white */
	{ 0x10, 0x0C }, /* mode control */
	{ 0x11, 0x00 },	/* overscan color */
	{ 0x12, 0x0f },	/* color plane enable */
	{ 0x13, 0x08 }, /* horizontal Pel Panning */
	{ 0x14, 0x00 }, /* color select */
	{ 0xFF, 0xFF}		/* end of table */
};

/* Values for VGA 80 x 25 Text mode */
static VIDEO_CFG_TABLE crtc[] = {
	{0x00,0x5F},	/* horizontal total */
	{0x01,0x4F},	/* horizontal displayed */
	{0x02,0x50},	/* horizontal blank start */
	{0x03,0x82},	/* horizontal blank end MIP520 BIOS*/
	{0x04,0x55},	/* horizontal synch pos  MIP520 */
	{0x05,0x9F},	/* horizontal synch width BIOS Source */
	{0x06,0xBF},	/* vertical total BIOS MIP520*/
	{0x07,0x1F},	/* overflow */
	{0x08,0x00},	/* prescan  */
	{0x09,0x4F},	/* maximum scanline */
	{0x0A,0x0D},	/* cursor start */
	{0x0B,0x0E},	/* cursor end */
	{0x0C,0x00},	/* start address high byte */
	{0x0D,0x00},	/* start address low byte */
	{0x0E,0x07},	/* cursor location high byte */
	{0x0F,0x80},	/* cursor location low byte */
	{0x10,0x9C},	/* vertical synch start BIOS MIP520*/
	{0x11,0x8E},	/* vertical synch end */
	{0x12,0x8F},	/* vertical display enable end BIOS MIP520 */
	{0x13,0x28},	/* offset */
	{0x14,0x1F},	/* underline row */
	{0x15,0x96},	/* verical blank start */
	{0x16,0xB9},	/* verical blank end */
	{0x17,0xA3},	/* crt Mode Control */
	{0x18,0xFF},	/* line compare */
	/* added for 69000 */
	{0x22,0x20},	/* Memory Latch */
	{0x30,0x00},	/* ext. total vertical register */
	{0x31,0x00},	/* ext. vertical display end */
	{0x32,0x00},	/* ext. vertical synch */
	{0x33,0x00},	/* ext. vertical blanking start */
	{0x38,0x00},	/* ext. total horizontal register */
	{0x3C,0x00},	/* ext. horizontal blanking end */
	{0x40,0x00},	/* ext. start address */
	{0x41,0x00},	/* ext. offset */
	{0x70,0x4F},	/* interlace control register */
	{0x71,0x00},	/* NTSC/PAL Video Output Control */
	{0x72,0x00},	/* NTSC/PAL horizontal serration 1 start */
	{0x73,0x00},	/* NTSC/PAL horizontal serration 2 start */
	{0x74,0x00},	/* NTSC/PAL horizontal pulse width */
	{0x75,0x00},	/* NTSC/PAL filtering burst read length */
	{0x76,0x00},	/* NTSC/PAL filtering burst read quantity */
	{0x77,0x00},	/* NTSC/PAL Filtering Control */
	{0x78,0x00},	/* NTSC/PAL Vertical reduction */
	{0x79,0x00},	/* NTSC/PAL horizontal total fine adjust */
	{0xFF,0xFF}		/* end of table */
};

static VIDEO_CFG_TABLE grmr[] = {
	{0x00,0x00},	/* all planes are reset */
	{0x01,0x00},	/* no special altering of plane */
	{0x02,0x00},	/* color compare */
	{0x03,0x00},	/* data rotate */
	{0x04,0x00},	/* read plane 0 */
	{0x05,0x10},	/* Mode */
	{0x06,0x0E},	/* misc */
	{0x07,0x00},	/* Color */
	{0x08,0xFF},	/* Bitmask */
	{0xFF,0xFF}		/* end of table */
};


static VIDEO_CFG_TABLE seq[] = {
	{0x00,0x03},	/* release the resets */
	{0x01,0x00},	/* clocking mode */
	{0x02,0x03},	/* enable plane 0,1 access */
	{0x03,0x00},	/* character map */
	{0x04,0x02},	/* Memory mode */
	{0x07,0x00},	/* Reset Counter */
	{0xFF,0xFF}		/* end of table */
};

static VIDEO_CFG_TABLE xreg[] = {

	{ 0x0A, 0x00 }, /* Frame Buffer Mapping */
	{ 0x0B, 0x01 }, /* PCI Write Burst support */
	{ 0x0E, 0x00 },	/* Frame buffer Page select */
	{ 0x20, 0x00 }, /* BitBLT Configuration */
	/*	{ 0x40, 0x03 }, */ /* Memory Access Control */
	{ 0x40, 0x00 }, /* Memory Access Control */
	{ 0x60, 0x00 },	/* Video Pin Control */
	{ 0x61, 0x00 },	/* DPMS Synch control */
	{ 0x62, 0x00 },	/* GPIO Pin Control */
	{ 0x63, 0xBD },	/* GPIO Pin Data*/
	{ 0x67, 0x00 },	/* Pin Tri-State */
	{ 0x80, 0x00 },	/* Pixel Pipeline Config 0 register */
	{ 0x81, 0x00 },	/* Pixel Pipeline Config 1 register */
	{ 0x82, 0x00 },	/* Pixel Pipeline Config 2 register */
	{ 0xA0, 0x00 },	/* Cursor 1 Control Reg */
	{ 0xA1, 0x00 },	/* Cursor 1 Vertical Extension Reg */
	{ 0xA2, 0x00 },	/* Cursor 1 Base Address Low */
	{ 0xA3, 0x00 },	/* Cursor 1 Base Address High */
	{ 0xA4, 0x00 },	/* Cursor 1 X-Position Low */
	{ 0xA5, 0x00 },	/* Cursor 1 X-Position High */
	{ 0xA6, 0x00 },	/* Cursor 1 Y-Position Low */
	{ 0xA7, 0x00 },	/* Cursor 1 Y-Position High */
	{ 0xA8, 0x00 },	/* Cursor 2 Control Reg */
	{ 0xA9, 0x00 },	/* Cursor 2 Vertical Extension Reg */
	{ 0xAA, 0x00 },	/* Cursor 2 Base Address Low */
	{ 0xAB, 0x00 },	/* Cursor 2 Base Address High */
	{ 0xAC, 0x00 },	/* Cursor 2 X-Position Low */
	{ 0xAD, 0x00 },	/* Cursor 2 X-Position High */
	{ 0xAE, 0x00 },	/* Cursor 2 Y-Position Low */
	{ 0xAF, 0x00 },	/* Cursor 2 Y-Position High */
	{ 0xC0, 0x7D },	/* Dot Clock 0 VCO M-Divisor */
	{ 0xC1, 0x07 },	/* Dot Clock 0 VCO N-Divisor */
	{ 0xC3, 0x34 },	/* Dot Clock 0 Divisor select */
	{ 0xC4, 0x55 },	/* Dot Clock 1 VCO M-Divisor */
	{ 0xC5, 0x09 },	/* Dot Clock 1 VCO N-Divisor */
	{ 0xC7, 0x24 },	/* Dot Clock 1 Divisor select */
	{ 0xC8, 0x7D },	/* Dot Clock 2 VCO M-Divisor */
	{ 0xC9, 0x07 },	/* Dot Clock 2 VCO N-Divisor */
	{ 0xCB, 0x34 },	/* Dot Clock 2 Divisor select */
	{ 0xCC, 0x38 },	/* Memory Clock 0 VCO M-Divisor */
	{ 0xCD, 0x03 },	/* Memory Clock 0 VCO N-Divisor */
	{ 0xCE, 0x90 },	/* Memory Clock 0 Divisor select */
	{ 0xCF, 0x06 },	/* Clock Config */
	{ 0xD0, 0x0F },	/* Power Down */
	{ 0xD1, 0x01 },	/* Power Down BitBLT */
	/*	{ 0xD2, 0x0F }, */  /* 2KHz Counter Power Down  */
	{ 0xFF, 0xFF}			/* end of table */
};
/* Clock Config:
 * If Loop Divisor = 1
 *   Fvco = (Fref * M/N)
 *	 Fout = Fvco / Post Divisor
 * Dot Clk0:
 * ---------
 * M  = (M Div + 2) = 127
 * N  = (N Div + 2) = 9
 * Post Divisor =     8
 * Loop Divisor =     1
 * Fref = 14.31818MHz => Fvco 202.045MHz => Dot Clock 0 = 25.25MHz
 *
 * Dot Clk1:
 * ---------
 * M  = (M Div + 2) = 57
 * N  = (N Div + 2) = 11
 * Post Divisor =     4
 * Loop Divisor =     1
 * Fref = 14.31818MHz => Fvco 113.24MHz => Dot Clock 1 = 28.31MHz
 *
 * Dot Clk2:
 * ---------
 * M  = (M Div + 2) = 127
 * N  = (N Div + 2) = 9
 * Post Divisor =     8
 * Loop Divisor =     1
 * Fref = 14.31818MHz => Fvco 202.045MHz => Dot Clock 2 = 25.25MHz
 *
 * Memory Clk:
 * -----------
 * M  = (M Div + 2) = 58
 * N  = (N Div + 2) = 5
 * Post Divisor =     2
 * Fref = 14.31818MHz => Fvco 166MHz => Dot Clock 1 = 83MHz
 *
 */



/* DAC datas */
static unsigned char dac[][3] = {
  {0x00, 0x00, 0x00}, /* Index  0 (00) */
  {0x00, 0x00, 0x2A}, /* Index  1 (01) */
  {0x00, 0x2A, 0x00}, /* Index  2 (02) */
  {0x00, 0x2A, 0x2A}, /* Index  3 (03) */
  {0x2A, 0x00, 0x00}, /* Index  4 (04) */
  {0x2A, 0x00, 0x2A}, /* Index  5 (05) */
  {0x2A, 0x2A, 0x00}, /* Index  6 (06) */
  {0x2A, 0x2A, 0x2A}, /* Index  7 (07) */
  {0x00, 0x00, 0x15}, /* Index  8 (08) */
  {0x00, 0x00, 0x3F}, /* Index  9 (09) */
  {0x00, 0x2A, 0x15}, /* Index 10 (0A) */
  {0x00, 0x2A, 0x3F}, /* Index 11 (0B) */
  {0x2A, 0x00, 0x15}, /* Index 12 (0C) */
  {0x2A, 0x00, 0x3F}, /* Index 13 (0D) */
  {0x2A, 0x2A, 0x15}, /* Index 14 (0E) */
  {0x2A, 0x2A, 0x3F}, /* Index 15 (0F) */
  {0x00, 0x15, 0x00}, /* Index 16 (10) */
  {0x00, 0x15, 0x2A}, /* Index 17 (11) */
  {0x00, 0x3F, 0x00}, /* Index 18 (12) */
  {0x00, 0x3F, 0x2A}, /* Index 19 (13) */
  {0x2A, 0x15, 0x00}, /* Index 20 (14) */
  {0x2A, 0x15, 0x2A}, /* Index 21 (15) */
  {0x2A, 0x3F, 0x00}, /* Index 22 (16) */
  {0x2A, 0x3F, 0x2A}, /* Index 23 (17) */
  {0x00, 0x15, 0x15}, /* Index 24 (18) */
  {0x00, 0x15, 0x3F}, /* Index 25 (19) */
  {0x00, 0x3F, 0x15}, /* Index 26 (1A) */
  {0x00, 0x3F, 0x3F}, /* Index 27 (1B) */
  {0x2A, 0x15, 0x15}, /* Index 28 (1C) */
  {0x2A, 0x15, 0x3F}, /* Index 29 (1D) */
  {0x2A, 0x3F, 0x15}, /* Index 30 (1E) */
  {0x2A, 0x3F, 0x3F}, /* Index 31 (1F) */
  {0x15, 0x00, 0x00}, /* Index 32 (20) */
  {0x15, 0x00, 0x2A}, /* Index 33 (21) */
  {0x15, 0x2A, 0x00}, /* Index 34 (22) */
  {0x15, 0x2A, 0x2A}, /* Index 35 (23) */
  {0x3F, 0x00, 0x00}, /* Index 36 (24) */
  {0x3F, 0x00, 0x2A}, /* Index 37 (25) */
  {0x3F, 0x2A, 0x00}, /* Index 38 (26) */
  {0x3F, 0x2A, 0x2A}, /* Index 39 (27) */
  {0x15, 0x00, 0x15}, /* Index 40 (28) */
  {0x15, 0x00, 0x3F}, /* Index 41 (29) */
  {0x15, 0x2A, 0x15}, /* Index 42 (2A) */
  {0x15, 0x2A, 0x3F}, /* Index 43 (2B) */
  {0x3F, 0x00, 0x15}, /* Index 44 (2C) */
  {0x3F, 0x00, 0x3F}, /* Index 45 (2D) */
  {0x3F, 0x2A, 0x15}, /* Index 46 (2E) */
  {0x3F, 0x2A, 0x3F}, /* Index 47 (2F) */
  {0x15, 0x15, 0x00}, /* Index 48 (30) */
  {0x15, 0x15, 0x2A}, /* Index 49 (31) */
  {0x15, 0x3F, 0x00}, /* Index 50 (32) */
  {0x15, 0x3F, 0x2A}, /* Index 51 (33) */
  {0x3F, 0x15, 0x00}, /* Index 52 (34) */
  {0x3F, 0x15, 0x2A}, /* Index 53 (35) */
  {0x3F, 0x3F, 0x00}, /* Index 54 (36) */
  {0x3F, 0x3F, 0x2A}, /* Index 55 (37) */
  {0x15, 0x15, 0x15}, /* Index 56 (38) */
  {0x15, 0x15, 0x3F}, /* Index 57 (39) */
  {0x15, 0x3F, 0x15}, /* Index 58 (3A) */
  {0x15, 0x3F, 0x3F}, /* Index 59 (3B) */
  {0x3F, 0x15, 0x15}, /* Index 60 (3C) */
  {0x3F, 0x15, 0x3F}, /* Index 61 (3D) */
  {0x3F, 0x3F, 0x15}, /* Index 62 (3E) */
  {0x3F, 0x3F, 0x3F}, /* Index 63 (3F) */
  {0x16, 0x1E, 0x17}, /* Index 64 (40) */
  {0x27, 0x2F, 0x00}, /* Index 65 (41) */
  {0x1E, 0x20, 0x18}, /* Index 66 (42) */
  {0x30, 0x04, 0x06}, /* Index 67 (43) */
  {0x08, 0x05, 0x12}, /* Index 68 (44) */
  {0x30, 0x0A, 0x31}, /* Index 69 (45) */
  {0x08, 0x16, 0x07}, /* Index 70 (46) */
  {0x1B, 0x33, 0x21}, /* Index 71 (47) */
  {0x02, 0x2C, 0x16}, /* Index 72 (48) */
  {0x3D, 0x1C, 0x11}, /* Index 73 (49) */
  {0x07, 0x22, 0x33}, /* Index 74 (4A) */
  {0x1D, 0x2B, 0x0A}, /* Index 75 (4B) */
  {0x1A, 0x15, 0x16}, /* Index 76 (4C) */
  {0x15, 0x26, 0x24}, /* Index 77 (4D) */
  {0x05, 0x2B, 0x1E}, /* Index 78 (4E) */
  {0x11, 0x18, 0x01}, /* Index 79 (4F) */
  {0x3A, 0x2C, 0x27}, /* Index 80 (50) */
  {0x25, 0x23, 0x00}, /* Index 81 (51) */
  {0x2A, 0x16, 0x2A}, /* Index 82 (52) */
  {0x18, 0x19, 0x17}, /* Index 83 (53) */
  {0x0B, 0x0F, 0x06}, /* Index 84 (54) */
  {0x00, 0x34, 0x08}, /* Index 85 (55) */
  {0x00, 0x19, 0x12}, /* Index 86 (56) */
  {0x01, 0x06, 0x3B}, /* Index 87 (57) */
  {0x29, 0x0E, 0x25}, /* Index 88 (58) */
  {0x20, 0x10, 0x28}, /* Index 89 (59) */
  {0x02, 0x37, 0x24}, /* Index 90 (5A) */
  {0x08, 0x2A, 0x2E}, /* Index 91 (5B) */
  {0x26, 0x2A, 0x22}, /* Index 92 (5C) */
  {0x0C, 0x0C, 0x2A}, /* Index 93 (5D) */
  {0x28, 0x07, 0x02}, /* Index 94 (5E) */
  {0x34, 0x05, 0x2B}, /* Index 95 (5F) */
  {0x0C, 0x31, 0x33}, /* Index 96 (60) */
  {0x22, 0x08, 0x30}, /* Index 97 (61) */
  {0x00, 0x25, 0x01}, /* Index 98 (62) */
  {0x06, 0x15, 0x01}, /* Index 99 (63) */
  {0x0D, 0x2A, 0x0A}, /* Index 100 (64) */
  {0x08, 0x25, 0x16}, /* Index 101 (65) */
  {0x2A, 0x0A, 0x01}, /* Index 102 (66) */
  {0x08, 0x3B, 0x28}, /* Index 103 (67) */
  {0x00, 0x09, 0x04}, /* Index 104 (68) */
  {0x16, 0x0F, 0x05}, /* Index 105 (69) */
  {0x02, 0x2F, 0x1D}, /* Index 106 (6A) */
  {0x06, 0x3E, 0x02}, /* Index 107 (6B) */
  {0x09, 0x30, 0x07}, /* Index 108 (6C) */
  {0x34, 0x03, 0x06}, /* Index 109 (6D) */
  {0x00, 0x15, 0x2A}, /* Index 110 (6E) */
  {0x39, 0x23, 0x20}, /* Index 111 (6F) */
  {0x2A, 0x32, 0x0C}, /* Index 112 (70) */
  {0x09, 0x31, 0x26}, /* Index 113 (71) */
  {0x27, 0x23, 0x28}, /* Index 114 (72) */
  {0x20, 0x13, 0x0C}, /* Index 115 (73) */
  {0x2C, 0x1E, 0x26}, /* Index 116 (74) */
  {0x20, 0x2F, 0x05}, /* Index 117 (75) */
  {0x22, 0x1B, 0x22}, /* Index 118 (76) */
  {0x09, 0x1C, 0x06}, /* Index 119 (77) */
  {0x16, 0x38, 0x0E}, /* Index 120 (78) */
  {0x22, 0x16, 0x20}, /* Index 121 (79) */
  {0x10, 0x17, 0x25}, /* Index 122 (7A) */
  {0x04, 0x32, 0x22}, /* Index 123 (7B) */
  {0x20, 0x00, 0x37}, /* Index 124 (7C) */
  {0x21, 0x15, 0x1A}, /* Index 125 (7D) */
  {0x01, 0x04, 0x20}, /* Index 126 (7E) */
  {0x02, 0x0C, 0x1E}, /* Index 127 (7F) */
  {0x15, 0x15, 0x29}, /* Index 128 (80) */
  {0x24, 0x3B, 0x00}, /* Index 129 (81) */
  {0x24, 0x28, 0x01}, /* Index 130 (82) */
  {0x20, 0x19, 0x07}, /* Index 131 (83) */
  {0x1A, 0x13, 0x02}, /* Index 132 (84) */
  {0x04, 0x24, 0x1F}, /* Index 133 (85) */
  {0x32, 0x30, 0x08}, /* Index 134 (86) */
  {0x23, 0x12, 0x0B}, /* Index 135 (87) */
  {0x21, 0x38, 0x00}, /* Index 136 (88) */
  {0x04, 0x13, 0x09}, /* Index 137 (89) */
  {0x06, 0x3E, 0x14}, /* Index 138 (8A) */
  {0x23, 0x22, 0x2D}, /* Index 139 (8B) */
  {0x3D, 0x35, 0x30}, /* Index 140 (8C) */
  {0x24, 0x38, 0x05}, /* Index 141 (8D) */
  {0x18, 0x01, 0x26}, /* Index 142 (8E) */
  {0x27, 0x11, 0x38}, /* Index 143 (8F) */
  {0x08, 0x1A, 0x08}, /* Index 144 (90) */
  {0x00, 0x1A, 0x07}, /* Index 145 (91) */
  {0x16, 0x0C, 0x30}, /* Index 146 (92) */
  {0x1B, 0x0A, 0x0B}, /* Index 147 (93) */
  {0x01, 0x0C, 0x09}, /* Index 148 (94) */
  {0x00, 0x33, 0x03}, /* Index 149 (95) */
  {0x13, 0x0A, 0x06}, /* Index 150 (96) */
  {0x22, 0x19, 0x23}, /* Index 151 (97) */
  {0x07, 0x30, 0x39}, /* Index 152 (98) */
  {0x20, 0x07, 0x0D}, /* Index 153 (99) */
  {0x39, 0x18, 0x20}, /* Index 154 (9A) */
  {0x32, 0x31, 0x29}, /* Index 155 (9B) */
  {0x28, 0x3F, 0x02}, /* Index 156 (9C) */
  {0x02, 0x15, 0x3E}, /* Index 157 (9D) */
  {0x27, 0x33, 0x0E}, /* Index 158 (9E) */
  {0x39, 0x2E, 0x1D}, /* Index 159 (9F) */
  {0x1E, 0x38, 0x10}, /* Index 160 (A0) */
  {0x01, 0x33, 0x19}, /* Index 161 (A1) */
  {0x2B, 0x20, 0x0B}, /* Index 162 (A2) */
  {0x29, 0x0B, 0x23}, /* Index 163 (A3) */
  {0x25, 0x04, 0x19}, /* Index 164 (A4) */
  {0x34, 0x36, 0x08}, /* Index 165 (A5) */
  {0x17, 0x1D, 0x01}, /* Index 166 (A6) */
  {0x0A, 0x29, 0x10}, /* Index 167 (A7) */
  {0x14, 0x1C, 0x2B}, /* Index 168 (A8) */
  {0x02, 0x2C, 0x13}, /* Index 169 (A9) */
  {0x14, 0x16, 0x3A}, /* Index 170 (AA) */
  {0x2B, 0x22, 0x28}, /* Index 171 (AB) */
  {0x2E, 0x0A, 0x22}, /* Index 172 (AC) */
  {0x00, 0x20, 0x28}, /* Index 173 (AD) */
  {0x08, 0x22, 0x2D}, /* Index 174 (AE) */
  {0x2C, 0x17, 0x1D}, /* Index 175 (AF) */
  {0x02, 0x0D, 0x20}, /* Index 176 (B0) */
  {0x00, 0x18, 0x2C}, /* Index 177 (B1) */
  {0x19, 0x19, 0x3C}, /* Index 178 (B2) */
  {0x20, 0x32, 0x10}, /* Index 179 (B3) */
  {0x38, 0x1C, 0x21}, /* Index 180 (B4) */
  {0x36, 0x10, 0x00}, /* Index 181 (B5) */
  {0x20, 0x08, 0x19}, /* Index 182 (B6) */
  {0x09, 0x12, 0x01}, /* Index 183 (B7) */
  {0x1D, 0x39, 0x03}, /* Index 184 (B8) */
  {0x20, 0x28, 0x11}, /* Index 185 (B9) */
  {0x35, 0x17, 0x01}, /* Index 186 (BA) */
  {0x0C, 0x02, 0x08}, /* Index 187 (BB) */
  {0x39, 0x0D, 0x10}, /* Index 188 (BC) */
  {0x38, 0x21, 0x16}, /* Index 189 (BD) */
  {0x29, 0x3E, 0x14}, /* Index 190 (BE) */
  {0x0A, 0x1C, 0x28}, /* Index 191 (BF) */
  {0x2F, 0x03, 0x08}, /* Index 192 (C0) */
  {0x02, 0x18, 0x39}, /* Index 193 (C1) */
  {0x0F, 0x31, 0x1E}, /* Index 194 (C2) */
  {0x24, 0x0C, 0x03}, /* Index 195 (C3) */
  {0x04, 0x1A, 0x04}, /* Index 196 (C4) */
  {0x30, 0x33, 0x04}, /* Index 197 (C5) */
  {0x2C, 0x18, 0x36}, /* Index 198 (C6) */
  {0x18, 0x2F, 0x09}, /* Index 199 (C7) */
  {0x03, 0x04, 0x03}, /* Index 200 (C8) */
  {0x22, 0x05, 0x10}, /* Index 201 (C9) */
  {0x03, 0x24, 0x0A}, /* Index 202 (CA) */
  {0x00, 0x1E, 0x1A}, /* Index 203 (CB) */
  {0x00, 0x0A, 0x11}, /* Index 204 (CC) */
  {0x0E, 0x1F, 0x09}, /* Index 205 (CD) */
  {0x1B, 0x3A, 0x3B}, /* Index 206 (CE) */
  {0x22, 0x39, 0x36}, /* Index 207 (CF) */
  {0x22, 0x10, 0x23}, /* Index 208 (D0) */
  {0x31, 0x14, 0x2B}, /* Index 209 (D1) */
  {0x0C, 0x33, 0x35}, /* Index 210 (D2) */
  {0x27, 0x3E, 0x10}, /* Index 211 (D3) */
  {0x10, 0x04, 0x30}, /* Index 212 (D4) */
  {0x05, 0x21, 0x0A}, /* Index 213 (D5) */
  {0x09, 0x11, 0x24}, /* Index 214 (D6) */
  {0x02, 0x2B, 0x00}, /* Index 215 (D7) */
  {0x02, 0x05, 0x15}, /* Index 216 (D8) */
  {0x11, 0x32, 0x1A}, /* Index 217 (D9) */
  {0x2E, 0x1B, 0x08}, /* Index 218 (DA) */
  {0x0D, 0x2F, 0x11}, /* Index 219 (DB) */
  {0x03, 0x30, 0x28}, /* Index 220 (DC) */
  {0x15, 0x38, 0x0A}, /* Index 221 (DD) */
  {0x07, 0x00, 0x00}, /* Index 222 (DE) */
  {0x1D, 0x1C, 0x20}, /* Index 223 (DF) */
  {0x35, 0x11, 0x35}, /* Index 224 (E0) */
  {0x24, 0x29, 0x03}, /* Index 225 (E1) */
  {0x22, 0x37, 0x39}, /* Index 226 (E2) */
  {0x11, 0x1B, 0x10}, /* Index 227 (E3) */
  {0x2D, 0x18, 0x00}, /* Index 228 (E4) */
  {0x20, 0x2F, 0x10}, /* Index 229 (E5) */
  {0x21, 0x26, 0x32}, /* Index 230 (E6) */
  {0x24, 0x10, 0x3D}, /* Index 231 (E7) */
  {0x27, 0x0E, 0x03}, /* Index 232 (E8) */
  {0x31, 0x1F, 0x11}, /* Index 233 (E9) */
  {0x16, 0x0D, 0x02}, /* Index 234 (EA) */
  {0x24, 0x12, 0x16}, /* Index 235 (EB) */
  {0x0F, 0x27, 0x18}, /* Index 236 (EC) */
  {0x10, 0x0E, 0x20}, /* Index 237 (ED) */
  {0x12, 0x0C, 0x0D}, /* Index 238 (EE) */
  {0x14, 0x38, 0x0B}, /* Index 239 (EF) */
  {0x23, 0x0C, 0x09}, /* Index 240 (F0) */
  {0x13, 0x21, 0x0E}, /* Index 241 (F1) */
  {0x2C, 0x05, 0x2C}, /* Index 242 (F2) */
  {0x08, 0x29, 0x01}, /* Index 243 (F3) */
  {0x36, 0x0A, 0x13}, /* Index 244 (F4) */
  {0x08, 0x2D, 0x26}, /* Index 245 (F5) */
  {0x23, 0x30, 0x3E}, /* Index 246 (F6) */
  {0x33, 0x00, 0x04}, /* Index 247 (F7) */
  {0x25, 0x1E, 0x3A}, /* Index 248 (F8) */
  {0x11, 0x2C, 0x26}, /* Index 249 (F9) */
  {0x20, 0x32, 0x27}, /* Index 250 (FA) */
  {0x23, 0x21, 0x13}, /* Index 251 (FB) */
  {0x22, 0x23, 0x1F}, /* Index 252 (FC) */
  {0x31, 0x08, 0x0A}, /* Index 253 (FD) */
  {0x00, 0x01, 0x09}, /* Index 254 (FE) */
  {0x17, 0x07, 0x38} /* Index 255 (FF) */
};


/***********************************************
 * 8x16 Font
 *
 * copied from file
 * drivers/video/font_8x16.c (LINUX)
 **********************************************/
/**********************************************/
/*                                            */
/*       Font file generated by cpi2fnt       */
/*                                            */
/**********************************************/

#define FONTDATAMAX 4096

unsigned char fontdata_8x16[FONTDATAMAX] = {

	/* 0 0x00 '^@' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 1 0x01 '^A' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x7e, /* 01111110 */
	0x81, /* 10000001 */
	0xa5, /* 10100101 */
	0x81, /* 10000001 */
	0x81, /* 10000001 */
	0xbd, /* 10111101 */
	0x99, /* 10011001 */
	0x81, /* 10000001 */
	0x81, /* 10000001 */
	0x7e, /* 01111110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 2 0x02 '^B' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x7e, /* 01111110 */
	0xff, /* 11111111 */
	0xdb, /* 11011011 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xc3, /* 11000011 */
	0xe7, /* 11100111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0x7e, /* 01111110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 3 0x03 '^C' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x6c, /* 01101100 */
	0xfe, /* 11111110 */
	0xfe, /* 11111110 */
	0xfe, /* 11111110 */
	0xfe, /* 11111110 */
	0x7c, /* 01111100 */
	0x38, /* 00111000 */
	0x10, /* 00010000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 4 0x04 '^D' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x10, /* 00010000 */
	0x38, /* 00111000 */
	0x7c, /* 01111100 */
	0xfe, /* 11111110 */
	0x7c, /* 01111100 */
	0x38, /* 00111000 */
	0x10, /* 00010000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 5 0x05 '^E' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x18, /* 00011000 */
	0x3c, /* 00111100 */
	0x3c, /* 00111100 */
	0xe7, /* 11100111 */
	0xe7, /* 11100111 */
	0xe7, /* 11100111 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x3c, /* 00111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 6 0x06 '^F' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x18, /* 00011000 */
	0x3c, /* 00111100 */
	0x7e, /* 01111110 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0x7e, /* 01111110 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x3c, /* 00111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 7 0x07 '^G' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x18, /* 00011000 */
	0x3c, /* 00111100 */
	0x3c, /* 00111100 */
	0x18, /* 00011000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 8 0x08 '^H' */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xe7, /* 11100111 */
	0xc3, /* 11000011 */
	0xc3, /* 11000011 */
	0xe7, /* 11100111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */

	/* 9 0x09 '^I' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x3c, /* 00111100 */
	0x66, /* 01100110 */
	0x42, /* 01000010 */
	0x42, /* 01000010 */
	0x66, /* 01100110 */
	0x3c, /* 00111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 10 0x0a '^J' */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xc3, /* 11000011 */
	0x99, /* 10011001 */
	0xbd, /* 10111101 */
	0xbd, /* 10111101 */
	0x99, /* 10011001 */
	0xc3, /* 11000011 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */

	/* 11 0x0b '^K' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x1e, /* 00011110 */
	0x0e, /* 00001110 */
	0x1a, /* 00011010 */
	0x32, /* 00110010 */
	0x78, /* 01111000 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0x78, /* 01111000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 12 0x0c '^L' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x3c, /* 00111100 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x3c, /* 00111100 */
	0x18, /* 00011000 */
	0x7e, /* 01111110 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 13 0x0d '^M' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x3f, /* 00111111 */
	0x33, /* 00110011 */
	0x3f, /* 00111111 */
	0x30, /* 00110000 */
	0x30, /* 00110000 */
	0x30, /* 00110000 */
	0x30, /* 00110000 */
	0x70, /* 01110000 */
	0xf0, /* 11110000 */
	0xe0, /* 11100000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 14 0x0e '^N' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x7f, /* 01111111 */
	0x63, /* 01100011 */
	0x7f, /* 01111111 */
	0x63, /* 01100011 */
	0x63, /* 01100011 */
	0x63, /* 01100011 */
	0x63, /* 01100011 */
	0x67, /* 01100111 */
	0xe7, /* 11100111 */
	0xe6, /* 11100110 */
	0xc0, /* 11000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 15 0x0f '^O' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0xdb, /* 11011011 */
	0x3c, /* 00111100 */
	0xe7, /* 11100111 */
	0x3c, /* 00111100 */
	0xdb, /* 11011011 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 16 0x10 '^P' */
	0x00, /* 00000000 */
	0x80, /* 10000000 */
	0xc0, /* 11000000 */
	0xe0, /* 11100000 */
	0xf0, /* 11110000 */
	0xf8, /* 11111000 */
	0xfe, /* 11111110 */
	0xf8, /* 11111000 */
	0xf0, /* 11110000 */
	0xe0, /* 11100000 */
	0xc0, /* 11000000 */
	0x80, /* 10000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 17 0x11 '^Q' */
	0x00, /* 00000000 */
	0x02, /* 00000010 */
	0x06, /* 00000110 */
	0x0e, /* 00001110 */
	0x1e, /* 00011110 */
	0x3e, /* 00111110 */
	0xfe, /* 11111110 */
	0x3e, /* 00111110 */
	0x1e, /* 00011110 */
	0x0e, /* 00001110 */
	0x06, /* 00000110 */
	0x02, /* 00000010 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 18 0x12 '^R' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x18, /* 00011000 */
	0x3c, /* 00111100 */
	0x7e, /* 01111110 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x7e, /* 01111110 */
	0x3c, /* 00111100 */
	0x18, /* 00011000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 19 0x13 '^S' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x00, /* 00000000 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 20 0x14 '^T' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x7f, /* 01111111 */
	0xdb, /* 11011011 */
	0xdb, /* 11011011 */
	0xdb, /* 11011011 */
	0x7b, /* 01111011 */
	0x1b, /* 00011011 */
	0x1b, /* 00011011 */
	0x1b, /* 00011011 */
	0x1b, /* 00011011 */
	0x1b, /* 00011011 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 21 0x15 '^U' */
	0x00, /* 00000000 */
	0x7c, /* 01111100 */
	0xc6, /* 11000110 */
	0x60, /* 01100000 */
	0x38, /* 00111000 */
	0x6c, /* 01101100 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0x6c, /* 01101100 */
	0x38, /* 00111000 */
	0x0c, /* 00001100 */
	0xc6, /* 11000110 */
	0x7c, /* 01111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 22 0x16 '^V' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xfe, /* 11111110 */
	0xfe, /* 11111110 */
	0xfe, /* 11111110 */
	0xfe, /* 11111110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 23 0x17 '^W' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x18, /* 00011000 */
	0x3c, /* 00111100 */
	0x7e, /* 01111110 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x7e, /* 01111110 */
	0x3c, /* 00111100 */
	0x18, /* 00011000 */
	0x7e, /* 01111110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 24 0x18 '^X' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x18, /* 00011000 */
	0x3c, /* 00111100 */
	0x7e, /* 01111110 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 25 0x19 '^Y' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x7e, /* 01111110 */
	0x3c, /* 00111100 */
	0x18, /* 00011000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 26 0x1a '^Z' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x18, /* 00011000 */
	0x0c, /* 00001100 */
	0xfe, /* 11111110 */
	0x0c, /* 00001100 */
	0x18, /* 00011000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 27 0x1b '^[' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x30, /* 00110000 */
	0x60, /* 01100000 */
	0xfe, /* 11111110 */
	0x60, /* 01100000 */
	0x30, /* 00110000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 28 0x1c '^\' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xc0, /* 11000000 */
	0xc0, /* 11000000 */
	0xc0, /* 11000000 */
	0xfe, /* 11111110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 29 0x1d '^]' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x28, /* 00101000 */
	0x6c, /* 01101100 */
	0xfe, /* 11111110 */
	0x6c, /* 01101100 */
	0x28, /* 00101000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 30 0x1e '^^' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x10, /* 00010000 */
	0x38, /* 00111000 */
	0x38, /* 00111000 */
	0x7c, /* 01111100 */
	0x7c, /* 01111100 */
	0xfe, /* 11111110 */
	0xfe, /* 11111110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 31 0x1f '^_' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xfe, /* 11111110 */
	0xfe, /* 11111110 */
	0x7c, /* 01111100 */
	0x7c, /* 01111100 */
	0x38, /* 00111000 */
	0x38, /* 00111000 */
	0x10, /* 00010000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 32 0x20 ' ' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 33 0x21 '!' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x18, /* 00011000 */
	0x3c, /* 00111100 */
	0x3c, /* 00111100 */
	0x3c, /* 00111100 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x00, /* 00000000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 34 0x22 '"' */
	0x00, /* 00000000 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x24, /* 00100100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 35 0x23 '#' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x6c, /* 01101100 */
	0x6c, /* 01101100 */
	0xfe, /* 11111110 */
	0x6c, /* 01101100 */
	0x6c, /* 01101100 */
	0x6c, /* 01101100 */
	0xfe, /* 11111110 */
	0x6c, /* 01101100 */
	0x6c, /* 01101100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 36 0x24 '$' */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x7c, /* 01111100 */
	0xc6, /* 11000110 */
	0xc2, /* 11000010 */
	0xc0, /* 11000000 */
	0x7c, /* 01111100 */
	0x06, /* 00000110 */
	0x06, /* 00000110 */
	0x86, /* 10000110 */
	0xc6, /* 11000110 */
	0x7c, /* 01111100 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 37 0x25 '%' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xc2, /* 11000010 */
	0xc6, /* 11000110 */
	0x0c, /* 00001100 */
	0x18, /* 00011000 */
	0x30, /* 00110000 */
	0x60, /* 01100000 */
	0xc6, /* 11000110 */
	0x86, /* 10000110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 38 0x26 '&' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x38, /* 00111000 */
	0x6c, /* 01101100 */
	0x6c, /* 01101100 */
	0x38, /* 00111000 */
	0x76, /* 01110110 */
	0xdc, /* 11011100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0x76, /* 01110110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 39 0x27 ''' */
	0x00, /* 00000000 */
	0x30, /* 00110000 */
	0x30, /* 00110000 */
	0x30, /* 00110000 */
	0x60, /* 01100000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 40 0x28 '(' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x0c, /* 00001100 */
	0x18, /* 00011000 */
	0x30, /* 00110000 */
	0x30, /* 00110000 */
	0x30, /* 00110000 */
	0x30, /* 00110000 */
	0x30, /* 00110000 */
	0x30, /* 00110000 */
	0x18, /* 00011000 */
	0x0c, /* 00001100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 41 0x29 ')' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x30, /* 00110000 */
	0x18, /* 00011000 */
	0x0c, /* 00001100 */
	0x0c, /* 00001100 */
	0x0c, /* 00001100 */
	0x0c, /* 00001100 */
	0x0c, /* 00001100 */
	0x0c, /* 00001100 */
	0x18, /* 00011000 */
	0x30, /* 00110000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 42 0x2a '*' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x66, /* 01100110 */
	0x3c, /* 00111100 */
	0xff, /* 11111111 */
	0x3c, /* 00111100 */
	0x66, /* 01100110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 43 0x2b '+' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x7e, /* 01111110 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 44 0x2c ',' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x30, /* 00110000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 45 0x2d '-' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xfe, /* 11111110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 46 0x2e '.' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 47 0x2f '/' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x02, /* 00000010 */
	0x06, /* 00000110 */
	0x0c, /* 00001100 */
	0x18, /* 00011000 */
	0x30, /* 00110000 */
	0x60, /* 01100000 */
	0xc0, /* 11000000 */
	0x80, /* 10000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 48 0x30 '0' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x38, /* 00111000 */
	0x6c, /* 01101100 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xd6, /* 11010110 */
	0xd6, /* 11010110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0x6c, /* 01101100 */
	0x38, /* 00111000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 49 0x31 '1' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x18, /* 00011000 */
	0x38, /* 00111000 */
	0x78, /* 01111000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x7e, /* 01111110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 50 0x32 '2' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x7c, /* 01111100 */
	0xc6, /* 11000110 */
	0x06, /* 00000110 */
	0x0c, /* 00001100 */
	0x18, /* 00011000 */
	0x30, /* 00110000 */
	0x60, /* 01100000 */
	0xc0, /* 11000000 */
	0xc6, /* 11000110 */
	0xfe, /* 11111110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 51 0x33 '3' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x7c, /* 01111100 */
	0xc6, /* 11000110 */
	0x06, /* 00000110 */
	0x06, /* 00000110 */
	0x3c, /* 00111100 */
	0x06, /* 00000110 */
	0x06, /* 00000110 */
	0x06, /* 00000110 */
	0xc6, /* 11000110 */
	0x7c, /* 01111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 52 0x34 '4' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x0c, /* 00001100 */
	0x1c, /* 00011100 */
	0x3c, /* 00111100 */
	0x6c, /* 01101100 */
	0xcc, /* 11001100 */
	0xfe, /* 11111110 */
	0x0c, /* 00001100 */
	0x0c, /* 00001100 */
	0x0c, /* 00001100 */
	0x1e, /* 00011110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 53 0x35 '5' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xfe, /* 11111110 */
	0xc0, /* 11000000 */
	0xc0, /* 11000000 */
	0xc0, /* 11000000 */
	0xfc, /* 11111100 */
	0x06, /* 00000110 */
	0x06, /* 00000110 */
	0x06, /* 00000110 */
	0xc6, /* 11000110 */
	0x7c, /* 01111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 54 0x36 '6' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x38, /* 00111000 */
	0x60, /* 01100000 */
	0xc0, /* 11000000 */
	0xc0, /* 11000000 */
	0xfc, /* 11111100 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0x7c, /* 01111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 55 0x37 '7' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xfe, /* 11111110 */
	0xc6, /* 11000110 */
	0x06, /* 00000110 */
	0x06, /* 00000110 */
	0x0c, /* 00001100 */
	0x18, /* 00011000 */
	0x30, /* 00110000 */
	0x30, /* 00110000 */
	0x30, /* 00110000 */
	0x30, /* 00110000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 56 0x38 '8' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x7c, /* 01111100 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0x7c, /* 01111100 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0x7c, /* 01111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 57 0x39 '9' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x7c, /* 01111100 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0x7e, /* 01111110 */
	0x06, /* 00000110 */
	0x06, /* 00000110 */
	0x06, /* 00000110 */
	0x0c, /* 00001100 */
	0x78, /* 01111000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 58 0x3a ':' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 59 0x3b ';' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x30, /* 00110000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 60 0x3c '<' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x06, /* 00000110 */
	0x0c, /* 00001100 */
	0x18, /* 00011000 */
	0x30, /* 00110000 */
	0x60, /* 01100000 */
	0x30, /* 00110000 */
	0x18, /* 00011000 */
	0x0c, /* 00001100 */
	0x06, /* 00000110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 61 0x3d '=' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x7e, /* 01111110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x7e, /* 01111110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 62 0x3e '>' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x60, /* 01100000 */
	0x30, /* 00110000 */
	0x18, /* 00011000 */
	0x0c, /* 00001100 */
	0x06, /* 00000110 */
	0x0c, /* 00001100 */
	0x18, /* 00011000 */
	0x30, /* 00110000 */
	0x60, /* 01100000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 63 0x3f '?' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x7c, /* 01111100 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0x0c, /* 00001100 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x00, /* 00000000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 64 0x40 '@' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x7c, /* 01111100 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xde, /* 11011110 */
	0xde, /* 11011110 */
	0xde, /* 11011110 */
	0xdc, /* 11011100 */
	0xc0, /* 11000000 */
	0x7c, /* 01111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 65 0x41 'A' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x10, /* 00010000 */
	0x38, /* 00111000 */
	0x6c, /* 01101100 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xfe, /* 11111110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 66 0x42 'B' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xfc, /* 11111100 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x7c, /* 01111100 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0xfc, /* 11111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 67 0x43 'C' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x3c, /* 00111100 */
	0x66, /* 01100110 */
	0xc2, /* 11000010 */
	0xc0, /* 11000000 */
	0xc0, /* 11000000 */
	0xc0, /* 11000000 */
	0xc0, /* 11000000 */
	0xc2, /* 11000010 */
	0x66, /* 01100110 */
	0x3c, /* 00111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 68 0x44 'D' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xf8, /* 11111000 */
	0x6c, /* 01101100 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x6c, /* 01101100 */
	0xf8, /* 11111000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 69 0x45 'E' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xfe, /* 11111110 */
	0x66, /* 01100110 */
	0x62, /* 01100010 */
	0x68, /* 01101000 */
	0x78, /* 01111000 */
	0x68, /* 01101000 */
	0x60, /* 01100000 */
	0x62, /* 01100010 */
	0x66, /* 01100110 */
	0xfe, /* 11111110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 70 0x46 'F' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xfe, /* 11111110 */
	0x66, /* 01100110 */
	0x62, /* 01100010 */
	0x68, /* 01101000 */
	0x78, /* 01111000 */
	0x68, /* 01101000 */
	0x60, /* 01100000 */
	0x60, /* 01100000 */
	0x60, /* 01100000 */
	0xf0, /* 11110000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 71 0x47 'G' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x3c, /* 00111100 */
	0x66, /* 01100110 */
	0xc2, /* 11000010 */
	0xc0, /* 11000000 */
	0xc0, /* 11000000 */
	0xde, /* 11011110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0x66, /* 01100110 */
	0x3a, /* 00111010 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 72 0x48 'H' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xfe, /* 11111110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 73 0x49 'I' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x3c, /* 00111100 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x3c, /* 00111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 74 0x4a 'J' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x1e, /* 00011110 */
	0x0c, /* 00001100 */
	0x0c, /* 00001100 */
	0x0c, /* 00001100 */
	0x0c, /* 00001100 */
	0x0c, /* 00001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0x78, /* 01111000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 75 0x4b 'K' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xe6, /* 11100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x6c, /* 01101100 */
	0x78, /* 01111000 */
	0x78, /* 01111000 */
	0x6c, /* 01101100 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0xe6, /* 11100110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 76 0x4c 'L' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xf0, /* 11110000 */
	0x60, /* 01100000 */
	0x60, /* 01100000 */
	0x60, /* 01100000 */
	0x60, /* 01100000 */
	0x60, /* 01100000 */
	0x60, /* 01100000 */
	0x62, /* 01100010 */
	0x66, /* 01100110 */
	0xfe, /* 11111110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 77 0x4d 'M' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xc6, /* 11000110 */
	0xee, /* 11101110 */
	0xfe, /* 11111110 */
	0xfe, /* 11111110 */
	0xd6, /* 11010110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 78 0x4e 'N' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xc6, /* 11000110 */
	0xe6, /* 11100110 */
	0xf6, /* 11110110 */
	0xfe, /* 11111110 */
	0xde, /* 11011110 */
	0xce, /* 11001110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 79 0x4f 'O' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x7c, /* 01111100 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0x7c, /* 01111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 80 0x50 'P' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xfc, /* 11111100 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x7c, /* 01111100 */
	0x60, /* 01100000 */
	0x60, /* 01100000 */
	0x60, /* 01100000 */
	0x60, /* 01100000 */
	0xf0, /* 11110000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 81 0x51 'Q' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x7c, /* 01111100 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xd6, /* 11010110 */
	0xde, /* 11011110 */
	0x7c, /* 01111100 */
	0x0c, /* 00001100 */
	0x0e, /* 00001110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 82 0x52 'R' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xfc, /* 11111100 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x7c, /* 01111100 */
	0x6c, /* 01101100 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0xe6, /* 11100110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 83 0x53 'S' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x7c, /* 01111100 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0x60, /* 01100000 */
	0x38, /* 00111000 */
	0x0c, /* 00001100 */
	0x06, /* 00000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0x7c, /* 01111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 84 0x54 'T' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x7e, /* 01111110 */
	0x7e, /* 01111110 */
	0x5a, /* 01011010 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x3c, /* 00111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 85 0x55 'U' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0x7c, /* 01111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 86 0x56 'V' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0x6c, /* 01101100 */
	0x38, /* 00111000 */
	0x10, /* 00010000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 87 0x57 'W' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xd6, /* 11010110 */
	0xd6, /* 11010110 */
	0xd6, /* 11010110 */
	0xfe, /* 11111110 */
	0xee, /* 11101110 */
	0x6c, /* 01101100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 88 0x58 'X' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0x6c, /* 01101100 */
	0x7c, /* 01111100 */
	0x38, /* 00111000 */
	0x38, /* 00111000 */
	0x7c, /* 01111100 */
	0x6c, /* 01101100 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 89 0x59 'Y' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x3c, /* 00111100 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x3c, /* 00111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 90 0x5a 'Z' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xfe, /* 11111110 */
	0xc6, /* 11000110 */
	0x86, /* 10000110 */
	0x0c, /* 00001100 */
	0x18, /* 00011000 */
	0x30, /* 00110000 */
	0x60, /* 01100000 */
	0xc2, /* 11000010 */
	0xc6, /* 11000110 */
	0xfe, /* 11111110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 91 0x5b '[' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x3c, /* 00111100 */
	0x30, /* 00110000 */
	0x30, /* 00110000 */
	0x30, /* 00110000 */
	0x30, /* 00110000 */
	0x30, /* 00110000 */
	0x30, /* 00110000 */
	0x30, /* 00110000 */
	0x30, /* 00110000 */
	0x3c, /* 00111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 92 0x5c '\' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x80, /* 10000000 */
	0xc0, /* 11000000 */
	0xe0, /* 11100000 */
	0x70, /* 01110000 */
	0x38, /* 00111000 */
	0x1c, /* 00011100 */
	0x0e, /* 00001110 */
	0x06, /* 00000110 */
	0x02, /* 00000010 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 93 0x5d ']' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x3c, /* 00111100 */
	0x0c, /* 00001100 */
	0x0c, /* 00001100 */
	0x0c, /* 00001100 */
	0x0c, /* 00001100 */
	0x0c, /* 00001100 */
	0x0c, /* 00001100 */
	0x0c, /* 00001100 */
	0x0c, /* 00001100 */
	0x3c, /* 00111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 94 0x5e '^' */
	0x10, /* 00010000 */
	0x38, /* 00111000 */
	0x6c, /* 01101100 */
	0xc6, /* 11000110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 95 0x5f '_' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xff, /* 11111111 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 96 0x60 '`' */
	0x00, /* 00000000 */
	0x30, /* 00110000 */
	0x18, /* 00011000 */
	0x0c, /* 00001100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 97 0x61 'a' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x78, /* 01111000 */
	0x0c, /* 00001100 */
	0x7c, /* 01111100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0x76, /* 01110110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 98 0x62 'b' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xe0, /* 11100000 */
	0x60, /* 01100000 */
	0x60, /* 01100000 */
	0x78, /* 01111000 */
	0x6c, /* 01101100 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x7c, /* 01111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 99 0x63 'c' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x7c, /* 01111100 */
	0xc6, /* 11000110 */
	0xc0, /* 11000000 */
	0xc0, /* 11000000 */
	0xc0, /* 11000000 */
	0xc6, /* 11000110 */
	0x7c, /* 01111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 100 0x64 'd' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x1c, /* 00011100 */
	0x0c, /* 00001100 */
	0x0c, /* 00001100 */
	0x3c, /* 00111100 */
	0x6c, /* 01101100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0x76, /* 01110110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 101 0x65 'e' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x7c, /* 01111100 */
	0xc6, /* 11000110 */
	0xfe, /* 11111110 */
	0xc0, /* 11000000 */
	0xc0, /* 11000000 */
	0xc6, /* 11000110 */
	0x7c, /* 01111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 102 0x66 'f' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x1c, /* 00011100 */
	0x36, /* 00110110 */
	0x32, /* 00110010 */
	0x30, /* 00110000 */
	0x78, /* 01111000 */
	0x30, /* 00110000 */
	0x30, /* 00110000 */
	0x30, /* 00110000 */
	0x30, /* 00110000 */
	0x78, /* 01111000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 103 0x67 'g' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x76, /* 01110110 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0x7c, /* 01111100 */
	0x0c, /* 00001100 */
	0xcc, /* 11001100 */
	0x78, /* 01111000 */
	0x00, /* 00000000 */

	/* 104 0x68 'h' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xe0, /* 11100000 */
	0x60, /* 01100000 */
	0x60, /* 01100000 */
	0x6c, /* 01101100 */
	0x76, /* 01110110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0xe6, /* 11100110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 105 0x69 'i' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x00, /* 00000000 */
	0x38, /* 00111000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x3c, /* 00111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 106 0x6a 'j' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x06, /* 00000110 */
	0x06, /* 00000110 */
	0x00, /* 00000000 */
	0x0e, /* 00001110 */
	0x06, /* 00000110 */
	0x06, /* 00000110 */
	0x06, /* 00000110 */
	0x06, /* 00000110 */
	0x06, /* 00000110 */
	0x06, /* 00000110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x3c, /* 00111100 */
	0x00, /* 00000000 */

	/* 107 0x6b 'k' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xe0, /* 11100000 */
	0x60, /* 01100000 */
	0x60, /* 01100000 */
	0x66, /* 01100110 */
	0x6c, /* 01101100 */
	0x78, /* 01111000 */
	0x78, /* 01111000 */
	0x6c, /* 01101100 */
	0x66, /* 01100110 */
	0xe6, /* 11100110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 108 0x6c 'l' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x38, /* 00111000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x3c, /* 00111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 109 0x6d 'm' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xec, /* 11101100 */
	0xfe, /* 11111110 */
	0xd6, /* 11010110 */
	0xd6, /* 11010110 */
	0xd6, /* 11010110 */
	0xd6, /* 11010110 */
	0xc6, /* 11000110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 110 0x6e 'n' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xdc, /* 11011100 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 111 0x6f 'o' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x7c, /* 01111100 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0x7c, /* 01111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 112 0x70 'p' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xdc, /* 11011100 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x7c, /* 01111100 */
	0x60, /* 01100000 */
	0x60, /* 01100000 */
	0xf0, /* 11110000 */
	0x00, /* 00000000 */

	/* 113 0x71 'q' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x76, /* 01110110 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0x7c, /* 01111100 */
	0x0c, /* 00001100 */
	0x0c, /* 00001100 */
	0x1e, /* 00011110 */
	0x00, /* 00000000 */

	/* 114 0x72 'r' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xdc, /* 11011100 */
	0x76, /* 01110110 */
	0x66, /* 01100110 */
	0x60, /* 01100000 */
	0x60, /* 01100000 */
	0x60, /* 01100000 */
	0xf0, /* 11110000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 115 0x73 's' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x7c, /* 01111100 */
	0xc6, /* 11000110 */
	0x60, /* 01100000 */
	0x38, /* 00111000 */
	0x0c, /* 00001100 */
	0xc6, /* 11000110 */
	0x7c, /* 01111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 116 0x74 't' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x10, /* 00010000 */
	0x30, /* 00110000 */
	0x30, /* 00110000 */
	0xfc, /* 11111100 */
	0x30, /* 00110000 */
	0x30, /* 00110000 */
	0x30, /* 00110000 */
	0x30, /* 00110000 */
	0x36, /* 00110110 */
	0x1c, /* 00011100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 117 0x75 'u' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0x76, /* 01110110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 118 0x76 'v' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0x6c, /* 01101100 */
	0x38, /* 00111000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 119 0x77 'w' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xd6, /* 11010110 */
	0xd6, /* 11010110 */
	0xd6, /* 11010110 */
	0xfe, /* 11111110 */
	0x6c, /* 01101100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 120 0x78 'x' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xc6, /* 11000110 */
	0x6c, /* 01101100 */
	0x38, /* 00111000 */
	0x38, /* 00111000 */
	0x38, /* 00111000 */
	0x6c, /* 01101100 */
	0xc6, /* 11000110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 121 0x79 'y' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0x7e, /* 01111110 */
	0x06, /* 00000110 */
	0x0c, /* 00001100 */
	0xf8, /* 11111000 */
	0x00, /* 00000000 */

	/* 122 0x7a 'z' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xfe, /* 11111110 */
	0xcc, /* 11001100 */
	0x18, /* 00011000 */
	0x30, /* 00110000 */
	0x60, /* 01100000 */
	0xc6, /* 11000110 */
	0xfe, /* 11111110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 123 0x7b '{' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x0e, /* 00001110 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x70, /* 01110000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x0e, /* 00001110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 124 0x7c '|' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 125 0x7d '}' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x70, /* 01110000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x0e, /* 00001110 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x70, /* 01110000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 126 0x7e '~' */
	0x00, /* 00000000 */
	0x76, /* 01110110 */
	0xdc, /* 11011100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 127 0x7f '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x10, /* 00010000 */
	0x38, /* 00111000 */
	0x6c, /* 01101100 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xfe, /* 11111110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 128 0x80 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x3c, /* 00111100 */
	0x66, /* 01100110 */
	0xc2, /* 11000010 */
	0xc0, /* 11000000 */
	0xc0, /* 11000000 */
	0xc0, /* 11000000 */
	0xc0, /* 11000000 */
	0xc2, /* 11000010 */
	0x66, /* 01100110 */
	0x3c, /* 00111100 */
	0x18, /* 00011000 */
	0x70, /* 01110000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 129 0x81 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xcc, /* 11001100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0x76, /* 01110110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 130 0x82 '' */
	0x00, /* 00000000 */
	0x0c, /* 00001100 */
	0x18, /* 00011000 */
	0x30, /* 00110000 */
	0x00, /* 00000000 */
	0x7c, /* 01111100 */
	0xc6, /* 11000110 */
	0xfe, /* 11111110 */
	0xc0, /* 11000000 */
	0xc0, /* 11000000 */
	0xc6, /* 11000110 */
	0x7c, /* 01111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 131 0x83 '' */
	0x00, /* 00000000 */
	0x10, /* 00010000 */
	0x38, /* 00111000 */
	0x6c, /* 01101100 */
	0x00, /* 00000000 */
	0x78, /* 01111000 */
	0x0c, /* 00001100 */
	0x7c, /* 01111100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0x76, /* 01110110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 132 0x84 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xcc, /* 11001100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x78, /* 01111000 */
	0x0c, /* 00001100 */
	0x7c, /* 01111100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0x76, /* 01110110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 133 0x85 '' */
	0x00, /* 00000000 */
	0x60, /* 01100000 */
	0x30, /* 00110000 */
	0x18, /* 00011000 */
	0x00, /* 00000000 */
	0x78, /* 01111000 */
	0x0c, /* 00001100 */
	0x7c, /* 01111100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0x76, /* 01110110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 134 0x86 '' */
	0x00, /* 00000000 */
	0x38, /* 00111000 */
	0x6c, /* 01101100 */
	0x38, /* 00111000 */
	0x00, /* 00000000 */
	0x78, /* 01111000 */
	0x0c, /* 00001100 */
	0x7c, /* 01111100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0x76, /* 01110110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 135 0x87 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x7c, /* 01111100 */
	0xc6, /* 11000110 */
	0xc0, /* 11000000 */
	0xc0, /* 11000000 */
	0xc0, /* 11000000 */
	0xc6, /* 11000110 */
	0x7c, /* 01111100 */
	0x18, /* 00011000 */
	0x70, /* 01110000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 136 0x88 '' */
	0x00, /* 00000000 */
	0x10, /* 00010000 */
	0x38, /* 00111000 */
	0x6c, /* 01101100 */
	0x00, /* 00000000 */
	0x7c, /* 01111100 */
	0xc6, /* 11000110 */
	0xfe, /* 11111110 */
	0xc0, /* 11000000 */
	0xc0, /* 11000000 */
	0xc6, /* 11000110 */
	0x7c, /* 01111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 137 0x89 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xc6, /* 11000110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x7c, /* 01111100 */
	0xc6, /* 11000110 */
	0xfe, /* 11111110 */
	0xc0, /* 11000000 */
	0xc0, /* 11000000 */
	0xc6, /* 11000110 */
	0x7c, /* 01111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 138 0x8a '' */
	0x00, /* 00000000 */
	0x60, /* 01100000 */
	0x30, /* 00110000 */
	0x18, /* 00011000 */
	0x00, /* 00000000 */
	0x7c, /* 01111100 */
	0xc6, /* 11000110 */
	0xfe, /* 11111110 */
	0xc0, /* 11000000 */
	0xc0, /* 11000000 */
	0xc6, /* 11000110 */
	0x7c, /* 01111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 139 0x8b '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x66, /* 01100110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x38, /* 00111000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x3c, /* 00111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 140 0x8c '' */
	0x00, /* 00000000 */
	0x18, /* 00011000 */
	0x3c, /* 00111100 */
	0x66, /* 01100110 */
	0x00, /* 00000000 */
	0x38, /* 00111000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x3c, /* 00111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 141 0x8d '' */
	0x00, /* 00000000 */
	0x60, /* 01100000 */
	0x30, /* 00110000 */
	0x18, /* 00011000 */
	0x00, /* 00000000 */
	0x38, /* 00111000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x3c, /* 00111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 142 0x8e '' */
	0x00, /* 00000000 */
	0xc6, /* 11000110 */
	0x00, /* 00000000 */
	0x10, /* 00010000 */
	0x38, /* 00111000 */
	0x6c, /* 01101100 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xfe, /* 11111110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 143 0x8f '' */
	0x38, /* 00111000 */
	0x6c, /* 01101100 */
	0x38, /* 00111000 */
	0x10, /* 00010000 */
	0x38, /* 00111000 */
	0x6c, /* 01101100 */
	0xc6, /* 11000110 */
	0xfe, /* 11111110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 144 0x90 '' */
	0x0c, /* 00001100 */
	0x18, /* 00011000 */
	0x00, /* 00000000 */
	0xfe, /* 11111110 */
	0x66, /* 01100110 */
	0x62, /* 01100010 */
	0x68, /* 01101000 */
	0x78, /* 01111000 */
	0x68, /* 01101000 */
	0x62, /* 01100010 */
	0x66, /* 01100110 */
	0xfe, /* 11111110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 145 0x91 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xec, /* 11101100 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x7e, /* 01111110 */
	0xd8, /* 11011000 */
	0xd8, /* 11011000 */
	0x6e, /* 01101110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 146 0x92 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x3e, /* 00111110 */
	0x6c, /* 01101100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xfe, /* 11111110 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xce, /* 11001110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 147 0x93 '' */
	0x00, /* 00000000 */
	0x10, /* 00010000 */
	0x38, /* 00111000 */
	0x6c, /* 01101100 */
	0x00, /* 00000000 */
	0x7c, /* 01111100 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0x7c, /* 01111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 148 0x94 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xc6, /* 11000110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x7c, /* 01111100 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0x7c, /* 01111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 149 0x95 '' */
	0x00, /* 00000000 */
	0x60, /* 01100000 */
	0x30, /* 00110000 */
	0x18, /* 00011000 */
	0x00, /* 00000000 */
	0x7c, /* 01111100 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0x7c, /* 01111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 150 0x96 '' */
	0x00, /* 00000000 */
	0x30, /* 00110000 */
	0x78, /* 01111000 */
	0xcc, /* 11001100 */
	0x00, /* 00000000 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0x76, /* 01110110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 151 0x97 '' */
	0x00, /* 00000000 */
	0x60, /* 01100000 */
	0x30, /* 00110000 */
	0x18, /* 00011000 */
	0x00, /* 00000000 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0x76, /* 01110110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 152 0x98 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xc6, /* 11000110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0x7e, /* 01111110 */
	0x06, /* 00000110 */
	0x0c, /* 00001100 */
	0x78, /* 01111000 */
	0x00, /* 00000000 */

	/* 153 0x99 '' */
	0x00, /* 00000000 */
	0xc6, /* 11000110 */
	0x00, /* 00000000 */
	0x7c, /* 01111100 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0x7c, /* 01111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 154 0x9a '' */
	0x00, /* 00000000 */
	0xc6, /* 11000110 */
	0x00, /* 00000000 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0x7c, /* 01111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 155 0x9b '' */
	0x00, /* 00000000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x7c, /* 01111100 */
	0xc6, /* 11000110 */
	0xc0, /* 11000000 */
	0xc0, /* 11000000 */
	0xc0, /* 11000000 */
	0xc6, /* 11000110 */
	0x7c, /* 01111100 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 156 0x9c '' */
	0x00, /* 00000000 */
	0x38, /* 00111000 */
	0x6c, /* 01101100 */
	0x64, /* 01100100 */
	0x60, /* 01100000 */
	0xf0, /* 11110000 */
	0x60, /* 01100000 */
	0x60, /* 01100000 */
	0x60, /* 01100000 */
	0x60, /* 01100000 */
	0xe6, /* 11100110 */
	0xfc, /* 11111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 157 0x9d '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x3c, /* 00111100 */
	0x18, /* 00011000 */
	0x7e, /* 01111110 */
	0x18, /* 00011000 */
	0x7e, /* 01111110 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 158 0x9e '' */
	0x00, /* 00000000 */
	0xf8, /* 11111000 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xf8, /* 11111000 */
	0xc4, /* 11000100 */
	0xcc, /* 11001100 */
	0xde, /* 11011110 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xc6, /* 11000110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 159 0x9f '' */
	0x00, /* 00000000 */
	0x0e, /* 00001110 */
	0x1b, /* 00011011 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x7e, /* 01111110 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0xd8, /* 11011000 */
	0x70, /* 01110000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 160 0xa0 '' */
	0x00, /* 00000000 */
	0x18, /* 00011000 */
	0x30, /* 00110000 */
	0x60, /* 01100000 */
	0x00, /* 00000000 */
	0x78, /* 01111000 */
	0x0c, /* 00001100 */
	0x7c, /* 01111100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0x76, /* 01110110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 161 0xa1 '' */
	0x00, /* 00000000 */
	0x0c, /* 00001100 */
	0x18, /* 00011000 */
	0x30, /* 00110000 */
	0x00, /* 00000000 */
	0x38, /* 00111000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x3c, /* 00111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 162 0xa2 '' */
	0x00, /* 00000000 */
	0x18, /* 00011000 */
	0x30, /* 00110000 */
	0x60, /* 01100000 */
	0x00, /* 00000000 */
	0x7c, /* 01111100 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0x7c, /* 01111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 163 0xa3 '' */
	0x00, /* 00000000 */
	0x18, /* 00011000 */
	0x30, /* 00110000 */
	0x60, /* 01100000 */
	0x00, /* 00000000 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0x76, /* 01110110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 164 0xa4 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x76, /* 01110110 */
	0xdc, /* 11011100 */
	0x00, /* 00000000 */
	0xdc, /* 11011100 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 165 0xa5 '' */
	0x76, /* 01110110 */
	0xdc, /* 11011100 */
	0x00, /* 00000000 */
	0xc6, /* 11000110 */
	0xe6, /* 11100110 */
	0xf6, /* 11110110 */
	0xfe, /* 11111110 */
	0xde, /* 11011110 */
	0xce, /* 11001110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 166 0xa6 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x3c, /* 00111100 */
	0x6c, /* 01101100 */
	0x6c, /* 01101100 */
	0x3e, /* 00111110 */
	0x00, /* 00000000 */
	0x7e, /* 01111110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 167 0xa7 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x38, /* 00111000 */
	0x6c, /* 01101100 */
	0x6c, /* 01101100 */
	0x38, /* 00111000 */
	0x00, /* 00000000 */
	0x7c, /* 01111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 168 0xa8 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x30, /* 00110000 */
	0x30, /* 00110000 */
	0x00, /* 00000000 */
	0x30, /* 00110000 */
	0x30, /* 00110000 */
	0x60, /* 01100000 */
	0xc0, /* 11000000 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0x7c, /* 01111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 169 0xa9 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xfe, /* 11111110 */
	0xc0, /* 11000000 */
	0xc0, /* 11000000 */
	0xc0, /* 11000000 */
	0xc0, /* 11000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 170 0xaa '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xfe, /* 11111110 */
	0x06, /* 00000110 */
	0x06, /* 00000110 */
	0x06, /* 00000110 */
	0x06, /* 00000110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 171 0xab '' */
	0x00, /* 00000000 */
	0x60, /* 01100000 */
	0xe0, /* 11100000 */
	0x62, /* 01100010 */
	0x66, /* 01100110 */
	0x6c, /* 01101100 */
	0x18, /* 00011000 */
	0x30, /* 00110000 */
	0x60, /* 01100000 */
	0xdc, /* 11011100 */
	0x86, /* 10000110 */
	0x0c, /* 00001100 */
	0x18, /* 00011000 */
	0x3e, /* 00111110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 172 0xac '' */
	0x00, /* 00000000 */
	0x60, /* 01100000 */
	0xe0, /* 11100000 */
	0x62, /* 01100010 */
	0x66, /* 01100110 */
	0x6c, /* 01101100 */
	0x18, /* 00011000 */
	0x30, /* 00110000 */
	0x66, /* 01100110 */
	0xce, /* 11001110 */
	0x9a, /* 10011010 */
	0x3f, /* 00111111 */
	0x06, /* 00000110 */
	0x06, /* 00000110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 173 0xad '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x00, /* 00000000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x3c, /* 00111100 */
	0x3c, /* 00111100 */
	0x3c, /* 00111100 */
	0x18, /* 00011000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 174 0xae '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x36, /* 00110110 */
	0x6c, /* 01101100 */
	0xd8, /* 11011000 */
	0x6c, /* 01101100 */
	0x36, /* 00110110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 175 0xaf '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xd8, /* 11011000 */
	0x6c, /* 01101100 */
	0x36, /* 00110110 */
	0x6c, /* 01101100 */
	0xd8, /* 11011000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 176 0xb0 '' */
	0x11, /* 00010001 */
	0x44, /* 01000100 */
	0x11, /* 00010001 */
	0x44, /* 01000100 */
	0x11, /* 00010001 */
	0x44, /* 01000100 */
	0x11, /* 00010001 */
	0x44, /* 01000100 */
	0x11, /* 00010001 */
	0x44, /* 01000100 */
	0x11, /* 00010001 */
	0x44, /* 01000100 */
	0x11, /* 00010001 */
	0x44, /* 01000100 */
	0x11, /* 00010001 */
	0x44, /* 01000100 */

	/* 177 0xb1 '' */
	0x55, /* 01010101 */
	0xaa, /* 10101010 */
	0x55, /* 01010101 */
	0xaa, /* 10101010 */
	0x55, /* 01010101 */
	0xaa, /* 10101010 */
	0x55, /* 01010101 */
	0xaa, /* 10101010 */
	0x55, /* 01010101 */
	0xaa, /* 10101010 */
	0x55, /* 01010101 */
	0xaa, /* 10101010 */
	0x55, /* 01010101 */
	0xaa, /* 10101010 */
	0x55, /* 01010101 */
	0xaa, /* 10101010 */

	/* 178 0xb2 '' */
	0xdd, /* 11011101 */
	0x77, /* 01110111 */
	0xdd, /* 11011101 */
	0x77, /* 01110111 */
	0xdd, /* 11011101 */
	0x77, /* 01110111 */
	0xdd, /* 11011101 */
	0x77, /* 01110111 */
	0xdd, /* 11011101 */
	0x77, /* 01110111 */
	0xdd, /* 11011101 */
	0x77, /* 01110111 */
	0xdd, /* 11011101 */
	0x77, /* 01110111 */
	0xdd, /* 11011101 */
	0x77, /* 01110111 */

	/* 179 0xb3 '' */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */

	/* 180 0xb4 '' */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0xf8, /* 11111000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */

	/* 181 0xb5 '' */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0xf8, /* 11111000 */
	0x18, /* 00011000 */
	0xf8, /* 11111000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */

	/* 182 0xb6 '' */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0xf6, /* 11110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */

	/* 183 0xb7 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xfe, /* 11111110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */

	/* 184 0xb8 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xf8, /* 11111000 */
	0x18, /* 00011000 */
	0xf8, /* 11111000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */

	/* 185 0xb9 '' */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0xf6, /* 11110110 */
	0x06, /* 00000110 */
	0xf6, /* 11110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */

	/* 186 0xba '' */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */

	/* 187 0xbb '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xfe, /* 11111110 */
	0x06, /* 00000110 */
	0xf6, /* 11110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */

	/* 188 0xbc '' */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0xf6, /* 11110110 */
	0x06, /* 00000110 */
	0xfe, /* 11111110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 189 0xbd '' */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0xfe, /* 11111110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 190 0xbe '' */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0xf8, /* 11111000 */
	0x18, /* 00011000 */
	0xf8, /* 11111000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 191 0xbf '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xf8, /* 11111000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */

	/* 192 0xc0 '' */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x1f, /* 00011111 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 193 0xc1 '' */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0xff, /* 11111111 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 194 0xc2 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xff, /* 11111111 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */

	/* 195 0xc3 '' */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x1f, /* 00011111 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */

	/* 196 0xc4 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xff, /* 11111111 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 197 0xc5 '' */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0xff, /* 11111111 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */

	/* 198 0xc6 '' */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x1f, /* 00011111 */
	0x18, /* 00011000 */
	0x1f, /* 00011111 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */

	/* 199 0xc7 '' */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x37, /* 00110111 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */

	/* 200 0xc8 '' */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x37, /* 00110111 */
	0x30, /* 00110000 */
	0x3f, /* 00111111 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 201 0xc9 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x3f, /* 00111111 */
	0x30, /* 00110000 */
	0x37, /* 00110111 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */

	/* 202 0xca '' */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0xf7, /* 11110111 */
	0x00, /* 00000000 */
	0xff, /* 11111111 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 203 0xcb '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xff, /* 11111111 */
	0x00, /* 00000000 */
	0xf7, /* 11110111 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */

	/* 204 0xcc '' */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x37, /* 00110111 */
	0x30, /* 00110000 */
	0x37, /* 00110111 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */

	/* 205 0xcd '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xff, /* 11111111 */
	0x00, /* 00000000 */
	0xff, /* 11111111 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 206 0xce '' */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0xf7, /* 11110111 */
	0x00, /* 00000000 */
	0xf7, /* 11110111 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */

	/* 207 0xcf '' */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0xff, /* 11111111 */
	0x00, /* 00000000 */
	0xff, /* 11111111 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 208 0xd0 '' */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0xff, /* 11111111 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 209 0xd1 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xff, /* 11111111 */
	0x00, /* 00000000 */
	0xff, /* 11111111 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */

	/* 210 0xd2 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xff, /* 11111111 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */

	/* 211 0xd3 '' */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x3f, /* 00111111 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 212 0xd4 '' */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x1f, /* 00011111 */
	0x18, /* 00011000 */
	0x1f, /* 00011111 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 213 0xd5 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x1f, /* 00011111 */
	0x18, /* 00011000 */
	0x1f, /* 00011111 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */

	/* 214 0xd6 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x3f, /* 00111111 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */

	/* 215 0xd7 '' */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0xff, /* 11111111 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */

	/* 216 0xd8 '' */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0xff, /* 11111111 */
	0x18, /* 00011000 */
	0xff, /* 11111111 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */

	/* 217 0xd9 '' */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0xf8, /* 11111000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 218 0xda '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x1f, /* 00011111 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */

	/* 219 0xdb '' */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */

	/* 220 0xdc '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */

	/* 221 0xdd '' */
	0xf0, /* 11110000 */
	0xf0, /* 11110000 */
	0xf0, /* 11110000 */
	0xf0, /* 11110000 */
	0xf0, /* 11110000 */
	0xf0, /* 11110000 */
	0xf0, /* 11110000 */
	0xf0, /* 11110000 */
	0xf0, /* 11110000 */
	0xf0, /* 11110000 */
	0xf0, /* 11110000 */
	0xf0, /* 11110000 */
	0xf0, /* 11110000 */
	0xf0, /* 11110000 */
	0xf0, /* 11110000 */
	0xf0, /* 11110000 */

	/* 222 0xde '' */
	0x0f, /* 00001111 */
	0x0f, /* 00001111 */
	0x0f, /* 00001111 */
	0x0f, /* 00001111 */
	0x0f, /* 00001111 */
	0x0f, /* 00001111 */
	0x0f, /* 00001111 */
	0x0f, /* 00001111 */
	0x0f, /* 00001111 */
	0x0f, /* 00001111 */
	0x0f, /* 00001111 */
	0x0f, /* 00001111 */
	0x0f, /* 00001111 */
	0x0f, /* 00001111 */
	0x0f, /* 00001111 */
	0x0f, /* 00001111 */

	/* 223 0xdf '' */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0xff, /* 11111111 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 224 0xe0 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x76, /* 01110110 */
	0xdc, /* 11011100 */
	0xd8, /* 11011000 */
	0xd8, /* 11011000 */
	0xd8, /* 11011000 */
	0xdc, /* 11011100 */
	0x76, /* 01110110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 225 0xe1 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x78, /* 01111000 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xcc, /* 11001100 */
	0xd8, /* 11011000 */
	0xcc, /* 11001100 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xcc, /* 11001100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 226 0xe2 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xfe, /* 11111110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc0, /* 11000000 */
	0xc0, /* 11000000 */
	0xc0, /* 11000000 */
	0xc0, /* 11000000 */
	0xc0, /* 11000000 */
	0xc0, /* 11000000 */
	0xc0, /* 11000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 227 0xe3 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xfe, /* 11111110 */
	0x6c, /* 01101100 */
	0x6c, /* 01101100 */
	0x6c, /* 01101100 */
	0x6c, /* 01101100 */
	0x6c, /* 01101100 */
	0x6c, /* 01101100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 228 0xe4 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xfe, /* 11111110 */
	0xc6, /* 11000110 */
	0x60, /* 01100000 */
	0x30, /* 00110000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x30, /* 00110000 */
	0x60, /* 01100000 */
	0xc6, /* 11000110 */
	0xfe, /* 11111110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 229 0xe5 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x7e, /* 01111110 */
	0xd8, /* 11011000 */
	0xd8, /* 11011000 */
	0xd8, /* 11011000 */
	0xd8, /* 11011000 */
	0xd8, /* 11011000 */
	0x70, /* 01110000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 230 0xe6 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x7c, /* 01111100 */
	0x60, /* 01100000 */
	0x60, /* 01100000 */
	0xc0, /* 11000000 */
	0x00, /* 00000000 */

	/* 231 0xe7 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x76, /* 01110110 */
	0xdc, /* 11011100 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 232 0xe8 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x7e, /* 01111110 */
	0x18, /* 00011000 */
	0x3c, /* 00111100 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x3c, /* 00111100 */
	0x18, /* 00011000 */
	0x7e, /* 01111110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 233 0xe9 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x38, /* 00111000 */
	0x6c, /* 01101100 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xfe, /* 11111110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0x6c, /* 01101100 */
	0x38, /* 00111000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 234 0xea '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x38, /* 00111000 */
	0x6c, /* 01101100 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0x6c, /* 01101100 */
	0x6c, /* 01101100 */
	0x6c, /* 01101100 */
	0x6c, /* 01101100 */
	0xee, /* 11101110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 235 0xeb '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x1e, /* 00011110 */
	0x30, /* 00110000 */
	0x18, /* 00011000 */
	0x0c, /* 00001100 */
	0x3e, /* 00111110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x66, /* 01100110 */
	0x3c, /* 00111100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 236 0xec '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x7e, /* 01111110 */
	0xdb, /* 11011011 */
	0xdb, /* 11011011 */
	0xdb, /* 11011011 */
	0x7e, /* 01111110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 237 0xed '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x03, /* 00000011 */
	0x06, /* 00000110 */
	0x7e, /* 01111110 */
	0xdb, /* 11011011 */
	0xdb, /* 11011011 */
	0xf3, /* 11110011 */
	0x7e, /* 01111110 */
	0x60, /* 01100000 */
	0xc0, /* 11000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 238 0xee '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x1c, /* 00011100 */
	0x30, /* 00110000 */
	0x60, /* 01100000 */
	0x60, /* 01100000 */
	0x7c, /* 01111100 */
	0x60, /* 01100000 */
	0x60, /* 01100000 */
	0x60, /* 01100000 */
	0x30, /* 00110000 */
	0x1c, /* 00011100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 239 0xef '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x7c, /* 01111100 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0xc6, /* 11000110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 240 0xf0 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xfe, /* 11111110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xfe, /* 11111110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0xfe, /* 11111110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 241 0xf1 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x7e, /* 01111110 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x7e, /* 01111110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 242 0xf2 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x30, /* 00110000 */
	0x18, /* 00011000 */
	0x0c, /* 00001100 */
	0x06, /* 00000110 */
	0x0c, /* 00001100 */
	0x18, /* 00011000 */
	0x30, /* 00110000 */
	0x00, /* 00000000 */
	0x7e, /* 01111110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 243 0xf3 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x0c, /* 00001100 */
	0x18, /* 00011000 */
	0x30, /* 00110000 */
	0x60, /* 01100000 */
	0x30, /* 00110000 */
	0x18, /* 00011000 */
	0x0c, /* 00001100 */
	0x00, /* 00000000 */
	0x7e, /* 01111110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 244 0xf4 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x0e, /* 00001110 */
	0x1b, /* 00011011 */
	0x1b, /* 00011011 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */

	/* 245 0xf5 '' */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0xd8, /* 11011000 */
	0xd8, /* 11011000 */
	0xd8, /* 11011000 */
	0x70, /* 01110000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 246 0xf6 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x18, /* 00011000 */
	0x00, /* 00000000 */
	0x7e, /* 01111110 */
	0x00, /* 00000000 */
	0x18, /* 00011000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 247 0xf7 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x76, /* 01110110 */
	0xdc, /* 11011100 */
	0x00, /* 00000000 */
	0x76, /* 01110110 */
	0xdc, /* 11011100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 248 0xf8 '' */
	0x00, /* 00000000 */
	0x38, /* 00111000 */
	0x6c, /* 01101100 */
	0x6c, /* 01101100 */
	0x38, /* 00111000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 249 0xf9 '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x18, /* 00011000 */
	0x18, /* 00011000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 250 0xfa '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x18, /* 00011000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 251 0xfb '' */
	0x00, /* 00000000 */
	0x0f, /* 00001111 */
	0x0c, /* 00001100 */
	0x0c, /* 00001100 */
	0x0c, /* 00001100 */
	0x0c, /* 00001100 */
	0x0c, /* 00001100 */
	0xec, /* 11101100 */
	0x6c, /* 01101100 */
	0x6c, /* 01101100 */
	0x3c, /* 00111100 */
	0x1c, /* 00011100 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 252 0xfc '' */
	0x00, /* 00000000 */
	0x6c, /* 01101100 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x36, /* 00110110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 253 0xfd '' */
	0x00, /* 00000000 */
	0x3c, /* 00111100 */
	0x66, /* 01100110 */
	0x0c, /* 00001100 */
	0x18, /* 00011000 */
	0x32, /* 00110010 */
	0x7e, /* 01111110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 254 0xfe '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x7e, /* 01111110 */
	0x7e, /* 01111110 */
	0x7e, /* 01111110 */
	0x7e, /* 01111110 */
	0x7e, /* 01111110 */
	0x7e, /* 01111110 */
	0x7e, /* 01111110 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

	/* 255 0xff '' */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */
	0x00, /* 00000000 */

};

#endif /* #ifndef _VGA_TABLE_H */
