/*
 * (C) Copyright 2008
 * Stefan Roese, DENX Software Engineering, sr@denx.de.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <ppc4xx.h>
#include <asm/io.h>
#include <asm/processor.h>

static void wait_init_complete(void)
{
	u32 val;

	do {
		mfsdram(SDRAM_MCSTAT, val);
	} while (!(val & 0x80000000));
}

long int initdram(int board_type)
{
	/*
	 * Reset the DDR-SDRAM controller.
	 */
	mtsdr(SDR0_SRST, (0x80000000 >> 10));
	mtsdr(SDR0_SRST, 0x00000000);

	/*
	 * These values are cloned from a running NOR booting
	 * Canyonlands with SPD-DDR2 detection and calibration
	 * enabled. This will only work for the same memory
	 * configuration as used here:
	 *
	 * Crucial CT6464AC53E.4FE - 512MB SO-DIMM
	 *
	 */
	mtsdram(SDRAM_MCOPT2, 0x00000000);
	mtsdram(SDRAM_MCOPT1, 0x05322000);
	mtsdram(SDRAM_MODT0, 0x01000000);
	mtsdram(SDRAM_CODT, 0x00800021);
	mtsdram(SDRAM_WRDTR, 0x82000823);
	mtsdram(SDRAM_CLKTR, 0x40000000);
	mtsdram(SDRAM_MB0CF, 0x00000201);
	mtsdram(SDRAM_RTR, 0x06180000);
	mtsdram(SDRAM_SDTR1, 0x80201000);
	mtsdram(SDRAM_SDTR2, 0x42103243);
	mtsdram(SDRAM_SDTR3, 0x0A0D0D1A);
	mtsdram(SDRAM_MMODE, 0x00000632);
	mtsdram(SDRAM_MEMODE, 0x00000040);
	mtsdram(SDRAM_INITPLR0, 0xB5380000);
	mtsdram(SDRAM_INITPLR1, 0x82100400);
	mtsdram(SDRAM_INITPLR2, 0x80820000);
	mtsdram(SDRAM_INITPLR3, 0x80830000);
	mtsdram(SDRAM_INITPLR4, 0x80810040);
	mtsdram(SDRAM_INITPLR5, 0x80800532);
	mtsdram(SDRAM_INITPLR6, 0x82100400);
	mtsdram(SDRAM_INITPLR7, 0x8A080000);
	mtsdram(SDRAM_INITPLR8, 0x8A080000);
	mtsdram(SDRAM_INITPLR9, 0x8A080000);
	mtsdram(SDRAM_INITPLR10, 0x8A080000);
	mtsdram(SDRAM_INITPLR11, 0x80000432);
	mtsdram(SDRAM_INITPLR12, 0x808103C0);
	mtsdram(SDRAM_INITPLR13, 0x80810040);
	mtsdram(SDRAM_INITPLR14, 0x00000000);
	mtsdram(SDRAM_INITPLR15, 0x00000000);

	mtsdram(SDRAM_MCOPT2, 0x28000000);

	wait_init_complete();

	mtdcr(SDRAM_R0BAS, 0x0000F000);		/* MQ0_B0BAS */

	mtsdram(SDRAM_RDCC, 0x40000000);
	mtsdram(SDRAM_RQDC, 0x80000038);
	mtsdram(SDRAM_RFDC, 0x00000257);

	return CFG_MBYTES_SDRAM << 20;
}
