/*
 * Copyright (c) 2012-2013, NVIDIA CORPORATION. All rights reserved
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include <sys/types.h>
#include <debug.h>
#include <arch/arm.h>
#include <platform/memmap.h>
#include <platform/irqs.h>
#include <platform/platform_p.h>

#if ARM_WITH_SCU
void cpu_enable_scu(void)
{
	*(volatile uint32_t *)TEGRA_ARM_SCU_BASE = 0x1;
}

void cpu_enable_scu_access(void)
{
	/* SCU access control register */
	*(volatile uint32_t *)(TEGRA_ARM_SCU_BASE + 0x50) = 0xF;
	/* SCU NSACR */
	*(volatile uint32_t *)(TEGRA_ARM_SCU_BASE + 0x54) = 0xFFF;
}
#endif

void cpu_gic_setup(void)
{
	uint32_t gic_int_dist_sec = TEGRA_ARM_INT_DIST_BASE;
	uint32_t gic_cpu_phys_base = TEGRA_ARM_INT_CPU_BASE;

	/* DIST_IRQ_SEC */
	*(volatile uint32_t *)(gic_int_dist_sec + 128) = ~0UL;
	/* GIC_CPU_PRIMASK */
	*(volatile uint32_t *)(gic_cpu_phys_base + 4) = 0xFF;
}
