#!/usr/bin/python
# Copyright (c) 2012-2013, NVIDIA CORPORATION. All rights reserved.
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files
# (the "Software"), to deal in the Software without restriction,
# including without limitation the rights to use, copy, modify, merge,
# publish, distribute, sublicense, and/or sell copies of the Software,
# and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
# IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
# CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
# TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
# SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

import textwrap
import sys, getopt
def main(argv):
    target = ''
    try:
        opts, args = getopt.getopt(argv,"t:")
    except getopt.GetoptError:
        print "Usage: tools/tf_gen_include.py -t $(TARGET)"
        sys.exit(2)
    for opt, arg in opts:
        if opt == '-t':
            target = arg
    outdir = "./build-" + target
    binary_name = outdir + "/lk.bin"
    print "Generate LK Image Header File"
    with open(binary_name) as f:
        data = f.read()
    hexs = [hex(ord(x)) for x in data]
    text = ", ".join(hexs)
    text = '\n'.join(textwrap.wrap(text, 80))
    with open(outdir+"/tf_include.h", "w") as f:
        f.write("static const union { uint8_t content[" + str(len(data)) + "]; uint32_t force_alignment; } trusted_foundations_union = { {\n")
        f.write(text)
        f.write("} };\n")
        f.write("#define trusted_foundations trusted_foundations_union.content\n")
        f.write("#define trusted_foundations_size " + str(len(data)) + "\n")

if __name__ == "__main__":
    main(sys.argv[1:])
