/*
 * Copyright (c) 2013, NVIDIA CORPORATION. All rights reserved
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#if ARM_WITH_NEON
#include <asm.h>

/* uint32_t arm_get_vfp_fpexc(void) */
FUNCTION(arm_get_vfp_fpexc)
	mrc	p10, 7, r0, cr8, cr0, 0
	bx	lr

/* void arm_set_vfp_fpexc(uint32_t val) */
FUNCTION(arm_set_vfp_fpexc)
	mcr	p10, 7, r0, cr8, cr0, 0
	bx	lr

/* uint32_t arm_get_vfp_fpscr(void) */
FUNCTION(arm_get_vfp_fpscr)
	mrc	p10, 7, r0, cr1, cr0, 0
	bx	lr

/* void arm_set_vfp_fpscr(uint32_t val) */
FUNCTION(arm_set_vfp_fpscr)
	mcr	p10, 7, r0, cr1, cr0, 0
	bx	lr

/* void arm_save_vfp_dregs(addr_t ctxbuf) */
FUNCTION(arm_save_vfp_dregs)
	vstmia	 r0!, {d0-d15}
	mrc	 p10, 7, r1, cr7, cr0, 0	@ vmrs r1, mvfr0
	and	 r1, r1, #15
	cmp	 r1, #2				@ 32 x 64bit registers?
	vstmiaeq r0!, {d16-d31}
	bx	lr

/* void arm_restore_vfp_dregs(addr_t ctxbuf) */
FUNCTION(arm_restore_vfp_dregs)
	vldmia	 r0!, {d0-d15}
	mrc	 p10, 7, r1, cr7, cr0, 0	@ vmrs r1, mvfr0
	and	 r1, r1, #15
	cmp	 r1, #2				@ 32 x 64bit registers?
	vldmiaeq r0!, {d16-d31}
	bx	lr
#endif
