/*
 * Copyright (c) 2014, NVIDIA CORPORATION. All rights reserved
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef __PLATFORM_FUSE_H
#define __PLATFORM_FUSE_H

#include <fuse_ext.h>

/*
 * ODM_PROD          -> ODM production fuse set
 * RB_ENABLE         -> enable rollback protection feature
 * RB_KEY_PROGRAMMED -> rollback protection key has been programmed
 */
enum fuse_ids {
	FUSE_ID_ODM_PROD,
	FUSE_ID_RB_ENABLE,
	FUSE_ID_RB_KEY_PROGRAMMED,
	FUSE_ID_MAX
};

void platform_fuse_init(void);
uint32_t platform_fuse_get(enum fuse_ids fuse);

#endif
