/*
 * Copyright (c) 2013, NVIDIA CORPORATION. All rights reserved
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef __BOOT_SECONDARY_H
#define __BOOT_SECONDARY_H

#include <platform/memmap.h>
#include <platform/tzrammap.h>

#if ARM_WITH_LPAE
#include <arch/arm/mmu_ldesc_macros.h>
#else
#include <arch/arm/mmu_sdesc_macros.h>
#endif

/* copied from Travis' upstream include/asm.h */
#define FUNCTION(x) .global x; .type x,STT_FUNC; x:
#define DATA(x) .global x; .type x,STT_OBJECT; x:

#define LOCAL_FUNCTION(x) .type x,STT_FUNC; x:
#define LOCAL_DATA(x) .type x,STT_OBJECT; x:

/* returns the ID of the current processor */
.macro cpu_id, rd
	mrc	p15, 0, \rd, c0, c0, 5
	and	\rd, \rd, #0xF
.endm

/* void cpu_save_context(void) */
FUNCTION(cpu_save_context)
	/* save MMU registers */
	adr	r0, _cpu_context
	mmu_desc_save_context r0, r1, r2

	/* save CPU registers */
	mrc	p15, 0, r1, c12, c0, 0		@ VBAR
	str	r1, [r0, #0]
	mrc	p15, 0, r1, c13, c0, 3		@ TLS
	str	r1, [r0, #4]
	mrc	p15, 0, r1, c1, c0, 0		@ SCTLR
	str	r1, [r0, #8]
	dsb
	bx	lr

/* referenced within boot_secondary.S */
.macro cpu_restore_context, base, enable, tmp, tmp2
	/* restore MMU registers */
	mmu_desc_restore_context \base, \tmp, \tmp2

	/* restore CPU registers */
	ldr	\tmp, [\base, #0]
	mcr	p15, 0, \tmp, c12, c0, 0	@ VBAR
	ldr	\tmp, [\base, #4]
	mcr	p15, 0, \tmp, c13, c0, 3	@ TLS
	ldr	\tmp, [\base, #8]		@ saved SCTLR

	/* should MMU be enabled? */
	cmp	\enable, #0
	biceq	\tmp, #0x1			@ nope, clear the enable
	mcr	p15, 0, \tmp, c1, c0, 0		@ SCTLR
	isb
.endm

/* void cpu_copy_context(void *dstaddr) */
FUNCTION(cpu_copy_context)
	adr	r1, _cpu_context
	ldr	r2, =_cpu_context_end
	cmp	r1, r2
	beq	2f
1:
	/* copy data */
	ldr	r3, [r1], #4
	str	r3, [r0], #4
	cmp	r1, r2
	blt	1b
2:
	bx	lr

#define	CPU_CONTEXT_INTS	3

LOCAL_DATA(_cpu_context)
	.rept (CPU_CONTEXT_INTS + MMU_DESC_CONTEXT_INTS)
	.int   0
	.endr
LOCAL_DATA(_cpu_context_end)

#endif /*__BOOT_SECONDARY_H */
