/*
 * Copyright (c) 2014, NVIDIA CORPORATION. All rights reserved
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#include <asm.h>
#include <arch/arm.h>
#include <arm64/asm.h>
#include <lib/monitor/monitor_vector.h>

FUNCTION(monitor_fastcall)
	str	lr, [sp, #-16]!		// save NS world's LR

	/* load fastcall frame */
	stp	x6, x7, [sp, #-16]!
	stp	x4, x5, [sp, #-16]!
	stp	x2, x3, [sp, #-16]!
	stp	x0, x1, [sp, #-16]!

	/*
	 * Find index in fastcall_table. If index >= TRUSTED_BASE,
	 * route through TRUSTED_SERVICE (covers OS/APP fastcalls).
	 */
	lsr	x10, x0, #SMC_OWNER_SHIFT
	and	x10, x10, #SMC_OWNER_MASK
	cmp	x10, #SMC_OWNER_TRUSTED_BASE
	mov	x6, #SMC_OWNER_TRUSTED_SERVICE
	csel	x10, x6, x10, ge

	/* args for fastcall handler (frame) */
	mov	x0, sp

	/* call fastcall handler */
	adr	x9, fastcall_table
	ldr	x10, [x9, x10, lsl #3]
	blr	x10

	/* restore fastcall frame (returning results) */
	ldp	x0, x1, [sp], #16
	ldp	x2, x3, [sp], #16
	ldp	x4, x5, [sp], #16
	ldp	x6, x7, [sp], #16

	ldr	lr, [sp], #16		// restore NS world's LR
	ldp	x9, x10, [sp], #16	// restore scratch
	eret

unimp_fastcall:
	b	.

/* fastcall SMCs issued from non-secure */
fastcall_table:
	.quad	unimp_fastcall		/* ARM Arch service */
	.quad	unimp_fastcall		/* CPU service */
	.quad	platform_sip_handler	/* SIP service */
	.quad	unimp_fastcall		/* OEM service */
	.quad	platform_psci_handler	/* ARM Standard service (currently, only PSCI) */
	.quad	unimp_fastcall		/* Trusted (OS/TA) service */
