OUTPUT_FORMAT("elf64-littleaarch64", "elf64-littleaarch64", "elf64-littleaarch64")
OUTPUT_ARCH(aarch64)

ENTRY(_start)
SECTIONS
{
	. = %MEMBASE%;

	/* text/read-only data */
	.text.boot.vectab1 : { KEEP(*(.text.boot.vectab1)) }
	.text.boot.vectab2 : { KEEP(*(.text.boot.vectab2)) }
	.text.boot : { KEEP(*(.text.boot)) }
	.text :	{ *(.text .text.* .glue_7* .gnu.linkonce.t.*) } =0x9090

	.interp : { *(.interp) }
	.hash : { *(.hash) }
	.dynsym : { *(.dynsym) }
	.dynstr : { *(.dynstr) }
	.rel.text : { *(.rel.text) *(.rel.gnu.linkonce.t*) }
	.rela.text : { *(.rela.text) *(.rela.gnu.linkonce.t*) }
	.rel.data : { *(.rel.data) *(.rel.gnu.linkonce.d*) }
	.rela.data : { *(.rela.data) *(.rela.gnu.linkonce.d*) }
	.rel.rodata : { *(.rel.rodata) *(.rel.gnu.linkonce.r*) }
	.rela.rodata : { *(.rela.rodata) *(.rela.gnu.linkonce.r*) }
	.rel.got : { *(.rel.got) }
	.rela.got : { *(.rela.got) }
	.rel.ctors : { *(.rel.ctors) }
	.rela.ctors : { *(.rela.ctors) }
	.rel.dtors : { *(.rel.dtors) }
	.rela.dtors : { *(.rela.dtors) }
	.rel.init : { *(.rel.init) }
	.rela.init : { *(.rela.init) }
	.rel.fini : { *(.rel.fini) }
	.rela.fini : { *(.rela.fini) }
	.rel.bss : { *(.rel.bss) }
	.rela.bss : { *(.rela.bss) }
	.rel.plt : { *(.rel.plt) }
	.rela.plt : { *(.rela.plt) }
	.init : { *(.init) } =0x9090
	.plt : { *(.plt) }

	/* .ARM.exidx is sorted, so has to go in its own output section.  */
	__exidx_start = .;
	.ARM.exidx : { *(.ARM.exidx* .gnu.linkonce.armexidx.*) }
	__exidx_end = .;

	.rodata : {
		*(.rodata .rodata.* .gnu.linkonce.r.*)
		. = ALIGN(8);
		__rodata_end = . ;
	}

	/* writable data  */
	__data_start_rom = .;
	/* in one segment binaries, the rom data address is on top of the ram data address */
	__data_start = .;
	.data : SUBALIGN(8) {
		*(.data .data.* .gnu.linkonce.d.*)
	}

	__ctor_list = .;
	.ctors : { *(.ctors) }
	__ctor_end = .;
	__dtor_list = .;
	.dtors : { *(.dtors) }
	__dtor_end = .;
	.got : { *(.got.plt) *(.got) }
	.dynamic : { *(.dynamic) }

	__data_end = .;

	/* unintialized data (in same segment as writable data) */
	.prebss : SUBALIGN(8) { KEEP(*(.bss.prebss.*)) }
	.bss.initial_stack : SUBALIGN(8) { KEEP(*(.bss.initial_stack)) }
	__bss_start = .;
	.bss : SUBALIGN(8) {
		*(.bss .bss.*)
		*(COMMON)
	}
	__bss_end = .;

	.bss-filler : {
		/* This .bss-filler section serves two purposes.
		   To execute the task in-place, the preceding .bss section needs to
		   occupy real space in the image, so when loaded into LK, there's
		   memory underneath it. Adding this section after .bss, forces space
		   in the file to be allocated.
		   This section also rounds .bss to be page-aligned, which is required,
		   so when multiple tasks are concatenated together in loading the image,
		   the end of the task (before the beginning of the next) has the needed
		   page alignment */
		. += (__bss_end - __bss_start);
		BYTE(0);
		. += 1;
		. = ALIGN(0x1000);
	} =0

	_end = .;

	/* Strip unnecessary stuff */
	/DISCARD/ : { *(.comment .note .eh_frame) }
}
