/*
 * Copyright (c) 2013, NVIDIA CORPORATION. All rights reserved
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include <debug.h>
#include <arch/outercache.h>
#include <arch/arm.h>
#include <platform/platform_p.h>
#include <arch/arm/cache-l2x0.h>

static int l2x0_init_done;

void tz_handle_smc_l2(unsigned int smc)
{
	if (smc == 0x1) {
		if (!l2x0_init_done) {
			outer_init();
			l2x0_init_done = 1;
		} else {
			platform_init_outer();
			outer_enable();
		}
	} else if (smc == 0x2) {
		outer_flush_all();
		outer_disable(); /* disable */
	} else {
		dprintf(INFO, "invalid L2 SMC\n");
	}
}

void tz_handle_smc_deep_sleep(void)
{
	l2x0_init_done = 0;
}
