/*
 * Copyright (c) 2008 Travis Geiselbrecht
 * Copyright (c) 2012, NVIDIA CORPORATION. All rights reserved
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#include <asm.h>
#include <arch/arch_thread.h>

FUNCTION(arm_undefined)
	stmfd	sp!, { r0-r12, r14 }
	sub	sp, sp, #12
	mrs	r1, spsr
	stmia	sp, { r1, r13-r14 }^

	mov	r0, sp
	bl	arm_undefined_handler

	ldmia	sp, { r1, r13-r14 }^
	msr	spsr_fsxc, r1
	add	sp, sp, #12
	ldmia	sp!, { r0-r12, r14 }
	movs	pc, r14

FUNCTION(arm_syscall)
	stmfd	sp!, { r0-r12, r14 }
	sub	sp, sp, #12
	mrs	r1, spsr
	stmia	sp, { r1, r13-r14 }^

	mov	r0, sp
	bl	arm_syscall_handler

	ldmia	sp, { r1, r13-r14 }^

	/* make USR cpsr I/F bits agree with SVC */
	mrs	r0, cpsr
	cpsid	aif		@ don't let IRQ intr change spsr
	bic	r1, r1, #(3 << 6)
	and	r0, r0, #(3 << 6)
	orr	r1, r1, r0
	msr	spsr_fsxc, r1

	add	sp, sp, #12
	ldmia	sp!, { r0-r12, r14 }
	movs	pc, r14

FUNCTION(arm_prefetch_abort)
	stmfd 	sp!, { r0-r12, r14 }
	sub	sp, sp, #12
	mov	r0, sp
	mrs	r1, spsr
	stmia	r0, { r1, r13-r14 }^
	b	arm_prefetch_abort_handler
	b	.

FUNCTION(arm_data_abort)
	stmfd 	sp!, { r0-r12, r14 }
	sub	sp, sp, #12
	mov	r0, sp
	mrs	r1, spsr
	stmia	r0, { r1, r13-r14 }^
	b	arm_data_abort_handler
	b	.

FUNCTION(arm_reserved)
	b	.

FUNCTION(arm_irq)
	/* save spsr, exception pc on sp_svc */
	sub	lr, lr, #4	@ both ARM/Thumb latch (PC + 4)
	srsdb	sp!, #0x13

	/* move into supervisor mode. irq/fiq disabled */
	cpsid	if, #0x13

	/* save core register state */
	stmfd	sp, { r13-r14 }^
	sub	sp, sp, #8
	stmfd	sp!, { r0-r12, r14 }

	/* increment the global critical section count */
	ldr	r1, =critical_section_count
	ldr	r0, [r1]
	add	r0, r0, #1
	str	r0, [r1]

	/* call into higher level code */
	mov	r0, sp /* iframe */
	bl	platform_irq

	/* reschedule if the handler returns nonzero */
	cmp	r0, #0
	bne	thread_preempt

	/* decrement the global critical section count */
	ldr	r1, =critical_section_count
	ldr	r0, [r1]
	sub	r0, r0, #1
	str	r0, [r1]

	/* restore core register state */
	ldmia	sp!, { r0-r12, r14 }
	ldmia	sp, { r13-r14 }^
	add	sp, sp, #8

	/* restore to cpsr, pc */
	rfeia	sp!

	/* should never reach here */
	b	.

.bss
.align 2
	.global irq_save_spot
irq_save_spot:
	.word	0	/* r4 */
	.word	0	/* r5 */
	.word	0	/* r6 */

.text
FUNCTION(arm_fiq)
	sub	lr, lr, #4
	stmfd	sp!, { r0-r3, r12, lr }

	bl	platform_fiq

	ldmfd	sp!, { r0-r3, r12, pc }^

.ltorg
