/*
 * Copyright (c) 2012-2013, NVIDIA CORPORATION. All rights reserved
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef __PLATFORM_TEGRA_MEMMAP_H
#define __PLATFORM_TEGRA_MEMMAP_H

#include <memmap_ext.h>

#define TEGRA_ARM_PERIF_BASE		0x50040000
#define TEGRA_ARM_PERIF_SIZE		SZ_8K

#define TEGRA_ARM_INT_DIST_BASE		0x50041000
#define TEGRA_ARM_INT_DIST_SIZE		SZ_4K

#define TEGRA_PRIMARY_ICTLR_BASE	0x60004000
#define TEGRA_PRIMARY_ICTLR_SIZE	64

#define TEGRA_ARBGNT_ICTLR_BASE		0x60004040
#define TEGRA_ARBGNT_ICTLR_SIZE		192

#define TEGRA_SECONDARY_ICTLR_BASE	0x60004100
#define TEGRA_SECONDARY_ICTLR_SIZE	64

#define TEGRA_TERTIARY_ICTLR_BASE	0x60004200
#define TEGRA_TERTIARY_ICTLR_SIZE	64

#define TEGRA_QUATERNARY_ICTLR_BASE	0x60004300
#define TEGRA_QUATERNARY_ICTLR_SIZE	64

#define TEGRA_QUINARY_ICTLR_BASE	0x60004400
#define TEGRA_QUINARY_ICTLR_SIZE	SZ_64

#define TEGRA_TMR1_BASE			0x60005000
#define TEGRA_TMR1_SIZE			SZ_8

#define TEGRA_TMR2_BASE			0x60005008
#define TEGRA_TMR2_SIZE			SZ_8

#define TEGRA_TMRUS_BASE		0x60005010
#define TEGRA_TMRUS_SIZE		64

#define TEGRA_TMR3_BASE			0x60005050
#define TEGRA_TMR3_SIZE			SZ_8

#define TEGRA_TMR4_BASE			0x60005058
#define TEGRA_TMR4_SIZE			SZ_8

#define TEGRA_TMR5_BASE			0x60005060
#define TEGRA_TMR5_SIZE			8

#define TEGRA_TMR6_BASE			0x60005068
#define TEGRA_TMR6_SIZE			8

#define TEGRA_TMR7_BASE			0x60005070
#define TEGRA_TMR7_SIZE			8

#define TEGRA_TMR8_BASE			0x60005078
#define TEGRA_TMR8_SIZE			8

#define TEGRA_TMR9_BASE			0x60005080
#define TEGRA_TMR9_SIZE			8

#define TEGRA_TMR0_BASE			0x60005088
#define TEGRA_TMR0_SIZE			8

#define TEGRA_WDT0_BASE			0x60005100
#define TEGRA_WDT0_SIZE			32

#define TEGRA_WDT1_BASE			0x60005120
#define TEGRA_WDT1_SIZE			32

#define TEGRA_WDT2_BASE			0x60005140
#define TEGRA_WDT2_SIZE			32

#define TEGRA_WDT3_BASE			0x60005160
#define TEGRA_WDT3_SIZE			32

#define TEGRA_WDT4_BASE			0x60005180
#define TEGRA_WDT4_SIZE			32

#define TEGRA_CLK_RESET_BASE		0x60006000
#define TEGRA_CLK_RESET_SIZE		SZ_4K

#define TEGRA_FLOW_CTRL_BASE		0x60007000
#define TEGRA_FLOW_CTRL_SIZE		20

#define TEGRA_SB_BASE			0x6000C200
#define TEGRA_SB_SIZE			256

#define TEGRA_GPIO_BASE			0x6000D000
#define TEGRA_GPIO_SIZE			SZ_4K

#define TEGRA_EXCEPTION_VECTORS_BASE	0x6000F000
#define TEGRA_EXCEPTION_VECTORS_SIZE	SZ_4K

#define TEGRA_UARTA_BASE		0x70006000
#define TEGRA_UARTA_SIZE		64

#define TEGRA_UARTB_BASE		0x70006040
#define TEGRA_UARTB_SIZE		64

#define TEGRA_UARTC_BASE		0x70006200
#define TEGRA_UARTC_SIZE		SZ_256

#define TEGRA_UARTD_BASE		0x70006300
#define TEGRA_UARTD_SIZE		SZ_256

#define TEGRA_UARTE_BASE		0x70006400
#define TEGRA_UARTE_SIZE		SZ_256

#define TEGRA_RTC_BASE			0x7000E000
#define TEGRA_RTC_SIZE			SZ_256

#define TEGRA_PMC_BASE			0x7000E400
#define TEGRA_PMC_SIZE			SZ_256

#define TEGRA_FUSE_BASE			0x7000F800
#define TEGRA_FUSE_SIZE			SZ_1K

#define TEGRA_SE_BASE			0x70012000
#define TEGRA_SE_SIZE			SZ_8K

#define TEGRA_TZRAM_BASE		0x7C010000
#define TEGRA_TZRAM_SIZE		0x10000

#define NV_ARM_CORE_HIVEC_BASE		0xFFFF0000

#endif /*__PLATFORM_TEGRA_MEMMAP_H */

